/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.datamgr;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBufferByLoadTimes;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.Vector;

public class TENEConfigurationDataMgr {
    private static TENEConfigurationDataMgr instance;
    private int bQXNE = 0;
    private TETimeBufferByLoadTimes<Integer, Vector<TESubrack>> subrackBuffer = new TETimeBufferByLoadTimes();

    private TENEConfigurationDataMgr() {
        this.subrackBuffer.setBufferCapacity(5000);
        this.subrackBuffer.setPeriodTime(5000L);
        this.subrackBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            @Override
            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                Integer idkey;
                TENE ne;
                if (key instanceof Integer && (ne = TENEConfigurationDataMgr.this.getNE(idkey = (Integer)key)) != null) {
                    return ne.getSubrackList();
                }
                return null;
            }
        });
    }

    public static synchronized TENEConfigurationDataMgr getInstance() {
        if (instance == null) {
            instance = new TENEConfigurationDataMgr();
        }
        return instance;
    }

    public synchronized void startBufferSubrack(int iNEID) {
        TENE ne = this.getNE(iNEID);
        if (ne != null) {
            try {
                this.subrackBuffer.put(iNEID, ne.getSubrackList());
            }
            catch (TEUnknowmKeyTypeException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
            catch (UnkownRefresherException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
        }
    }

    public void clearBufferSubrack(int iNEID) {
        this.subrackBuffer.clearData(iNEID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<TESubrack> getSubrackListRef(int iNEID) {
        TENE ne;
        Vector tmpVector = new Vector();
        TETimeBufferByLoadTimes<Integer, Vector<TESubrack>> tETimeBufferByLoadTimes = this.subrackBuffer;
        synchronized (tETimeBufferByLoadTimes) {
            Set<Integer> keySet = this.subrackBuffer.keySet();
            for (Integer key : keySet) {
                if (key != iNEID) continue;
                try {
                    tmpVector.addAll((Collection)this.subrackBuffer.get(key));
                    break;
                }
                catch (TEUnknowmKeyTypeException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
                catch (UnkownRefresherException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
            }
        }
        if (tmpVector.isEmpty() && (ne = this.getNE(iNEID)) != null) {
            tmpVector = ne.getSubrackList();
        }
        return tmpVector;
    }

    public TENE getNE(int iNEID) {
        return TENEListMgr.getInstance().getNE(iNEID);
    }

    public TENE getNE(String sNODEID) {
        return TENEListMgr.getInstance().getNE(sNODEID);
    }

    public int getNEID(int logicNEID) {
        return TENECommMgr.getInstance().getNEID((long)logicNEID);
    }

    public String getFullNeID(int neID) {
        return String.valueOf((neID - neID % 65536) / 65536) + "-" + neID % 65536;
    }

    public String getNEName(int logicNEID) {
        return TETL1NECommMgr.getInstance().getTL1NEName((long)logicNEID);
    }

    public boolean isPTNDevice(TENE ne) {
        int neType = ne.getNEType();
        TIntArrayList domainList = TEEquipmentDescription.getInstance().getNEDomainList(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return domainList.contains(16);
    }

    public void deleteNEID(int logicNEID) {
        TENECommMgr.getInstance().deleteNEID((long)logicNEID);
    }

    public void deleteLogicNEIDName(int logicNEID) {
        TETL1NECommMgr.getInstance().deleteTL1NEID((long)logicNEID);
    }

    public int getNEType() {
        return this.bQXNE;
    }

    public void setNEType(int _neType) {
        this.bQXNE = _neType;
    }

    public boolean isRTNDomainNEByType(int neType) {
        TIntArrayList domainList = TEEquipmentDescription.getInstance().getNEDomainList(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return domainList.contains(11);
    }

    public boolean isRTNDomainNE(int neid) {
        return this.isRTNDomainNEByType(TENEListMgr.getInstance().getNE(neid).getNEType());
    }

    public boolean isOTNDomainNE(int neid) {
        int neType = TENEListMgr.getInstance().getNE(neid).getNEType();
        TIntArrayList domainList = TEEquipmentDescription.getInstance().getNEDomainList(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return domainList.contains(3);
    }

    public boolean isRTN900DomainNEByType(int neType) {
        TIntArrayList domainList = TEEquipmentDescription.getInstance().getNEDomainList(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return domainList.contains(11) && domainList.contains(16);
    }

    public boolean isOSN5X0NEByType(int neType) {
        return 81 == neType || 62 == neType;
    }
}

