/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.datamgr;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.bscfg.installcp.TECPOccupySlot;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.TEQueryLogicPortForDataMgr;
import com.huawei.nglct.nelist.model.TEQueryPortForDataMgr;
import com.huawei.nglct.nelist.model.TEStaticFBCount;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nelist.model.cpnerelate.TEBoardSlotInfo;
import com.huawei.nglct.nelist.model.datamgr.NEIDAndSlotIDKey;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.po.TESubrackTypes;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBufferByLoadTimes;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class TEBoardConfigurationDataMgr {
    private static TEBoardConfigurationDataMgr instance;
    private Hashtable<String, HashMap<Integer, List<Integer>>> boardExistPortData = new Hashtable();
    private TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> boardBuffer = new TETimeBufferByLoadTimes();
    private TENEConfigurationDataMgr neConfigMgr = TENEConfigurationDataMgr.getInstance();

    private TEBoardConfigurationDataMgr() {
        this.boardBuffer.setBufferCapacity(5000);
        this.boardBuffer.setPeriodTime(3000L);
        this.boardBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            @Override
            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof NEIDAndSlotIDKey) {
                    NEIDAndSlotIDKey idkey = (NEIDAndSlotIDKey)key;
                    TENE ne = TEBoardConfigurationDataMgr.this.neConfigMgr.getNE(idkey.neid);
                    if (ne != null) {
                        return ne.getBoard(idkey.slotid);
                    }
                }
                return null;
            }
        });
    }

    public static synchronized TEBoardConfigurationDataMgr getInstance() {
        if (instance == null) {
            instance = new TEBoardConfigurationDataMgr();
        }
        return instance;
    }

    public boolean isWDMBoardType(int neID, int iBoardType) {
        TESDCircuitPackRecord record = TECircuitPackDescription.getInstance().getCPRecord(iBoardType);
        if (record != null) {
            return record.wdmType != 0;
        }
        return false;
    }

    public boolean isSCCBoard(int neID, int iBoardType) {
        return this.isCPHaveFB(iBoardType, 26);
    }

    public boolean isCPHaveFB(int iBoardType, int fbType) {
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(iBoardType, true);
        return fbTypeList.contains(fbType);
    }

    public boolean isBranchBoard(int iNEID, int iSlotID) {
        TEBoard boardref = this.getBoardRef(iNEID, iSlotID);
        if (boardref == null) {
            return false;
        }
        return this.isBranchBoardBybdType(iNEID, boardref.getBoardType());
    }

    public boolean isBranchBoardBybdType(int iNEID, int bdType) {
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(bdType, true);
        if (bdType == 1622) {
            return false;
        }
        return this.isSupportFunDomain(129, fbTypeList);
    }

    public boolean isSDHLineBoard(int iNEID, int iSlotID) {
        TEBoard boardref = this.getBoardRef(iNEID, iSlotID);
        if (boardref == null) {
            return false;
        }
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(boardref.getBoardType(), true);
        return this.isSupportFunDomain(1, fbTypeList) && this.isSupportFunDomain(130, fbTypeList);
    }

    public boolean isElecLineBoard(int iNEID, int iSlotID) {
        TEBoard boardref = this.getBoardRef(iNEID, iSlotID);
        if (boardref == null) {
            return false;
        }
        int cpType = boardref.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TESDCircuitPackRecord record = cpDesc.getCPRecord(cpType);
        if (record == null) {
            return false;
        }
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(cpType, true);
        if (this.isSupportFunDomain(130, fbTypeList)) {
            List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(cpType);
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                TEInstallCPPortRecord portRecord = portRecordList.get(i);
                if (!portRecord.isElectricPortType()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIFboard(int boardtype) {
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(boardtype, true);
        return this.isSupportFunDomain(11, fbTypeList);
    }

    public boolean isFanBoard(int boardtype) {
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(boardtype, false);
        return fbTypeList.contains(98);
    }

    private final boolean isSupportFunDomain(int domainType, List fbTypeList) {
        if (fbTypeList == null || fbTypeList.isEmpty()) {
            return false;
        }
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        TIntArrayList fbs = new TIntArrayList();
        fbDesc.getDomainContainFB(domainType, fbs);
        int size = fbTypeList.size();
        for (int i = 0; i < size; ++i) {
            if (!fbs.contains(fbDesc.getBidirFBType((Integer)fbTypeList.get(i)))) continue;
            return true;
        }
        return false;
    }

    public List getStaticFBCountList(int portType, int level, List fbList) {
        int fbType = 0;
        int biFbType = 0;
        TEStaticFBCount fbCount = null;
        ArrayList<TEStaticFBCount> portFBList = new ArrayList<TEStaticFBCount>();
        TEPortDescription portDesc = TEPortDescription.getInstance();
        TEFuncBlockDescription fbDesc = TEFuncBlockDescription.getInstance();
        int m = fbList.size();
        for (int i = 0; i < m; ++i) {
            fbType = (Integer)fbList.get(i);
            biFbType = fbDesc.getBidirFBType(fbType);
            fbCount = new TEStaticFBCount(biFbType, portDesc.getPortContainMONumByType(portType, level, fbType));
            if (portFBList.contains(fbCount)) continue;
            portFBList.add(fbCount);
        }
        return portFBList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startBufferBoard(int iNEID, List<Integer> iSlotIDList) {
        TENE ne = this.neConfigMgr.getNE(iNEID);
        TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> tETimeBufferByLoadTimes = this.boardBuffer;
        synchronized (tETimeBufferByLoadTimes) {
            if (ne != null) {
                for (int i = 0; i < iSlotIDList.size(); ++i) {
                    try {
                        this.boardBuffer.put(new NEIDAndSlotIDKey(iNEID, iSlotIDList.get(i)), ne.getBoard(iSlotIDList.get(i)));
                        continue;
                    }
                    catch (TEUnknowmKeyTypeException e) {
                        TELogFactory.getNormalLogger().error(e.toString());
                        continue;
                    }
                    catch (UnkownRefresherException e) {
                        TELogFactory.getNormalLogger().error(e.toString());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startBufferBoard(int iNEID) {
        TENE ne = this.neConfigMgr.getNE(iNEID);
        if (ne != null) {
            Vector boardList = ne.getBoardList();
            for (int i = 0; i < boardList.size(); ++i) {
                TEBoard board = (TEBoard)boardList.get(i);
                try {
                    TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> tETimeBufferByLoadTimes = this.boardBuffer;
                    synchronized (tETimeBufferByLoadTimes) {
                        this.boardBuffer.put(new NEIDAndSlotIDKey(iNEID, board.getSlotID()), board);
                        continue;
                    }
                }
                catch (TEUnknowmKeyTypeException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                    continue;
                }
                catch (UnkownRefresherException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBufferBoard(int iNEID, List<Integer> iSlotIDList) {
        for (int i = 0; i < iSlotIDList.size(); ++i) {
            TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> tETimeBufferByLoadTimes = this.boardBuffer;
            synchronized (tETimeBufferByLoadTimes) {
                this.boardBuffer.clearData(new NEIDAndSlotIDKey(iNEID, iSlotIDList.get(i)));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBufferBoard(int iNEID) {
        ArrayList<Integer> slotList = new ArrayList<Integer>();
        TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> tETimeBufferByLoadTimes = this.boardBuffer;
        synchronized (tETimeBufferByLoadTimes) {
            Set<NEIDAndSlotIDKey> keySet = this.boardBuffer.keySet();
            for (NEIDAndSlotIDKey key : keySet) {
                if (key.neid != iNEID) continue;
                slotList.add(key.slotid);
            }
            this.clearBufferBoard(iNEID, slotList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TEBoard> getBoardRef(int iNEID) {
        TENE ne;
        AbstractList boardList = new ArrayList<TEBoard>();
        TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> tETimeBufferByLoadTimes = this.boardBuffer;
        synchronized (tETimeBufferByLoadTimes) {
            Set<NEIDAndSlotIDKey> keySet = this.boardBuffer.keySet();
            for (NEIDAndSlotIDKey key : keySet) {
                if (key.neid != iNEID) continue;
                try {
                    boardList.add(this.boardBuffer.get(key));
                }
                catch (TEUnknowmKeyTypeException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
                catch (UnkownRefresherException e) {
                    TELogFactory.getNormalLogger().error(e.toString());
                }
            }
        }
        if (boardList.isEmpty() && (ne = TEConfigurationDataMgr.getInstance().getNE(iNEID)) != null) {
            boardList = ne.getBoardList();
        }
        return boardList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEBoard getBoardRef(int iNEID, int iSlotID) {
        NEIDAndSlotIDKey key = new NEIDAndSlotIDKey(iNEID, iSlotID);
        TETimeBufferByLoadTimes<NEIDAndSlotIDKey, TEBoard> tETimeBufferByLoadTimes = this.boardBuffer;
        synchronized (tETimeBufferByLoadTimes) {
            try {
                TEBoard board = this.boardBuffer.get(key);
                if (null != board) {
                    return board;
                }
            }
            catch (TEUnknowmKeyTypeException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
            catch (UnkownRefresherException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
        }
        TENE ne = this.neConfigMgr.getNE(iNEID);
        if (ne != null) {
            return ne.getBoard(iSlotID);
        }
        return null;
    }

    public int getBoardType(int iNEID, int iSlotID) {
        TEBoard board = this.getBoardRef(iNEID, iSlotID);
        if (board != null) {
            return board.getBoardType();
        }
        return -1;
    }

    public ArrayList queryBoardPortList(TEBoard board) {
        ArrayList result = new ArrayList();
        if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            Hashtable<String, List<TEPort>> boardPortData = TEPortModelConfigurationDataMgr.getInstance().getDynBoardPortData(board.getNEID());
            if (null != boardPortData) {
                String boardKey = String.valueOf(board.getSlotID()) + board.getBoardType();
                ArrayList portdyndataList = (ArrayList)boardPortData.get(boardKey);
                TEPort port = null;
                if (null != portdyndataList) {
                    for (int i = 0; i < portdyndataList.size(); ++i) {
                        port = TEPortModelConfigurationDataMgr.getInstance().buildTEPort(board.getNEID(), board.getSlotID(), (Integer)portdyndataList.get(i));
                        if (null == port) continue;
                        result.add(port);
                    }
                }
            }
        } else {
            int neID = board.getNEID();
            int slotID = board.getSlotID();
            int boardType = board.getBoardType();
            List<TECPAddiblePortRecord> addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
            int neVersion = TEConvertUtil.convertVerStrToInt(TENEListMgr.getInstance().getNE(neID).getHostVersion());
            HashMap<Integer, Integer> porttypes = new HashMap<Integer, Integer>();
            TECPAddiblePortRecord addiblePortRecord = null;
            int m = addiblePortRecordList.size();
            for (int i = 0; i < m; ++i) {
                addiblePortRecord = addiblePortRecordList.get(i);
                if (!addiblePortRecord.isWithInRange(neVersion)) continue;
                porttypes.put(addiblePortRecord.portID, addiblePortRecord.portType);
            }
            result = (ArrayList)TEQueryPortForDataMgr.getPortListOnInter(neID, slotID, boardType, porttypes);
        }
        return result;
    }

    public TEBoard getBoard(int iNEID, int iSlotID) {
        TEBoard boardref = this.getBoardRef(iNEID, iSlotID);
        if (boardref != null) {
            return (TEBoard)boardref.clone();
        }
        return null;
    }

    public List getBoardList(int neID, int iBoardType) {
        List<TEBoard> vBoardList = this.getBoardRef(neID);
        ArrayList<TEBoard> boardList = new ArrayList<TEBoard>();
        int size = vBoardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = vBoardList.get(i);
            if (board.getBoardType() != iBoardType) continue;
            boardList.add(board);
        }
        return boardList;
    }

    public ArrayList getBoardPortList(int neID, int iBoardType) {
        ArrayList portNoList = new ArrayList();
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            int n = portRecord.getPortIDList().size();
            for (int j = 0; j < n; ++j) {
                if (portNoList.contains(portRecord.getPortIDList().get(j))) continue;
                portNoList.add(portRecord.getPortIDList().get(j));
            }
        }
        return portNoList;
    }

    public ArrayList getBoardPortList(int neID, int iBoardType, int slotid) {
        String key;
        HashMap<Integer, List<Integer>> existPortMap;
        ArrayList portNoList = new ArrayList();
        if (iBoardType == 1573 && (existPortMap = this.boardExistPortData.get(key = String.valueOf(neID) + '-' + String.valueOf(slotid))) != null) {
            portNoList.addAll(existPortMap.keySet());
            return portNoList;
        }
        portNoList = this.getBoardPortList(neID, iBoardType);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (58 == ne.getNEType() && 3 == slotid) {
            if (1384 == iBoardType) {
                portNoList.remove(portNoList.size() - 1);
            } else if (1133 == iBoardType || 2222 == iBoardType) {
                for (int i = 0; i < 5; ++i) {
                    portNoList.remove(portNoList.size() - 1);
                }
            }
        }
        if ((65 == ne.getNEType() || 77 == ne.getNEType()) && iBoardType == 1416 && 1 != slotid && 2 != slotid) {
            portNoList.remove(portNoList.size() - 1);
        }
        return portNoList;
    }

    public HashMap getBoardPortPathMap(int neID, int iBoardType, int slotid) {
        String key;
        HashMap<Integer, List<Integer>> existPortMap;
        HashMap<Integer, List<Integer>> portNoMap = new HashMap<Integer, List<Integer>>();
        if (iBoardType == 1573 && (existPortMap = this.boardExistPortData.get(key = String.valueOf(neID) + "-" + String.valueOf(slotid))) != null) {
            portNoMap.putAll(existPortMap);
        }
        return portNoMap;
    }

    public ArrayList getBoardPortPropertyList(int neID, int iBoardType) {
        ArrayList<TEPortProperty> allPortPropertyList = new ArrayList<TEPortProperty>();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TEPortProperty portProperty = null;
        TEInstallCPPortRecord installCPPortRecord = null;
        List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(iBoardType);
        int m = portRecordList.size();
        for (int i = 0; i < m; ++i) {
            installCPPortRecord = portRecordList.get(i);
            int mn = installCPPortRecord.portIDList.size();
            for (int k = 0; k < mn; ++k) {
                portProperty = new TEPortProperty(installCPPortRecord.signalType, installCPPortRecord.portType, installCPPortRecord.interfaceLevel, (Integer)installCPPortRecord.portIDList.get(k));
                portProperty.setPortUsage(installCPPortRecord.portUsage);
                ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, true);
                portProperty.setFunBlockPropertyList(this.getStaticFBCountList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, portFBList));
                allPortPropertyList.add(portProperty);
            }
        }
        return allPortPropertyList;
    }

    public ArrayList getLogicPortList(int iNEID, int iSlotID) {
        ArrayList logicPortList = TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts() ? this.getLogicPortListOnSingle(iNEID, iSlotID) : (ArrayList)this.getLogicPortListOnInter(iNEID, iSlotID);
        return logicPortList;
    }

    private List<Integer> getLogicPortListOnInter(int iNEID, int iSlotID) {
        return TEQueryLogicPortForDataMgr.getLogicPortListOnInter(iNEID, iSlotID);
    }

    private ArrayList getLogicPortListOnSingle(int iNEID, int iSlotID) {
        ArrayList<Integer> logicPortList = new ArrayList<Integer>();
        String key = String.valueOf(iNEID) + "-" + String.valueOf(iSlotID);
        HashMap<Integer, List<Integer>> existPortMap = this.boardExistPortData.get(key);
        int boardType = this.getBoardType(iNEID, iSlotID);
        if (boardType == 1573 && existPortMap != null) {
            Iterator<Integer> it = existPortMap.keySet().iterator();
            while (it.hasNext()) {
                logicPortList.add(it.next());
            }
        }
        try {
            Hashtable<String, List<TEPort>> boardPortData = null;
            ArrayList portdyndataList = null;
            if (this.isDynPortBoardType(iNEID, boardType)) {
                String boardKey;
                boardPortData = TEPortModelConfigurationDataMgr.getInstance().getDynBoardPortData(iNEID);
                if (null != boardPortData && null != (portdyndataList = (ArrayList)boardPortData.get(boardKey = String.valueOf(iSlotID) + String.valueOf(boardType)))) {
                    int size = portdyndataList.size();
                    for (int i = 0; i < size; ++i) {
                        logicPortList.add((Integer)portdyndataList.get(i));
                    }
                }
            } else {
                List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
                int size = portRecordList.size();
                for (int i = 0; i < size; ++i) {
                    TEInstallCPPortRecord portRecord = portRecordList.get(i);
                    ArrayList portList = portRecord.getPortIDList();
                    if (logicPortList.containsAll(portList)) continue;
                    logicPortList.addAll(portList);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getLogicPortList(neid = " + iNEID + " , slotID = " + iSlotID + ") fail!" + e);
        }
        return logicPortList;
    }

    public boolean isDynPortBoardType(int neID, int iBoardType) {
        return TECircuitPackDescription.getInstance().isSupportDynPortType(iBoardType);
    }

    public boolean isSupportSubCard(int boardType) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2427);
        list.add(2428);
        return list.contains(boardType) || TECircuitPackDescription.getInstance().isSupportSubCard(boardType);
    }

    public List getPortList(int iNEID, int iSlotID, int portType) {
        ArrayList<TEPort> portList = new ArrayList<TEPort>();
        TEBoard board = this.getBoardRef(iNEID, iSlotID);
        if (board == null) {
            return portList;
        }
        int boardType = board.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        if (cpDesc.isMutativeBoardType(boardType)) {
            ArrayList portTmpList = this.queryBoardPortList(board);
            int size = portTmpList.size();
            for (int i = 0; i < size; ++i) {
                TEPort tmpport = (TEPort)portTmpList.get(i);
                if (tmpport.getPortType() != portType) continue;
                portList.add(tmpport);
            }
        }
        String key = "" + iNEID + "-" + iSlotID;
        HashMap<Integer, List<Integer>> existPortMap = this.boardExistPortData.get(key);
        List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(boardType);
        if (portRecordList != null && portRecordList.size() > 0) {
            TEInstallCPPortRecord installCPPortRecord = null;
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                installCPPortRecord = portRecordList.get(i);
                ArrayList portNoList = installCPPortRecord.getPortIDList();
                if (portType != installCPPortRecord.portType) continue;
                int portNoSize = portNoList.size();
                for (int j = 0; j < portNoSize; ++j) {
                    int portID = (Integer)portNoList.get(j);
                    if (boardType == 1573 && (existPortMap == null || !existPortMap.containsKey(portID))) continue;
                    TEPort resultport = new TEPort(iNEID, iSlotID, boardType, portID, installCPPortRecord.portType, installCPPortRecord.interfaceLevel);
                    resultport.setPortAddibleType(installCPPortRecord.portDynType);
                    portList.add(resultport);
                }
            }
        }
        return portList;
    }

    public void addBoardPortList(int neid, int slotid, HashMap<Integer, List<Integer>> portMap) {
        String key = "" + neid + "-" + slotid;
        this.boardExistPortData.put(key, portMap);
    }

    public void removeBoardPortList(int neid, int slotid) {
        String key = "" + neid + "-" + slotid;
        this.boardExistPortData.remove(key);
    }

    public ArrayList getPortPropertyList(int boardType) {
        ArrayList<TEPortProperty> allPortPropertyList = new ArrayList<TEPortProperty>();
        TEPortProperty portProperty = null;
        TEInstallCPPortRecord installCPPortRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        int m = portRecordList.size();
        for (int i = 0; i < m; ++i) {
            installCPPortRecord = portRecordList.get(i);
            int n = installCPPortRecord.portIDList.size();
            for (int j = 0; j < n; ++j) {
                portProperty = new TEPortProperty(installCPPortRecord.signalType, installCPPortRecord.portType, installCPPortRecord.interfaceLevel, (Integer)installCPPortRecord.portIDList.get(j));
                portProperty.setPortUsage(installCPPortRecord.portUsage);
                ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, true);
                portProperty.setFunBlockPropertyList(this.getStaticFBCountList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, portFBList));
                portProperty.setSignalType(installCPPortRecord.signalType);
                portProperty.setBelongCPModel(installCPPortRecord.cpMode);
                allPortPropertyList.add(portProperty);
            }
        }
        return allPortPropertyList;
    }

    public List<TEPortProperty> getPortPropertyList(int neid, int slotid) {
        ArrayList<TEPortProperty> allPortPropertyList = new ArrayList<TEPortProperty>();
        TEPortProperty portProp = null;
        TEInstallCPPortRecord installCPPortRecord = null;
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        TEPortModelConfigurationDataMgr portMgr = TEPortModelConfigurationDataMgr.getInstance();
        boolean isDynBoard = this.isDynPortBoardType(neid, boardType);
        int m = portRecordList.size();
        for (int i = 0; i < m; ++i) {
            installCPPortRecord = portRecordList.get(i);
            int n = installCPPortRecord.portIDList.size();
            for (int j = 0; j < n; ++j) {
                int tempPort = (Integer)installCPPortRecord.portIDList.get(j);
                if (TEVirtualPortUtil.isMSOTNBoard(boardType) && isDynBoard && TEConfigurationDataMgr.getInstance().isDynPort(neid, boardType, tempPort) && installCPPortRecord.interfaceLevel != portMgr.convertNMSLevelFromPortSpeed(portMgr.getCacheSpeed(neid, slotid, tempPort))) {
                    installCPPortRecord.interfaceLevel = portMgr.convertNMSLevelFromPortSpeed(portMgr.getCacheSpeed(neid, slotid, tempPort));
                }
                portProp = new TEPortProperty(installCPPortRecord.signalType, installCPPortRecord.portType, installCPPortRecord.interfaceLevel, tempPort);
                portProp.setPortUsage(installCPPortRecord.portUsage);
                ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, true);
                portProp.setFunBlockPropertyList(this.getStaticFBCountList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, portFBList));
                portProp.setSignalType(installCPPortRecord.signalType);
                portProp.setBelongCPModel(installCPPortRecord.cpMode);
                allPortPropertyList.add(portProp);
            }
        }
        return allPortPropertyList;
    }

    public ArrayList getDynPropertyList(int neid, int boardType) {
        ArrayList<TEPortProperty> allPortPropertyList = new ArrayList<TEPortProperty>();
        int neVersion = TEConvertUtil.convertVerStrToInt(this.neConfigMgr.getNE(neid).getHostVersion());
        TEPortProperty portProperty = null;
        TECPAddiblePortRecord addiblePortRecord = null;
        List<TECPAddiblePortRecord> addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
        int n = addiblePortRecordList.size();
        for (int j = 0; j < n; ++j) {
            addiblePortRecord = addiblePortRecordList.get(j);
            if (!addiblePortRecord.isWithInRange(neVersion)) continue;
            portProperty = new TEPortProperty(addiblePortRecord.signalType, addiblePortRecord.portDynType, addiblePortRecord.m_interface, addiblePortRecord.portID, addiblePortRecord.boardModeList);
            portProperty.setPortUsage(addiblePortRecord.portUsage);
            ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(addiblePortRecord.portType, addiblePortRecord.m_interface, true);
            portProperty.setFunBlockPropertyList(this.getStaticFBCountList(addiblePortRecord.portType, addiblePortRecord.m_interface, portFBList));
            allPortPropertyList.add(portProperty);
        }
        return allPortPropertyList;
    }

    public ArrayList getSubCPDynPropertyList(int neid, int boardType, int subType, int subSlot) {
        ArrayList<TEPortProperty> allPortPropertyList = new ArrayList<TEPortProperty>();
        List<TECPAddiblePortRecord> addiblePortSubRecordList = TECircuitPackDescription.getInstance().getAddibleSubCPPort(boardType, subType, subSlot);
        TEPortProperty portProperty = null;
        TECPAddiblePortRecord addiblePortSubRecord = null;
        if (null != addiblePortSubRecordList && !addiblePortSubRecordList.isEmpty()) {
            int n = addiblePortSubRecordList.size();
            for (int j = 0; j < n; ++j) {
                addiblePortSubRecord = addiblePortSubRecordList.get(j);
                portProperty = new TEPortProperty(addiblePortSubRecord.signalType, addiblePortSubRecord.portDynType, addiblePortSubRecord.m_interface, addiblePortSubRecord.portID, addiblePortSubRecord.boardModeList);
                portProperty.setPortUsage(addiblePortSubRecord.portUsage);
                ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(addiblePortSubRecord.portType, addiblePortSubRecord.m_interface, true);
                portProperty.setFunBlockPropertyList(this.getStaticFBCountList(addiblePortSubRecord.portType, addiblePortSubRecord.m_interface, portFBList));
                allPortPropertyList.add(portProperty);
            }
        }
        return allPortPropertyList;
    }

    public List getBoardPortTypeList(int neID, int iBoardType) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        try {
            List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(iBoardType);
            if (portRecordList == null || portRecordList.isEmpty()) {
                return null;
            }
            TEInstallCPPortRecord portRecord = null;
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                portRecord = portRecordList.get(i);
                Integer portType = portRecord.portType;
                if (list.contains(portType)) continue;
                list.add(portType);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getBoardPortTypeList(neid = " + neID + " , boardType = " + iBoardType + ") fail!" + e);
        }
        return list;
    }

    public int getSubboardType(int neid, int slotid, int subboardid) {
        TEBoard board = this.getBoardRef(neid, slotid);
        if (null == board) {
            TELogFactory.getNormalLogger().error("getSubboardType(neid = " + neid + " , slotid = " + slotid + ", subboardid = " + subboardid + ") fail!");
            int INVALID_SUBBOARD_TYPE = -1;
            return -1;
        }
        int type = -1;
        try {
            List sublist = board.getSubBoardList();
            for (int j = 0; j < sublist.size(); ++j) {
                TESubBoard subboard = (TESubBoard)sublist.get(j);
                int subbbid = subboard.getSubSlotID();
                if (subbbid != subboardid) continue;
                type = subboard.getSubBoardType();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("get subboardtype fail", (Throwable)e);
        }
        return type;
    }

    public String getBoardTypeName(int neID, int iBoardType) {
        String boardName;
        TESDCircuitPackRecord record = TECircuitPackDescription.getInstance().getCPRecord(iBoardType);
        if (null != record && null != (boardName = record.cpName) && !"".equalsIgnoreCase(boardName)) {
            return boardName.trim();
        }
        return "UNKNOWN";
    }

    public String getSubBoardName(int neID, int slotid, int subSlotID) {
        int subBoardtype = TEConfigurationDataMgr.getInstance().getSubboardType(neID, slotid, subSlotID);
        return subSlotID + "-" + TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, subBoardtype);
    }

    public TESDCircuitPackRecord getBoardTypeProperty(int neID, int boardType) {
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TESDCircuitPackRecord record = cpDesc.getCPRecord(boardType);
        return record;
    }

    public String queryBoardMode(int neId, int slotId, int timeout) {
        try {
            Output operationOutput;
            Operation oper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_SUBBDTYPE");
            Input input = oper.getInput();
            Part part = input.getPart("slotid");
            part.setValue(String.valueOf(slotId));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)timeout).retCode;
            if (resualt == 0 && (operationOutput = ((Operation)operationList.get(0)).getOutput()[0]).getFault()[0].getCode().equals(String.valueOf(0))) {
                return operationOutput.getPartValue("W32BD_ATTR_SUBBDTYPE");
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        return "160";
    }

    public int get52TOGBoardModel(int neId, int slotID) {
        int BDTYPE_TN52XCM = 1570;
        int BDTYPE_TN52XCH = 1569;
        int BDTYPE_TNK2XCT = 1601;
        int BDTYPE_TNK2SXM = 1602;
        int shelfID = TEBoardUtil.getSubrackIDFromSlot(neId, slotID);
        int slotIDOf52XCH = shelfID * 65536 + 9;
        int frontslotIDOfK2SXMXCH = shelfID * 65536 + 9;
        int realslotIDOfK2SXMXCH = shelfID * 65536 + 43;
        if (this.getBoardType(neId, slotIDOf52XCH) == BDTYPE_TN52XCH || this.getBoardType(neId, slotIDOf52XCH + 1) == BDTYPE_TN52XCH || this.getBoardType(neId, slotIDOf52XCH) == BDTYPE_TN52XCM || this.getBoardType(neId, slotIDOf52XCH + 1) == BDTYPE_TN52XCM || this.getBoardType(neId, frontslotIDOfK2SXMXCH) == BDTYPE_TNK2XCT || this.getBoardType(neId, realslotIDOfK2SXMXCH) == BDTYPE_TNK2XCT || this.getBoardType(neId, frontslotIDOfK2SXMXCH + 1) == BDTYPE_TNK2SXM || this.getBoardType(neId, realslotIDOfK2SXMXCH + 1) == BDTYPE_TNK2SXM) {
            return 256;
        }
        return 255;
    }

    public int get52ND2BoardModel(int neid, int slotID) {
        int boardMode = this.get52TOGBoardModel(neid, slotID);
        int subBoardType = Integer.parseInt(this.queryBoardMode(neid, slotID, 10));
        if (boardMode == 255) {
            return subBoardType;
        }
        if (boardMode == 256 && subBoardType == 168) {
            return 424;
        }
        if (boardMode == 256 && subBoardType == 169) {
            return 425;
        }
        return 426;
    }

    public int get52NS2BoardModel(int neId, int slotID) {
        int BDTYPE_TN52XCH = 1569;
        int shelfID = slotID / 100;
        int slotIDOf52XCH = shelfID * 100 + 9;
        if (this.getBoardType(neId, slotIDOf52XCH) == BDTYPE_TN52XCH || this.getBoardType(neId, slotIDOf52XCH + 1) == BDTYPE_TN52XCH) {
            return 256;
        }
        return 255;
    }

    public TEBoardSlotInfo getBoardSlotInfo(int neid, int subrackId, int cpType, int slotid) {
        TENE ne = this.neConfigMgr.getNE(neid);
        int neType = ne.getNEType();
        int devType = TEGetNEDomainVersion.getInstance().getDevType(neType);
        int shelfType = ne.getShelfType();
        Vector subrackList = ne.getClonedSubrackList();
        TESubrack subrack = null;
        boolean isUseShelf = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_OTN_NE_MGR", "OTN_ATTR_SUPPORT_USESHELFTYPE");
        if (subrackList != null) {
            String subrackType = "255";
            int n = subrackList.size();
            for (int j = 0; j < n; ++j) {
                subrack = (TESubrack)subrackList.get(j);
                subrackType = ne.getIsTL1OrQX() == 0 ? subrack.getLogicSubrackType() : (2026 == devType || isUseShelf ? String.valueOf(subrack.getShelfType()) : subrack.getTL1ShelfType());
                if (Integer.valueOf(subrack.getSubrackID()) != subrackId) continue;
                if (1967 != devType && 2026 != devType && !isUseShelf) {
                    int neTypeTmp;
                    if (ne.getIsTL1OrQX() == 0) {
                        neTypeTmp = TESubrackTypes.getInstance().getNeType(subrackType);
                        if (neTypeTmp <= 0) {
                            neTypeTmp = Integer.valueOf(subrackType);
                            shelfType = 136;
                        } else {
                            shelfType = Integer.valueOf(subrackType);
                        }
                        devType = TEGetNEDomainVersion.getInstance().getDevType(neTypeTmp);
                        break;
                    }
                    neTypeTmp = TESubrackTypes.getInstance().getNeType(subrack.getLogicSubrackType());
                    shelfType = Integer.valueOf(subrackType);
                    devType = TEGetNEDomainVersion.getInstance().getDevType(neTypeTmp);
                    break;
                }
                shelfType = Integer.valueOf(subrackType);
                break;
            }
        }
        TECPOccupySlot occupySlot = null;
        TEBoardSlotInfo slotInfo = null;
        int occupySlotNumber = TECircuitPackDescription.getInstance().getOccupySlotNumber(cpType);
        ArrayList<TECPOccupySlot> occupySlotList = new ArrayList<TECPOccupySlot>();
        TEEquipmentDescription.getInstance().getInstallSlotByCPType(devType, shelfType, cpType, occupySlotList);
        int m = occupySlotList.size();
        for (int i = 0; i < m; ++i) {
            occupySlot = (TECPOccupySlot)occupySlotList.get(i);
            if (slotid != occupySlot.getM_SlotID()) continue;
            slotInfo = new TEBoardSlotInfo();
            slotInfo.setShelfType(shelfType);
            slotInfo.setDirectSlotid(occupySlot.getM_SlotID());
            ArrayList<Integer> tmpList = new ArrayList<Integer>();
            if (occupySlot.getM_OccupySlotList() != null) {
                int n = occupySlot.getM_OccupySlotList().size();
                for (int j = 0; j < n; ++j) {
                    tmpList.add(occupySlot.getM_OccupySlotList().get(j));
                }
            } else {
                int k;
                tmpList.add(slotid);
                if (occupySlotNumber > 0) {
                    for (k = 1; k < occupySlotNumber; ++k) {
                        tmpList.add(slotid + k);
                    }
                } else if (occupySlotNumber < 0) {
                    for (k = 1; k < Math.abs(occupySlotNumber); ++k) {
                        tmpList.add(slotid - k);
                    }
                }
            }
            slotInfo.setStandbySlotList(tmpList);
        }
        return slotInfo;
    }

    public List getBoardFromWDMType(int neID, int wdmTYpe) {
        ArrayList<TEBoard> result = new ArrayList<TEBoard>();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        Vector boardList = ne.getBoardList();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)boardList.get(i);
            int wdmFunType = this.getWDMFunType(neID, board.getBoardType());
            if (wdmTYpe != wdmFunType) continue;
            result.add(board);
        }
        return result;
    }

    public int getWDMFunType(int neID, int iBoardType) {
        try {
            return TECircuitPackDescription.getInstance().getCPWDMType(iBoardType);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getWDMFunType(neid = " + neID + " , boardType = " + iBoardType + ") fail!" + e);
            return -1;
        }
    }

    public boolean isOpticLineBoard(int iNEID, int iSlotID) {
        TEBoard boardref = this.getBoardRef(iNEID, iSlotID);
        if (boardref == null) {
            return false;
        }
        int cpType = boardref.getBoardType();
        TECircuitPackDescription cpDesc = TECircuitPackDescription.getInstance();
        TESDCircuitPackRecord record = cpDesc.getCPRecord(cpType);
        if (record == null) {
            return false;
        }
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(cpType, true);
        if (this.isSupportFunDomain(130, fbTypeList)) {
            List<TEInstallCPPortRecord> portRecordList = cpDesc.getInstallCPPort(cpType);
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                TEInstallCPPortRecord portRecord = portRecordList.get(i);
                if (!portRecord.isOpticalPortType()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEthBoard(int iNEID, int iSlotID) {
        TEBoard boardref = this.getBoardRef(iNEID, iSlotID);
        if (boardref == null) {
            return false;
        }
        ArrayList fbTypeList = TECircuitPackDescription.getInstance().getCPContainFBList(boardref.getBoardType(), true);
        return this.isSupportFunDomain(4, fbTypeList);
    }

    public Hashtable<String, HashMap<Integer, List<Integer>>> getBoardExistPortData() {
        return (Hashtable)this.boardExistPortData.clone();
    }
}

