/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.configmodel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.gencfg.frame.attrvaluernge.MatchData;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TEFunctionDescrib;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrDescrip;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEBoardSpecialAttrDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENESpecialAttrDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TESpecialAttrMgr {
    private static TESpecialAttrMgr instance = null;
    private SDXMLInterpreterMgr sdXMLMgr = SDXMLInterpreterMgr.getInstance();

    private TESpecialAttrMgr() {
    }

    public static synchronized TESpecialAttrMgr getInstance() {
        if (null == instance) {
            instance = new TESpecialAttrMgr();
        }
        return instance;
    }

    private Map<Integer, Map<Integer, List<TEFunctionDescrib>>> getBoardData() {
        return TEBoardSpecialAttrDataMgr.getInstance().getBoardConfigModel();
    }

    private TEFunctionDescrib getCPFunction(MatchData matchData, int funcID) {
        List<TEFunctionDescrib> funList = TEBoardSpecialAttrDataMgr.getInstance().getFuncDescrib(matchData.getBoardType(), funcID);
        if (funList != null && !funList.isEmpty()) {
            return this.getSupportFun(funList, matchData);
        }
        return null;
    }

    private TEFunctionDescrib getNEFunction(MatchData matchData, int funcID) {
        List<TEFunctionDescrib> funList = TENESpecialAttrDataMgr.getInstance().getFuncDescrib(matchData.getNeType(), funcID);
        if (funList != null && !funList.isEmpty()) {
            return this.getSupportFun(funList, matchData);
        }
        return null;
    }

    private TEFunctionDescrib getSupportFun(List<TEFunctionDescrib> funList, MatchData matchData) {
        TEFunctionDescrib funResult = null;
        if (funList != null && !funList.isEmpty()) {
            int len = funList.size();
            for (int i = 0; i < len; ++i) {
                TEFunctionDescrib fun = funList.get(i);
                if (!this.isSupportFun(fun, matchData)) continue;
                if (funResult == null) {
                    funResult = new TEFunctionDescrib();
                }
                funResult.getAttrDescripList().addAll(fun.getAttrDescripList(matchData.getNeID(), matchData.getNeVersion()));
                funResult.getSupportSpecailAttrList().addAll(fun.getSupportSpecailAttrList(matchData.getNeID(), matchData.getNeVersion()));
                funResult.getNotSupportSpecailAttrList().addAll(fun.getNotSupportSpecailAttrList(matchData.getNeID(), matchData.getNeVersion()));
            }
        }
        return funResult;
    }

    private boolean isSupportFun(TEFunctionDescrib fun, MatchData matchData) {
        if (fun.getConditions() == null || fun.getConditions().isEmpty()) {
            return true;
        }
        int length = fun.getConditions().size();
        for (int i = 0; i < length; ++i) {
            if (!fun.getConditions().get(i).isMatchCondition(matchData)) continue;
            return true;
        }
        return false;
    }

    private String getLogString(int neid, int slotid, String funcID, String attrID) {
        return "neid=" + neid + ";slotid=" + slotid + ";funcID=" + funcID + ";attrID=" + attrID;
    }

    private String getLogString(int neid, String funcID, String attrID) {
        return "neid=" + neid + ";funcID=" + funcID + ";attrID=" + attrID;
    }

    private String getLogStringByBoardType(int boardType, String funcID, String attrID) {
        return "boardType=" + boardType + ";funcID=" + funcID + ";attrID=" + attrID;
    }

    private TESpecialAttrDescrip getCPAttrDescrib(MatchData matchData, int funcID, int attrID) {
        TEFunctionDescrib fun = this.getCPFunction(matchData, funcID);
        TESpecialAttrDescrip attr = null;
        if (fun != null && fun.getAttrDescripList() != null && !fun.getAttrDescripList().isEmpty()) {
            attr = fun.getAttrDescrip(attrID, matchData.getNeID(), matchData.getNeVersion());
        }
        return attr;
    }

    private TESpecialAttrDescrip getNEAttrDescrib(MatchData matchData, int funcID, String attrID) {
        TEFunctionDescrib fun = this.getNEFunction(matchData, funcID);
        TESpecialAttrDescrip attr = null;
        if (fun != null && fun.getAttrDescripList() != null && !fun.getAttrDescripList().isEmpty()) {
            int iAttrID = this.sdXMLMgr.parseInt(attrID);
            attr = fun.getAttrDescrip(iAttrID, matchData.getNeID(), matchData.getNeVersion());
        }
        return attr;
    }

    private boolean isCPSupport(MatchData matchData, int funcID, String attrID) {
        TEFunctionDescrib fun = this.getCPFunction(matchData, funcID);
        boolean isSupport = false;
        if (fun != null && fun.getSupportAttrList() != null && !fun.getSupportAttrList().isEmpty()) {
            isSupport = fun.getSupportAttrList().contains(attrID);
        }
        return isSupport;
    }

    private MatchData constructMatchData(int neid, int slotid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        MatchData matchData = null;
        if (ne != null) {
            int boardType = TEBoardConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
            matchData = new MatchData();
            matchData.setNeID(neid);
            matchData.setBoardType(boardType);
            matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(ne.getNEType()));
            matchData.setNeVersion(this.getNEVersion(ne));
            matchData.setShelfType(TEBoardUtil.getShelfType(neid, slotid));
        }
        return matchData;
    }

    private MatchData constructMatchData(int neid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        MatchData matchData = null;
        if (ne != null) {
            matchData = new MatchData();
            matchData.setNeID(neid);
            matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(ne.getNEType()));
            matchData.setNeVersion(this.getNEVersion(ne));
            matchData.setShelfType(ne.getShelfType());
        }
        return matchData;
    }

    public boolean isCPSupport(int neid, int slotid, String funcID, String attrID) {
        boolean isNENotSupport;
        MatchData matchData = this.constructMatchData(neid, slotid);
        boolean isSupport = false;
        if (matchData != null && !(isNENotSupport = this.isNENotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID))) {
            isSupport = this.isCPSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    public boolean isCPSupportByType(int boardType, String funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setBoardType(boardType);
        boolean isSupport = false;
        if (matchData != null) {
            isSupport = this.isCPSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    private boolean isCPNotSupport(MatchData matchData, int funcID, String attrID) {
        TEFunctionDescrib fun = this.getCPFunction(matchData, funcID);
        boolean isSupport = false;
        if (fun != null && fun.getNotSupportAttrList() != null && !fun.getNotSupportAttrList().isEmpty()) {
            isSupport = fun.getNotSupportAttrList().contains(attrID);
        }
        return isSupport;
    }

    public boolean isCPNotSupport(int neid, int slotid, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid, slotid);
        boolean isSupport = false;
        if (matchData != null) {
            isSupport = this.isCPNotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    public boolean isCPNotSupportByType(int boardType, String funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setBoardType(boardType);
        boolean isSupport = false;
        if (matchData != null) {
            isSupport = this.isCPNotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    private boolean isNESupport(MatchData matchData, int funcID, String attrID) {
        TEFunctionDescrib fun = this.getNEFunction(matchData, funcID);
        boolean isSupport = false;
        if (fun != null && fun.getSupportAttrList() != null && !fun.getSupportAttrList().isEmpty()) {
            isSupport = fun.getSupportAttrList().contains(attrID);
        }
        return isSupport;
    }

    public boolean isNESupport(int neid, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid);
        boolean isSupport = false;
        if (matchData != null) {
            isSupport = this.isNESupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    public boolean isNESupportByType(int neType, String funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return this.isNESupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
    }

    public boolean isNESupportByShelfType(int neid, int shelfType, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid);
        boolean isSupport = false;
        if (matchData != null) {
            matchData.setShelfType(shelfType);
            isSupport = this.isNESupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    private boolean isNENotSupport(MatchData matchData, int funcID, String attrID) {
        TEFunctionDescrib fun = this.getNEFunction(matchData, funcID);
        boolean isSupport = false;
        if (fun != null && fun.getNotSupportAttrList() != null && !fun.getNotSupportAttrList().isEmpty()) {
            isSupport = fun.getNotSupportAttrList().contains(attrID);
        }
        return isSupport;
    }

    public TEFunctionDescrib getNEFunctionAttrInfo(int neid, String funcID) {
        MatchData matchData = this.constructMatchData(neid);
        if (matchData == null) {
            return null;
        }
        return this.getNEFunction(matchData, this.sdXMLMgr.parseInt(funcID));
    }

    public TEFunctionDescrib getNEFunctionAttrInfoByType(int neType, String funcID) {
        MatchData matchData = new MatchData();
        matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return this.getNEFunction(matchData, this.sdXMLMgr.parseInt(funcID));
    }

    public TEFunctionDescrib getCPFunctionAttrInfo(int neid, int slotid, String funcID) {
        MatchData matchData = this.constructMatchData(neid, slotid);
        TEFunctionDescrib fun = this.getCPFunctionAttrInfo(matchData, funcID);
        return fun;
    }

    public TEFunctionDescrib getCPFunctionAttrInfoByType(int boardType, String funcID) {
        MatchData matchData = new MatchData();
        matchData.setBoardType(boardType);
        TEFunctionDescrib fun = this.getCPFunctionAttrInfo(matchData, funcID);
        return fun;
    }

    private TEFunctionDescrib getCPFunctionAttrInfo(MatchData matchData, String funcID) {
        TEFunctionDescrib nefun;
        TEFunctionDescrib fun = null;
        if (matchData != null) {
            fun = this.getCPFunction(matchData, this.sdXMLMgr.parseInt(funcID));
        }
        if (fun != null && (nefun = this.getNEFunction(matchData, this.sdXMLMgr.parseInt(funcID))) != null) {
            TEFunctionDescrib funTmp = new TEFunctionDescrib();
            funTmp.getNotSupportAttrList().addAll(fun.getNotSupportAttrList());
            funTmp.getAttrDescripList().addAll(fun.getAttrDescripList());
            for (String attr : fun.getSupportAttrList()) {
                if (nefun.getNotSupportAttrList().contains(attr)) continue;
                funTmp.getSupportAttrList().add(attr);
            }
            return funTmp;
        }
        return fun;
    }

    public boolean isNENotSupport(int neid, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid);
        boolean isSupport = false;
        if (matchData != null) {
            isSupport = this.isNENotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    public boolean isNENotSupportByType(int neType, String funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return this.isNENotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
    }

    public boolean isNENotSupportByShelfType(int neid, int shelfType, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid);
        boolean isSupport = false;
        if (matchData != null) {
            matchData.setShelfType(shelfType);
            isSupport = this.isNENotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
        }
        return isSupport;
    }

    private List<Integer> getSupportCPList(int neType, long neVersion, int funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setNeType(neType);
        matchData.setNeVersion(neVersion);
        boolean isNENotSupport = this.isNENotSupport(matchData, funcID, attrID);
        ArrayList<Integer> cpList = new ArrayList<Integer>();
        if (!isNENotSupport) {
            Iterator<Map.Entry<Integer, Map<Integer, List<TEFunctionDescrib>>>> iterator = this.getBoardData().entrySet().iterator();
            Map.Entry<Integer, Map<Integer, List<TEFunctionDescrib>>> entry = null;
            while (iterator.hasNext()) {
                entry = iterator.next();
                List<TEFunctionDescrib> funList = entry.getValue().get(funcID);
                TEFunctionDescrib fun = this.getSupportFun(funList, matchData);
                if (fun == null || !fun.getSupportAttrList().contains(attrID)) continue;
                cpList.add(entry.getKey());
            }
        }
        return cpList;
    }

    private String getSupportCPStr(int neType, long neVersion, int funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(neType));
        matchData.setNeVersion(neVersion);
        boolean isNENotSupport = this.isNENotSupport(matchData, funcID, attrID);
        StringBuilder sbCps = new StringBuilder();
        if (!isNENotSupport) {
            Iterator<Map.Entry<Integer, Map<Integer, List<TEFunctionDescrib>>>> iteratorStr = this.getBoardData().entrySet().iterator();
            Map.Entry<Integer, Map<Integer, List<TEFunctionDescrib>>> entry = null;
            while (iteratorStr.hasNext()) {
                entry = iteratorStr.next();
                List<TEFunctionDescrib> funList = entry.getValue().get(funcID);
                TEFunctionDescrib fun = this.getSupportFun(funList, matchData);
                if (fun == null || !fun.getSupportAttrList().contains(attrID)) continue;
                sbCps.append(entry.getKey()).append(',');
            }
        } else {
            TELogFactory.getNormalLogger().error("ne is not support!neType=" + neType + ";neVersion=" + neVersion + ";funcID=" + funcID + ";attrID=" + attrID);
        }
        String result = "";
        if (sbCps.length() > 0) {
            result = sbCps.substring(0, sbCps.length() - 1);
        }
        return result;
    }

    public List<Integer> getSupportCPList(int neid, String funcID, String attrID) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        ArrayList<Integer> cpList = null;
        if (ne != null) {
            cpList = this.getSupportCPList(TEGetNEDomainVersion.getInstance().getDevType(ne.getNEType()), this.getNEVersion(ne), this.sdXMLMgr.parseInt(funcID), attrID);
        } else {
            cpList = new ArrayList();
            TELogFactory.getNormalLogger().error("ne is null!" + this.getLogString(neid, funcID, attrID));
        }
        return cpList;
    }

    public List<Integer> getSupportSlotList(int neid, String funcID, String attrID) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        ArrayList<Integer> slotList = new ArrayList<Integer>();
        if (ne != null) {
            List<Integer> cpList = this.getSupportCPList(neid, funcID, attrID);
            HashSet<Integer> cpSet = new HashSet<Integer>(cpList);
            Vector boardlist = ne.getBoardList();
            int len = boardlist.size();
            for (int i = 0; i < len; ++i) {
                TEBoard board = (TEBoard)boardlist.get(i);
                if (!cpSet.contains(board.getBoardType())) continue;
                slotList.add(board.getSlotID());
            }
        }
        return slotList;
    }

    public String getSupportSlotStr(int neid, String funcID, String attrID) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        StringBuilder sb = new StringBuilder();
        if (ne != null) {
            List<Integer> cpList = this.getSupportCPList(neid, funcID, attrID);
            HashSet<Integer> cpSet = new HashSet<Integer>(cpList);
            Vector boardlist = ne.getBoardList();
            int len = boardlist.size();
            for (int i = 0; i < len; ++i) {
                TEBoard board = (TEBoard)boardlist.get(i);
                if (!cpSet.contains(board.getBoardType())) continue;
                sb.append(board.getSlotID()).append(',');
            }
        }
        String result = "";
        if (sb.length() > 0) {
            result = sb.substring(0, sb.length() - 1);
        }
        return result;
    }

    public String getSupportCPStr(int neid, String funcID, String attrID) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        String strCps = "";
        if (ne != null) {
            strCps = this.getSupportCPStr(ne.getNEType(), this.getNEVersion(ne), this.sdXMLMgr.parseInt(funcID), attrID);
        } else {
            TELogFactory.getNormalLogger().error("ne is null!" + this.getLogString(neid, funcID, attrID));
        }
        return strCps;
    }

    private long getNEVersion(TENE ne) {
        String neVersion = ne.getShowNEVersion();
        if (neVersion != null && !neVersion.equals("")) {
            neVersion = ne.getHostVersion();
        }
        if (neVersion == null || neVersion.equals("")) {
            return -1L;
        }
        return Long.parseLong(neVersion.replace(".", ""));
    }

    public TESpecialAttrDescrip getCPAttrDescrip(int neid, int slotid, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid, slotid);
        if (matchData != null) {
            if (!this.isNENotSupport(matchData, this.sdXMLMgr.parseInt(funcID), attrID)) {
                return this.getCPAttrDescrib(matchData, this.sdXMLMgr.parseInt(funcID), this.sdXMLMgr.parseInt(attrID));
            }
            TELogFactory.getNormalLogger().info("ne is not support!" + this.getLogString(neid, slotid, funcID, attrID));
        }
        return null;
    }

    public TESpecialAttrDescrip getCPAttrDescripByType(int boardType, String funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setBoardType(boardType);
        return this.getCPAttrDescrib(matchData, this.sdXMLMgr.parseInt(funcID), this.sdXMLMgr.parseInt(attrID));
    }

    public TESpecialAttrDescrip getNEAttrDescrip(int neid, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid);
        if (matchData == null) {
            return null;
        }
        return this.getNEAttrDescrib(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
    }

    public TESpecialAttrDescrip getNEAttrDescripByType(int neType, String funcID, String attrID) {
        MatchData matchData = new MatchData();
        matchData.setNeType(TEGetNEDomainVersion.getInstance().getDevType(neType));
        return this.getNEAttrDescrib(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
    }

    public TESpecialAttrDescrip getNEAttrDescripByShelfType(int neid, int shelfType, String funcID, String attrID) {
        MatchData matchData = this.constructMatchData(neid);
        if (matchData == null) {
            return null;
        }
        matchData.setShelfType(shelfType);
        return this.getNEAttrDescrib(matchData, this.sdXMLMgr.parseInt(funcID), attrID);
    }

    public int getNEAttrIntValue(int neid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescrip(neid, funcID, attrID);
        int result = -1;
        if (attr != null) {
            result = attr.getIntValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, funcID, attrID));
        }
        return result;
    }

    public String getNEAttrValue(int neid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescrip(neid, funcID, attrID);
        String result = "";
        if (attr != null) {
            result = attr.getValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, funcID, attrID));
        }
        return result;
    }

    public String getNEAttrValueByType(int neType, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescripByType(neType, funcID, attrID);
        String result = "";
        if (attr != null) {
            result = attr.getValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neType, funcID, attrID));
        }
        return result;
    }

    public String getCPAttrValue(int neid, int slotid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescrip(neid, slotid, funcID, attrID);
        String result = "";
        if (attr != null) {
            result = attr.getValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, slotid, funcID, attrID));
        }
        return result;
    }

    public String getCPAttrValueByType(int boardType, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescripByType(boardType, funcID, attrID);
        String result = "";
        if (attr != null) {
            result = attr.getValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogStringByBoardType(boardType, funcID, attrID));
        }
        return result;
    }

    public long getNEAttrLongValue(int neid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescrip(neid, funcID, attrID);
        long result = -1L;
        if (attr != null) {
            result = attr.getLongValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, funcID, attrID));
        }
        return result;
    }

    public long getCPAttrLongValue(int neid, int slotid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescrip(neid, slotid, funcID, attrID);
        long result = -1L;
        if (attr != null) {
            result = attr.getLongValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, slotid, funcID, attrID));
        }
        return result;
    }

    public float getNEAttrFloatValue(int neid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescrip(neid, funcID, attrID);
        float result = -1.0f;
        if (attr != null) {
            result = attr.getFloatValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, funcID, attrID));
        }
        return result;
    }

    public float getCPAttrFloatValue(int neid, int slotid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescrip(neid, slotid, funcID, attrID);
        float result = -1.0f;
        if (attr != null) {
            result = attr.getFloatValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, slotid, funcID, attrID));
        }
        return result;
    }

    public List<String> getNEAttrListValue(int neid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescrip(neid, funcID, attrID);
        List<String> result = null;
        if (attr != null) {
            result = attr.getListValue();
        } else {
            result = new ArrayList<String>();
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, funcID, attrID));
        }
        return result;
    }

    public List<String> getNEAttrListValueByType(int neType, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescripByType(neType, funcID, attrID);
        List<String> result = null;
        if (attr != null) {
            result = attr.getListValue();
        } else {
            result = new ArrayList<String>();
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neType, funcID, attrID));
        }
        return result;
    }

    public List<String> getNEAttrListValueByShelfType(int neid, int shelfType, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getNEAttrDescripByShelfType(neid, shelfType, funcID, attrID);
        List<String> result = null;
        if (attr != null) {
            result = attr.getListValue();
        } else {
            result = new ArrayList<String>();
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, funcID, attrID));
        }
        return result;
    }

    public int getCPAttrIntValue(int neid, int slotid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescrip(neid, slotid, funcID, attrID);
        int result = -1;
        if (attr != null) {
            result = attr.getIntValue();
        } else {
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, slotid, funcID, attrID));
        }
        return result;
    }

    public List<String> getCPAttrListValue(int neid, int slotid, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescrip(neid, slotid, funcID, attrID);
        List<String> result = null;
        if (attr != null) {
            result = attr.getListValue();
        } else {
            result = new ArrayList<String>();
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogString(neid, slotid, funcID, attrID));
        }
        return result;
    }

    public List<String> getCPAttrListValueByType(int boardType, String funcID, String attrID) {
        TESpecialAttrDescrip attr = this.getCPAttrDescripByType(boardType, funcID, attrID);
        List<String> result = null;
        if (attr != null) {
            result = attr.getListValue();
        } else {
            result = new ArrayList<String>();
            TELogFactory.getNormalLogger().error("attr is null!" + this.getLogStringByBoardType(boardType, funcID, attrID));
        }
        return result;
    }
}

