/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.configmodel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.gencfg.frame.attrvaluernge.ConditionInterface;
import com.huawei.nglct.gencfg.frame.attrvaluernge.NETypeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.ShelfTypeCondition;
import com.huawei.nglct.gencfg.frame.attrvaluernge.VersionCondition;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TEFunctionDescrib;
import com.huawei.nglct.nelist.model.configmodel.TESpecailAttr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrDescrip;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEConfigModelUtil {
    public static String SUPPORT_CPTYPE = "support_cptype";
    public static String SUPPORT_NETYPE = "support_netype";
    public static String CPTYPE = "cptype";
    public static String SUPPORT_FUNCTION = "support_function";
    public static String FUNCTIONID = "functionID";
    public static String NETYPE = "netype";
    public static String SHELFTYPE = "shelftype";
    public static String NEVERSION = "neversion";
    public static String ATTR_DESCRIP = "attr_descrip";
    public static String ATTR_ID = "attr_id";
    public static String ATTR_TYPE = "attr_type";
    public static String ATTR_VALUE = "attr_value";
    public static String SUPPORT_ATTRIBID = "support_attribID";
    public static String NOT_SUPPORT_ATTRIBID = "not_support_attribID";
    public static String NE_OPT_FEATUREID = "neOptFeatureId";
    public static String DEPEND_EXIST_BD = "dependExistBd";
    public static String ATTRID = "attrID";
    public static String VERSION_SPLIT = "-";
    public static String BRACKET_START = "[";
    public static String BRACKET_END = "]";
    private static SDXMLInterpreterMgr sdXMLMgr = SDXMLInterpreterMgr.getInstance();

    private TEConfigModelUtil() {
    }

    public static List<ConditionInterface> parseNodeCondition(NamedNodeMap namedNodeMap) {
        ArrayList<ConditionInterface> list = new ArrayList<ConditionInterface>();
        if (namedNodeMap.getLength() > 0) {
            Node attr = null;
            String name = "";
            String value = "";
            int m = namedNodeMap.getLength();
            for (int i = 0; i < m; ++i) {
                attr = namedNodeMap.item(i);
                name = attr.getNodeName();
                value = attr.getNodeValue();
                if (NETYPE.equals(name) && !value.isEmpty()) {
                    NETypeCondition neType = new NETypeCondition();
                    neType.setSupportNE(value);
                    list.add(neType);
                    continue;
                }
                if (SHELFTYPE.equals(name) && !value.isEmpty()) {
                    ShelfTypeCondition shelfType = new ShelfTypeCondition();
                    shelfType.setShelfType(value);
                    list.add(shelfType);
                    continue;
                }
                if (NEVERSION.equals(name) && !value.isEmpty()) {
                    int startVersion;
                    String[] tempArr = value.split(VERSION_SPLIT);
                    int endVersion = startVersion = Integer.parseInt(tempArr[0]);
                    if (tempArr.length > 1) {
                        endVersion = Integer.parseInt(tempArr[1]);
                    }
                    VersionCondition version = new VersionCondition(startVersion, endVersion);
                    list.add(version);
                    continue;
                }
                TELogFactory.getNormalLogger().info("TEConfigModelUtil.parseNodeCondition no config!");
            }
        }
        return list;
    }

    public static Map<Integer, List<TEFunctionDescrib>> parseFunctionDescrib(Element node) {
        HashMap<Integer, List<TEFunctionDescrib>> map = new HashMap<Integer, List<TEFunctionDescrib>>();
        if (node == null || !node.hasChildNodes()) {
            return map;
        }
        NodeList nodeList = node.getElementsByTagName(SUPPORT_FUNCTION);
        Element elm = null;
        TEFunctionDescrib funDescrib = null;
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            elm = (Element)nodeList.item(i);
            int funID = sdXMLMgr.parseInt(elm.getAttribute(FUNCTIONID));
            funDescrib = new TEFunctionDescrib();
            funDescrib.setFunID(funID);
            List<ConditionInterface> conditionList = TEConfigModelUtil.parseNodeCondition(elm.getAttributes());
            if (conditionList != null && !conditionList.isEmpty()) {
                funDescrib.setConditions(conditionList);
            }
            TEConfigModelUtil.parseSupportAttrList(elm, funDescrib.getSupportSpecailAttrList());
            TEConfigModelUtil.parseNotSupportAttrList(elm, funDescrib.getNotSupportSpecailAttrList());
            TEConfigModelUtil.parseAttrDescribList(elm, funDescrib.getAttrDescripList());
            ArrayList<TEFunctionDescrib> funList = (ArrayList<TEFunctionDescrib>)map.get(funID);
            if (funList == null) {
                funList = new ArrayList<TEFunctionDescrib>();
                map.put(funID, funList);
            }
            funList.add(funDescrib);
        }
        return map;
    }

    private static void parseAttrDescribList(Element node, List<TESpecialAttrDescrip> attrDescripList) {
        if (node == null || !node.hasChildNodes()) {
            return;
        }
        NodeList nodeList = node.getElementsByTagName(ATTR_DESCRIP);
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            Element elm = (Element)nodeList.item(i);
            String attrID = elm.getAttribute(ATTR_ID);
            if (attrID == null || attrID.isEmpty()) continue;
            TESpecialAttrDescrip attrDescrip = new TESpecialAttrDescrip();
            attrDescrip.setId(SDXMLInterpreterMgr.getInstance().parseInt(attrID));
            attrDescrip.setName(attrID);
            String attrType = elm.getAttribute(ATTR_TYPE);
            String attrValue = elm.getAttribute(ATTR_VALUE);
            attrDescrip.setType(attrType);
            if ("INTLIST".equals(attrType)) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                sdXMLMgr.parseIntList(attrValue, list);
                attrValue = TEStringUtils.joinListAsComma(list);
            }
            if ("INT".equals(attrType)) {
                attrValue = String.valueOf(sdXMLMgr.parseInt(attrValue));
            }
            if ("LIST".equals(attrType)) {
                attrValue = attrValue.replace(BRACKET_START, "");
                attrValue = attrValue.replace(BRACKET_END, "");
            }
            attrDescrip.setValue(attrValue);
            String neversion = elm.getAttribute(NEVERSION);
            if (neversion != null && !neversion.isEmpty()) {
                int[] versions = TEConfigModelUtil.convertVersionStr(neversion);
                attrDescrip.setStartVersion(versions[0]);
                attrDescrip.setEndVersion(versions[1]);
            }
            TEConfigModelUtil.handleNeOptFeature(attrDescrip, elm);
            TEConfigModelUtil.handleDependExistBd(attrDescrip, elm);
            attrDescripList.add(attrDescrip);
        }
    }

    private static void handleNeOptFeature(TESpecialAttrDescrip attrDescrip, Element elm) {
        String neoptfeatureid = elm.getAttribute(NE_OPT_FEATUREID);
        if (null != neoptfeatureid && !neoptfeatureid.isEmpty()) {
            attrDescrip.setNeOptFeatureId(sdXMLMgr.parseInt(neoptfeatureid));
        }
    }

    private static void handleDependExistBd(TESpecialAttrDescrip attrDescrip, Element elm) {
        String dependexistbd = elm.getAttribute(DEPEND_EXIST_BD);
        if (null != dependexistbd && !dependexistbd.isEmpty()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            sdXMLMgr.parseIntList(dependexistbd, list);
            attrDescrip.setDependExistBd(list);
        }
    }

    private static List<TESpecailAttr> parseSupportOrNotAttrList(Element node, String tagName) {
        ArrayList<TESpecailAttr> result = new ArrayList<TESpecailAttr>();
        if (null == node || !node.hasChildNodes()) {
            return result;
        }
        NodeList nodeList = node.getElementsByTagName(tagName);
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            String dependexistbd;
            String neoptfeatureid;
            Element elm = (Element)nodeList.item(i);
            String attrIDs = elm.getAttribute(ATTRID);
            if (attrIDs == null || attrIDs.isEmpty()) continue;
            attrIDs = attrIDs.replace(BRACKET_START, "");
            attrIDs = attrIDs.replace(BRACKET_END, "");
            String[] strResult = attrIDs.split(",");
            List<String> attrList = Arrays.asList(strResult);
            TESpecailAttr attr = new TESpecailAttr();
            attr.getAttrList().addAll(attrList);
            String neversion = elm.getAttribute(NEVERSION);
            if (neversion != null && !neversion.isEmpty()) {
                int[] versions = TEConfigModelUtil.convertVersionStr(neversion);
                attr.setStartVersion(versions[0]);
                attr.setEndVersion(versions[1]);
            }
            if (null != (neoptfeatureid = elm.getAttribute(NE_OPT_FEATUREID)) && !neoptfeatureid.isEmpty()) {
                attr.setNeOptFeatureId(sdXMLMgr.parseInt(neoptfeatureid));
            }
            if (null != (dependexistbd = elm.getAttribute(DEPEND_EXIST_BD)) && !dependexistbd.isEmpty()) {
                ArrayList<Integer> list = new ArrayList<Integer>();
                sdXMLMgr.parseIntList(dependexistbd, list);
                attr.setDependExistBd(list);
            }
            result.add(attr);
        }
        return result;
    }

    private static void parseSupportAttrList(Element node, List<TESpecailAttr> supportAttrList) {
        List<TESpecailAttr> attrList = TEConfigModelUtil.parseSupportOrNotAttrList(node, SUPPORT_ATTRIBID);
        if (null != attrList && !attrList.isEmpty() && null != supportAttrList) {
            supportAttrList.addAll(attrList);
        }
    }

    private static void parseNotSupportAttrList(Element node, List<TESpecailAttr> nosupportAttrList) {
        List<TESpecailAttr> attrList = TEConfigModelUtil.parseSupportOrNotAttrList(node, NOT_SUPPORT_ATTRIBID);
        if (null != attrList && !attrList.isEmpty() && null != nosupportAttrList) {
            nosupportAttrList.addAll(attrList);
        }
    }

    private static int[] convertVersionStr(String version) {
        int[] versions;
        version = version.replace(BRACKET_START, "").replace(BRACKET_END, "");
        String[] tempArr = version.split(VERSION_SPLIT);
        versions = new int[]{Integer.parseInt(tempArr[0]), versions[0]};
        if (tempArr.length > 1) {
            versions[1] = Integer.parseInt(tempArr[1]);
        }
        return versions;
    }

    public static boolean isParamValid(Param param) {
        return null != param && null != param.getValue() && !param.getValue().isEmpty();
    }

    public static boolean isSupportFeature(int neID, long featureID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            return ne.isSupportFeature(featureID);
        }
        TELogFactory.getNormalLogger().error("get ne failed! neid:" + neID + ", featureID:" + featureID);
        return false;
    }

    public static boolean isExistBoardType(int neID, List<Integer> bdList) {
        if (null == bdList || bdList.isEmpty()) {
            return true;
        }
        List<TEBoard> boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        int len = boardList.size();
        for (int i = 0; i < len; ++i) {
            if (!bdList.contains(boardList.get(i).getBoardType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isExistBoardType(int neID, String bdList) {
        if (null != bdList && !bdList.isEmpty()) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            sdXMLMgr.parseIntList(bdList, list);
            return TEConfigModelUtil.isExistBoardType(neID, list);
        }
        return true;
    }

    public static boolean isSupportFeature(int neID, String featureID) {
        if (null != featureID && !featureID.isEmpty()) {
            return TEConfigModelUtil.isSupportFeature(neID, sdXMLMgr.parseInt(featureID));
        }
        return true;
    }
}

