/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.config.exc;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.model.config.exc.AutoExcItem;
import com.huawei.nglct.nelist.model.config.exc.WdmAutoExc;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEWdmAutoExcMgr {
    private static TEWdmAutoExcMgr teWdmAutoExcMgrInstance = null;
    private static String filepath = TEResourceManager.getPath() + File.separator + "conf" + File.separator + "core" + File.separator + "autoexctype.xml";
    private static final int TYPE_UNKNOWN = 255;
    private static final String AUTOEXC_DESCRIPTION = "autoexc_description";
    private static final String ITEM = "item";
    SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
    private HashMap autoExcByDevice = new HashMap();

    private TEWdmAutoExcMgr() {
        this.loadAutoExcXml();
    }

    public static synchronized TEWdmAutoExcMgr getInstance() {
        if (null == teWdmAutoExcMgrInstance) {
            teWdmAutoExcMgrInstance = new TEWdmAutoExcMgr();
        }
        return teWdmAutoExcMgrInstance;
    }

    private void loadAutoExcXml() {
        Document doc = null;
        doc = TEParseXMLFile.parseFile(filepath);
        if (null == doc) {
            TELogFactory.getNormalLogger().info("Parse autoexctype.xml file fail!");
            return;
        }
        NodeList nodelist = doc.getElementsByTagName("device");
        if (null != nodelist && nodelist.getLength() > 0) {
            for (int i = nodelist.getLength() - 1; i >= 0; --i) {
                if (!(nodelist.item(i) instanceof Element)) continue;
                Element element = (Element)nodelist.item(i);
                String deviceType = element.getAttribute("device_type");
                NodeList autoExclist = element.getChildNodes();
                if (null == autoExclist || autoExclist.getLength() <= 0) continue;
                this.parserAutoExc(autoExclist, deviceType);
            }
        }
    }

    private void parserAutoExc(NodeList autoExclist, String deviceType) {
        ArrayList<WdmAutoExc> autoExcBtDeviceList = new ArrayList<WdmAutoExc>();
        for (int j = autoExclist.getLength() - 1; j >= 0; --j) {
            Element autoExc;
            if (!(autoExclist.item(j) instanceof Element) || !(autoExc = (Element)autoExclist.item(j)).getNodeName().equals(AUTOEXC_DESCRIPTION)) continue;
            WdmAutoExc exc = new WdmAutoExc();
            exc.autoexc_name = autoExc.getAttribute("autoexc_name");
            exc.autoexc_type = autoExc.getAttribute("autoexc_type");
            exc.interface_level = autoExc.getAttribute("interface_level");
            NodeList exclist = autoExc.getChildNodes();
            if (null != exclist && exclist.getLength() > 0) {
                exc.items = this.parserExcItem(exclist);
            }
            autoExcBtDeviceList.add(exc);
        }
        this.autoExcByDevice.put(deviceType, autoExcBtDeviceList);
    }

    private ArrayList parserExcItem(NodeList exclist) {
        ArrayList<AutoExcItem> items = new ArrayList<AutoExcItem>();
        for (int i = exclist.getLength() - 1; i >= 0; --i) {
            Element excEle;
            if (!(exclist.item(i) instanceof Element) || !(excEle = (Element)exclist.item(i)).getNodeName().equals(ITEM)) continue;
            AutoExcItem excItem = new AutoExcItem();
            excItem.exc_port = Integer.parseInt(excEle.getAttribute("exc_port"));
            excItem.exc_level = excEle.getAttribute("exc_level");
            NodeList portElemList = excEle.getChildNodes();
            if (null != portElemList && portElemList.getLength() > 0) {
                for (int j = portElemList.getLength() - 1; j >= 0; --j) {
                    if (!(portElemList.item(j) instanceof Element)) continue;
                    Element portElement = (Element)portElemList.item(j);
                    if (portElement.getNodeName().equals("srcendport")) {
                        excItem.srcPortNum = Integer.parseInt(portElement.getAttribute("port"));
                        excItem.srcChannelNum = Integer.parseInt(portElement.getAttribute("channel"));
                        continue;
                    }
                    if (!portElement.getNodeName().equals("sinkendport")) continue;
                    excItem.snkPortNum = Integer.parseInt(portElement.getAttribute("port"));
                    excItem.snkChannelNum = Integer.parseInt(portElement.getAttribute("channel"));
                }
            }
            items.add(excItem);
        }
        return items;
    }

    public WdmAutoExc getWdmAutoExc(String deviceName, String autoExcName, String autoExcType, String interfaceLevel) {
        ArrayList autoExcList = this.getAutoExcByDeviceName(deviceName);
        if (autoExcList != null) {
            for (int i = autoExcList.size() - 1; i >= 0; --i) {
                if (!(autoExcList.get(i) instanceof WdmAutoExc)) continue;
                WdmAutoExc exc = (WdmAutoExc)autoExcList.get(i);
                Integer levelValue = this.instance.parseInt(exc.interface_level);
                if (levelValue == null || !exc.autoexc_name.equals(autoExcName) || !exc.autoexc_type.equals(autoExcType) || Integer.parseInt(interfaceLevel) != levelValue) continue;
                return exc;
            }
        }
        TELogFactory.getNormalLogger().error("Connot found autoexc for:deviceName=" + deviceName + " autoexc_name=" + autoExcName + " autoexc_type" + autoExcType + "interface_level" + interfaceLevel + " in autoexctype.xml");
        return null;
    }

    private ArrayList getAutoExcByDeviceName(String deviceName) {
        return (ArrayList)this.autoExcByDevice.get(deviceName);
    }

    public static void main(String[] args) {
        ArrayList excs = TEWdmAutoExcMgr.getInstance().getAutoExcByDeviceName("TYPE_UNKNOWN");
        for (int i = 0; i < excs.size(); ++i) {
            ((WdmAutoExc)excs.get(i)).print();
        }
        TEWdmAutoExcMgr.getInstance().getWdmAutoExc("TYPE_UNKNOWN", "GRP_NGWDM_AUTOCREATEODU2BYODU1", "XC_SRC_TP", "IL_WDM_OTU1").print();
    }
}

