/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.circuitpack;

import com.huawei.nglct.nelist.model.TEFunBlockID;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TEStaticFBCount;
import java.util.ArrayList;
import java.util.List;

public class TESDPortRecord {
    private ArrayList portNoList = null;
    public int portType = -1;
    private int portSpeed = -1;
    private int addibleType = 0;
    private ArrayList portLevelList = new ArrayList();
    private ArrayList funBlockPropertyList = null;
    public int outPortType = 255;
    public int domainType = 255;
    public String portTypeName = "";
    public String moClassName = "";
    public ArrayList levelList = new ArrayList();
    public boolean bVisible = true;
    public boolean bNameUpdable = false;
    public ArrayList containFBList = new ArrayList();

    TESDPortRecord(int iAddibleType, int iPortType, int iPortSpeed, ArrayList thePortNoList, ArrayList theFunblockList) {
        this.portType = iPortType;
        this.portSpeed = iPortSpeed;
        this.addibleType = iAddibleType;
        this.portNoList = thePortNoList;
        this.funBlockPropertyList = theFunblockList;
    }

    TESDPortRecord(int iAddibleType, int iPortType, int iPortSpeed, ArrayList thePortNoList) {
        this.portType = iPortType;
        this.portSpeed = iPortSpeed;
        this.addibleType = iAddibleType;
        this.portNoList = thePortNoList;
        this.funBlockPropertyList = null;
    }

    TESDPortRecord(int iAddibleType, int iPortType, int iPortSpeed) {
        this.addibleType = iAddibleType;
        this.portType = iPortType;
        this.portSpeed = iPortSpeed;
    }

    TESDPortRecord(int iPortType, int iPortSpeed, ArrayList thePortNoList, ArrayList theFunblockList) {
        this.portType = iPortType;
        this.portSpeed = iPortSpeed;
        this.portNoList = thePortNoList;
        this.funBlockPropertyList = theFunblockList;
    }

    TESDPortRecord(int iPortType, int iPortSpeed, ArrayList thePortNoList) {
        this(iPortType, iPortSpeed, thePortNoList, null);
    }

    ArrayList getPortNoList() {
        return this.portNoList;
    }

    ArrayList getFunBlockPropertyList() {
        return this.funBlockPropertyList;
    }

    List getSupportFBPropertyList() {
        TEFunBlockProperty fb = null;
        int size = this.funBlockPropertyList.size();
        ArrayList<Integer> list = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            fb = (TEFunBlockProperty)this.funBlockPropertyList.get(i);
            list.add(new Integer(fb.getFuctionBlockType()));
        }
        return list;
    }

    public int getPortType() {
        return this.portType;
    }

    public int getPortSpeed() {
        return this.portSpeed;
    }

    public int getAddibleType() {
        return this.addibleType;
    }

    boolean isOpticalPortType() {
        return (this.addibleType & 0xFF) == 1;
    }

    boolean isElectricPortType() {
        return (this.addibleType & 0xFF) == 0;
    }

    void setFunBlockPropertyList(List funblockList) {
        if (funblockList == null) {
            return;
        }
        int size = funblockList.size();
        if (this.funBlockPropertyList != null) {
            this.funBlockPropertyList.clear();
            this.funBlockPropertyList.ensureCapacity(size);
        } else {
            this.funBlockPropertyList = new ArrayList(size);
        }
        TEStaticFBCount fbcount = null;
        for (int i = 0; i < funblockList.size(); ++i) {
            fbcount = (TEStaticFBCount)funblockList.get(i);
            ArrayList<TEFunBlockID> fbList = new ArrayList<TEFunBlockID>(fbcount.getFunBlockTypeCount());
            for (int j = 0; j < fbcount.getFunBlockTypeCount(); ++j) {
                TEFunBlockID tmpfunID = new TEFunBlockID(j + 1, 0);
                fbList.add(tmpfunID);
            }
            TEFunBlockProperty FunBlock = new TEFunBlockProperty(fbcount.getFuctionBlockType(), fbList);
            this.funBlockPropertyList.add(FunBlock);
        }
    }

    void setFunBlockPropertyList() {
    }

    public TESDPortRecord() {
    }

    public TESDPortRecord(int portType, int outerType, int domainType, String portTypeName, String moClassName, ArrayList levelList, boolean bVisible, boolean bNameUpdable) {
        this.portType = portType;
        this.outPortType = outerType;
        this.domainType = domainType;
        this.portTypeName = portTypeName;
        this.moClassName = moClassName;
        this.bVisible = bVisible;
        this.bNameUpdable = bNameUpdable;
        this.levelList = levelList;
    }

    public void setPortLevelList(ArrayList portLevelList) {
        this.portLevelList.addAll(portLevelList);
    }

    public ArrayList getPortLevelList() {
        return this.portLevelList;
    }
}

