/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.circuitpack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TECPMappingAbility
implements Cloneable {
    private Map<Integer, Map<Integer, List<Integer>>> mappingMap = new HashMap<Integer, Map<Integer, List<Integer>>>();

    public Map<Integer, Map<Integer, List<Integer>>> getMappingMap() {
        return this.mappingMap;
    }

    public void setMappingMap(Map<Integer, Map<Integer, List<Integer>>> mappingMap) {
        this.mappingMap = mappingMap;
    }

    public List<Integer> getPortsByDomain(int domain) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        if (domain == 0) {
            ports.addAll(this.mappingMap.keySet());
        } else {
            for (int port : this.mappingMap.keySet()) {
                Set<Integer> serviceTypes = this.mappingMap.get(port).keySet();
                if (!serviceTypes.contains(domain)) continue;
                ports.add(port);
            }
        }
        return ports;
    }

    public List<Integer> getPathsByDomainAndport(int port, int domain) {
        ArrayList<Integer> paths = new ArrayList<Integer>();
        for (int tempPort : this.mappingMap.keySet()) {
            if (port != 0 && port != tempPort) continue;
            Map<Integer, List<Integer>> tempMap = this.mappingMap.get(tempPort);
            for (int tempSerivceType : tempMap.keySet()) {
                if (tempSerivceType != 0 && tempSerivceType != domain) continue;
                paths.addAll((Collection<Integer>)tempMap.get(tempSerivceType));
            }
        }
        return paths;
    }

    public Map<Integer, List<Integer>> getPortsAndPathsByDoamin(int domain) {
        HashMap<Integer, List<Integer>> resMap = new HashMap<Integer, List<Integer>>();
        Iterator<Integer> portIter = this.mappingMap.keySet().iterator();
        ArrayList paths = new ArrayList();
        while (portIter.hasNext()) {
            paths.clear();
            int tempPort = portIter.next();
            resMap.put(tempPort, paths);
            Map<Integer, List<Integer>> tempMap = this.mappingMap.get(tempPort);
            for (int tempSerivceType : tempMap.keySet()) {
                if (tempSerivceType != 0 && tempSerivceType != domain) continue;
                paths.addAll(tempMap.get(tempSerivceType));
            }
        }
        return resMap;
    }

    public void createMappingObj(List<Integer> ports, List<Integer> paths, List<Integer> serviceTypes) {
        Map<Integer, List<Integer>> serviceToPath = null;
        List<Integer> tempList = null;
        for (int port : ports) {
            for (int serviceType : serviceTypes) {
                serviceToPath = this.mappingMap.get(port);
                if (serviceToPath == null) {
                    serviceToPath = new HashMap<Integer, List<Integer>>();
                }
                if ((tempList = serviceToPath.get(serviceType)) == null) {
                    tempList = new ArrayList<Integer>();
                    tempList.addAll(paths);
                    serviceToPath.put(serviceType, tempList);
                } else {
                    tempList.addAll(paths);
                }
                this.mappingMap.put(port, serviceToPath);
            }
        }
    }

    public Object clone() {
        TECPMappingAbility record = null;
        try {
            record = (TECPMappingAbility)super.clone();
            HashMap<Integer, Map<Integer, List<Integer>>> mainMap = new HashMap<Integer, Map<Integer, List<Integer>>>();
            HashMap subMap = null;
            ArrayList<Integer> paths = null;
            Iterator<Integer> mainIter = this.mappingMap.keySet().iterator();
            Map<Integer, List<Integer>> tempMap = null;
            List<Integer> tempList = null;
            while (mainIter.hasNext()) {
                int key1 = mainIter.next();
                tempMap = this.mappingMap.get(key1);
                subMap = new HashMap();
                for (int key2 : tempMap.keySet()) {
                    tempList = tempMap.get(key2);
                    paths = new ArrayList<Integer>();
                    for (int path : tempList) {
                        paths.add(path);
                    }
                    subMap.put(key2, paths);
                }
                mainMap.put(key1, subMap);
            }
            record.setMappingMap(mainMap);
        }
        catch (Exception e) {
            throw new InternalError();
        }
        return record;
    }
}

