/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.circuitpack;

import com.huawei.nglct.nelist.model.TEFunBlockID;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.TEStaticFBCount;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOCount;
import java.util.ArrayList;

public final class TEBoardTypeProperty {
    private int boardType = -1;
    private boolean isWDMBoardType = false;
    private int wdmFunType = 255;
    private String boardTypeName = "";
    private String boardName = "";
    private int occupiedSlotNum = 1;
    private int addibleBoardType = -1;
    private ArrayList portPropertyList = new ArrayList();
    private ArrayList dynportPropertyList = new ArrayList();
    private ArrayList funBlockPropertyList = new ArrayList();
    private ArrayList staticFunBlockPropertyList = new ArrayList();
    private ArrayList xcStaticList = new ArrayList();
    private ArrayList autoexcList = new ArrayList();
    private ArrayList portParaList = null;
    private ArrayList portExcLevel = null;
    public ArrayList supportLevelList = new ArrayList();

    public TEBoardTypeProperty(int boardtype, String strBoardTypeName, int iAddibleBoardType, boolean isDWDMBoardType, int occupiedSlotNum, ArrayList levellist) {
        this.boardType = boardtype;
        this.boardTypeName = strBoardTypeName;
        this.addibleBoardType = iAddibleBoardType;
        this.isWDMBoardType = isDWDMBoardType;
        this.occupiedSlotNum = occupiedSlotNum;
        this.supportLevelList = levellist;
    }

    public ArrayList getLevelList() {
        return this.supportLevelList;
    }

    public ArrayList getPortPropertyList() {
        return this.portPropertyList;
    }

    public ArrayList getDynPropertyList() {
        return this.dynportPropertyList;
    }

    public void setXCStaticList(ArrayList xcStaticList) {
        this.xcStaticList.addAll(xcStaticList);
    }

    public ArrayList getXCStaticList() {
        return this.xcStaticList;
    }

    public int getPortNum() {
        int portNum = 0;
        if (this.portPropertyList != null) {
            for (int i = 0; i < this.portPropertyList.size(); ++i) {
                portNum += ((TEPortProperty)this.portPropertyList.get(i)).getPortNoList().size();
            }
        }
        return portNum;
    }

    public ArrayList getFunBlockPropertyList() {
        ArrayList funBlockList = new ArrayList(this.funBlockPropertyList.size());
        funBlockList.addAll(this.funBlockPropertyList);
        funBlockList.addAll(this.getPortFunBlockPropertyList());
        return funBlockList;
    }

    public ArrayList getSupportedFunBlockTypeList() {
        ArrayList allFunBlockList = this.getFunBlockPropertyList();
        ArrayList<Integer> typeList = new ArrayList<Integer>(allFunBlockList.size());
        int size = allFunBlockList.size();
        for (int i = 0; i < size; ++i) {
            typeList.add(new Integer(((TEFunBlockProperty)allFunBlockList.get(i)).getFuctionBlockType()));
        }
        size = this.staticFunBlockPropertyList.size();
        for (int j = 0; j < size; ++j) {
            TEStaticFBCount fbcount = (TEStaticFBCount)this.staticFunBlockPropertyList.get(j);
            typeList.add(new Integer(fbcount.getFuctionBlockType()));
        }
        return typeList;
    }

    public ArrayList getBoardFunBlockList() {
        return this.funBlockPropertyList;
    }

    public ArrayList getPortFunBlockPropertyList() {
        ArrayList portFunBlockList = new ArrayList();
        int size = this.portPropertyList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty portProperty = (TEPortProperty)this.portPropertyList.get(i);
            portFunBlockList.addAll(portProperty.getFunBlockPropertyList());
        }
        return portFunBlockList;
    }

    public ArrayList getDynPortFunBlockPropertyList() {
        ArrayList dynPortFunBlockList = new ArrayList();
        int size = this.dynportPropertyList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty portProperty = (TEPortProperty)this.dynportPropertyList.get(i);
            dynPortFunBlockList.addAll(portProperty.getFunBlockPropertyList());
        }
        return dynPortFunBlockList;
    }

    public int getBoardType() {
        return this.boardType;
    }

    public String getBoardTypeName() {
        return this.boardTypeName;
    }

    public int getOccupiedSlotNum() {
        return this.occupiedSlotNum;
    }

    public void setSupportedDynPortList(ArrayList dynPortList) {
        if (null == dynPortList) {
            return;
        }
        int size = dynPortList.size();
        for (int i = 0; i < size; ++i) {
            TECPAddiblePortRecord portInfo = (TECPAddiblePortRecord)dynPortList.get(i);
            TEPortProperty portProperty = new TEPortProperty(portInfo.signalType, portInfo.portDynType, portInfo.m_interface, portInfo.portNoList);
            ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(portInfo.portType, portInfo.m_interface, true);
            portProperty.setFunBlockPropertyList(portFBList);
            this.dynportPropertyList.add(portProperty);
        }
    }

    public void setPortParaList(ArrayList portParaList) {
        this.portParaList = portParaList;
    }

    public ArrayList getPortParaList() {
        return this.portParaList;
    }

    public void setPortExcLevel(ArrayList portExcLevel) {
        this.portExcLevel = portExcLevel;
    }

    public ArrayList getPortExcLevel() {
        return this.portExcLevel;
    }

    public void setPortList(ArrayList installPortList) {
        if (installPortList == null) {
            return;
        }
        int size = installPortList.size();
        this.portPropertyList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            TEInstallCPPortRecord installCPPortRecord = (TEInstallCPPortRecord)installPortList.get(i);
            TEPortProperty portProperty = new TEPortProperty(installCPPortRecord.signalType, installCPPortRecord.portType, installCPPortRecord.interfaceLevel, installCPPortRecord.portIDList);
            portProperty.setPortUsage(installCPPortRecord.portUsage);
            portProperty.setAidFrefix(installCPPortRecord.aidFrefix);
            portProperty.setPortOffset(installCPPortRecord.portOffset);
            ArrayList portFBList = TEPortDescription.getInstance().getPortFBList(installCPPortRecord.portType, installCPPortRecord.interfaceLevel, true);
            portProperty.setFunBlockPropertyList(portFBList);
            portProperty.setBelongCPModel(installCPPortRecord.cpMode);
            this.portPropertyList.add(portProperty);
        }
    }

    public void addPort(TEPortProperty _port) {
        this.portPropertyList.add(_port);
    }

    public void setFunctionBlockList(ArrayList containedFunctionBlockList) {
        if (containedFunctionBlockList == null) {
            return;
        }
        int size = containedFunctionBlockList.size();
        this.funBlockPropertyList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            TESDContianMOCount moCountRecord = (TESDContianMOCount)containedFunctionBlockList.get(i);
            if (moCountRecord == null || moCountRecord.moCount <= 0) continue;
            ArrayList<TEFunBlockID> ttpIDList = new ArrayList<TEFunBlockID>(moCountRecord.moCount);
            for (int j = 0; j < moCountRecord.moCount; ++j) {
                ttpIDList.add(new TEFunBlockID(j + 1, 0));
            }
            int fbType = TEFuncBlockDescription.getInstance().getFBTypeClassName(moCountRecord.moName);
            if (255 == fbType) continue;
            moCountRecord.setFBType(fbType);
            TEFunBlockProperty funblockproperty = new TEFunBlockProperty(moCountRecord.fbType, ttpIDList);
            this.funBlockPropertyList.add(funblockproperty);
        }
    }

    public void setStaticFunblockDataList(ArrayList fbDataList) {
        if (fbDataList == null || fbDataList.size() <= 0) {
            return;
        }
        int size = fbDataList.size();
        this.staticFunBlockPropertyList = new ArrayList(size);
        for (int i = 0; i < size; ++i) {
            int fbType = (Integer)fbDataList.get(i);
            TEStaticFBCount fbcount = new TEStaticFBCount(fbType, 1);
            this.staticFunBlockPropertyList.add(fbcount);
        }
    }

    public int getBoardWDMFunType() {
        return this.wdmFunType;
    }

    public void setBoardWDMFunType(int funType) {
        this.wdmFunType = funType;
    }

    public void setBoardName(String boardName) {
        this.boardName = boardName;
    }

    public String getBoardName() {
        return this.boardName;
    }

    public boolean isMutativeBoardType() {
        return (this.addibleBoardType & 8) != 0;
    }

    public boolean isIntefaceBoardType() {
        return (this.addibleBoardType & 2) != 0;
    }

    public boolean isProcessBoardType() {
        return (this.addibleBoardType & 1) != 0;
    }

    public boolean isSupportDynPortType() {
        return (this.addibleBoardType & 0x20) != 0;
    }

    public boolean isDWDMBoardType() {
        return this.isWDMBoardType;
    }

    public TEPortProperty getPortProperty(int portNo) {
        int size = this.portPropertyList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty tmpPort = (TEPortProperty)this.portPropertyList.get(i);
            if (!tmpPort.getPortNoList().contains(new Integer(portNo))) continue;
            return tmpPort;
        }
        return null;
    }

    public TEPortProperty getPortProperty(String aidFrefix) {
        if (this.boardType == 60010) {
            int size = this.portPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEPortProperty tmpPort = (TEPortProperty)this.portPropertyList.get(i);
                if (!tmpPort.getAidFreFix().equals(aidFrefix) || tmpPort.getPortOffset() == 0) continue;
                return tmpPort;
            }
        } else {
            int size = this.portPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEPortProperty tmpPort = (TEPortProperty)this.portPropertyList.get(i);
                if (!tmpPort.getAidFreFix().equals(aidFrefix)) continue;
                return tmpPort;
            }
        }
        return null;
    }

    public ArrayList getAutoexcList() {
        return this.autoexcList;
    }

    public void setAutoexcList(ArrayList autoexcList) {
        this.autoexcList = autoexcList;
    }
}

