/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.channel;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QueryWDMMode {
    public static final int TIME_OUT = 10;
    public static final int OTN_Board_InSDHMode = 2;
    public static final int OTN_Board_InOTNMode = 1;
    public static final int BOARD_ODU1CONV_MODE = 14;
    public static final int BOARD_ODU1UNCONV_MODE = 15;
    public static final int BOARD_ONEANY2ODU2_MODE = 17;
    public static final int BOARD_TWOANY2ODU2_MODE = 19;
    public static final int BOARD_ODU0_ODU1_MODE = 20;
    public static final int BOARD_ALONE_MODE = 163;
    public static final int BOARD_CONNECT_MODE = 162;
    public static final int BOARD_SERVICE_MODE = 160;
    public static final int BOARD_HUB_MODE = 161;
    public static final int BOARD_RELAY_MODE = 169;
    public static final int OPTICAL_RELAY_MODE = 170;
    public static final int BOARD_LINE_MODE = 168;
    public static final int BOARD_AP8_MODE = 3;
    public static final int BOARD_2LQM_MODE = 4;
    public static final int BOARD_OES_MODE = 7;
    public static final int BOARD_NORMAL_MODE = 8;
    public static final int BOARD_OADM_MODE = 9;
    public static final int BOARD_DAITONG_MODE = 10;
    public static final int BOARD_OTN_MODE = 12;
    public static final int BOARD_10GE_MODE = 13;
    public static final int BOARD_ODU0_MODE = 2;
    public static final int BOARD_NONEODU0_MODE = 1;
    public static final String PAYLOADTYPE_MODE_ODU1 = "1";
    public static final String PAYLOADTYPE_MODE_ODU2 = "2";
    public static final int PAYLOADTYPE_NONE = 0;
    public static final int PAYLOADTYPE_OTU1 = 513;
    public static final int PAYLOADTYPE_OTU2 = 514;
    public static final int PAYLOADTYPE_OTU3 = 515;
    public static final int PAYLOADTYPE_OTU3E = 517;
    public static final int PAYLOADTYPE_OTU2V = 518;
    public static final int PAYLOADTYPE_OTU5G = 516;
    public static final int PAYLOADTYPE_OTU4 = 521;
    public static final int PAYLOADTYPE_ODU1 = 529;
    public static final int PAYLOADTYPE_ODU2 = 530;
    public static final int PAYLOADTYPE_ODU3 = 531;
    public static final int PAYLOADTYPE_ODU5G = 532;
    public static final int PAYLOADTYPE_GE = 257;
    public static final int PAYLOADTYPE_10GE_LAN = 258;
    public static final int PAYLOADTYPE_10GE_WAN = 259;
    public static final int PAYLOADTYPE_FE = 260;
    public static final int PAYLOADTYPE_STM_1 = 769;
    public static final int PAYLOADTYPE_STM_4 = 770;
    public static final int PAYLOADTYPE_STM_16 = 771;
    public static final int PAYLOADTYPE_STM_64 = 772;
    public static final int PAYLOADTYPE_STM_256 = 773;
    public static final int PAYLOADTYPE_OC3 = 1025;
    public static final int PAYLOADTYPE_OC12 = 1026;
    public static final int PAYLOADTYPE_OC48 = 1027;
    public static final int PAYLOADTYPE_OC192 = 1028;
    public static final int PAYLOADTYPE_OC768 = 405;
    public static final int PAYLOADTYPE_FC50 = 1281;
    public static final int PAYLOADTYPE_FC100 = 1282;
    public static final int PAYLOADTYPE_FC200 = 1283;
    public static final int PAYLOADTYPE_FC400 = 1284;
    public static final int PAYLOADTYPE_FC1000 = 1285;
    public static final int PAYLOADTYPE_FICON = 1537;
    public static final int PAYLOADTYPE_FICON_E = 1538;
    public static final int PAYLOADTYPE_HDTV = 1793;
    public static final int PAYLOADTYPE_DVB_ASI = 2049;
    public static final int PAYLOADTYPE_DVB_SDI = 2050;
    public static final int PAYLOADTYPE_ESCON = 2305;
    public static final int PAYLOADTYPE_GPON = 2307;
    public static final int PAYLOADTYPE_FDDI = 2561;
    public static final int PAYLOADTYPE_ANY = 65535;
    public static final int CLIENT_SIDE_COLOR_OPTICAL_PORT = 7;
    public static final int LINE_SIDE_COLOR_OPTICAL_PORT = 8;
    public static final String ODU1CONV_MODE = "ODU1CONV_MODE";
    public static final String ODU1UNCONV_MODE = "ODU1UNCONV_MODE";
    public static final String ONEANY2ODU2_MODE = "ONEANY2ODU2_MODE";
    public static final String TWOANY2ODU2_MODE = "TWOANY2ODU2_MODE";
    public static final String ODU0ODU1MIX_MODE = "ODU0ODU1_MODE";
    public static final String WDM_OTNMode = "WDM_OTN";
    public static final String WDM_SDHMode = "WDM_SDH";
    public static final String WDM_NONEMode = "WDM_NONE";
    public static final String CONNECT_MODE = "CONNECT_MODE";
    public static final String ALONE_MODE = "ALONE_MODE";
    public static final String AP8_MODE = "AP8_MODE";
    public static final String LQM2_MODE = "2LQM_MODE";
    public static final String OES_MODE = "OES_MODE";
    public static final String NORMAL_MODE = "NORMAL_MODE";
    public static final String OADM_MODE = "OADM_MODE";
    public static final String DAITONG_MODE = "DAITONG_MODE";
    public static final String NONEODU0_MODE = "NONEODU0_MODE";
    public static final String ODU0_MODE = "ODU0_MODE";
    public static final String SERVICE_MODE = "SERVICE_MODE";
    public static final String HUB_MODE = "HUB_MODE";
    public static final String LINE_MODE = "LINE_MODE";
    public static final String RELAY_MODE = "RELAY_MODE";
    public static final int CLIENT_MODE = 0;
    public static final int OTN_MODE = 1;
    public static final String OTN_MODE_12 = "OTN_MODE";
    public static final String IP_10GE_MODE_13 = "10GE_MODE";
    public static final String OP_RELAY_MODE = "OP_RELAY_MODE";
    public static final int TRIBUTRAY_ODU0_NON_AGGREGATION = 1;
    public static final int TRIBUTRAY_ODU1_MAPPING = 257;
    public static final int TRIBUTRAY_ODU1_AGGREGATION = 260;
    public static final int TRIBUTRAY_ODU1_NON_AGGREGATION = 261;

    private static boolean needGetServiceMode(int port, int boardType) {
        boolean ret = false;
        if (boardType == 1194 && port <= 10) {
            ret = true;
        } else if ((boardType == 1185 || boardType == 1186 || boardType == 1188 || boardType == 1193) && port <= 6) {
            ret = true;
        }
        return ret;
    }

    public static String QueryBoardWorkMode(int neID, int slotID, int port, int boardType) {
        if (QueryWDMMode.needGetServiceMode(port, boardType)) {
            if (TEGenCfgDataMgr.isSupportAttr(neID, slotID, "W32PORT_ATTR_PORTSVCMODE")) {
                return QueryWDMMode.queryPortServiceMode(neID, slotID, port);
            }
            if (TEGenCfgDataMgr.isSupportAttr(neID, slotID, "W32PORT_ATTR_CLIENTSERVICEMODE")) {
                return QueryWDMMode.queryClientServiceMode(neID, slotID, port);
            }
        } else {
            if (TEGenCfgDataMgr.isSupportAttr(neID, slotID, "W32PORT_ATTR_ST_SERVICEMODE")) {
                return QueryWDMMode.queryLinePortWDMWorkMode(neID, slotID, port);
            }
            if (TEGenCfgDataMgr.isSupportAttr(neID, slotID, "W32PORT_ATTR_ST_SERVICETYPE")) {
                return QueryWDMMode.queryPayloadType(neID, slotID, port);
            }
        }
        return "";
    }

    public static String QueryBoardWorkMode(int neID, int slotID, int port) {
        if (TEGenCfgDataMgr.isSupportAttr(neID, slotID, "W32PORT_ATTR_ST_SERVICEMODE")) {
            return QueryWDMMode.queryLinePortWDMWorkMode(neID, slotID, port);
        }
        if (TEGenCfgDataMgr.isSupportAttr(neID, slotID, "W32PORT_ATTR_ST_SERVICETYPE")) {
            return QueryWDMMode.queryPayloadType(neID, slotID, port);
        }
        return "";
    }

    public static int queryPortType(int neID, int slotID, int port) {
        int portType = 7;
        try {
            Output output;
            ArrayList<Object> operationList = new ArrayList<Object>();
            Operation operation = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORT");
            Input input = operation.getInput();
            input.setPartValue("slotID", String.valueOf(slotID));
            input.setPartValue("portID", String.valueOf(port));
            operationList.add(operation.clone());
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (0 == result && (output = (operation = (Operation)operationList.get(0)).getOutput(0)).getFault(0).getCode().equals("0")) {
                portType = Integer.parseInt(output.getPartValue("portType"));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[QueryWDMMode] queryPortType fail!", (Throwable)e);
        }
        switch (portType) {
            case 7: 
            case 8: {
                return 12;
            }
        }
        return 200;
    }

    private static String queryPayloadType(int neID, int slotID, int port) {
        try {
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PAYLOADTYPE");
            Input input = oper.getInput();
            Part part2 = input.getPart("slotid");
            part2.setValue(String.valueOf(slotID));
            part2 = input.getPart("port");
            part2.setValue(String.valueOf(port));
            part2 = input.getPart("path");
            part2.setValue("0");
            int neType = TENEListMgr.getInstance().getNE(neID).getNEType();
            int bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neID, slotID);
            if (67 == neType && (bdtype == 1613 || bdtype == 1309 || bdtype == 1310)) {
                part2.setValue(PAYLOADTYPE_MODE_ODU1);
            }
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (resualt == 0) {
                ArrayList<String> serviceTypeList = new ArrayList<String>();
                Output[] outputArr = ((Operation)operationList.get(0)).getOutput();
                for (int j = 0; j < outputArr.length; ++j) {
                    Part[] parts = outputArr[j].getPart();
                    String name = "";
                    for (Part part2 : parts) {
                        name = part2.getName();
                        if (!name.equalsIgnoreCase("W32PORT_ATTR_ST_SERVICETYPE") || part2.getValue() == null) continue;
                        String payloadType = QueryWDMMode.getPayloadType(Integer.parseInt(part2.getValue()));
                        serviceTypeList.add(payloadType);
                    }
                }
                if (serviceTypeList.contains(WDM_OTNMode)) {
                    return WDM_OTNMode;
                }
                if (serviceTypeList.contains(WDM_SDHMode)) {
                    return WDM_SDHMode;
                }
                return WDM_NONEMode;
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        return WDM_NONEMode;
    }

    public static String getPayloadType(int payloadValue) {
        switch (payloadValue) {
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 521: 
            case 529: 
            case 530: 
            case 531: 
            case 532: {
                return WDM_OTNMode;
            }
            case 0: 
            case 1537: 
            case 1538: 
            case 2049: 
            case 2305: 
            case 2307: {
                return WDM_NONEMode;
            }
        }
        return WDM_SDHMode;
    }

    private static String queryLinePortWDMWorkMode(int neID, int slotID, int port) {
        int value = 2;
        try {
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_WDMMODE");
            Input input = oper.getInput();
            Part part2 = input.getPart("slotid");
            part2.setValue(String.valueOf(slotID));
            part2 = input.getPart("port");
            part2.setValue(String.valueOf(port));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (resualt == 0) {
                Part[] parts = ((Operation)operationList.get(0)).getOutput(0).getPart();
                String name = "";
                for (Part part2 : parts) {
                    name = part2.getName();
                    if (!name.equalsIgnoreCase("W32PORT_ATTR_ST_SERVICEMODE")) continue;
                    value = new Integer(part2.getValue());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        switch (value) {
            case 2: {
                return WDM_SDHMode;
            }
            case 1: {
                return WDM_OTNMode;
            }
        }
        return WDM_SDHMode;
    }

    private static String queryClientServiceMode(int neID, int slotID, int port) {
        int value = 0;
        try {
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_CLIENTPLTYPE");
            Input input = oper.getInput();
            Part part2 = input.getPart("slotid");
            part2.setValue(String.valueOf(slotID));
            part2 = input.getPart("port");
            part2.setValue(String.valueOf(port));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (resualt == 0) {
                Part[] parts = ((Operation)operationList.get(0)).getOutput(0).getPart();
                String name = "";
                for (Part part2 : parts) {
                    name = part2.getName();
                    if (!name.equalsIgnoreCase("W32PORT_ATTR_CLIENTSERVICEMODE")) continue;
                    value = new Integer(part2.getValue());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        switch (value) {
            case 0: {
                return WDM_SDHMode;
            }
            case 1: {
                return WDM_OTNMode;
            }
        }
        return WDM_SDHMode;
    }

    private static String queryPortServiceMode(int neID, int slotID, int port) {
        int value = 0;
        try {
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORTSERVICEMODE");
            Input input = oper.getInput();
            Part part2 = input.getPart("slotid");
            part2.setValue(String.valueOf(slotID));
            part2 = input.getPart("port");
            part2.setValue(String.valueOf(port));
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int resualt = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (resualt == 0) {
                Part[] parts = ((Operation)operationList.get(0)).getOutput(0).getPart();
                String name = "";
                for (Part part2 : parts) {
                    name = part2.getName();
                    if (!name.equalsIgnoreCase("W32PORT_ATTR_PORTSVCMODE")) continue;
                    value = new Integer(part2.getValue());
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Parse Qx description file fail!", (Throwable)e);
        }
        switch (value) {
            case 0: {
                return WDM_SDHMode;
            }
            case 1: {
                return WDM_OTNMode;
            }
        }
        return WDM_SDHMode;
    }

    public static String queryBoardMode(int neID, int slotID) {
        int boardMode = -1;
        try {
            Output output;
            ArrayList<Object> operationList = new ArrayList<Object>();
            Operation operation = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_SUBBDTYPE");
            Input input = operation.getInput();
            input.setPartValue("slotid", String.valueOf(slotID));
            operationList.add(operation.clone());
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (0 == result && (output = (operation = (Operation)operationList.get(0)).getOutput(0)).getFault(0).getCode().equals("0")) {
                boardMode = Integer.parseInt(output.getPartValue("W32BD_ATTR_SUBBDTYPE"));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[QueryBoardMode] queryBoardMode fail!", (Throwable)e);
        }
        return QueryWDMMode.queryBoardMode(boardMode);
    }

    public static TIntObjectHashMap<Integer> queryBoardMode(int neID, TIntArrayList slotIDList, String hostVersion) {
        TIntObjectHashMap boardModeMap = new TIntObjectHashMap();
        if (null == slotIDList) {
            return boardModeMap;
        }
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation operation = TECreateObjectFactory.getOperationWithVer(neID, "NSCMD_CFG_GET_SUBBDTYPE", hostVersion);
            int slotID = -1;
            Operation tmpOper = null;
            int boardMode = -1;
            int len = slotIDList.size();
            for (int i = 0; i < len; ++i) {
                slotID = slotIDList.get(i);
                tmpOper = (Operation)operation.clone();
                tmpOper.getInput().setPartValue("slotid", String.valueOf(slotID));
                operationList.add(tmpOper);
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (0 == result) {
                int len2 = operationList.size();
                for (int i = 0; i < len2; ++i) {
                    operation = (Operation)operationList.get(i);
                    Output output = operation.getOutput(0);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    slotID = Integer.parseInt(output.getPartValue("slotid"));
                    boardMode = Integer.parseInt(output.getPartValue("W32BD_ATTR_SUBBDTYPE"));
                    boardModeMap.put(slotID, (Object)boardMode);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[QueryBoardMode] queryBoardMode fail!", (Throwable)e);
        }
        return boardModeMap;
    }

    public static TIntObjectHashMap<Integer> queryBoardMode(int neID, TIntArrayList slotIDList, String hostVersion, List<TEErrInfo> errInfoList) {
        TIntObjectHashMap boardModeMap = new TIntObjectHashMap();
        if (null == slotIDList) {
            return boardModeMap;
        }
        try {
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation operation = TECreateObjectFactory.getOperationWithVer(neID, "NSCMD_CFG_GET_SUBBDTYPE", hostVersion);
            int slotID = -1;
            Operation tmpOper = null;
            int boardMode = -1;
            int len = slotIDList.size();
            for (int i = 0; i < len; ++i) {
                slotID = slotIDList.get(i);
                tmpOper = (Operation)operation.clone();
                tmpOper.getInput().setPartValue("slotid", String.valueOf(slotID));
                operationList.add(tmpOper);
            }
            TEErrInfo errInfo = null;
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (0 == result) {
                int errorCode = -1;
                int shelfID = -1;
                int relativeSlotID = -1;
                int len2 = operationList.size();
                for (int i = 0; i < len2; ++i) {
                    operation = (Operation)operationList.get(i);
                    Output output = operation.getOutput(0);
                    errorCode = Integer.parseInt(output.getFault(0).getCode());
                    if (0 == errorCode) {
                        if (!TEStringUtils.isNumber(output.getPartValue("slotid"))) continue;
                        slotID = Integer.parseInt(output.getPartValue("slotid"));
                        boardMode = Integer.parseInt(output.getPartValue("W32BD_ATTR_SUBBDTYPE"));
                        boardModeMap.put(slotID, (Object)boardMode);
                        continue;
                    }
                    if (!TEStringUtils.isNumber(operation.getInput().getPartValue("slotid"))) continue;
                    slotID = Integer.parseInt(operation.getInput().getPartValue("slotid"));
                    errInfo = new TEErrInfo();
                    shelfID = TEBoardUtil.getRelativeShelfID(slotID);
                    relativeSlotID = TEBoardUtil.bigSlotToSmall(slotID);
                    errInfo.setObjID(new int[]{neID, shelfID, relativeSlotID});
                    errInfo.setErrorCode(errorCode);
                    errInfoList.add(errInfo);
                }
            } else {
                errInfo = new TEErrInfo();
                errInfo.setObjID(new int[]{neID});
                errInfo.setErrorCode(result);
                errInfoList.add(errInfo);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[QueryBoardMode] queryBoardMode fail!", (Throwable)e);
            TEErrInfo errInfo = new TEErrInfo();
            errInfo.setObjID(new int[]{neID});
            errInfo.setErrorCode(1090646019);
            errInfoList.add(errInfo);
        }
        return boardModeMap;
    }

    public static String queryBoardMode(int boardMode) {
        switch (boardMode) {
            case 163: {
                return ALONE_MODE;
            }
            case 162: {
                return CONNECT_MODE;
            }
            case 3: {
                return AP8_MODE;
            }
            case 4: {
                return LQM2_MODE;
            }
            case 8: {
                return NORMAL_MODE;
            }
            case 7: {
                return OES_MODE;
            }
            case 9: {
                return OADM_MODE;
            }
            case 10: {
                return DAITONG_MODE;
            }
            case 1: {
                return NONEODU0_MODE;
            }
            case 2: {
                return ODU0_MODE;
            }
            case 160: {
                return SERVICE_MODE;
            }
            case 161: {
                return HUB_MODE;
            }
            case 169: {
                return RELAY_MODE;
            }
            case 168: {
                return LINE_MODE;
            }
            case 170: {
                return OP_RELAY_MODE;
            }
            case 12: {
                return OTN_MODE_12;
            }
            case 13: {
                return IP_10GE_MODE_13;
            }
            case 14: {
                return ODU1CONV_MODE;
            }
            case 15: {
                return ODU1UNCONV_MODE;
            }
            case 17: {
                return ONEANY2ODU2_MODE;
            }
            case 19: {
                return TWOANY2ODU2_MODE;
            }
            case 20: {
                return ODU0ODU1MIX_MODE;
            }
        }
        return String.valueOf(boardMode);
    }

    public static Map getPayloadMode(int neID, int slotID, List portList, int path) {
        HashMap<String, String> payLoadModeMap = new HashMap<String, String>();
        try {
            Operation operation;
            ArrayList<Object> operationList = new ArrayList<Object>();
            for (int i = 0; i < portList.size(); ++i) {
                int portid = (Integer)portList.get(i);
                operation = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORTSERVICEMODE");
                Input input = operation.getInput();
                input.setPartValue("slotid", String.valueOf(slotID));
                input.setPartValue("port", String.valueOf(portid));
                input.setPartValue("path", String.valueOf(path));
                operationList.add(operation.clone());
            }
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)10).retCode;
            if (0 == result) {
                for (int i = 0; i < operationList.size(); ++i) {
                    operation = (Operation)operationList.get(i);
                    Output output = operation.getOutput(0);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    String port = output.getPartValue("port");
                    String payLoadMode = output.getPartValue("W32PORT_ATTR_PORTSVCMODE");
                    payLoadModeMap.put(port, payLoadMode);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[getPayloadMode] getPayloadMode fail!", (Throwable)e);
        }
        return payLoadModeMap;
    }

    public static int convertBoardMode(String boardMode) {
        if (TEStringUtils.isNumeric(boardMode)) {
            return Integer.valueOf(boardMode);
        }
        if (ALONE_MODE.equals(boardMode)) {
            return 163;
        }
        if (CONNECT_MODE.equals(boardMode)) {
            return 162;
        }
        if (AP8_MODE.equals(boardMode)) {
            return 3;
        }
        if (LQM2_MODE.equals(boardMode)) {
            return 4;
        }
        if (NONEODU0_MODE.equals(boardMode)) {
            return 1;
        }
        if (ODU0_MODE.equals(boardMode)) {
            return 2;
        }
        if (NORMAL_MODE.equals(boardMode)) {
            return 8;
        }
        if (OES_MODE.equals(boardMode)) {
            return 7;
        }
        if (OADM_MODE.equals(boardMode)) {
            return 9;
        }
        if (DAITONG_MODE.equals(boardMode)) {
            return 10;
        }
        if (ODU1CONV_MODE.equals(boardMode)) {
            return 14;
        }
        if (ODU1UNCONV_MODE.equals(boardMode)) {
            return 15;
        }
        if (ONEANY2ODU2_MODE.equals(boardMode)) {
            return 17;
        }
        if (TWOANY2ODU2_MODE.equals(boardMode)) {
            return 19;
        }
        if (ODU0ODU1MIX_MODE.equals(boardMode)) {
            return 20;
        }
        if (LINE_MODE.equals(boardMode)) {
            return 168;
        }
        if (RELAY_MODE.equals(boardMode)) {
            return 169;
        }
        if (OP_RELAY_MODE.equals(boardMode)) {
            return 170;
        }
        return -1;
    }

    public static HashMap<Integer, Integer> queryPortMode(int neid, int slotid) {
        HashMap<Integer, Integer> portModeMap = new HashMap<Integer, Integer>();
        try {
            ArrayList<Object> operationList = new ArrayList<Object>();
            Operation operation = TECreateObjectFactory.getOperation(neid, "NSCMD_CFG_GET_PORTMODE");
            Input input = operation.getInput();
            input.setPartValue("slotID", String.valueOf(slotid));
            operationList.add(operation.clone());
            int result = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)10).retCode;
            if (0 == result) {
                operation = (Operation)operationList.get(0);
                int size = operation.getOutputCount();
                for (int i = 0; i < size; ++i) {
                    Output output = operation.getOutput(i);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    int portIDKey = Integer.parseInt(output.getPartValue("port"));
                    Integer portModeValue = Integer.valueOf(output.getPartValue("portworkmodel"));
                    portModeMap.put(portIDKey, portModeValue);
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[QueryWDMMode] queryPortMode fail!", (Throwable)e);
        }
        if (portModeMap.size() == 0) {
            TELogFactory.getNormalLogger().error("Query Port Mode Fail!");
        }
        return portModeMap;
    }

    public static Integer queryPortMode(int neid, int slotid, int portid) {
        HashMap portModeMap = new HashMap();
        try {
            ArrayList<Object> operationList = new ArrayList<Object>();
            Operation operation = TECreateObjectFactory.getOperation(neid, "NSCMD_CFG_GET_PORTMODE");
            Input input = operation.getInput();
            input.setPartValue("slotID", String.valueOf(slotid));
            input.setPartValue("port", String.valueOf(portid));
            operationList.add(operation.clone());
            int result = TENECommMgr.getInstance().sendCommand((int)neid, operationList, (int)10).retCode;
            if (0 == result) {
                operation = (Operation)operationList.get(0);
                int size = operation.getOutputCount();
                for (int i = 0; i < size; ++i) {
                    Output output = operation.getOutput(i);
                    if (!output.getFault(0).getCode().equals("0")) continue;
                    return Integer.valueOf(output.getPartValue("portworkmodel"));
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("[QueryWDMMode] queryPortMode fail!", (Throwable)e);
        }
        if (portModeMap.size() == 0) {
            TELogFactory.getNormalLogger().error("Query Port Mode Fail!");
        }
        return -1;
    }
}

