/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.alarm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.AlmFBKeyType;
import com.huawei.nglct.nelist.model.AlmObjKeyType;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAISTh;
import com.huawei.nglct.nelist.model.alarm.TEAlarmAISTh;
import com.huawei.nglct.nelist.model.alarm.TEAlarmInverse;
import com.huawei.nglct.nelist.model.alarm.TEAlarmUneqTh;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBInfo;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nelist.model.alarm.TEAlmObjInfo;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEUNEQTh;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TETL1AlarmsdInterpreter
extends XMLInterpreterImpl {
    SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
    TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();

    @Override
    public int interpretXMLTag(Node tl1node) {
        this.parseXML(tl1node);
        return 0;
    }

    public void parseXML(Node node) {
        this.parseSupportAlarmFunction(node);
        this.parseSupportAlarmInsertFunction(node);
        this.parseSupportAlarmObjFunction(node);
        this.parsePortFunction(node);
    }

    private void parseSupportAlarmInsertFunction(Node tl1node) {
        Element element = (Element)tl1node;
        NodeList tl1nodeList = element.getElementsByTagName("alarmbaseattr");
        Element tl1elementTmp = (Element)tl1nodeList.item(0);
        String cpTypeStr = tl1elementTmp.getAttribute("cptype");
        int cpType = this.instance.parseInt(cpTypeStr);
        tl1nodeList = element.getElementsByTagName("support_insert");
        if (null == tl1nodeList) {
            return;
        }
        int len = tl1nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            tl1elementTmp = (Element)tl1nodeList.item(i);
            String fbTypeStr = tl1elementTmp.getAttribute("fbtype");
            TEAlmFBInfo tEAlmFBInfo = new TEAlmFBInfo();
            tEAlmFBInfo.fbType = this.instance.parseInt(fbTypeStr);
            String portIDStr = tl1elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEAlmFBInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = tl1elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEAlmFBInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            String aeidStr = tl1elementTmp.getAttribute("aeid");
            ArrayList supportAlmList = new ArrayList();
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            this.expandFbObjs(cpType, tEAlmFBInfo, supportAlmList);
        }
    }

    private void expandFbObjs(int cpType, TEAlmFBInfo tETl1AlmFBInfo, ArrayList supportAlmList) {
        ArrayList portList = tETl1AlmFBInfo.portIDList;
        ArrayList pathIDList = tETl1AlmFBInfo.pathIDList;
        TEAlmFBObj fbObj = null;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                fbObj = new TEAlmFBObj();
                fbObj.m_usFBType = this.tEConfigurationDataMgr.isBIFBType(tETl1AlmFBInfo.fbType) ? this.tEConfigurationDataMgr.getBidirFBType(tETl1AlmFBInfo.fbType) : tETl1AlmFBInfo.fbType;
                fbObj.m_usPortID = (Integer)portList.get(i);
                fbObj.m_usPathID = (Integer)pathIDList.get(j);
                TEAlarmDataMgr.getInstance().setAlarmInsertFBMap(cpType, fbObj);
                TEAlarmDataMgr.getInstance().setAlarmInsertMap(cpType, fbObj, supportAlmList);
            }
        }
    }

    private void parseSupportAlarmFunction(Node tl1node) {
        HashMap almAttrToFBMap = new HashMap();
        Element element = (Element)tl1node;
        NodeList nodeList = element.getElementsByTagName("alarmbaseattr");
        Element tl1elementTmp = (Element)nodeList.item(0);
        String cpTypeStr = tl1elementTmp.getAttribute("cptype");
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = tl1elementTmp.getElementsByTagName("support_alarm");
        if (null == nodeList) {
            return;
        }
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            tl1elementTmp = (Element)nodeList.item(i);
            String fbTypeStr = tl1elementTmp.getAttribute("fbtype");
            TEAlmFBInfo tEAlmFBInfo = new TEAlmFBInfo();
            tEAlmFBInfo.fbType = this.instance.parseInt(fbTypeStr);
            String portIDStr = tl1elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEAlmFBInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = tl1elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEAlmFBInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            String aeidStr = tl1elementTmp.getAttribute("aeid");
            ArrayList supportAlmList = new ArrayList();
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            String subtp = tl1elementTmp.getAttribute("subtp");
            if (!"".equals(subtp)) {
                tEAlmFBInfo.subtb = Integer.parseInt(subtp);
            }
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            this.expandFbObjs(cpType, tEAlmFBInfo, supportAlmList, almAttrToFBMap);
        }
        TEAlarmDataMgr.getInstance().setAlarmMap(almAttrToFBMap);
    }

    private ArrayList getAeID(String tl1aeidStr, ArrayList supportAlmList) {
        if (null == tl1aeidStr || "".equals(tl1aeidStr.trim())) {
            return supportAlmList;
        }
        StringBuffer fb = new StringBuffer();
        int alarmID = -1;
        int len2 = tl1aeidStr.length();
        for (int j = 0; j < len2; ++j) {
            char ch = tl1aeidStr.charAt(j);
            if (ch != ',' && ch != '[' && ch != ']') {
                fb.append(ch);
                continue;
            }
            if (fb.length() == 0) continue;
            String almMacro = fb.toString().trim();
            Integer tmpTl1AlmID = SDXMLInterpreterMgr.getInstance().parseInt(almMacro);
            if (tmpTl1AlmID != null) {
                alarmID = tmpTl1AlmID;
                supportAlmList.add(alarmID);
            }
            fb.delete(0, fb.length());
        }
        return supportAlmList;
    }

    private void expandFbObjs(int cpType, TEAlmFBInfo tETl1AlmFBInfo, ArrayList supportAlmList, HashMap almAttrToFBMap) {
        ArrayList portList = tETl1AlmFBInfo.portIDList;
        ArrayList pathIDList = tETl1AlmFBInfo.pathIDList;
        TEAlmFBObj tl1fbObj = null;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                tl1fbObj = new TEAlmFBObj();
                tl1fbObj.subtp = tETl1AlmFBInfo.subtb;
                tl1fbObj.m_usFBType = this.tEConfigurationDataMgr.isBIFBType(tETl1AlmFBInfo.fbType) ? this.tEConfigurationDataMgr.getBidirFBType(tETl1AlmFBInfo.fbType) : tETl1AlmFBInfo.fbType;
                tl1fbObj.m_usPortID = (Integer)portList.get(i);
                tl1fbObj.m_usPathID = (Integer)pathIDList.get(j);
                TEAlarmDataMgr.getInstance().setAlarmFBMap(cpType, tl1fbObj);
                TEAlarmDataMgr.getInstance().setAlarmCptypeFBMap(cpType, tl1fbObj, supportAlmList);
                int supportAlmListLength = supportAlmList.size();
                for (int k = 0; k < supportAlmListLength; ++k) {
                    int alarmID = (Integer)supportAlmList.get(k);
                    AlmFBKeyType key = new AlmFBKeyType(alarmID, cpType, tl1fbObj.m_usPortID, tl1fbObj.m_usPathID);
                    almAttrToFBMap.put(key, tl1fbObj.m_usFBType);
                }
            }
        }
    }

    private void parsePortFunction(Node node) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("alarmbaseattr");
        Element elementTmp = (Element)nodeList.item(0);
        String cpTypeStr = elementTmp.getAttribute("cptype");
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = element.getElementsByTagName("port_function");
        if (null == nodeList) {
            return;
        }
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String bitStr;
            String uneqStr;
            String aisStr;
            elementTmp = (Element)nodeList.item(i);
            String portIDStr = elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            TENEListUtils.getNumList(portIDStr, portNoList);
            TEAlarmDataMgr.getInstance().fillPortNOMap(cpType, portNoList);
            String pathIDStr = elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            TENEListUtils.getNumList(pathIDStr, pathNoList);
            boolean supportInverse = false;
            String inverseStr = elementTmp.getAttribute("inverse");
            if (!"false".equalsIgnoreCase(inverseStr)) {
                this.pareseInverseNode(inverseStr, portNoList, pathNoList, cpType);
            }
            if ("true".equalsIgnoreCase(inverseStr)) {
                supportInverse = true;
            }
            if (!"false".equalsIgnoreCase(aisStr = elementTmp.getAttribute("ais"))) {
                this.pareseAISNode(aisStr, portNoList, pathNoList, cpType, supportInverse);
            }
            if (!"false".equalsIgnoreCase(uneqStr = elementTmp.getAttribute("uneq"))) {
                this.parseUNEQNode(uneqStr, portNoList, pathNoList, cpType, supportInverse);
            }
            if ("false".equalsIgnoreCase(bitStr = elementTmp.getAttribute("bitth"))) continue;
            this.pareseBITThNode(bitStr, portNoList, pathNoList, cpType, supportInverse);
        }
    }

    private void pareseInverseNode(String nodeSubStr, ArrayList portNoList, ArrayList pathNoList, int cpType) {
        int size = portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)portNoList.get(i);
            TEAlarmInverse tEAlarmInverse = new TEAlarmInverse(portNo, pathNoList);
            TEAlarmDataMgr.getInstance().fillInverseList(cpType, tEAlarmInverse);
        }
    }

    private void pareseAISNode(String tl1nodeSubStr, ArrayList tl1portNoList, ArrayList tl1pathNoList, int tl1cpType, boolean supportInverse) {
        ArrayList<TEAISTh> aisThList = new ArrayList<TEAISTh>();
        for (String tl1thtypeStr : tl1nodeSubStr.split(",")) {
            int index = tl1thtypeStr.indexOf("(");
            String typeStr = tl1thtypeStr.substring(0, index);
            int indexLast = tl1thtypeStr.lastIndexOf(")");
            String defaultStr = tl1thtypeStr.substring(index + 1, indexLast);
            int thtype = Integer.parseInt(typeStr.trim());
            boolean defaultvalue = false;
            if ("true".equalsIgnoreCase(defaultStr)) {
                defaultvalue = true;
            }
            TEAISTh aisTh = new TEAISTh(thtype, defaultvalue);
            aisThList.add(aisTh);
        }
        int size = tl1portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)tl1portNoList.get(i);
            int jSize = tl1pathNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int pathNo = (Integer)tl1pathNoList.get(j);
                TEAlarmAISTh alarmAIDTh = new TEAlarmAISTh(portNo, pathNo, aisThList);
                alarmAIDTh.setSupportInverse(supportInverse);
                TEAlarmDataMgr.getInstance().fillAISList(tl1cpType, alarmAIDTh);
            }
        }
    }

    private void parseUNEQNode(String tl1nodeSubStr, ArrayList tl1portNoList, ArrayList tl1pathNoList, int tl1cpType, boolean supportInverse) {
        ArrayList<TEUNEQTh> uneqThList = new ArrayList<TEUNEQTh>();
        for (String tl1thtypeStr : tl1nodeSubStr.split(",")) {
            int index = tl1thtypeStr.indexOf("(");
            String typeStr = tl1thtypeStr.substring(0, index);
            int indexLast = tl1thtypeStr.lastIndexOf(")");
            String defaultStr = tl1thtypeStr.substring(index + 1, indexLast);
            int thtype = Integer.parseInt(typeStr);
            boolean defaultvalue = false;
            if ("true".equalsIgnoreCase(defaultStr)) {
                defaultvalue = true;
            }
            TEUNEQTh uneqTh = new TEUNEQTh(thtype, defaultvalue);
            uneqThList.add(uneqTh);
        }
        int size = tl1portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)tl1portNoList.get(i);
            int jSize = tl1pathNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int pathNo = (Integer)tl1pathNoList.get(j);
                TEAlarmUneqTh alarmUneqTh = new TEAlarmUneqTh(portNo, pathNo, uneqThList);
                alarmUneqTh.setSuportInverse(supportInverse);
                TEAlarmDataMgr.getInstance().fillUNEQList(tl1cpType, alarmUneqTh);
            }
        }
    }

    private void pareseBITThNode(String tl1nodeSubStr, ArrayList tl1portNoList, ArrayList tl1pathNoList, int tl1cpType, boolean supportInverse) {
        ArrayList<TEBitErrorTh> bitThList = new ArrayList<TEBitErrorTh>();
        for (String thtypeStr : tl1nodeSubStr.split(",")) {
            int index = thtypeStr.indexOf("(");
            String typeStr = thtypeStr.substring(0, index);
            int indexLast = thtypeStr.lastIndexOf(")");
            String defaultStr = thtypeStr.substring(index + 1, indexLast);
            int thtype = Integer.parseInt(typeStr);
            int defaultvalue = Integer.parseInt(defaultStr);
            TEBitErrorTh bitErrorTh = new TEBitErrorTh(thtype, defaultvalue);
            bitThList.add(bitErrorTh);
            TEAlarmDataMgr.getInstance().fillBITTypeList(tl1cpType, thtype);
        }
        int size = tl1portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)tl1portNoList.get(i);
            int jSize = tl1pathNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int pathNo = (Integer)tl1pathNoList.get(j);
                TEPortBitErrorTh portBitErrorTh = new TEPortBitErrorTh(portNo, pathNo, bitThList);
                portBitErrorTh.setSuportInverse(supportInverse);
                TEAlarmDataMgr.getInstance().fillBITThList(tl1cpType, portBitErrorTh);
            }
        }
    }

    private HashMap parseAlarm(String devVersion, int boardType, Node node) {
        Element element = (Element)node;
        String strValue = null;
        NodeList nodeList = element.getElementsByTagName("support_alarm");
        HashMap<AlmFBKeyType, Integer> AlmAttrToFBMap = new HashMap<AlmFBKeyType, Integer>();
        try {
            StringBuffer fb = new StringBuffer();
            ArrayList<Integer> supportAlmList = new ArrayList<Integer>();
            ArrayList<Integer> supportPortList = new ArrayList<Integer>();
            ArrayList<Integer> supportPathList = new ArrayList<Integer>();
            int alarmID = -1;
            int port = -1;
            int path = -1;
            int funcBlock = -1;
            int len = nodeList.getLength();
            for (int i = 0; i < len; ++i) {
                char ch;
                int j;
                element = (Element)nodeList.item(i);
                String fbMacro = element.getAttribute("fbtype");
                Integer tmpFuncBlock = SDXMLInterpreterMgr.getInstance().parseInt(fbMacro);
                if (tmpFuncBlock != null) {
                    funcBlock = tmpFuncBlock;
                }
                strValue = element.getAttribute("aeid");
                int len2 = strValue.length();
                for (int j2 = 0; j2 < len2; ++j2) {
                    char ch2 = strValue.charAt(j2);
                    if (ch2 != ',' && ch2 != '[' && ch2 != ']') {
                        fb.append(ch2);
                        continue;
                    }
                    if (fb.length() == 0) continue;
                    String almMacro = fb.toString().trim();
                    Integer tmpAlmID = SDXMLInterpreterMgr.getInstance().parseInt(almMacro);
                    if (tmpAlmID != null) {
                        alarmID = tmpAlmID;
                        supportAlmList.add(alarmID);
                    }
                    fb.delete(0, fb.length());
                }
                strValue = element.getAttribute("portid");
                ArrayList<String> range = new ArrayList<String>();
                int start = -1;
                int end = -1;
                int len22 = strValue.length();
                for (j = 0; j < len22; ++j) {
                    ch = strValue.charAt(j);
                    if (ch != '-' && ch != '[' && ch != ']') {
                        fb.append(ch);
                        continue;
                    }
                    if (fb.length() == 0) continue;
                    range.add(fb.toString().trim());
                    fb.delete(0, fb.length());
                }
                start = Integer.parseInt((String)range.get(0));
                end = Integer.parseInt((String)range.get(range.size() - 1));
                range.clear();
                len22 = end;
                for (j = start; j <= len22; ++j) {
                    supportPortList.add(j);
                }
                strValue = element.getAttribute("pathid");
                len22 = strValue.length();
                for (j = 0; j < len22; ++j) {
                    ch = strValue.charAt(j);
                    if (ch != '-' && ch != '[' && ch != ']') {
                        fb.append(ch);
                        continue;
                    }
                    if (fb.length() == 0) continue;
                    range.add(fb.toString().trim());
                    fb.delete(0, fb.length());
                }
                start = Integer.parseInt((String)range.get(0));
                end = Integer.parseInt((String)range.get(range.size() - 1));
                range.clear();
                len22 = end;
                for (j = start; j <= len22; ++j) {
                    supportPathList.add(j);
                }
                int size = supportAlmList.size();
                for (j = 0; j < size; ++j) {
                    alarmID = (Integer)supportAlmList.get(j);
                    int size2 = supportPortList.size();
                    for (int k = 0; k < size2; ++k) {
                        port = (Integer)supportPortList.get(k);
                        int size3 = supportPathList.size();
                        for (int t = 0; t < size3; ++t) {
                            path = (Integer)supportPathList.get(t);
                            AlmFBKeyType key = new AlmFBKeyType(alarmID, boardType, port, path);
                            AlmAttrToFBMap.put(key, funcBlock);
                        }
                    }
                }
                supportAlmList.clear();
                supportPortList.clear();
                supportPathList.clear();
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1AlarmsdInterpreter.parseAlarm() fail!", (Throwable)e);
        }
        return AlmAttrToFBMap;
    }

    private void parseSupportAlarmObjFunction(Node node) {
        HashMap<AlmObjKeyType, Set<TEAlmObjInfo>> almAttrToObjMap = new HashMap<AlmObjKeyType, Set<TEAlmObjInfo>>();
        Element element = (Element)node;
        NodeList tl1nodeList = element.getElementsByTagName("almdyemstoqx");
        if (null == tl1nodeList) {
            return;
        }
        Element tl1elementTmp = (Element)tl1nodeList.item(0);
        if (null == tl1elementTmp) {
            return;
        }
        String cpTypeStr = tl1elementTmp.getAttribute("cptype");
        int cpType = this.instance.parseInt(cpTypeStr);
        tl1nodeList = tl1elementTmp.getElementsByTagName("support_alarm");
        if (null == tl1nodeList) {
            return;
        }
        int len = tl1nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            tl1elementTmp = (Element)tl1nodeList.item(i);
            String objTypeStr = tl1elementTmp.getAttribute("objtype");
            TEAlmObjInfo tEAlmFBInfo = new TEAlmObjInfo();
            tEAlmFBInfo.objType = SDXMLInterpreterMgr.getInstance().parseInt(objTypeStr);
            String fbTypeStr = tl1elementTmp.getAttribute("fbtype");
            tEAlmFBInfo.fbType = this.instance.parseInt(fbTypeStr);
            String aeidStr = tl1elementTmp.getAttribute("aeid");
            ArrayList supportAlmList = new ArrayList();
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            String portIDStr = tl1elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEAlmFBInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = tl1elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEAlmFBInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            this.expandObjectObjs(cpType, tEAlmFBInfo, supportAlmList, almAttrToObjMap);
        }
        TEAlarmDataMgr.getInstance().setAlarmObjMap(almAttrToObjMap);
    }

    private void expandObjectObjs(int tl1cpType, TEAlmObjInfo tETl1AlmObjInfo, ArrayList supportTl1AlmList, HashMap almAttrToObjMap) {
        ArrayList portList = tETl1AlmObjInfo.portIDList;
        ArrayList pathIDList = tETl1AlmObjInfo.pathIDList;
        TEAlmObjInfo fbObj = null;
        int portID = 0;
        int pathID = 0;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                fbObj = new TEAlmObjInfo();
                fbObj.objType = tETl1AlmObjInfo.objType;
                fbObj.aeidList = supportTl1AlmList;
                portID = (Integer)portList.get(i);
                AlmObjKeyType key = new AlmObjKeyType(tl1cpType, portID, pathID = ((Integer)pathIDList.get(j)).intValue());
                if (!almAttrToObjMap.containsKey(key)) {
                    ArrayList<TEAlmObjInfo> objs = new ArrayList<TEAlmObjInfo>();
                    objs.add(fbObj);
                    almAttrToObjMap.put(key, objs);
                    continue;
                }
                ArrayList list = (ArrayList)almAttrToObjMap.get(key);
                TEAlmObjInfo ObjTemp = null;
                boolean blExist = false;
                int m = list.size();
                for (int k = 0; k < m; ++k) {
                    ObjTemp = (TEAlmObjInfo)list.get(k);
                    if (ObjTemp.objType != fbObj.objType) continue;
                    ObjTemp.aeidList.addAll(supportTl1AlmList);
                    blExist = true;
                    break;
                }
                if (blExist) continue;
                list.add(fbObj);
            }
        }
    }
}

