/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.alarm;

import com.huawei.nglct.util.io.IOStreamConvertor;

public class TEParseAlarmParam {
    public static final int EX_ETHOAM_CC_LOS = 12298;
    public static final int EX_ETHOAM_MPID_CNFLCT = 12299;

    public static String getAlarmParamValue(int almID, String textPara) {
        String almEventParamStr = "";
        switch (almID) {
            case 12298: {
                almEventParamStr = TEParseAlarmParam.parseEX_ETHOAM_CC_LOS(textPara);
                break;
            }
            case 12299: {
                almEventParamStr = TEParseAlarmParam.parseEX_ETHOAM_MPID_CNFLCT(textPara);
                break;
            }
            default: {
                almEventParamStr = new String(IOStreamConvertor.getByteArrayFromString(textPara));
            }
        }
        return almEventParamStr;
    }

    private static String parseEX_ETHOAM_CC_LOS(String textPara) {
        StringBuffer almEventParamStr = new StringBuffer();
        byte[] parames = textPara.getBytes();
        byte[] bSrcMpId = new byte[8];
        System.arraycopy(parames, 0, bSrcMpId, 0, 8);
        long srcMpId = IOStreamConvertor.readPositiveLong(bSrcMpId, 0);
        byte[] bDstMpId = new byte[8];
        System.arraycopy(parames, 8, bDstMpId, 0, 8);
        long dstMpId = IOStreamConvertor.readPositiveLong(bDstMpId, 0);
        almEventParamStr.append("DSTMPID=0x").append(Long.toHexString(dstMpId)).append(",");
        byte[] bPort = new byte[4];
        System.arraycopy(parames, 32, bPort, 0, 4);
        int port = IOStreamConvertor.readPositiveInt(bPort, 0);
        if (port >= 32768) {
            almEventParamStr.append("Port=vctrunk").append(port - 32768).append(",");
        } else {
            almEventParamStr.append("Port=ip").append(port).append(",");
        }
        byte[] bVlan = new byte[4];
        System.arraycopy(parames, 36, bVlan, 0, 4);
        int vlan = IOStreamConvertor.readPositiveInt(bVlan, 0);
        almEventParamStr.append("Vlan=").append(vlan).append(",");
        byte[] bLevel = new byte[2];
        System.arraycopy(parames, 40, bLevel, 0, 2);
        int level = IOStreamConvertor.readPositiveShort(bLevel, 0);
        almEventParamStr.append("Level=").append(level).append(",");
        almEventParamStr.append("SRCMPID=0x").append(Long.toHexString(srcMpId)).append(",");
        almEventParamStr.append("DSTMPID=0x").append(Long.toHexString(dstMpId));
        return almEventParamStr.toString();
    }

    private static String parseEX_ETHOAM_MPID_CNFLCT(String textPara) {
        StringBuffer almEventParamStr = new StringBuffer();
        byte[] bContent = textPara.getBytes();
        byte[] bMpId = new byte[8];
        System.arraycopy(bContent, 0, bMpId, 0, 8);
        int mpId = IOStreamConvertor.readPositiveLong(bMpId, 0);
        almEventParamStr.append("MPID=0x").append(Long.toHexString(mpId)).append(",");
        byte[] bPort = new byte[4];
        System.arraycopy(bContent, 16, bPort, 0, 4);
        int port = IOStreamConvertor.readPositiveInt(bPort, 0);
        if (port >= 32768) {
            almEventParamStr.append("Port=vctrunk").append(String.valueOf(port - 32768)).append(",");
        } else {
            almEventParamStr.append("Port=ip").append(port).append(",");
        }
        byte[] bVlan = new byte[4];
        System.arraycopy(bContent, 20, bVlan, 0, 4);
        int vlan = IOStreamConvertor.readPositiveInt(bVlan, 0);
        almEventParamStr.append("Vlan=").append(vlan).append(",");
        byte[] bLevel = new byte[2];
        System.arraycopy(bContent, 24, bLevel, 0, 2);
        int level = IOStreamConvertor.readPositiveShort(bLevel, 0);
        almEventParamStr.append("Level=").append(level).append(",");
        almEventParamStr.append("MPID=0x").append(Long.toHexString(mpId));
        return almEventParamStr.toString();
    }
}

