/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.alarm;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.mo.VerRange;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.AlmFBKeyType;
import com.huawei.nglct.nelist.model.AlmObjKeyType;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAISTh;
import com.huawei.nglct.nelist.model.alarm.TEAlarmAISTh;
import com.huawei.nglct.nelist.model.alarm.TEAlarmInverse;
import com.huawei.nglct.nelist.model.alarm.TEAlarmUneqTh;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBInfo;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nelist.model.alarm.TEAlmObjInfo;
import com.huawei.nglct.nelist.model.alarm.TEBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEServiceAlarm;
import com.huawei.nglct.nelist.model.alarm.TEServiceAlarmFBInfo;
import com.huawei.nglct.nelist.model.alarm.TEUNEQTh;
import com.huawei.nglct.nelist.model.tl1alarm.TETL1AlarmDataMgr;
import com.huawei.nglct.nelist.model.tl1alarm.TETL1PortBitErrorTh;
import com.huawei.nglct.util.convertor.TEVersionConvertUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEAlarmsdInterpreter
extends XMLInterpreterImpl {
    SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
    TEConfigurationDataMgr tEConfigurationDataMgr = TEConfigurationDataMgr.getInstance();

    @Override
    public int interpretXMLTag(Node node) {
        this.parseXML(node);
        return 0;
    }

    public void parseXML(Node node) {
        this.parseSupportAlarmFunction(node);
        this.parseSupportAlarmInsertFunction(node);
        this.parseSupportAlarmObjFunction(node);
        this.parsePortFunction(node, false);
        this.parseSupportAlarmInverseObjFunction(node);
        this.parseServiceSupportAlarmFunction(node);
    }

    private void parseSupportAlarmInsertFunction(Node node) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("alarmbaseattr");
        if (null == nodeList || 0 == nodeList.getLength()) {
            return;
        }
        Element elementTmp = (Element)nodeList.item(0);
        String cpTypeStr = elementTmp.getAttribute("cptype");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementTmp.getAttribute("cp_type") : cpTypeStr;
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = element.getElementsByTagName("support_insert");
        if (null == nodeList) {
            return;
        }
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            elementTmp = (Element)nodeList.item(i);
            String fbTypeStr = elementTmp.getAttribute("fbtype");
            TEAlmFBInfo tEAlmFBInfo = new TEAlmFBInfo();
            tEAlmFBInfo.fbType = this.instance.parseInt(fbTypeStr);
            String portIDStr = elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEAlmFBInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEAlmFBInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            String aeidStr = elementTmp.getAttribute("aeid");
            ArrayList supportAlmList = new ArrayList();
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            String netype = elementTmp.getAttribute("neType");
            if (null != netype && !"".equals(netype)) {
                int tempNeType;
                tEAlmFBInfo.m_NEType = tempNeType = this.instance.parseInt(netype);
            }
            this.expandFbObjs(cpType, tEAlmFBInfo, supportAlmList);
        }
    }

    private void expandFbObjs(int cpType, TEAlmFBInfo tEAlmFBInfo, ArrayList supportAlmList) {
        ArrayList portList = tEAlmFBInfo.portIDList;
        ArrayList pathIDList = tEAlmFBInfo.pathIDList;
        TEAlmFBObj fbObj = null;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                fbObj = new TEAlmFBObj();
                fbObj.m_usFBType = !this.tEConfigurationDataMgr.isBIFBType(tEAlmFBInfo.fbType) ? this.tEConfigurationDataMgr.getBidirFBType(tEAlmFBInfo.fbType) : tEAlmFBInfo.fbType;
                fbObj.m_usPortID = (Integer)portList.get(i);
                fbObj.m_usPathID = (Integer)pathIDList.get(j);
                fbObj.m_NEType = tEAlmFBInfo.m_NEType;
                TEAlarmDataMgr.getInstance().setAlarmInsertFBMap(cpType, fbObj);
                TEAlarmDataMgr.getInstance().setAlarmInsertMap(cpType, fbObj, supportAlmList);
            }
        }
    }

    private void parseSupportAlarmFunction(Node node) {
        HashMap almAttrToFBMap = new HashMap();
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("alarmbaseattr");
        if (null == nodeList || 0 == nodeList.getLength()) {
            return;
        }
        Element elementTmp = (Element)nodeList.item(0);
        String cpTypeStr = elementTmp.getAttribute("cptype");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementTmp.getAttribute("cp_type") : cpTypeStr;
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = elementTmp.getElementsByTagName("support_alarm");
        if (null == nodeList) {
            return;
        }
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            elementTmp = (Element)nodeList.item(i);
            String fbTypeStr = elementTmp.getAttribute("fbtype");
            TEAlmFBInfo tEAlmFBInfo = new TEAlmFBInfo();
            tEAlmFBInfo.fbType = this.instance.parseInt(fbTypeStr);
            String portIDStr = elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEAlmFBInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEAlmFBInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            String aeidStr = elementTmp.getAttribute("aeid");
            ArrayList supportAlmList = new ArrayList();
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            String subtp = elementTmp.getAttribute("subtp");
            if (!subtp.equals("")) {
                tEAlmFBInfo.subtb = Integer.parseInt(subtp);
            }
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            this.expandFbObjs(cpType, tEAlmFBInfo, supportAlmList, almAttrToFBMap);
        }
        TEAlarmDataMgr.getInstance().setAlarmMap(almAttrToFBMap);
    }

    private ArrayList getAeID(String aeidStr, ArrayList supportAlmList) {
        if (null == aeidStr || "".equals(aeidStr.trim())) {
            return supportAlmList;
        }
        StringBuffer fb = new StringBuffer();
        int alarmID = -1;
        int len2 = aeidStr.length();
        for (int j = 0; j < len2; ++j) {
            char ch = aeidStr.charAt(j);
            if (ch != ',' && ch != '[' && ch != ']') {
                fb.append(ch);
                continue;
            }
            if (fb.length() == 0) continue;
            String almMacro = fb.toString().trim();
            Integer tmpAlmID = SDXMLInterpreterMgr.getInstance().parseInt(almMacro);
            if (tmpAlmID != null) {
                alarmID = tmpAlmID;
                supportAlmList.add(new Integer(alarmID));
            }
            fb.delete(0, fb.length());
        }
        return supportAlmList;
    }

    private void expandFbObjs(int cpType, TEAlmFBInfo tEAlmFBInfo, ArrayList supportAlmList, HashMap almAttrToFBMap) {
        ArrayList portList = tEAlmFBInfo.portIDList;
        ArrayList pathIDList = tEAlmFBInfo.pathIDList;
        TEAlmFBObj fbObj = null;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                fbObj = new TEAlmFBObj();
                fbObj.subtp = tEAlmFBInfo.subtb;
                fbObj.m_usFBType = !this.tEConfigurationDataMgr.isBIFBType(tEAlmFBInfo.fbType) ? this.tEConfigurationDataMgr.getBidirFBType(tEAlmFBInfo.fbType) : tEAlmFBInfo.fbType;
                fbObj.m_usPortID = (Integer)portList.get(i);
                fbObj.m_usPathID = (Integer)pathIDList.get(j);
                TEAlarmDataMgr.getInstance().setAlarmFBMap(cpType, fbObj);
                TEAlarmDataMgr.getInstance().setAlarmCptypeFBMap(cpType, fbObj, supportAlmList);
                int supportAlmListLength = supportAlmList.size();
                for (int k = 0; k < supportAlmListLength; ++k) {
                    int alarmID = (Integer)supportAlmList.get(k);
                    AlmFBKeyType key = new AlmFBKeyType(alarmID, cpType, fbObj.m_usPortID, fbObj.m_usPathID);
                    almAttrToFBMap.put(key, new Integer(fbObj.m_usFBType));
                }
            }
        }
    }

    public void parsePortFunction(Node node, boolean isNA) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("alarmbaseattr");
        if (null == nodeList || 0 == nodeList.getLength()) {
            return;
        }
        Element elementTmp = (Element)nodeList.item(0);
        String cpTypeStr = elementTmp.getAttribute("cptype");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementTmp.getAttribute("cp_type") : cpTypeStr;
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = element.getElementsByTagName("port_function");
        if (null == nodeList) {
            return;
        }
        boolean isTL1 = false;
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            String bitStr;
            elementTmp = (Element)nodeList.item(i);
            isTL1 = elementTmp.getAttribute("isTL1") != null && elementTmp.getAttribute("isTL1").equalsIgnoreCase("true");
            isTL1 = isNA ? true : isTL1;
            String portIDStr = elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            TENEListUtils.getNumList(portIDStr, portNoList);
            TEAlarmDataMgr.getInstance().fillPortNOMap(cpType, portNoList);
            String pathIDStr = elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            TENEListUtils.getNumList(pathIDStr, pathNoList);
            boolean supportInverse = false;
            String inverseStr = elementTmp.getAttribute("inverse");
            if (!isTL1 && !"false".equalsIgnoreCase(inverseStr)) {
                String objType;
                String string = objType = elementTmp.hasAttribute("objtype") ? elementTmp.getAttribute("objtype") : null;
                if (objType != null) {
                    objType = String.valueOf(SDXMLInterpreterMgr.getInstance().parseInt(objType));
                }
                this.pareseInverseNode(inverseStr, portNoList, pathNoList, cpType, objType);
            }
            if ("true".equalsIgnoreCase(inverseStr)) {
                supportInverse = true;
            }
            String aisStr = elementTmp.getAttribute("ais");
            if (!(isTL1 || "".equals(aisStr) || "false".equalsIgnoreCase(aisStr))) {
                this.pareseAISNode(aisStr, portNoList, pathNoList, cpType, supportInverse);
            }
            String uneqStr = elementTmp.getAttribute("uneq");
            if (!(isTL1 || "".equals(uneqStr) || "false".equalsIgnoreCase(uneqStr))) {
                this.parseUNEQNode(uneqStr, portNoList, pathNoList, cpType, supportInverse);
            }
            if ("".equals(bitStr = elementTmp.getAttribute("bitth")) || "false".equalsIgnoreCase(bitStr)) continue;
            this.pareseBITThNode(bitStr, portNoList, pathNoList, cpType, supportInverse, isTL1);
        }
    }

    private void pareseInverseNode(String nodeSubStr, ArrayList portNoList, ArrayList pathNoList, int cpType, String objType) {
        int size = portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)portNoList.get(i);
            TEAlarmInverse tEAlarmInverse = new TEAlarmInverse(portNo, pathNoList);
            if (objType != null && !"".equals(objType)) {
                tEAlarmInverse.setObjType(objType);
            }
            TEAlarmDataMgr.getInstance().fillInverseList(cpType, tEAlarmInverse);
        }
    }

    private void pareseAISNode(String nodeSubStr, ArrayList portNoList, ArrayList pathNoList, int cpType, boolean supportInverse) {
        ArrayList<TEAISTh> aisThList = new ArrayList<TEAISTh>();
        for (String thtypeStr : nodeSubStr.split(",")) {
            int index = thtypeStr.indexOf("(");
            String typeStr = thtypeStr.substring(0, index);
            int indexLast = thtypeStr.lastIndexOf(")");
            String defaultStr = thtypeStr.substring(index + 1, indexLast);
            int thtype = Integer.parseInt(typeStr.trim());
            boolean defaultvalue = false;
            if ("true".equalsIgnoreCase(defaultStr)) {
                defaultvalue = true;
            }
            TEAISTh aisTh = new TEAISTh(thtype, defaultvalue);
            aisThList.add(aisTh);
        }
        int size = portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)portNoList.get(i);
            if (pathNoList.size() == 0) {
                pathNoList.add(0);
            }
            int jSize = pathNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int pathNo = (Integer)pathNoList.get(j);
                TEAlarmAISTh alarmAIDTh = new TEAlarmAISTh(portNo, pathNo, aisThList);
                alarmAIDTh.setSupportInverse(supportInverse);
                TEAlarmDataMgr.getInstance().fillAISList(cpType, alarmAIDTh);
            }
        }
    }

    private void parseUNEQNode(String nodeSubStr, ArrayList portNoList, ArrayList pathNoList, int cpType, boolean supportInverse) {
        ArrayList<TEUNEQTh> uneqThList = new ArrayList<TEUNEQTh>();
        for (String thtypeStr : nodeSubStr.split(",")) {
            int index = thtypeStr.indexOf("(");
            String typeStr = thtypeStr.substring(0, index);
            int indexLast = thtypeStr.lastIndexOf(")");
            String defaultStr = thtypeStr.substring(index + 1, indexLast);
            int thtype = Integer.parseInt(typeStr);
            boolean defaultvalue = false;
            if ("true".equalsIgnoreCase(defaultStr)) {
                defaultvalue = true;
            }
            TEUNEQTh uneqTh = new TEUNEQTh(thtype, defaultvalue);
            uneqThList.add(uneqTh);
        }
        int size = portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)portNoList.get(i);
            int jSize = pathNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int pathNo = (Integer)pathNoList.get(j);
                TEAlarmUneqTh alarmUneqTh = new TEAlarmUneqTh(portNo, pathNo, uneqThList);
                alarmUneqTh.setSuportInverse(supportInverse);
                TEAlarmDataMgr.getInstance().fillUNEQList(cpType, alarmUneqTh);
            }
        }
    }

    private void pareseBITThNode(String nodeSubStr, ArrayList portNoList, ArrayList pathNoList, int cpType, boolean supportInverse, boolean isTL1) {
        ArrayList<TEBitErrorTh> bitThList = new ArrayList<TEBitErrorTh>();
        for (String thtypeStr : nodeSubStr.split(",")) {
            int index = thtypeStr.indexOf("(");
            String typeStr = thtypeStr.substring(0, index);
            int indexLast = thtypeStr.lastIndexOf(")");
            String defaultStr = thtypeStr.substring(index + 1, indexLast);
            int thtype = Integer.parseInt(typeStr);
            int defaultvalue = Integer.parseInt(defaultStr);
            TEBitErrorTh bitErrorTh = new TEBitErrorTh(thtype, defaultvalue);
            bitThList.add(bitErrorTh);
            if (!isTL1) {
                TEAlarmDataMgr.getInstance().fillBITTypeList(cpType, thtype);
            }
            TETL1AlarmDataMgr.getInstance().fillBITTypeList(cpType, thtype);
        }
        int size = portNoList.size();
        for (int i = 0; i < size; ++i) {
            int portNo = (Integer)portNoList.get(i);
            if (pathNoList.size() == 0) {
                pathNoList.add(0);
            }
            int jSize = pathNoList.size();
            for (int j = 0; j < jSize; ++j) {
                int pathNo = (Integer)pathNoList.get(j);
                TEPortBitErrorTh portBitErrorTh = new TEPortBitErrorTh(portNo, pathNo, bitThList);
                portBitErrorTh.setSuportInverse(supportInverse);
                if (!isTL1) {
                    TEAlarmDataMgr.getInstance().fillBITThList(cpType, portBitErrorTh);
                }
                TETL1PortBitErrorTh tl1portBitErrorTh = new TETL1PortBitErrorTh(portNo, pathNo, bitThList, isTL1);
                TETL1AlarmDataMgr.getInstance().fillBITThList(cpType, tl1portBitErrorTh);
            }
        }
    }

    private void parseSupportAlarmObjFunction(Node node) {
        HashMap<AlmObjKeyType, Set<TEAlmObjInfo>> almAttrToObjMap = new HashMap<AlmObjKeyType, Set<TEAlmObjInfo>>();
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("almdyemstoqx");
        if (null == nodeList || 0 == nodeList.getLength()) {
            return;
        }
        Element elementTmp = (Element)nodeList.item(0);
        if (null == elementTmp) {
            return;
        }
        String cpTypeStr = elementTmp.getAttribute("cptype");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementTmp.getAttribute("cp_type") : cpTypeStr;
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = elementTmp.getElementsByTagName("support_alarm");
        if (null == nodeList) {
            return;
        }
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            elementTmp = (Element)nodeList.item(i);
            String objTypeStr = elementTmp.getAttribute("objtype");
            TEAlmObjInfo tEAlmFBInfo = new TEAlmObjInfo();
            tEAlmFBInfo.objType = SDXMLInterpreterMgr.getInstance().parseInt(objTypeStr);
            String fbTypeStr = elementTmp.getAttribute("fbtype");
            tEAlmFBInfo.fbType = this.instance.parseInt(fbTypeStr);
            String aeidStr = elementTmp.getAttribute("aeid");
            ArrayList supportAlmList = new ArrayList();
            supportAlmList = this.getAeID(aeidStr, supportAlmList);
            String portIDStr = elementTmp.getAttribute("portid");
            ArrayList portNoList = new ArrayList();
            tEAlmFBInfo.portIDList = TENEListUtils.getPortArr(portIDStr, portNoList);
            String pathIDStr = elementTmp.getAttribute("pathid");
            ArrayList pathNoList = new ArrayList();
            tEAlmFBInfo.pathIDList = TENEListUtils.getPortArr(pathIDStr, pathNoList);
            this.expandObjectObjs(cpType, tEAlmFBInfo, supportAlmList, almAttrToObjMap);
        }
        TEAlarmDataMgr.getInstance().setAlarmObjMap(almAttrToObjMap);
    }

    private void expandObjectObjs(int cpType, TEAlmObjInfo tEAlmObjInfo, ArrayList supportAlmList, Map<AlmObjKeyType, Set<TEAlmObjInfo>> almAttrToObjMap) {
        ArrayList portList = tEAlmObjInfo.portIDList;
        ArrayList pathIDList = tEAlmObjInfo.pathIDList;
        TEAlmObjInfo fbObj = null;
        int portID = 0;
        int pathID = 0;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            int length = pathIDList.size();
            for (int j = 0; j < length; ++j) {
                fbObj = new TEAlmObjInfo();
                fbObj.objType = tEAlmObjInfo.objType;
                fbObj.aeidList = supportAlmList;
                fbObj.fbType = tEAlmObjInfo.fbType;
                portID = (Integer)portList.get(i);
                AlmObjKeyType key = new AlmObjKeyType(cpType, portID, pathID = ((Integer)pathIDList.get(j)).intValue());
                if (!almAttrToObjMap.containsKey(key)) {
                    HashSet<TEAlmObjInfo> objs = new HashSet<TEAlmObjInfo>();
                    objs.add(fbObj);
                    almAttrToObjMap.put(key, objs);
                    continue;
                }
                HashSet set = (HashSet)almAttrToObjMap.get(key);
                TEAlmObjInfo ObjTemp2 = null;
                boolean blExist = false;
                for (TEAlmObjInfo ObjTemp2 : set) {
                    if (ObjTemp2.objType != fbObj.objType || ObjTemp2.fbType != fbObj.fbType) continue;
                    ObjTemp2.aeidList.addAll(supportAlmList);
                    blExist = true;
                    break;
                }
                if (blExist) continue;
                set.add(fbObj);
            }
        }
    }

    private void parseSupportAlarmInverseObjFunction(Node node) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("alminvport2obj");
        if (null == nodeList || 0 == nodeList.getLength()) {
            return;
        }
        Element elementTmp = (Element)nodeList.item(0);
        String cpTypeStr = elementTmp.getAttribute("cptype");
        cpTypeStr = cpTypeStr == null || cpTypeStr.equals("") ? elementTmp.getAttribute("cp_type") : cpTypeStr;
        int cpType = this.instance.parseInt(cpTypeStr);
        nodeList = elementTmp.getElementsByTagName("support_alarm");
        if (null == nodeList) {
            return;
        }
        ArrayList portNoList = null;
        int len = nodeList.getLength();
        for (int i = 0; i < len; ++i) {
            elementTmp = (Element)nodeList.item(i);
            String objTypeStr = elementTmp.getAttribute("objtype");
            int objType = SDXMLInterpreterMgr.getInstance().parseInt(objTypeStr);
            String portIDStr = elementTmp.getAttribute("portid");
            portNoList = new ArrayList();
            TENEListUtils.getPortArr(portIDStr, portNoList);
            this.extendsAlarmInverseObj(cpType, portNoList, objType);
        }
    }

    private void extendsAlarmInverseObj(int cpType, ArrayList portNoList, int objType) {
        ArrayList inverseList = null;
        TEAlarmInverse objInverse = null;
        inverseList = TEAlarmDataMgr.getInstance().getInverseList(cpType);
        if (inverseList == null) {
            return;
        }
        int m = inverseList.size();
        for (int j = 0; j < m; ++j) {
            objInverse = (TEAlarmInverse)inverseList.get(j);
            if (!portNoList.contains(objInverse.getPortID())) continue;
            objInverse.setObjType(objType + "");
        }
    }

    private void parseServiceSupportAlarmFunction(Node node) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("service_support_alm");
        if (null == nodeList || 0 == nodeList.getLength()) {
            return;
        }
        ArrayList<TEServiceAlarm> versionToAlm = new ArrayList<TEServiceAlarm>();
        Element elementTmp = null;
        NodeList nodeListTmp = null;
        String neversion = "";
        ArrayList supportAlmList = null;
        VerRange verRange = null;
        TEServiceAlarm serviceAlarm = null;
        TEServiceAlarmFBInfo fbAlarm = null;
        int iLen = nodeList.getLength();
        for (int i = 0; i < iLen; ++i) {
            int[] to;
            int[] from;
            elementTmp = (Element)nodeList.item(i);
            nodeListTmp = elementTmp.getElementsByTagName("ne_support_alm");
            if (null == nodeListTmp || 0 == nodeListTmp.getLength() || 0 != TEVersionConvertUtil.parseSplitVerFromTo(neversion = (elementTmp = (Element)nodeListTmp.item(0)).getAttribute("neversion"), from = new int[1], to = new int[1], ",")) continue;
            verRange = new VerRange(0, 0);
            verRange.init(from[0], to[0]);
            nodeListTmp = elementTmp.getElementsByTagName("support_alarm");
            if (null == nodeListTmp) continue;
            serviceAlarm = new TEServiceAlarm();
            serviceAlarm.setVerRange(verRange);
            int jLen = nodeListTmp.getLength();
            for (int j = 0; j < jLen; ++j) {
                elementTmp = (Element)nodeListTmp.item(j);
                String fbTypeStr = elementTmp.getAttribute("fbtype");
                String aeidStr = elementTmp.getAttribute("aeid");
                supportAlmList = new ArrayList();
                supportAlmList = this.getAeID(aeidStr, supportAlmList);
                fbAlarm = new TEServiceAlarmFBInfo();
                fbAlarm.setFbType(this.instance.parseInt(fbTypeStr));
                if (elementTmp.hasAttribute("objtype")) {
                    fbAlarm.setObjType(this.instance.parseInt(elementTmp.getAttribute("objtype")));
                }
                fbAlarm.setAlarmIDList(supportAlmList);
                serviceAlarm.getAlarmFbList().add(fbAlarm);
            }
            versionToAlm.add(serviceAlarm);
        }
        TEAlarmDataMgr.getInstance().setServiceAlarmList(versionToAlm);
    }
}

