/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.alarm;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TopoUtility;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.ngwdm_pub.TEOTNModelShowPathMgr;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEAlarmMonObjID
implements Cloneable,
Comparable {
    public int m_ulNEID = -1;
    public int m_usSlotID = -1;
    public int m_usPortID = -1;
    public int m_usFBType = -1;
    public int m_usOldFBType = -1;
    public int m_usPathID = -1;
    public int fbID1 = -1;
    public int fbID2 = -1;
    public int subtp = 0;
    public static final int VC12_PATH_OFFSET = 65536;
    private static final List<Integer> BOARDS_NEEDDDPATH_VC12 = new ArrayList<Integer>();
    private static final Map<Integer, String> FB_SIMPLE_MAP = new HashMap<Integer, String>();
    public int m_objectType = -1;
    private String m_asonString = "";

    public int getNEID() {
        return this.m_ulNEID;
    }

    public void setNEID(int m_ulneid) {
        this.m_ulNEID = m_ulneid;
    }

    public int getSlotID() {
        return this.m_usSlotID;
    }

    public void setSlotID(int slotID) {
        this.m_usSlotID = slotID;
    }

    public int getPortID() {
        return this.m_usPortID;
    }

    public void setPortID(int portID) {
        this.m_usPortID = portID;
    }

    public int getFBType() {
        return this.m_usFBType;
    }

    public void setFBType(int type) {
        this.m_usFBType = type;
    }

    public int getOldFBType() {
        return this.m_usOldFBType;
    }

    public void setOldFBType(int oldFBType) {
        this.m_usOldFBType = oldFBType;
    }

    public int getPathID() {
        return this.m_usPathID;
    }

    public void setPathID(int pathID) {
        this.m_usPathID = pathID;
    }

    public int getFbID1() {
        return this.fbID1;
    }

    public void setFbID1(int fbID1) {
        this.fbID1 = fbID1;
    }

    public int getFbID2() {
        return this.fbID2;
    }

    public void setFbID2(int fbID2) {
        this.fbID2 = fbID2;
    }

    public int getSubtp() {
        return this.subtp;
    }

    public void setSubtp(int subtp) {
        this.subtp = subtp;
    }

    public TEAlarmMonObjID() {
    }

    public TEAlarmMonObjID(int m_ulNEID, int m_usSlotID, int m_usPortID, int m_usFBType, int m_usPathID, int fbID1, int fbID2) {
        this.fbID1 = fbID1;
        this.fbID2 = fbID2;
        this.m_ulNEID = m_ulNEID;
        this.m_usFBType = m_usFBType;
        this.m_usPathID = m_usPathID;
        this.m_usPortID = m_usPortID;
        this.m_usSlotID = m_usSlotID;
    }

    public void setAsonString(String asonString) {
        this.m_asonString = asonString;
    }

    public String getAsonString() {
        return this.m_asonString;
    }

    public Param[] toRowParams() {
        Param[] params = new Param[8];
        params[0] = new Param();
        params[0].setName("neID");
        params[0].setValue("" + this.m_ulNEID);
        params[1] = new Param();
        params[1].setName("slotID");
        params[1].setValue("" + this.m_usSlotID);
        params[2] = new Param();
        params[2].setName("portID");
        params[2].setValue("" + this.m_usPortID);
        params[3] = new Param();
        params[3].setName("pathID");
        params[3].setValue("" + this.m_usPathID);
        params[4] = new Param();
        params[4].setName("fbType");
        params[4].setValue("" + this.m_usFBType);
        params[5] = new Param();
        params[5].setName("oldFbType");
        params[5].setValue("" + this.m_usOldFBType);
        params[6] = new Param();
        params[6].setName("pfmMonObj");
        params[6].setValue(this.toString());
        params[7] = new Param();
        params[7].setName("objectType");
        params[7].setValue("" + this.m_objectType);
        return params;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TEAlarmMonObjID) {
            TEAlarmMonObjID tmp = (TEAlarmMonObjID)obj;
            return tmp.m_ulNEID == this.m_ulNEID && tmp.m_usSlotID == this.m_usSlotID && tmp.m_usPortID == this.m_usPortID && tmp.m_usPathID == this.m_usPathID && tmp.m_usFBType == this.m_usFBType;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.m_ulNEID;
        result = 37 * result + this.m_usSlotID;
        result = 37 * result + this.m_usPortID;
        result = 37 * result + this.m_usFBType;
        result = 37 * result + this.m_usPathID;
        return result;
    }

    public Object clone() {
        try {
            TEAlarmMonObjID obj = (TEAlarmMonObjID)super.clone();
            obj.m_ulNEID = this.m_ulNEID;
            obj.m_usSlotID = this.m_usSlotID;
            obj.m_usPortID = this.m_usPortID;
            obj.m_usFBType = this.m_usFBType;
            obj.m_usOldFBType = this.m_usOldFBType;
            obj.m_usPathID = this.m_usPathID;
            obj.fbID1 = this.fbID1;
            obj.fbID2 = this.fbID2;
            return obj;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public void getconfigfbID1() {
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.m_ulNEID, this.m_usSlotID);
        if ((BOARDS_NEEDDDPATH_VC12.contains(boardtype) || TESpecialAttrMgr.getInstance().isCPSupportByType(boardtype, "TE_FUNC_ALM_SUPPRESS", "ALM_ATTR_SUPPORT_CONVERTVC12")) && this.m_usFBType == 92 && this.m_usPathID < 65536) {
            if (this.m_usPathID % 63 > 0) {
                this.fbID1 = this.m_usPathID / 63 + 1;
                this.fbID2 = this.m_usPathID % 63;
            } else {
                this.fbID1 = this.m_usPathID / 63;
                this.fbID2 = this.m_usPathID % 63 + 63;
            }
        }
        if (boardtype == 1210 || boardtype == 1066) {
            if (this.m_usFBType == 92) {
                this.fbID1 = 2;
            }
            if (this.m_usFBType == 91) {
                this.fbID1 = this.m_usPathID / 3 + 1;
            }
        }
        if ((boardtype == 1557 || TESpecialAttrMgr.getInstance().isCPNotSupportByType(boardtype, "TE_FUNC_ALM_SUPPRESS", "ALM_ATTR_SUPPORT_CONVERTVC3")) && this.m_usFBType == 91 && this.m_usPathID < 65536) {
            if (this.m_usPathID % 3 > 0) {
                this.fbID1 = this.m_usPathID / 3 + 1;
                this.fbID2 = this.m_usPathID % 3;
            } else {
                this.fbID1 = this.m_usPathID / 3;
                this.fbID2 = this.m_usPathID % 3 + 3;
            }
        }
    }

    public void decPathID() {
        if (this.m_usFBType == 91 || this.m_usFBType == 92 || this.m_usFBType == 96 || this.m_usFBType == 95) {
            this.fbID1 = (this.m_usPathID & 0xFFFF0000) >> 16;
            this.fbID1 = this.fbID1 <= 0 ? 1 : this.fbID1;
            this.fbID2 = this.m_usPathID & 0xFFFF;
        } else {
            this.fbID1 = this.m_usPathID;
        }
        this.getconfigfbID1();
        if (this.subtp == 0) {
            this.setsubtp();
        }
    }

    public void setsubtp() {
        int cpType;
        TEAlarmDataMgr instance = TEAlarmDataMgr.getInstance();
        ArrayList list = instance.getAlarmFbList(cpType = TEConfigurationDataMgr.getInstance().getBoardType(this.m_ulNEID, this.m_usSlotID));
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                TEAlmFBObj fbObj = (TEAlmFBObj)list.get(i);
                int FBType = fbObj.m_usFBType;
                int PortID = fbObj.m_usPortID;
                int PathID = fbObj.m_usPathID;
                if (FBType != this.m_usFBType || this.m_usPortID != PortID || this.m_usPathID != PathID) continue;
                this.subtp = fbObj.subtp;
            }
        }
    }

    public String toString() {
        TENE neObj = TENEListMgr.getInstance().getNE(this.m_ulNEID);
        String neName = neObj.getNEName();
        if (this.m_usSlotID == -1) {
            if (null != this.m_asonString && !"".equals(this.m_asonString)) {
                return this.m_asonString;
            }
            String monObjStr = "-";
            if (this.m_usFBType != -1 && this.m_usFBType != 30) {
                String fbNameKey = "PTN_SERVICE_TYPE" + Integer.toHexString(this.m_usFBType).toUpperCase();
                String fbName = TENEListUtils.getString(fbNameKey);
                monObjStr = fbName.equals(fbNameKey) ? monObjStr : fbName;
            }
            return monObjStr;
        }
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.m_ulNEID, this.m_usSlotID);
        String suffixString = "";
        suffixString = null != this.m_asonString && !"".equals(this.m_asonString) ? this.getAsonString(boardtype) : this.getCommonString(boardtype);
        String boardTypeName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.m_ulNEID, boardtype);
        StringBuffer result = new StringBuffer();
        result.append(neName);
        String subrackName = TEBoardUtil.getSubrackNameFromSlot(this.m_ulNEID, this.m_usSlotID);
        if (!"".equals(subrackName)) {
            result.append("-").append(subrackName);
        }
        result.append("-").append(TEBoardUtil.getSlotIDFromSlot(this.m_ulNEID, this.m_usSlotID)).append("-").append(boardTypeName);
        if (!"".equals(suffixString)) {
            result.append("-").append(suffixString);
        }
        return result.toString();
    }

    private String getAsonString(int boardtype) {
        String funBlockName = "";
        if (this.m_usPortID != -1 && this.m_usPortID != 0) {
            String portName = TEConfigurationDataMgr.getInstance().getPortName(this.m_ulNEID, this.m_usSlotID, boardtype, this.m_usPortID);
            funBlockName = funBlockName + portName + "-";
            String tempFBName = TEFuncBlockDescription.getInstance().getFBTypeName(this.m_usFBType);
            funBlockName = tempFBName.equals("") ? funBlockName.substring(0, funBlockName.length() - 1) : funBlockName + tempFBName;
        }
        if (null != this.m_asonString && !"".equals(this.m_asonString)) {
            funBlockName = funBlockName.equals("") ? funBlockName + this.m_asonString : funBlockName + "," + this.m_asonString;
        }
        return funBlockName;
    }

    private String getCommonString(int boardtype) {
        String funBlockName = "";
        if (this.m_objectType != -1 || TEOTNModelDataMgr.getInstance().isSupportSimpleModePort(boardtype, this.m_usPortID) && this.m_usPathID > 1200) {
            int nmPath = TEOTNModelDataMgr.getInstance().getNMPathFromObjType(this.m_objectType, boardtype, this.m_usPathID);
            if (nmPath == -1) {
                nmPath = this.m_usPathID;
            }
            String portName = TEConfigurationDataMgr.getInstance().getPortName(this.m_ulNEID, this.m_usSlotID, boardtype, this.m_usPortID);
            funBlockName = portName + "-" + TEOTNModelShowPathMgr.getInstance().getOTNModelShowPath(nmPath);
        } else {
            funBlockName = TopoUtility.getPortFunBlockName(this.m_ulNEID, this.m_usSlotID, this.m_usFBType, this.m_usPortID, this.fbID1, this.fbID2, 0, 0, 0);
        }
        if (TEOTNModelDataMgr.getInstance().isSupportSimpleModePort(boardtype, this.m_usPortID) && this.m_usPathID == 1 && FB_SIMPLE_MAP.keySet().contains(this.m_usFBType)) {
            String portName = TEConfigurationDataMgr.getInstance().getPortName(this.m_ulNEID, this.m_usSlotID, boardtype, this.m_usPortID);
            funBlockName = portName + "-" + FB_SIMPLE_MAP.get(this.m_usFBType);
        }
        if (this.subtp != 0) {
            String[] temp = funBlockName.split(":");
            funBlockName = temp[0] + ":" + this.subtp + ":" + temp[1];
        }
        if (this.m_usFBType == 5) {
            if (this.fbID1 <= 0) {
                this.fbID1 = 1;
            }
            funBlockName = this.m_usPortID + "(SDH_TU-" + this.m_usPortID + ")" + "-PPI:" + this.fbID1;
        }
        if ((955 == boardtype || 971 == boardtype) && 122 == this.m_usFBType) {
            funBlockName = TopoUtility.getPortFunBlockName(this.m_ulNEID, this.m_usSlotID, this.m_usFBType, 0, this.m_usPortID, this.fbID2, 0, 0, 0);
        }
        return funBlockName;
    }

    public int compareTo(Object obj) {
        TEAlarmMonObjID tEAlarmMonObjID;
        try {
            tEAlarmMonObjID = (TEAlarmMonObjID)obj;
        }
        catch (ClassCastException ex) {
            TELogFactory.getNormalLogger().error("TEAlarmMonObjID.compareTo() fail!", (Throwable)ex);
            return 1;
        }
        if (tEAlarmMonObjID == null) {
            return 1;
        }
        int neidDiff = this.m_ulNEID - tEAlarmMonObjID.m_ulNEID;
        if (neidDiff != 0) {
            return neidDiff;
        }
        int slotidDiff = this.m_usSlotID - tEAlarmMonObjID.m_usSlotID;
        if (slotidDiff != 0) {
            return slotidDiff;
        }
        int portidDiff = this.m_usPortID - tEAlarmMonObjID.m_usPortID;
        if (portidDiff != 0) {
            return portidDiff;
        }
        int fbTypeiff = this.m_usFBType - tEAlarmMonObjID.m_usFBType;
        if (fbTypeiff != 0) {
            return fbTypeiff;
        }
        return this.m_usPathID - tEAlarmMonObjID.m_usPathID;
    }

    static {
        BOARDS_NEEDDDPATH_VC12.add(1622);
        BOARDS_NEEDDDPATH_VC12.add(2080);
        BOARDS_NEEDDDPATH_VC12.add(2079);
        BOARDS_NEEDDDPATH_VC12.add(2266);
        BOARDS_NEEDDDPATH_VC12.add(2267);
        BOARDS_NEEDDDPATH_VC12.add(2475);
        BOARDS_NEEDDDPATH_VC12.add(2468);
        FB_SIMPLE_MAP.put(810, "OCh:1-OTU1:1");
        FB_SIMPLE_MAP.put(804, "OCh:1-OTU2:1");
        FB_SIMPLE_MAP.put(801, "OCh:1-OTU3:1");
        FB_SIMPLE_MAP.put(813, "OCh:1-OTU4:1");
        FB_SIMPLE_MAP.put(832, "OCh:1-ODU0:1");
        FB_SIMPLE_MAP.put(829, "OCh:1-ODU1:1");
        FB_SIMPLE_MAP.put(823, "OCh:1-ODU2:1");
        FB_SIMPLE_MAP.put(820, "OCh:1-ODU3:1");
        FB_SIMPLE_MAP.put(838, "OCh:1-ODU4:1");
    }
}

