/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model.alarm;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.model.alarm.TEAISTh;
import java.util.ArrayList;

public class TEAlarmAISTh {
    int portID = 1;
    int pathID = 1;
    ArrayList aisThList = null;
    int boardType = 0;
    boolean isBranchBoard = false;
    boolean supportInverse = false;

    public TEAlarmAISTh() {
    }

    public TEAlarmAISTh(int portID, int pathID, ArrayList aisThList) {
        this.portID = portID;
        this.pathID = pathID;
        this.aisThList = aisThList;
    }

    public void setSupportInverse(boolean supportInverse) {
        this.supportInverse = supportInverse;
    }

    public ArrayList getAisThList() {
        return this.aisThList;
    }

    public int getPortID() {
        return this.portID;
    }

    public int getPathID() {
        return this.pathID;
    }

    public int hashCode() {
        int hashCode = 17;
        hashCode = 37 * hashCode + this.pathID;
        hashCode = 37 * hashCode + this.portID;
        return hashCode;
    }

    public String getOperationInput() {
        if (this.isBranchBoard) {
            return String.valueOf(this.pathID);
        }
        return String.valueOf(this.portID);
    }

    public RowParams toRowParams() {
        RowParams row = new RowParams();
        Param param = new Param();
        StringBuffer monObject = new StringBuffer();
        param.setName("portID");
        if (this.isBranchBoard) {
            monObject.append(this.pathID);
        } else {
            monObject.append(this.portID);
        }
        param.setValue(monObject.toString());
        row.addParam(param);
        int len = this.aisThList.size();
        for (int i = 0; i < len; ++i) {
            TEAISTh aisInsertion = (TEAISTh)this.aisThList.get(i);
            row.addParam(aisInsertion.toParam());
        }
        return row;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TEAlarmAISTh)) {
            return false;
        }
        TEAlarmAISTh tEAlarmAISTh = (TEAlarmAISTh)obj;
        return tEAlarmAISTh.portID == this.portID && tEAlarmAISTh.pathID == this.pathID;
    }

    public boolean isBranchBoard() {
        return this.isBranchBoard;
    }

    public void setBranchBoard(boolean isBranchBoard) {
        this.isBranchBoard = isBranchBoard;
    }

    public int getBoardType() {
        return this.boardType;
    }

    public void setBoardType(int boardType) {
        this.boardType = boardType;
    }

    public Object clone() {
        TEAlarmAISTh o = new TEAlarmAISTh();
        o.supportInverse = this.supportInverse;
        o.boardType = this.boardType;
        o.isBranchBoard = this.isBranchBoard;
        o.pathID = this.pathID;
        o.portID = this.portID;
        if (this.aisThList != null) {
            o.aisThList = (ArrayList)this.aisThList.clone();
        }
        return o;
    }

    public boolean portEqueal(int port) {
        if (this.isBranchBoard) {
            return this.pathID == port;
        }
        return this.portID == port;
    }
}

