/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.Vector;

public class TopoUtility {
    public static final int LOWBYTE_PORT = 255;
    public static boolean isOverRange = false;
    private static TopoUtility instance = null;

    private TopoUtility() {
    }

    public static synchronized TopoUtility getInstance() {
        if (instance == null) {
            instance = new TopoUtility();
        }
        return instance;
    }

    public static boolean isBitValueSet(int srcint, int value) {
        int highBit = TopoUtility.getHighBit(value);
        return (srcint >> highBit & (1 << highBit) - 1) == 1;
    }

    public static boolean isBitSet(int srcint, int fromIndex) {
        return TopoUtility.getBitsValue(srcint, fromIndex, 1) == 1;
    }

    public static int setBit(int srcint, int fromIndex) {
        return TopoUtility.setBitsValue(srcint, 1, fromIndex, 1);
    }

    public static int clearBit(int srcint, int fromIndex) {
        return TopoUtility.setBitsValue(srcint, 0, fromIndex, 1);
    }

    public static int getBitsValue(int srcint, int fromIndex, int width) {
        return srcint >> fromIndex & (1 << width) - 1;
    }

    public static int setBitsValue(int srcint, int desint, int fromIndex, int width) {
        int mask = -1 - (1 << fromIndex + width) + (1 << fromIndex);
        return (desint << fromIndex) + (srcint & mask);
    }

    public static int getHighBit(int srcint) {
        int i = 0;
        while (srcint > 1) {
            srcint >>= 1;
            ++i;
        }
        return i;
    }

    public static int getBitsIntValueFromSrcint(int srcint, int fromIndex, int toIndex) {
        String srcStr = Integer.toString(srcint);
        try {
            Integer retInt = new Integer(srcStr.substring(fromIndex, toIndex));
            return retInt;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static long convertIPStrToLong(String ipStr) {
        if (null == ipStr) {
            return 0L;
        }
        char[] ch = ipStr.toCharArray();
        long result = 0L;
        long sum = 0L;
        int TCount = 0;
        boolean frontIsPoint = true;
        int[] T = new int[]{0x1000000, 65536, 256};
        int[] nMax = new int[]{223, 255, 255, 255};
        for (int i = 0; i < ipStr.length(); ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                sum = sum * 10L + (long)(ch[i] - 48);
                frontIsPoint = false;
                continue;
            }
            if (ch[i] == '.') {
                if (frontIsPoint) {
                    return 0L;
                }
                frontIsPoint = true;
                if (TCount >= 3) {
                    return 0L;
                }
                if (sum > (long)nMax[TCount]) {
                    return 0L;
                }
                result += sum * (long)T[TCount++];
                sum = 0L;
                continue;
            }
            if (ch[i] == ' ') continue;
            return 0L;
        }
        if (frontIsPoint) {
            return 0L;
        }
        if (TCount != 3) {
            return 0L;
        }
        if (sum > (long)nMax[TCount]) {
            return 0L;
        }
        return result + sum;
    }

    public static long convertIPStrToLong(String ipStr, boolean flag) {
        int[] max;
        if (null == ipStr) {
            return 0L;
        }
        char[] ch = ipStr.toCharArray();
        long result = 0L;
        long sum = 0L;
        int TCount = 0;
        boolean frontIsPoint = true;
        int[] T = new int[]{0x1000000, 65536, 256};
        int[] nMax = flag ? (max = new int[]{223, 255, 255, 254}) : (max = new int[]{223, 255, 255, 255});
        for (int i = 0; i < ipStr.length(); ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                sum = sum * 10L + (long)(ch[i] - 48);
                frontIsPoint = false;
                continue;
            }
            if (ch[i] == '.') {
                if (frontIsPoint) {
                    return 0L;
                }
                frontIsPoint = true;
                if (flag && sum == 0L && TCount == 0) {
                    return 0L;
                }
                if (TCount >= 3) {
                    return 0L;
                }
                if (sum > (long)nMax[TCount]) {
                    return 0L;
                }
                result += sum * (long)T[TCount++];
                sum = 0L;
                continue;
            }
            if (ch[i] == ' ') continue;
            return 0L;
        }
        if (frontIsPoint) {
            return 0L;
        }
        if (TCount != 3) {
            return 0L;
        }
        if (flag && sum == 0L && TCount == 3) {
            return 0L;
        }
        if (sum > (long)nMax[TCount]) {
            return 0L;
        }
        return result + sum;
    }

    public static long convertIPMaskStrToLong(String ipStr) {
        if (null == ipStr) {
            return 0L;
        }
        char[] ch = ipStr.toCharArray();
        long result = 0L;
        long sum = 0L;
        int TCount = 0;
        boolean frontIsPoint = true;
        int[] T = new int[]{0x1000000, 65536, 256};
        for (int i = 0; i < ipStr.length(); ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                sum = sum * 10L + (long)(ch[i] - 48);
                frontIsPoint = false;
                continue;
            }
            if (ch[i] == '.') {
                if (frontIsPoint) {
                    return 0L;
                }
                frontIsPoint = true;
                if (TCount >= 3) {
                    return 0L;
                }
                if (sum > 255L) {
                    return 0L;
                }
                result += sum * (long)T[TCount++];
                sum = 0L;
                continue;
            }
            if (ch[i] == ' ') continue;
            return 0L;
        }
        if (frontIsPoint) {
            return 0L;
        }
        if (TCount != 3) {
            return 0L;
        }
        if (sum > 255L) {
            return 0L;
        }
        return result + sum;
    }

    public static boolean isValidIpMask(long ipMask) {
        String sIpMask = Integer.toBinaryString(BigInteger.valueOf(ipMask).intValue());
        if (sIpMask.length() == 32) {
            int pos = sIpMask.indexOf("0");
            return pos == -1 || (pos = (sIpMask = sIpMask.substring(pos + 1, sIpMask.length())).indexOf("1")) == -1;
        }
        return false;
    }

    public static String ipToString(long ip) {
        long ip1 = ip >> 24 & 0xFFL;
        long ip2 = ip >> 16 & 0xFFL;
        long ip3 = ip >> 8 & 0xFFL;
        long ip4 = ip & 0xFFL;
        return "" + ip1 + "." + ip2 + "." + ip3 + "." + ip4;
    }

    public static ArrayList parseSlot(String s) {
        if (s == null) {
            return null;
        }
        char[] ch = s.toCharArray();
        int len = ch.length;
        if (len > 1 && (ch[len - 1] < '0' || ch[len - 1] > '9')) {
            return null;
        }
        return TopoUtility.parseSlot1(s);
    }

    public static ArrayList parseSlot1(String s) {
        ArrayList<Integer> hs1 = new ArrayList<Integer>();
        isOverRange = false;
        int cur = -1;
        int last1 = -1;
        int number1 = 0;
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                if (cur == -1) {
                    cur = 0;
                }
                cur = cur * 10 + (ch[i] - 48);
                ++number1;
                continue;
            }
            if (ch[i] == ',') {
                if (last1 != -1 && cur != -1) {
                    int j;
                    int min = last1;
                    int max = cur;
                    if (last1 > cur) {
                        min = cur;
                        for (j = max = last1; j >= min; --j) {
                            hs1.add(j);
                        }
                    } else {
                        for (j = min; j <= max; ++j) {
                            hs1.add(j);
                        }
                    }
                } else if (cur != -1) {
                    hs1.add(cur);
                } else {
                    return null;
                }
                last1 = -1;
                cur = -1;
                number1 = 0;
                continue;
            }
            if (ch[i] == '-') {
                if (last1 != -1 || cur == -1) {
                    return null;
                }
                if (cur != -1) {
                    last1 = cur;
                }
                cur = -1;
                number1 = 0;
                continue;
            }
            if (ch[i] == '[' || ch[i] == ']') continue;
            return null;
        }
        if (last1 != -1 && cur != -1) {
            int j;
            int min = last1;
            int max = cur;
            if (last1 > cur) {
                min = cur;
                for (j = max = last1; j >= min; --j) {
                    hs1.add(j);
                }
            } else {
                for (j = min; j <= max; ++j) {
                    hs1.add(j);
                }
            }
        } else if (cur != -1) {
            hs1.add(cur);
        }
        return hs1;
    }

    public static ArrayList parseSlot2(String s, int maxValue) {
        ArrayList<Integer> hs = new ArrayList<Integer>();
        isOverRange = false;
        int cur = -1;
        int last = -1;
        int number = 0;
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                if (cur == -1) {
                    cur = 0;
                }
                cur = cur * 10 + (ch[i] - 48);
                ++number;
                if (cur <= maxValue) continue;
                isOverRange = true;
                return null;
            }
            if (ch[i] == ',') {
                if (last != -1 && cur != -1) {
                    int j;
                    int min = last;
                    int max = cur;
                    if (last > cur) {
                        min = cur;
                        for (j = max = last; j >= min; --j) {
                            hs.add(j);
                        }
                    } else {
                        for (j = min; j <= max; ++j) {
                            hs.add(j);
                        }
                    }
                } else if (cur != -1) {
                    hs.add(cur);
                } else if (i == 0 || ch[i - 1] != '-') {
                    return null;
                }
                last = -1;
                cur = -1;
                number = 0;
                continue;
            }
            if (ch[i] == '-') {
                if (last != -1 || cur == -1) {
                    return null;
                }
                if (cur != -1) {
                    last = cur;
                }
                cur = -1;
                number = 0;
                continue;
            }
            if (ch[i] == '[' || ch[i] == ']') continue;
            return null;
        }
        if (last != -1 && cur != -1) {
            int j;
            int min = last;
            int max = cur;
            if (last > cur) {
                min = cur;
                for (j = max = last; j >= min; --j) {
                    hs.add(j);
                }
            } else {
                for (j = min; j <= max; ++j) {
                    hs.add(j);
                }
            }
        } else if (cur != -1) {
            hs.add(cur);
        }
        return hs;
    }

    public static ArrayList parseValidSlotValue(String s, int minValue, int maxValue) {
        ArrayList<Integer> valueList = new ArrayList<Integer>();
        int cur = -1;
        int last = -1;
        char[] ch = s.toCharArray();
        if (ch.length == 0) {
            return valueList;
        }
        int strLength = ch.length;
        for (int i = 0; i <= strLength; ++i) {
            if (i == strLength || ch[i] == ',') {
                if (last != -1 && cur != -1) {
                    if (last < minValue || cur < minValue) {
                        return null;
                    }
                    int min = last;
                    int max = cur;
                    if (last > cur) {
                        min = cur;
                        max = last;
                    }
                    for (int j = min; j <= max; ++j) {
                        valueList.add(j);
                    }
                } else if (cur != -1) {
                    if (cur < minValue) {
                        return null;
                    }
                    valueList.add(cur);
                } else {
                    return null;
                }
                last = -1;
                cur = -1;
                continue;
            }
            if (ch[i] == '-') {
                if (last != -1 || cur == -1) {
                    return null;
                }
                last = cur;
                cur = -1;
                continue;
            }
            if (ch[i] >= '0' && ch[i] <= '9') {
                if (cur == -1) {
                    cur = 0;
                }
                if ((cur = cur * 10 + (ch[i] - 48)) <= maxValue) continue;
                return null;
            }
            return null;
        }
        return valueList;
    }

    public static boolean isXCLevelOK(int interfaceLevel, int xcLevel) {
        switch (interfaceLevel) {
            case 6401: {
                return xcLevel >= 0 && xcLevel <= 4865;
            }
            case 6402: {
                return xcLevel >= 0 && xcLevel <= 4865;
            }
            case 6404: {
                return xcLevel >= 0 && xcLevel <= 4868;
            }
            case 6408: {
                return xcLevel <= 4872;
            }
            case 6416: {
                return xcLevel >= 0 && xcLevel <= 4880;
            }
            case 6448: {
                return xcLevel == 4865;
            }
            case 6464: {
                return xcLevel >= 0 && xcLevel <= 4928;
            }
            case 4097: {
                return xcLevel == 4097;
            }
            case 4099: {
                return xcLevel == 4099;
            }
            case 4100: {
                return xcLevel == 4865;
            }
            case 4868: {
                return xcLevel == 4868;
            }
            case 4872: {
                return xcLevel == 4872 || xcLevel == 4868;
            }
            case 20482: {
                return xcLevel <= 4865;
            }
            case 20483: {
                return xcLevel <= 4865;
            }
            case 16387: {
                return xcLevel == 4097;
            }
            case 16388: {
                return xcLevel == 4872 || xcLevel == 4868;
            }
        }
        return false;
    }

    public static int getVC4Number(int level) {
        switch (level) {
            case 4864: 
            case 4865: {
                return 1;
            }
            case 4868: {
                return 4;
            }
            case 4872: {
                return 8;
            }
            case 4880: {
                return 16;
            }
            case 4928: {
                return 64;
            }
        }
        return 1;
    }

    public static String getCurrentTime() {
        String[] ids = TimeZone.getAvailableIDs(-28800000);
        if (ids.length == 0) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar(new SimpleTimeZone(28800000, ids[0]));
        int value = calendar.get(10);
        String temp = String.valueOf(value);
        temp = temp + ":";
        value = calendar.get(12);
        temp = temp + String.valueOf(value);
        temp = temp + ":";
        value = calendar.get(13);
        temp = temp + String.valueOf(value);
        temp = temp + ":";
        value = calendar.get(14);
        temp = temp + String.valueOf(value);
        return temp;
    }

    public static ArrayList parseSlotValue(String s, int maxValue) {
        ArrayList<BigInteger> hs = new ArrayList<BigInteger>();
        int cur = -1;
        int last = -1;
        int number = 0;
        char[] ch = s.toCharArray();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] >= '0' && ch[i] <= '9') {
                if (cur == -1) {
                    cur = 0;
                }
                cur = cur * 10 + (ch[i] - 48);
                ++number;
                if (cur <= maxValue) continue;
                return null;
            }
            if (ch[i] == ',') {
                if (last != -1 && cur != -1) {
                    int j;
                    int min = last;
                    int max = cur;
                    if (last > cur) {
                        min = cur;
                        for (j = max = last; j >= min; --j) {
                            hs.add(BigInteger.valueOf(j));
                        }
                    } else {
                        for (j = min; j <= max; ++j) {
                            hs.add(BigInteger.valueOf(j));
                        }
                    }
                } else if (cur != -1) {
                    hs.add(BigInteger.valueOf(cur));
                } else {
                    return null;
                }
                last = -1;
                cur = -1;
                number = 0;
                continue;
            }
            if (ch[i] == '-') {
                if (last != -1 || cur == -1) {
                    return null;
                }
                if (cur != -1) {
                    last = cur;
                }
                cur = -1;
                number = 0;
                continue;
            }
            return null;
        }
        if (last != -1 && cur != -1) {
            int j;
            int min = last;
            int max = cur;
            if (last > cur) {
                min = cur;
                for (j = max = last; j >= min; --j) {
                    hs.add(BigInteger.valueOf(j));
                }
            } else {
                for (j = min; j <= max; ++j) {
                    hs.add(BigInteger.valueOf(j));
                }
            }
        } else if (cur != -1) {
            hs.add(BigInteger.valueOf(cur));
        }
        return hs;
    }

    public static String getStringFromSequenceOfInt(ArrayList src) {
        if (src != null) {
            Collections.sort(src);
            StringBuffer result = new StringBuffer();
            boolean bneedAddDelim = false;
            int start = 0;
            int end = 0;
            int startTemp = 0;
            int endTemp = 0;
            int endTempX = 0;
            int size = src.size();
            while (start != end || start != size) {
                endTempX = (Integer)src.get(++end - 1);
                startTemp = (Integer)src.get(start);
                if (end < src.size() && (endTemp = ((Integer)src.get(end)).intValue()) - endTempX == 1) continue;
                if (bneedAddDelim) {
                    result.append(",");
                }
                if (start == end - 1) {
                    result.append(startTemp);
                } else {
                    result.append(startTemp).append('-').append(endTempX);
                }
                bneedAddDelim = true;
                start = end;
            }
            return new String(result);
        }
        return "";
    }

    public static String getStringFromSequenceOfInt(Vector src) {
        if (src != null) {
            Collections.sort(src);
            StringBuffer result = new StringBuffer();
            boolean bneedAddDelim = false;
            int start = 0;
            int end = 0;
            int startTemp = 0;
            int endTemp = 0;
            int endTempX = 0;
            int size = src.size();
            while (start != end || start != size) {
                endTempX = ((BigInteger)src.get(++end - 1)).intValue();
                startTemp = ((BigInteger)src.get(start)).intValue();
                if (end < src.size() && (endTemp = ((BigInteger)src.get(end)).intValue()) - endTempX == 1) continue;
                if (bneedAddDelim) {
                    result.append(",");
                }
                if (start == end - 1) {
                    result.append(startTemp);
                } else {
                    result.append(startTemp).append('-').append(endTempX);
                }
                bneedAddDelim = true;
                start = end;
            }
            return new String(result);
        }
        return "";
    }

    public static String getStringFromSequenceOfInt(int[] array) {
        StringBuffer result = new StringBuffer();
        boolean bneedAddDelim = false;
        int start = 0;
        int end = 0;
        int size = array.length;
        while (start != end || start != size) {
            if (++end < size && array[end] - array[end - 1] == 1) continue;
            if (bneedAddDelim) {
                result.append(",");
            }
            if (start == end - 1) {
                result.append(array[start]);
            } else {
                result.append(array[start] + "-" + array[end - 1]);
            }
            bneedAddDelim = true;
            start = end;
        }
        return new String(result);
    }

    public String getNEBoardPortFunBlockName(int neID, int slotID, int boardType, int iFunblockType, int iLocation1, int iLocation2, int iLocation3, int iLocation4, int iLocation5, int iLocation6) {
        String portFunBlockName;
        StringBuffer strbuff = new StringBuffer();
        if (slotID > 0 && slotID != 255) {
            strbuff.append(slotID);
        }
        if (boardType > 0) {
            strbuff.append("-").append(TEConfigurationDataMgr.getInstance().getBoardTypeName(neID, boardType));
        }
        if (null != (portFunBlockName = TopoUtility.getPortFunBlockName(neID, slotID, iFunblockType, iLocation1, iLocation2, iLocation3, iLocation4, iLocation5, iLocation6)) && !"".equals(portFunBlockName)) {
            strbuff.append("-").append(portFunBlockName);
        }
        return strbuff.toString();
    }

    public static final String getPortFunBlockName(int neID, int slotID, int iFunblockType, int iLocation1, int iLocation2, int iLocation3, int iLocation4, int iLocation5, int iLocation6) {
        StringBuffer strbuff = new StringBuffer();
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int boardType = cfgMgr.getBoardType(neID, slotID);
        if (iFunblockType > 0 && iFunblockType != 255) {
            if (iFunblockType != 30 && iFunblockType != 53 && iFunblockType != 500 && iFunblockType != 501 && iFunblockType != 502 && iFunblockType != 7 && iFunblockType != 122 && iFunblockType != 4208 && iFunblockType != 4209) {
                int portID = iLocation1;
                int funID1 = iLocation2;
                int funID2 = iLocation3;
                if (portID > 0 && portID != 65535) {
                    String portName = "";
                    portName = iFunblockType == 128 || iFunblockType == 129 || iFunblockType == 130 || iFunblockType == 919 || iFunblockType == 920 || iFunblockType == 921 ? cfgMgr.getPortNameByPortType(neID, slotID, boardType, portID, 1802) : (iFunblockType == 931 || iFunblockType == 932 || iFunblockType == 933 ? cfgMgr.getPortNameByPortType(neID, slotID, boardType, portID, 1803) : (iFunblockType == 19 || iFunblockType == 49 || iFunblockType == 50 ? cfgMgr.getPortNameByPortType(neID, slotID, boardType, portID, 1025) : (iFunblockType == 92 || iFunblockType == 96 || iFunblockType == 95 || iFunblockType == 91 || iFunblockType == 94 || iFunblockType == 93 || iFunblockType == 4 || iFunblockType == 44 || iFunblockType == 43 || iFunblockType == 5 || iFunblockType == 46 || iFunblockType == 45 || iFunblockType == 2 || iFunblockType == 3 ? cfgMgr.getPortNameByPortType(neID, slotID, boardType, portID, 256) : (iFunblockType == 4153 ? String.valueOf(portID) : cfgMgr.getPortNameForNARTN(neID, slotID, boardType, portID)))));
                    if (portName.startsWith("VCTRUNK")) {
                        return strbuff.append(portName).toString();
                    }
                    strbuff.append(portName).append("-");
                }
                if (iFunblockType == 91 || iFunblockType == 93 || iFunblockType == 94 || iFunblockType == 92 || iFunblockType == 95 || iFunblockType == 96) {
                    if (funID1 == 0) {
                        funID1 = 1;
                    }
                    strbuff.append(cfgMgr.getFunBlockTypeName(4));
                    strbuff.append(':').append(funID1).append('-');
                    strbuff.append(cfgMgr.getFunBlockTypeName(iFunblockType));
                    if (funID2 > 0) {
                        strbuff.append(':').append(funID2);
                    }
                } else {
                    String funName = cfgMgr.getFunBlockTypeName(iFunblockType);
                    strbuff.append(funName);
                    if (funID1 > 0) {
                        if (1000 <= funID1) {
                            strbuff.append(':').append(funID1);
                        } else {
                            strbuff.append(':').append(TEConfigurationDataMgr.getPortRelativeID(funID1));
                        }
                    }
                }
            } else if (iFunblockType == 122) {
                strbuff.append(cfgMgr.getFunBlockTypeName(iFunblockType));
                if (iLocation1 > 0) {
                    strbuff.append("-").append(iLocation1).append(":").append(iLocation1);
                }
            } else {
                strbuff.append(cfgMgr.getFunBlockTypeName(iFunblockType));
                if ((iFunblockType == 500 || iFunblockType == 501 || iFunblockType == 502 || iFunblockType == 7) && iLocation1 > 0) {
                    strbuff.append(":").append(TEConfigurationDataMgr.getPortRelativeID(iLocation1));
                }
            }
        } else if (iLocation1 > 0) {
            strbuff.append(cfgMgr.getPortNameForNARTN(neID, slotID, boardType, iLocation1));
        }
        return strbuff.toString();
    }

    public static boolean isLEM18Board(int boardType) {
        return boardType == 2272;
    }
}

