/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.circuitpack.TEPortModeData;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEWorkModeInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("work_mode_desc");
        if (nodeList.getLength() == 0) {
            return 0;
        }
        HashMap<Integer, ArrayList<TEPortModeData>> workModeMap = TEWorkModeInterpreter.parseWorkModeNodeList(nodeList);
        if (workModeMap != null && !workModeMap.isEmpty()) {
            TECircuitPackDescription.getInstance().addWorkModeMap(workModeMap);
        }
        return 0;
    }

    public static HashMap<Integer, ArrayList<TEPortModeData>> parseWorkModeNodeList(NodeList nl) {
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        HashMap<Integer, ArrayList<TEPortModeData>> workModeMap = new HashMap<Integer, ArrayList<TEPortModeData>>();
        int len = nl.getLength();
        for (int i = 0; i < len; ++i) {
            Element eltWdm = (Element)nl.item(i);
            String cpTypeValue = eltWdm.getAttribute("cp_type");
            int cptype = instance.parseInt(cpTypeValue);
            if (cptype == 0) continue;
            ArrayList<TEPortModeData> workModeList = new ArrayList<TEPortModeData>();
            workModeMap.put(cptype, workModeList);
            NodeList itemNode = eltWdm.getElementsByTagName("item");
            int size = itemNode.getLength();
            for (int j = 0; j < size; ++j) {
                String dependport;
                String portid;
                String workmode;
                TEPortModeData workModeData = new TEPortModeData();
                Element eltTmp = (Element)itemNode.item(j);
                String boardmode = eltTmp.getAttribute("boardmode");
                if (!boardmode.equalsIgnoreCase("none")) {
                    workModeData.setBoardMode(Integer.parseInt(boardmode));
                }
                if (!(workmode = eltTmp.getAttribute("workmode")).equalsIgnoreCase("none")) {
                    workModeData.setWorkmode(workmode);
                }
                if (!(portid = eltTmp.getAttribute("portid")).equals("0")) {
                    workModeData.setPortid(portid);
                }
                if (!"".equals(dependport = eltTmp.getAttribute("dependport"))) {
                    workModeData.setDependPortId(dependport);
                }
                String versionRange = eltTmp.getAttribute("neversion");
                workModeData.setVersionRange(versionRange);
                String netype = eltTmp.getAttribute("netype");
                workModeData.setNeTypeStr(netype);
                workModeData.init();
                workModeList.add(workModeData);
            }
        }
        return workModeMap;
    }
}

