/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.datetime.TEDateUtils;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;

public class TETL1AbNormalEvent {
    public int eventID = 0;
    public String eventName = "";
    public String mod2 = "";
    public int severityLevel = 0;
    public String severityStr = "";
    public String location = "";
    public String direction = "";
    public String objStr = "";
    public Calendar timeStr = null;
    public Date risedDate = null;
    public String timeRiseStr = "";
    public String comment = "";
    public int nodeType = 0;
    public int domainType = 0;
    public int evtType = -1;
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";
    private static final HashMap<Integer, String> devTypeMap = new HashMap();

    public RowParams toRowParam(int neID, boolean isPrint) {
        RowParams rtnRowParams = new RowParams();
        Param param = new Param();
        param.setName("eventID");
        param.setValue(String.valueOf(this.eventID));
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("eventName");
        param.setValue(this.eventName);
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("eventLocation");
        param.setValue(this.location);
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("eventDirection");
        param.setValue(this.direction);
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("severityLevel");
        param.setValue(String.valueOf(this.severityLevel));
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("eventLevel");
        param.setValue(this.severityStr);
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("monObj");
        param.setValue(this.objStr);
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("nodeType");
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neID);
        String nodeTypeStr = -1 == this.nodeType || 0 == this.nodeType ? this.getNodeType(isPrint, ne.getNEType()) : this.getNodeType(isPrint, this.nodeType);
        if (nodeTypeStr == null) {
            param.setValue("");
        } else {
            param.setValue(nodeTypeStr);
        }
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("risedTime");
        long time = TEDateUtils.strToCalendar(this.timeRiseStr, "yyyy-MM-dd HH:mm:ss").getTimeInMillis();
        time = TEDateUtils.getTL1NMTimeFromNETime(neID, time).getTimeInMillis();
        param.setValue(String.valueOf(time));
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("desciption");
        param.setValue(this.comment.trim());
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("domainType");
        param.setValue(String.valueOf(this.domainType));
        rtnRowParams.addParam(param);
        param = new Param();
        param.setName("evtType");
        param.setValue(this.convertAlarmTypeToStr(this.evtType));
        rtnRowParams.addParam(param);
        return rtnRowParams;
    }

    private String getNodeType(boolean isPrint, int nodetype) {
        if (isPrint) {
            return devTypeMap.get(nodetype);
        }
        return String.valueOf(nodetype);
    }

    private String convertAlarmTypeToStr(int aeType2) {
        return TENEListUtils.getString("alarmType_" + aeType2, ALARM_SOURCE_FILE);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        TETL1AbNormalEvent Event2 = (TETL1AbNormalEvent)obj;
        return Event2.eventID == this.eventID && Event2.mod2.equals(this.mod2) && Event2.timeRiseStr.equalsIgnoreCase(this.timeRiseStr) && Event2.comment.equalsIgnoreCase(this.comment) && Event2.location.equals(this.location) && Event2.direction.equals(this.direction);
    }

    static {
        devTypeMap.put(66, "Optix OSN 1800(NA)");
        devTypeMap.put(70, "Optix OSN 3800A");
        devTypeMap.put(71, "Optix OSN 6800A");
        devTypeMap.put(73, "OptiX OSN 8800 T32(NA)");
        devTypeMap.put(75, "OptiX OSN 8800 T64(NA)");
    }
}

