/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.tl1.TETL1CommonUtil;

public class TETL1AIDKey {
    private int neID = -1;
    private int shelfID = -1;
    private int slotID = -1;
    private int portID = -1;
    private int pathID = -1;
    private String aidPre = "";
    private String aid = "";
    private String mod2 = "";
    private static final int BOARDOFFSET = 65536;

    public TETL1AIDKey(int _neID, String _aid, String _mod2) {
        this.neID = _neID;
        this.aid = _aid;
        this.mod2 = _mod2;
        String[] aidArray = TETL1CommonUtil.parseAID(this.aid, this.neID);
        this.aidPre = aidArray[0];
        try {
            this.shelfID = Integer.parseInt(aidArray[1]);
            this.slotID = Integer.parseInt(aidArray[2]);
            this.portID = Integer.parseInt(aidArray[3]);
            this.pathID = Integer.parseInt(aidArray[4]);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }

    public int getNMSlot() {
        return this.shelfID * 65536 + this.slotID;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public int getShelfID() {
        return this.shelfID;
    }

    public void setShelfID(int shelfID) {
        this.shelfID = shelfID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public int getPortID() {
        return this.portID;
    }

    public void setPortID(int portID) {
        this.portID = portID;
    }

    public int getPathID() {
        return this.pathID;
    }

    public void setPathID(int pathID) {
        this.pathID = pathID;
    }

    public String getAidPre() {
        return this.aidPre;
    }

    public void setAidPre(String aidPre) {
        this.aidPre = aidPre;
    }

    public String getAid() {
        return this.aid;
    }

    public void setAid(String aid) {
        this.aid = aid;
    }

    public String getMod2() {
        return this.mod2;
    }

    public void setMod2(String mod2) {
        this.mod2 = mod2;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.aidPre == null ? 0 : this.aidPre.hashCode());
        result = 31 * result + (this.mod2 == null ? 0 : this.mod2.hashCode());
        result = 31 * result + this.neID;
        result = 31 * result + this.pathID;
        result = 31 * result + this.portID;
        result = 31 * result + this.shelfID;
        result = 31 * result + this.slotID;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TETL1AIDKey)) {
            return false;
        }
        TETL1AIDKey other = (TETL1AIDKey)obj;
        if (this.aidPre == null ? other.aidPre != null : !this.aidPre.equals(other.aidPre)) {
            return false;
        }
        if (this.mod2 == null ? other.mod2 != null : !this.mod2.equals(other.mod2)) {
            return false;
        }
        if (this.neID != other.neID) {
            return false;
        }
        if (this.pathID != other.pathID) {
            return false;
        }
        if (this.portID != other.portID) {
            return false;
        }
        if (this.shelfID != other.shelfID) {
            return false;
        }
        return this.slotID == other.slotID;
    }
}

