/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TELCTFunBlock;
import com.huawei.nglct.nelist.model.TENgwdmDynPortConfigurationDataCache;
import com.huawei.nglct.nelist.model.TEPortFBModel;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.util.device.board.TEQueryBoardInfoBean;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TESpecialBoardData {
    private static int TIME_OUT = 20;
    private Map<String, List<TEPortFBModel>> boardInfoMap = new Hashtable<String, List<TEPortFBModel>>();
    private Map<String, Set<Integer>> portInfoMap = new HashMap<String, Set<Integer>>();
    private Set<Integer> portNoSet = new HashSet<Integer>();
    private List pathList = new ArrayList();
    private static TESpecialBoardData instance = null;
    private static Map<Integer, String> fbNameMap = new HashMap<Integer, String>();
    private static Logger log = TELogFactory.getNormalLogger();
    public static final int XC_LEVEL_OTU1 = 513;
    public static final int XC_LEVEL_OTU2 = 514;
    public static final int XC_LEVEL_OTU3 = 515;
    public static final int XC_LEVEL_OTU5G = 516;
    public static final int XC_LEVEL_ODU0 = 528;
    public static final int XC_LEVEL_ODU1 = 529;
    public static final int XC_LEVEL_ODU2 = 530;
    public static final int XC_LEVEL_ODU3 = 531;
    public static final int XC_LEVEL_ODU5G = 532;
    public static final int XC_LEVEL_ANY = 65535;
    public static final Map<Integer, Integer[]> FBQxTable;

    private TESpecialBoardData() {
    }

    public static synchronized TESpecialBoardData getInstance() {
        if (instance == null) {
            instance = new TESpecialBoardData();
        }
        return instance;
    }

    public Set getPortNoList() {
        return this.portNoSet;
    }

    public List getPathList() {
        return this.pathList;
    }

    public void setPathList(ArrayList pathList) {
        this.pathList.clear();
        this.pathList.addAll(pathList);
    }

    public void setPortNoSet(Set<Integer> portNoSet) {
        this.portNoSet.clear();
        this.portNoSet.addAll(portNoSet);
    }

    public void addPortNo(int neId, int slotId, int portNo) {
        String key = "" + neId + "-" + slotId;
        if (!this.portInfoMap.containsKey(key)) {
            this.portInfoMap.put(key, new HashSet());
        }
        this.portInfoMap.get(key).add(portNo);
    }

    public void clearBoardPortInfo(int neId, int slotId) {
        String key = "" + neId + "-" + slotId;
        if (this.portInfoMap.containsKey(key)) {
            this.portInfoMap.remove(key);
        }
    }

    public void clearNePortInfo(int neId) {
        Iterator<Map.Entry<String, Set<Integer>>> iter = this.portInfoMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Set<Integer>> entry = iter.next();
            String key = entry.getKey();
            if (!key.split("-")[0].equals(String.valueOf(neId))) continue;
            iter.remove();
        }
    }

    public int getPortType() {
        return -1;
    }

    public String getPortName() {
        return "";
    }

    public int getPalyloadType() {
        return -1;
    }

    public void addPortFB(int neId, int slotId, TEPortFBModel fbModel) {
        String key = "" + neId + "-" + slotId;
        int port = fbModel.getPortId();
        if (!this.boardInfoMap.containsKey(key)) {
            this.boardInfoMap.put(key, new ArrayList());
        }
        if (!this.portInfoMap.containsKey(key) || !this.portInfoMap.get(key).contains(port)) {
            TEPortFBModel portRootFB = new TEPortFBModel(neId, slotId, fbModel.getPortId(), 0, 0);
            portRootFB.setSeqenceLevel();
            this.boardInfoMap.get(key).add(portRootFB);
        }
        this.boardInfoMap.get(key).add(fbModel);
    }

    public void setBoardFB(int neId, int slotId, List<TEPortFBModel> fbList) {
        String key = "" + neId + "-" + slotId;
        this.boardInfoMap.put(key, fbList);
    }

    public List<TEPortFBModel> getFBList(int neId, int slotId) {
        String key = "" + neId + "-" + slotId;
        return this.boardInfoMap.get(key);
    }

    public void removeBoardInfo(int neId, int slotId) {
        String key = "" + neId + "-" + slotId;
        if (this.boardInfoMap.containsKey(key)) {
            this.boardInfoMap.remove(key);
        }
    }

    public void clearNeBoardInfo(int neId) {
        Iterator<Map.Entry<String, List<TEPortFBModel>>> iter = this.boardInfoMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, List<TEPortFBModel>> entry = iter.next();
            String key = entry.getKey();
            if (!key.split("-")[0].equals(String.valueOf(neId))) continue;
            iter.remove();
        }
    }

    public ArrayList getChannelPathFBList(int neID, int slotID, String boardName, int iBoardType) {
        List<TEPortFBModel> fbList;
        List boardFunPropertyList;
        ArrayList<TELCTFunBlock> result = new ArrayList<TELCTFunBlock>();
        TELCTFunBlock funblock = new TELCTFunBlock();
        funblock.name = boardName;
        funblock.id = "0";
        funblock.pid = "-1";
        funblock.seqenceLevel = 0;
        result.add(funblock);
        HashSet<Integer> dynPortSet = new HashSet<Integer>();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        if (mgr.isMutativeBoardType(neID, iBoardType)) {
            ArrayList dynProList = mgr.getDynPropertyList(neID, iBoardType);
            int size = dynProList.size();
            for (int i = 0; i < size; ++i) {
                TEPortProperty portProperty = (TEPortProperty)dynProList.get(i);
                int portType = portProperty.getPortType();
                if ((portType & 2) != 2) continue;
                dynPortSet.add(portProperty.getPortNo());
            }
        }
        if ((boardFunPropertyList = mgr.getBoardFunBlockList(iBoardType)) != null && boardFunPropertyList.size() > 0) {
            int size = boardFunPropertyList.size();
            for (int i = 0; i < size; ++i) {
                TEFunBlockProperty fbproperty = (TEFunBlockProperty)boardFunPropertyList.get(i);
                int fbtype = fbproperty.getFuctionBlockType();
                ArrayList fbNoList = fbproperty.getFunctionBlockNoList();
                if (fbNoList == null || fbNoList.size() <= 0) continue;
                int length = fbNoList.size();
                for (int j = 0; j < length; ++j) {
                    TELCTFunBlock fb = new TELCTFunBlock();
                    fb.id = funblock.id + "-" + result.size();
                    fb.pid = funblock.id;
                    fb.functionType = fbtype;
                    fb.pathid = 0;
                    fb.portid = 0;
                    fb.seqenceLevel = 1;
                    int id = j + 1;
                    fb.name = TEConfigurationDataMgr.getInstance().getFunBlockTypeName(fbtype) + "-" + id;
                    result.add(fb);
                }
            }
        }
        if ((fbList = this.getFBList(neID, slotID)) == null || fbList.size() == 0) {
            ArrayList<Integer> tmpL = new ArrayList<Integer>();
            tmpL.add(slotID);
            TEQueryBoardInfoBean.queryBoardInfo(neID, tmpL);
            fbList = this.getFBList(neID, slotID);
        }
        this.processPortFb(neID, slotID, fbList, result, dynPortSet);
        return result;
    }

    private void processPortFb(int neID, int slotID, List<TEPortFBModel> fbList, ArrayList<TELCTFunBlock> result, HashSet dynPortSet) {
        if (fbList == null || result == null) {
            return;
        }
        TELCTFunBlock funblock = null;
        TEPortFBModel portFBMode = null;
        ArrayList logicPortList = TEConfigurationDataMgr.getInstance().getLogicPortList(neID, slotID);
        String pid = "0";
        int clientFBIndex = 1;
        String tempPid = "";
        List portsEt = this.getLogiPortExist(neID, slotID, dynPortSet);
        int size = fbList.size();
        for (int i = 0; i < size; ++i) {
            portFBMode = fbList.get(i);
            funblock = new TELCTFunBlock();
            if (portFBMode.getPath() == 0) {
                funblock.pid = "0";
                funblock.id = "0-" + result.size();
                funblock.name = "";
                funblock.portName = portFBMode.getPortName();
                pid = funblock.id;
                clientFBIndex = 1;
                tempPid = funblock.id;
            } else {
                String fbName;
                funblock.pid = portFBMode.getSeqenceLevel() > 2 ? tempPid : pid;
                funblock.id = pid + "-" + result.size();
                if (portFBMode.getSeqenceLevel() <= 2) {
                    tempPid = funblock.id;
                }
                if (null == (fbName = fbNameMap.get(portFBMode.getPathType()))) continue;
                if (fbName.indexOf("CLIENT") != -1) {
                    fbName = fbName + "-" + clientFBIndex;
                    ++clientFBIndex;
                } else {
                    clientFBIndex = 1;
                }
                funblock.name = fbName;
            }
            int canDelPort = 0;
            int logicPortInPosition = 1;
            if (dynPortSet.contains(portFBMode.getPortId())) {
                canDelPort = 1;
                if (!logicPortList.contains(portFBMode.getPortId()) || !portsEt.contains(portFBMode.getPortId())) {
                    logicPortInPosition = 0;
                } else {
                    Integer portType = TENgwdmDynPortConfigurationDataCache.getInstance().getDynportType(neID, slotID, portFBMode.getPortId());
                    if (portType != null && !portType.equals(-1)) {
                        funblock.portType = portType.toString();
                    }
                }
            }
            funblock.canDelPort = canDelPort;
            funblock.functionType = portFBMode.getFuctionBlockType();
            funblock.pathid = portFBMode.getPath();
            funblock.portid = portFBMode.getPortId();
            funblock.canModifyPort = canDelPort;
            funblock.logicPortInPosition = logicPortInPosition;
            funblock.seqenceLevel = portFBMode.getSeqenceLevel();
            result.add(funblock);
            if (3 > funblock.portid || funblock.portid > 10 || funblock.pathid == 0) continue;
            TELCTFunBlock fb = (TELCTFunBlock)funblock.clone();
            funblock.name = "OCH-1";
            result.add(fb);
        }
        dynPortSet.removeAll(logicPortList);
        Iterator it = dynPortSet.iterator();
        while (it.hasNext()) {
            funblock = new TELCTFunBlock();
            funblock.functionType = 10769;
            funblock.pid = pid;
            funblock.portid = (Integer)it.next();
            funblock.id = pid + "-" + result.size();
            funblock.seqenceLevel = 3;
            funblock.logicPortInPosition = 0;
            funblock.canDelPort = 1;
            funblock.canModifyPort = 1;
            result.add(funblock);
        }
    }

    private List getLogiPortExist(int neID, int slotID, Set dyPorts) {
        ArrayList<Integer> res = new ArrayList<Integer>();
        try {
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORT");
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            Operation tmpOper = null;
            Input input = null;
            Iterator ite = dyPorts.iterator();
            while (ite.hasNext()) {
                tmpOper = (Operation)oper.clone();
                input = tmpOper.getInput();
                input.getPart("slotID").setValue(String.valueOf(slotID));
                input.getPart("portID").setValue(ite.next().toString());
                operationList.add(tmpOper);
            }
            int resualt = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)TESpecialBoardData.TIME_OUT).retCode;
            if (resualt == 0) {
                int iLen = operationList.size();
                for (int i = 0; i < iLen; ++i) {
                    tmpOper = (Operation)operationList.get(i);
                    if (!tmpOper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
                    res.add(Integer.valueOf(tmpOper.getInput().getPartValue("portID")));
                }
            }
        }
        catch (Exception e) {
            log.error("Find operation object fail!", (Throwable)e);
            return null;
        }
        return res;
    }

    static {
        fbNameMap.put(513, "OTU-1");
        fbNameMap.put(514, "OTU-2");
        fbNameMap.put(515, "OTU-3");
        fbNameMap.put(516, "OTU-5G");
        fbNameMap.put(528, "ODU-0");
        fbNameMap.put(529, "ODU-1");
        fbNameMap.put(530, "ODU-2");
        fbNameMap.put(531, "ODU-3");
        fbNameMap.put(532, "ODU-5G");
        fbNameMap.put(65535, "CLIENT");
        FBQxTable = new HashMap<Integer, Integer[]>();
        Integer[] a = new Integer[]{810, 860};
        FBQxTable.put(513, a);
        Integer[] b = new Integer[]{804, 854};
        FBQxTable.put(514, b);
        Integer[] c = new Integer[]{801, 851};
        FBQxTable.put(515, c);
        Integer[] d = new Integer[]{807, 857};
        FBQxTable.put(516, d);
        Integer[] e = new Integer[]{832, 883};
        FBQxTable.put(528, e);
        Integer[] f = new Integer[]{829, 880};
        FBQxTable.put(529, f);
        Integer[] g = new Integer[]{822, 874};
        FBQxTable.put(530, g);
        Integer[] h = new Integer[]{820, 871};
        FBQxTable.put(531, h);
        Integer[] i = new Integer[]{826, 877};
        FBQxTable.put(532, i);
        Integer[] j = new Integer[]{200};
        FBQxTable.put(65535, j);
    }
}

