/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.mo.ttp.TETTPKey;
import com.huawei.nglct.nelist.model.TESDHXCTTp;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TObjectIntHashMap;
import java.util.List;

public class TESDHTTPUsedInfoMgr {
    private static TESDHTTPUsedInfoMgr instance = null;
    static int[][] ulTblUsedVC4 = new int[][]{{4864, 1}, {4865, 1}, {4868, 4}, {4872, 8}, {4880, 16}, {4928, 64}, {5120, 256}};
    private TIntObjectHashMap<TIntObjectHashMap<TObjectIntHashMap<TETTPKey>>> m_SlotTTPUsedInfo = new TIntObjectHashMap();

    private TESDHTTPUsedInfoMgr() {
    }

    public static synchronized TESDHTTPUsedInfoMgr getInstance() {
        if (null == instance) {
            instance = new TESDHTTPUsedInfoMgr();
        }
        return instance;
    }

    public void updatePPIUsedInfo(int neID, List<TESDHXCTTp> ttpList, boolean isSrc, boolean isAdd) {
        if (!this.m_SlotTTPUsedInfo.contains(neID)) {
            if (!isAdd) {
                TELogFactory.getNormalLogger().debug("Cound not find used TTP info about NE : " + neID);
                return;
            }
            this.m_SlotTTPUsedInfo.put(neID, (Object)new TIntObjectHashMap());
        }
        TIntObjectHashMap neInfo = (TIntObjectHashMap)this.m_SlotTTPUsedInfo.get(neID);
        int slotID = 0;
        int portID = 0;
        int size = ttpList.size();
        for (int index = 0; index < size; ++index) {
            TESDHXCTTp xcTTP = ttpList.get(index);
            slotID = xcTTP.getSlotID();
            if (!isAdd && !neInfo.contains(slotID)) {
                TELogFactory.getNormalLogger().debug("Cound not find used TTP info about NE : " + neID + ", SLOT : " + slotID);
                return;
            }
            TObjectIntHashMap slotInfo = (TObjectIntHashMap)neInfo.get(slotID);
            if (null == slotInfo) {
                slotInfo = new TObjectIntHashMap();
            }
            portID = xcTTP.getPortID();
            TETTPKey ttpKey = new TETTPKey();
            if (isSrc) {
                ttpKey.setPara(45, portID, 1, 1);
            } else {
                ttpKey.setPara(46, portID, 1, 1);
            }
            if (slotInfo.contains((Object)ttpKey)) {
                if (isAdd) {
                    slotInfo.put((Object)ttpKey, slotInfo.get((Object)ttpKey) + 1);
                    continue;
                }
                if (slotInfo.get((Object)ttpKey) < 1) {
                    TELogFactory.getNormalLogger().debug("The used time of TTPKey is invalid, TTPKey's current used time is " + slotInfo.get((Object)ttpKey));
                    return;
                }
                slotInfo.put((Object)ttpKey, slotInfo.get((Object)ttpKey) - 1);
                continue;
            }
            if (isAdd) {
                slotInfo.put((Object)ttpKey, 1);
                continue;
            }
            TELogFactory.getNormalLogger().debug("The TTPKey's record is not exist!");
            return;
        }
    }

    public void updateVC4TTPUsedInfo(int neID, List<TESDHXCTTp> ttpList, boolean isSrc, boolean isAdd) {
        if (!this.m_SlotTTPUsedInfo.contains(neID)) {
            if (!isAdd) {
                TELogFactory.getNormalLogger().debug("Cound not find used TTP info about NE : " + neID);
                return;
            }
            this.m_SlotTTPUsedInfo.put(neID, (Object)new TIntObjectHashMap());
        }
        TIntObjectHashMap neInfo = (TIntObjectHashMap)this.m_SlotTTPUsedInfo.get(neID);
        int slotID = 0;
        int portID = 0;
        int vc4No = 0;
        int ttpLowNo = 0;
        int size = ttpList.size();
        for (int index = 0; index < size; ++index) {
            TESDHXCTTp xcTTP = ttpList.get(index);
            slotID = xcTTP.getSlotID();
            if (!isAdd && !neInfo.contains(slotID)) {
                TELogFactory.getNormalLogger().debug("Cound not find used TTP info about NE : " + neID + ", SLOT : " + slotID);
                return;
            }
            portID = xcTTP.getPortID();
            vc4No = xcTTP.getTs().m_usVC4;
            TObjectIntHashMap slotInfo = (TObjectIntHashMap)neInfo.get(slotID);
            if (null == slotInfo) {
                slotInfo = new TObjectIntHashMap();
                neInfo.put(slotID, (Object)slotInfo);
            }
            int xcLevel = xcTTP.m_TTpLevel;
            TETTPKey ttpKey = new TETTPKey();
            switch (xcLevel) {
                case 4097: {
                    ttpLowNo = xcTTP.getTs().getNo();
                    if (isSrc) {
                        ttpKey.setPara(95, portID, vc4No, ttpLowNo);
                        break;
                    }
                    ttpKey.setPara(96, portID, vc4No, ttpLowNo);
                    break;
                }
                case 4099: {
                    ttpLowNo = xcTTP.getTs().getNo();
                    if (isSrc) {
                        ttpKey.setPara(93, portID, vc4No, ttpLowNo);
                        break;
                    }
                    ttpKey.setPara(94, portID, vc4No, ttpLowNo);
                    break;
                }
                default: {
                    if (isSrc) {
                        ttpKey.setPara(43, portID, vc4No, 0);
                        break;
                    }
                    ttpKey.setPara(44, portID, vc4No, 0);
                }
            }
            if (slotInfo.contains((Object)ttpKey)) {
                if (isAdd) {
                    slotInfo.put((Object)ttpKey, slotInfo.get((Object)ttpKey) + 1);
                    continue;
                }
                if (slotInfo.get((Object)ttpKey) < 1) {
                    TELogFactory.getNormalLogger().debug("The used time of TTPKey is invalid, TTPKey's current used time is " + slotInfo.get((Object)ttpKey));
                    return;
                }
                slotInfo.put((Object)ttpKey, slotInfo.get((Object)ttpKey) - 1);
                continue;
            }
            if (isAdd) {
                slotInfo.put((Object)ttpKey, 1);
                continue;
            }
            TELogFactory.getNormalLogger().debug("The TTPKey's record is not exist!");
            return;
        }
    }

    public int getUsedVC4Number(int level) {
        if (!this.isXCHighLevel(level)) {
            return 1;
        }
        for (int tblIndex = 0; tblIndex < ulTblUsedVC4.length; ++tblIndex) {
            if (level != ulTblUsedVC4[tblIndex][0]) continue;
            return ulTblUsedVC4[tblIndex][1];
        }
        return 0;
    }

    public boolean isXCHighLevel(int xcLevel) {
        return xcLevel >= 4864;
    }

    public boolean isTTPKeyUsed(int neID, int slotID, TETTPKey key) {
        return this.m_SlotTTPUsedInfo.contains(neID) && ((TIntObjectHashMap)this.m_SlotTTPUsedInfo.get(neID)).contains(slotID) && ((TObjectIntHashMap)((TIntObjectHashMap)this.m_SlotTTPUsedInfo.get(neID)).get(slotID)).contains((Object)key) && ((TObjectIntHashMap)((TIntObjectHashMap)this.m_SlotTTPUsedInfo.get(neID)).get(slotID)).get((Object)key) > 0;
    }

    public void delNEInfo(int neID) {
        if (this.m_SlotTTPUsedInfo.contains(neID)) {
            this.m_SlotTTPUsedInfo.remove(neID);
        }
    }
}

