/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.mo.CfgDataMgr;
import com.huawei.nglct.mo.VerRange;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.util.batch.TECollectionOperations;
import com.huawei.nglct.util.convertor.TEVersionConvertUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TEReadServiceTypeUtil {
    private static TEReadServiceTypeUtil instance = new TEReadServiceTypeUtil();
    private NodeList nodeList = this.parseServiceTypeXML();

    private TEReadServiceTypeUtil() {
    }

    public static TEReadServiceTypeUtil getInstance() {
        return instance;
    }

    public ArrayList getServiceTypeList(int neID, int boardType, int portID, int ver) {
        ArrayList serviceTypeList = new ArrayList();
        NodeList list = this.getPortList(boardType);
        if (list == null) {
            return serviceTypeList;
        }
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        TENE ne = TENEListUtils.getNEObj(neID);
        int n = list.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)list.item(i);
            String elementValue = element.getAttribute("port_no_list");
            TIntArrayList portIDList = new TIntArrayList();
            mgr.parseIntList(elementValue, portIDList);
            int mn = portIDList.size();
            for (int k = 0; k < mn; ++k) {
                VerRange verRange;
                int portId = portIDList.get(k);
                if (portId != portID || (verRange = this.parseNEVersion(element.getAttribute("supportVersion"))) != null && !verRange.isWithInRange(ver)) continue;
                TIntArrayList iList = new TIntArrayList();
                String serviceTypeListStr = "";
                if (ne.getIsTL1OrQX() == 1) {
                    serviceTypeListStr = element.getAttribute("support_tl1xc_level");
                }
                if (serviceTypeListStr.equals("")) {
                    serviceTypeListStr = element.getAttribute("support_xc_level");
                }
                mgr.parseIntList(serviceTypeListStr, iList);
                TECollectionOperations.copyFromTIntArrayListWithOutRepeat(this.convertFromNMToNE(iList), serviceTypeList);
            }
        }
        return serviceTypeList;
    }

    private VerRange parseNEVersion(String value) {
        VerRange verRange = null;
        int[] from = new int[1];
        int[] to = new int[1];
        if (!value.equals("") && 0 == TEVersionConvertUtil.parseVerFromTo(value, from, to)) {
            verRange = new VerRange(0, 0);
            verRange.init(from[0], to[0]);
        }
        return verRange;
    }

    private TIntArrayList convertFromNMToNE(TIntArrayList nmServiceTypeList) {
        CfgDataMgr dataMgr = CfgDataMgr.getInstance();
        TIntArrayList tempArr = new TIntArrayList();
        int size = nmServiceTypeList.size();
        for (int i = 0; i < size; ++i) {
            int nmServiceType = nmServiceTypeList.get(i);
            int neServiceType = dataMgr.getNESerTypeByNM(nmServiceType);
            tempArr.add(neServiceType);
        }
        return tempArr;
    }

    private NodeList parseServiceTypeXML() {
        Document doc = null;
        String filePath = TEResourceManager.getPath() + "core" + File.separator + "conf" + File.separator + "xml" + File.separator + "model" + File.separator + "wdm" + File.separator + "wdmcp_service_type.xml";
        try {
            doc = TEParseXMLFile.parseFile(filePath);
            this.nodeList = doc.getElementsByTagName("port_para");
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TEReadServiceTypeUtil.parseServiceTypeXML() fail!", (Throwable)ex);
        }
        return this.nodeList;
    }

    public NodeList getPortList(int boardType) {
        NodeList bdTypeList = null;
        if (this.nodeList != null) {
            int n = this.nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Element element = (Element)this.nodeList.item(i);
                String cpType = element.getAttribute("type");
                if (boardType != Integer.parseInt(cpType)) continue;
                bdTypeList = element.getElementsByTagName("item");
            }
        }
        return bdTypeList;
    }
}

