/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TEPortBufferKey;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TEPortModelConfigurationDataMgr;
import com.huawei.nglct.po.embeddednemgrmo.TEPortMOPO;
import com.huawei.nglct.util.buffer.RefreshTimeBufferIF;
import com.huawei.nglct.util.buffer.TETimeBufferByLoadTimes;
import com.huawei.nglct.util.buffer.TEUnknowmKeyTypeException;
import com.huawei.nglct.util.buffer.UnkownRefresherException;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.system.TEClassRuntime;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TEQueryPortForDataMgr {
    private static TETimeBufferByLoadTimes<TEPortBufferKey, TEPort> portBuffer = new TETimeBufferByLoadTimes();

    public static void startBuffer(int neID, List<Integer> iSlotIDList) {
        TENE ne = TENEConfigurationDataMgr.getInstance().getNE(neID);
        if (ne != null) {
            for (int i = 0; i < iSlotIDList.size(); ++i) {
                TEBoard board = ne.getBoard(iSlotIDList.get(i));
                if (board == null) continue;
                int boardType = board.getBoardType();
                List<TEPort> portList = TEQueryPortForDataMgr.getPortBySlotOnInterNoBuffer(neID, iSlotIDList.get(i), boardType);
                for (int j = 0; j < portList.size(); ++j) {
                    TEPort port = portList.get(j);
                    try {
                        portBuffer.put(new TEPortBufferKey(neID, iSlotIDList.get(i), port.getPortNo(), port.getPortDomainType()), portList.get(j));
                        continue;
                    }
                    catch (TEUnknowmKeyTypeException e) {
                        TELogFactory.getNormalLogger().error(e.toString());
                        continue;
                    }
                    catch (UnkownRefresherException e) {
                        TELogFactory.getNormalLogger().error(e.toString());
                    }
                }
            }
        }
    }

    public static void clearBuffer(int neID, List<Integer> iSlotIDList) {
        ArrayList<TEPortBufferKey> portList = new ArrayList<TEPortBufferKey>();
        Set<TEPortBufferKey> keySet = portBuffer.keySet();
        for (TEPortBufferKey key : keySet) {
            if (key.getNeid() != neID || !iSlotIDList.contains(key.getSlotid())) continue;
            portList.add(key);
        }
        for (TEPortBufferKey key : portList) {
            portBuffer.clearData(key);
        }
    }

    private static TEPort getPortOnInterNoByBuffer(int neID, int slotID, int boardType, int portID, int portDomainType) {
        TEPort port = null;
        TEDaoOperationResult dbResult = null;
        try {
            int abstractPortID = TEQueryPortForDataMgr.getAbstractPortID(neID, portID, portDomainType);
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TELogFactory.getNormalLogger().error("The ne is not exist! neID->" + neID);
                return port;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findPorts(neID, slotID, new int[]{abstractPortID}) : TECommonDaoService.findPorts_NonLock(neID, slotID, new int[]{abstractPortID});
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get Port error!", (Throwable)e);
            return port;
        }
        if (null == dbResult) {
            TELogFactory.getNormalLogger().error("Get Port error! The dbResult is null.");
            return port;
        }
        if (0 != dbResult.getResult()) {
            TELogFactory.getNormalLogger().error("Get Port error! The dbResult.result is: " + dbResult.getResult());
            return port;
        }
        List<Object> portList = dbResult.getData();
        if (0 != portList.size()) {
            TEPortMOPO portPO = (TEPortMOPO)portList.get(0);
            port = TEQueryPortForDataMgr.convertPortFromPO(neID, slotID, boardType, portID, portPO);
        } else {
            TELogFactory.getNormalLogger().error("Get Port error! The portList is empty!" + slotID + '-' + portID);
        }
        return port;
    }

    public static TEPort getPortOnInterForType(int neID, int slotID, int boardType, int portID, int portType) {
        int portDomain = TEPortDescription.getInstance().getPortDomain(portType);
        if (portDomain == 255) {
            portDomain = TEQueryPortForDataMgr.getCNEMgrDomainType(neID);
        }
        return TEQueryPortForDataMgr.getPortOnInter(neID, slotID, boardType, portID, portDomain);
    }

    public static TEPort getPortOnInter(int neID, int slotID, int boardType, int portID) {
        int portType = TEPortModelConfigurationDataMgr.getInstance().getPortType(neID, boardType, portID);
        return TEQueryPortForDataMgr.getPortOnInterForType(neID, slotID, boardType, portID, portType);
    }

    public static TEPort getPortOnInter(int neID, int slotID, int boardType, int portID, int portDomainType) {
        TEPortBufferKey key = new TEPortBufferKey(neID, slotID, portID, portDomainType);
        if (portBuffer.containsKey(key)) {
            try {
                return portBuffer.get(key);
            }
            catch (TEUnknowmKeyTypeException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
            catch (UnkownRefresherException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
        }
        return TEQueryPortForDataMgr.getPortOnInterNoByBuffer(neID, slotID, boardType, portID, portDomainType);
    }

    public static int getAbstractPortID(int neID, int portID) {
        int domainType = TEQueryPortForDataMgr.getCNEMgrDomainType(neID);
        return TEConfigurationDataMgr.getAbsolutPort(domainType, portID);
    }

    public static int getAbstractPortID(int neID, int portID, int portDomainType) {
        return TEConfigurationDataMgr.getAbsolutPort(portDomainType, portID);
    }

    public static int getBoardAbstractPortID(int neID, int boardType, int portID) {
        int portType = TEPortModelConfigurationDataMgr.getInstance().getPortType(neID, boardType, portID);
        int portDomain = TEPortDescription.getInstance().getPortDomain(portType);
        if (portDomain == 255) {
            portDomain = TEQueryPortForDataMgr.getCNEMgrDomainType(neID);
        }
        return TEConfigurationDataMgr.getAbsolutPort(portDomain, portID);
    }

    public static int getCNEMgrDomainType(int neID) {
        int domainType = -1;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String domain = TEGetNEDomainVersion.getInstance().getCnemgrDomain(ne.getNEType());
        if (ne.getNEType() == 79 || "sdh".equals(domain)) {
            domainType = 1;
        } else if (ne.getNEType() != 79 && "ngwdm".equals(domain)) {
            domainType = 3;
        } else if ("rtn".equals(domain)) {
            domainType = 11;
        } else if ("marine".equals(domain)) {
            domainType = 3;
        } else if ("ptn".equals(domain)) {
            domainType = 16;
        } else if ("tl1ngwdm".equals(domain)) {
            domainType = 3;
        } else if ("wdm".equals(domain)) {
            domainType = 3;
        } else {
            TELogFactory.getNormalLogger().error("Get domain type error!");
        }
        return domainType;
    }

    public static List<TEPort> getPortListOnInter(int neID, int slotID, int boardType) {
        return TEQueryPortForDataMgr.getPortBySlotOnInterNoBuffer(neID, slotID, boardType);
    }

    private static List<TEPort> getPortBySlotOnInterNoBuffer(int neID, int slotID, int boardType) {
        ArrayList<TEPort> portList = new ArrayList<TEPort>();
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TELogFactory.getNormalLogger().error("The ne is not exist! neID->" + neID);
                return portList;
            }
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findPorts(neID, slotID) : TECommonDaoService.findPorts_NonLock(neID, slotID);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get Port List error!", (Throwable)e);
            return portList;
        }
        if (null == dbResult) {
            TELogFactory.getNormalLogger().error("Get Port List error! The dbResult is null.");
            return portList;
        }
        if (0 != dbResult.getResult()) {
            TELogFactory.getNormalLogger().error("Get Port List error! The dbResult.result is: " + dbResult.getResult());
            return portList;
        }
        List<Object> portPOList = dbResult.getData();
        if (null == portPOList) {
            TELogFactory.getNormalLogger().error("Get Port List error! The portPOList is null!");
            return portList;
        }
        TEPort port = null;
        TEPortMOPO portPO = null;
        int len = portPOList.size();
        for (int i = 0; i < len; ++i) {
            portPO = (TEPortMOPO)portPOList.get(i);
            port = TEQueryPortForDataMgr.convertPortFromPO(neID, slotID, boardType, -1, portPO);
            portList.add(port);
        }
        return portList;
    }

    private static List<Integer> getListFromArray(int[] intArray) {
        ArrayList<Integer> intList = new ArrayList<Integer>(intArray.length);
        for (int i = 0; i < intArray.length; ++i) {
            intList.add(intArray[i]);
        }
        return intList;
    }

    public static List<TEPort> getPortListOnInter(int neID, int slotID, int boardType, Map<Integer, Integer> porttypes) {
        ArrayList<TEPort> portList = new ArrayList<TEPort>();
        ArrayList<Integer> portIDList = new ArrayList<Integer>();
        ArrayList<Integer> portNumList = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> porttype : porttypes.entrySet()) {
            portIDList.add(porttype.getKey());
            int portdomain = TEPortDescription.getInstance().getPortDomain(porttype.getValue());
            TEPortBufferKey key = new TEPortBufferKey(neID, slotID, porttype.getKey(), portdomain);
            if (!portBuffer.containsKey(key)) continue;
            try {
                portList.add(portBuffer.get(key));
                portNumList.add(porttype.getKey());
            }
            catch (TEUnknowmKeyTypeException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
            catch (UnkownRefresherException e) {
                TELogFactory.getNormalLogger().error(e.toString());
            }
        }
        portIDList.removeAll(portNumList);
        if (!portIDList.isEmpty()) {
            TEDaoOperationResult dbResult = null;
            try {
                int[] abstractPortIDs = TEQueryPortForDataMgr.getAbstractPortIDs(neID, porttypes);
                TENE ne = TENEListMgr.getInstance().getNE(neID);
                if (null == ne) {
                    TELogFactory.getNormalLogger().error("The ne is not exist! neID->" + neID);
                    return portList;
                }
                dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findPorts(neID, slotID, abstractPortIDs) : TECommonDaoService.findPorts_NonLock(neID, slotID, abstractPortIDs);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Get Port List error!", (Throwable)e);
                return portList;
            }
            if (null == dbResult) {
                TELogFactory.getNormalLogger().error("Get Port List error! The dbResult is null.");
                return portList;
            }
            if (0 != dbResult.getResult()) {
                TELogFactory.getNormalLogger().error("Get Port List error! The dbResult.result is: " + dbResult.getResult());
                return portList;
            }
            List<Object> portPOList = dbResult.getData();
            if (null == portPOList) {
                TELogFactory.getNormalLogger().error("Get Port List error! The portPOList is null!");
                return portList;
            }
            TEPort port = null;
            TEPortMOPO portPO = null;
            int len = portPOList.size();
            for (int i = 0; i < len; ++i) {
                portPO = (TEPortMOPO)portPOList.get(i);
                port = TEQueryPortForDataMgr.convertPortFromPO(neID, slotID, boardType, -1, portPO);
                portList.add(port);
            }
        }
        return portList;
    }

    private static int[] getAbstractPortIDs(int neID, Map<Integer, Integer> porttypes) {
        int[] abstractPortIDs = new int[porttypes.size()];
        Iterator<Map.Entry<Integer, Integer>> iterator = porttypes.entrySet().iterator();
        int i = 0;
        TEPortDescription portDes = TEPortDescription.getInstance();
        while (iterator.hasNext()) {
            Map.Entry<Integer, Integer> porttype = iterator.next();
            int portDomain = portDes.getPortDomain(porttype.getValue());
            if (255 == portDomain) {
                portDomain = TEQueryPortForDataMgr.getCNEMgrDomainType(neID);
            }
            abstractPortIDs[i++] = TEQueryPortForDataMgr.getAbstractPortID(neID, porttype.getKey(), portDomain);
        }
        return abstractPortIDs;
    }

    private static TEPort convertPortFromPO(int neID, int slotID, int boardType, int portID, TEPortMOPO portPO) {
        TEPort port = new TEPort(neID, slotID, boardType, portID);
        port.setLevel(portPO.getInterfaceLevel());
        port.setPortAddibleType(portPO.getSignalType());
        port.setPortName(portPO.getName());
        if (-1 == portID) {
            int portNo = TEConfigurationDataMgr.getPortRelativeID((int)portPO.getPortNo());
            port.setPortNo(portNo);
            int portDomainType = TEConfigurationDataMgr.getPortDomainType((int)portPO.getPortNo());
            port.setPortDomainType(portDomainType);
        }
        port.setPortType(portPO.getPortInnerType());
        port.setPortMode(portPO.getPortMode());
        return port;
    }

    static {
        portBuffer.setBufferCapacity(50000);
        portBuffer.setPeriodTime(3000L);
        portBuffer.setRefreshTimeBuffer(new RefreshTimeBufferIF(){

            @Override
            public Object refreshTimeBuffer(Object key) throws TEUnknowmKeyTypeException {
                if (key instanceof TEPortBufferKey) {
                    TEPortBufferKey idkey = (TEPortBufferKey)key;
                    int cptype = TEBoardConfigurationDataMgr.getInstance().getBoardType(idkey.getNeid(), idkey.getSlotid());
                    TEPort port = TEQueryPortForDataMgr.getPortOnInterNoByBuffer(idkey.getNeid(), idkey.getSlotid(), cptype, idkey.getPortid(), idkey.getDomainType());
                    if (port != null) {
                        return port;
                    }
                    TELogFactory.getNormalLogger().error("refreshTimeBuffer but gei port failed on \n" + TEClassRuntime.getCaller());
                }
                return null;
            }
        });
    }
}

