/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.datamgr.TEBoardConfigurationDataMgr;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public final class TEQueryLogicPortForDataMgr {
    public static List<Integer> getLogicPortListOnInter(int iNEID, int iSlotID) {
        List<Object> logicPortList = null;
        TENE ne = TENEListMgr.getInstance().getNE(iNEID);
        if (null != ne) {
            int isTL1OrQx;
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(iNEID, iSlotID);
            logicPortList = TEConfigurationDataMgr.getInstance().isDynPortBoardType(iNEID, boardType) ? (1 == (isTL1OrQx = ne.getIsTL1OrQX()) ? TEQueryLogicPortForDataMgr.getLogicPortForTL1(iNEID, iSlotID) : TEQueryLogicPortForDataMgr.getLogicPortForQxNew(iNEID, iSlotID, boardType)) : TEQueryLogicPortForDataMgr.getInstallCPPort(boardType);
        }
        if (null == logicPortList) {
            logicPortList = new ArrayList();
        }
        return logicPortList;
    }

    private static List<Integer> getLogicPortForQxNew(int iNEID, int iSlotID, int boardType) {
        List<Integer> dyncPortList = TEQueryLogicPortForDataMgr.getLogicPortForQx(iNEID, iSlotID, boardType);
        ArrayList addiblePortList = TEBoardConfigurationDataMgr.getInstance().getDynPropertyList(iNEID, boardType);
        List<Integer> allInstallCPPortList = TEQueryLogicPortForDataMgr.getInstallCPPort(boardType);
        for (TEPortProperty portProperty : addiblePortList) {
            Integer portID = portProperty.getPortNo();
            if (dyncPortList.contains(portID)) continue;
            allInstallCPPortList.remove(portID);
        }
        if (TECircuitPackDescription.getInstance().isSupportSubCard(boardType)) {
            allInstallCPPortList.addAll(TEQueryLogicPortForDataMgr.getQuerySubCPPortOperList(iNEID, iSlotID, boardType));
        }
        return allInstallCPPortList;
    }

    private static List<Integer> getInstallCPPort(int boardType) {
        ArrayList<Integer> installCPPortList = new ArrayList<Integer>();
        ArrayList portList = null;
        TEInstallCPPortRecord portRecord = null;
        List<TEInstallCPPortRecord> portRecordList = TECircuitPackDescription.getInstance().getInstallCPPort(boardType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            portRecord = portRecordList.get(i);
            portList = portRecord.getPortIDList();
            if (installCPPortList.containsAll(portList)) continue;
            installCPPortList.addAll(portList);
        }
        return installCPPortList;
    }

    private static List<Integer> getLogicPortForTL1(int neId, int slotId) {
        ArrayList<Integer> logicPortList = new ArrayList<Integer>();
        TL1Definitions definitions = null;
        Logger log = TELogFactory.getNormalLogger();
        TL1Operation oper = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile(neId);
            oper = definitions.getTL1Operation("RTRV-EQPT");
            ArrayList<Object> operationList = new ArrayList<Object>();
            InMsg input = oper.getInMsg();
            com.huawei.uflight.tl1.tl1operation.Part part = input.getPart("AID");
            String shelfSlotID = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neId, slotId);
            part.setValue("SLOT-" + shelfSlotID + "-ALL");
            operationList.add(oper.clone());
            int result = TETL1NECommMgr.getInstance().sendCommand((int)neId, operationList, (int)40).retCode;
            if (result != 0) {
                TELogFactory.getNormalLogger().info("query logic port fail,the errorCode is " + result);
                return logicPortList;
            }
            int m = operationList.size();
            for (int k = 0; k < m; ++k) {
                TL1Operation tempTL1Operation = (TL1Operation)operationList.get(k);
                int n = tempTL1Operation.getOutMsgCount();
                for (int l = 0; l < n; ++l) {
                    HashMap hm;
                    Part provType;
                    OutMsg output = tempTL1Operation.getOutMsg(l);
                    if (0 != output.getFault().getCompletionCode() || (provType = (Part)(hm = TETL1CommonUtil.getOutMsgPart(output)).get("PROVTYPE")) == null || provType.getValue() == null) continue;
                    Part AID2 = (Part)hm.get("slotID");
                    String[] str = TETL1CommonUtil.parseAID(AID2.getValue(), neId);
                    logicPortList.add(Integer.parseInt(str[3]));
                }
            }
        }
        catch (Exception e) {
            log.error("Parse TL1 description file fail!", (Throwable)e);
        }
        return logicPortList;
    }

    public static List<Integer> getQuerySubCPPortOperList(int neId, int slotId, int boardType) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT");
        if (null != oper) {
            int len = TECircuitPackDescription.getInstance().getSubCPNum(boardType);
            for (int i = 0; i < len; ++i) {
                oper.getInput().setPartValue("slotID", String.valueOf(slotId));
                oper.getInput().setPartValue("subCardId", String.valueOf(i + 1));
                oper.getInput().setPartValue("portID", "0");
                operationList.add((Operation)oper.clone());
            }
        }
        ArrayList<Integer> logicPortList = new ArrayList<Integer>();
        if (operationList.isEmpty()) {
            return logicPortList;
        }
        int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
        if (0 != result) {
            return logicPortList;
        }
        int m = operationList.size();
        for (int k = 0; k < m; ++k) {
            oper = (Operation)operationList.get(k);
            if (oper.getOutputCount() == 0 || !String.valueOf(0).equals(oper.getOutput(0).getFault(0).getCode())) continue;
            int len = oper.getOutputCount();
            for (int j = 0; j < len; ++j) {
                if (oper.getOutput(j).getPartValue("subCardId") == null) continue;
                int subCard = Integer.parseInt(oper.getOutput(j).getPartValue("subCardId"));
                int portid = Integer.parseInt(oper.getOutput(j).getPartValue("portID"));
                int subportid = TECircuitPackDescription.getInstance().convertSubCPNMPort(boardType, subCard, portid);
                logicPortList.add(subportid);
                int portType = -1;
                if (null != oper.getOutput(j).getPart("portType")) {
                    portType = Integer.parseInt(oper.getOutput(j).getPartValue("portType"));
                }
                int speedLevel = -1;
                if (null != oper.getOutput(j).getPart("speedLevel")) {
                    speedLevel = Integer.parseInt(oper.getOutput(j).getPartValue("speedLevel"));
                }
                TEConfigurationDataMgr.getInstance().addLogicPort(neId, slotId, subportid, portType, speedLevel);
            }
        }
        return logicPortList;
    }

    public static List<Operation> getQueryPortOperList(Operation oper, int neId, int slotId, List<Integer> portList) {
        Operation operWDM = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT_WDM");
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        int n = portList.size();
        for (int j = 0; j < n; ++j) {
            int portId = portList.get(j);
            Input input = oper.getInput();
            Part part = input.getPart("slotID");
            part.setValue(String.valueOf(slotId));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portId));
            operationList.add((Operation)oper.clone());
            if (operWDM == null) continue;
            input = operWDM.getInput();
            part = input.getPart("slotID");
            part.setValue(String.valueOf(slotId));
            part = input.getPart("portID");
            part.setValue(String.valueOf(portId));
            operationList.add((Operation)operWDM.clone());
        }
        return operationList;
    }

    private static List<Integer> getLogicPortForQx(int neId, int slotId, int boardType) {
        ArrayList<Integer> logicPortList = new ArrayList<Integer>();
        if (TEVirtualPortUtil.isMSOTNBoard(boardType)) {
            List<Integer> tempPorts = TEVirtualPortUtil.queryVPortsAndCache(neId, slotId);
            if (tempPorts != null) {
                logicPortList.addAll(tempPorts);
            }
            return logicPortList;
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int neVersion = TEConvertUtil.convertVerStrToInt(mgr.getNE(neId).getHostVersion());
        List<TECPAddiblePortRecord> addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
        HashSet<Integer> set = new HashSet<Integer>();
        TECPAddiblePortRecord addiblePortRecord = null;
        int m = addiblePortRecordList.size();
        for (int i = 0; i < m; ++i) {
            addiblePortRecord = addiblePortRecordList.get(i);
            if (!addiblePortRecord.isWithInRange(neVersion)) continue;
            set.add(addiblePortRecord.portID);
        }
        if (!set.isEmpty()) {
            ArrayList<Integer> phyList = new ArrayList<Integer>();
            phyList.addAll(set);
            Collections.sort(phyList);
            Operation oper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT");
            if (null == oper) {
                logicPortList.addAll(phyList);
                return logicPortList;
            }
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.addAll(TEQueryLogicPortForDataMgr.getQueryPortOperList(oper, neId, slotId, phyList));
            if (operationList.isEmpty()) {
                return logicPortList;
            }
            int faultCode = 1090650120;
            int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
            for (int count = 0; result != 0 && count < 3; ++count) {
                result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
            }
            int m2 = operationList.size();
            for (int k = 0; k < m2; ++k) {
                oper = (Operation)operationList.get(k);
                if (oper.getOutputCount() == 0) continue;
                Output output = oper.getOutput()[0];
                if (!"".equalsIgnoreCase(output.getFault()[0].getCode())) {
                    faultCode = Integer.parseInt(output.getFault()[0].getCode());
                }
                if (faultCode == 0) {
                    logicPortList.add(Integer.parseInt(output.getPartValue("portID")));
                    continue;
                }
                if (faultCode != 37898) continue;
                int n = phyList.size();
                for (int i = 0; i < n; ++i) {
                    int portId = (Integer)phyList.get(i);
                    logicPortList.add(portId);
                }
            }
        }
        return logicPortList;
    }
}

