/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TEQueryLogicPortForDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.util.device.port.TEVirtualPortUtil;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public final class TEQueryLogicPort {
    private static final int TEVC4LEVEL = 4;
    private static final String STM1_VC4 = "1";
    private static final String STM4_VC4 = "4";
    private static final int STM4 = 2;
    private static final int STM1 = 1;
    private static List<Integer> NEED_QUERY_PORTLEVEL = new ArrayList<Integer>();

    public static void queryExistLogicPort(int neId, int slotId, int boardType) {
        if (TEVirtualPortUtil.isMSOTNBoard(boardType)) {
            TEVirtualPortUtil.queryVPortsAndCache(neId, slotId);
            return;
        }
        if (TECircuitPackDescription.getInstance().isSupportSubCard(boardType)) {
            TEQueryLogicPortForDataMgr.getQuerySubCPPortOperList(neId, slotId, boardType);
        }
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int neVersion = TEConvertUtil.convertVerStrToInt(mgr.getNE(neId).getHostVersion());
        List<TECPAddiblePortRecord> addiblePortRecordList = TECircuitPackDescription.getInstance().getAddibleCPPort(boardType);
        Operation oper = null;
        oper = TESpecialAttrMgr.getInstance().isCPSupport(neId, slotId, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_PORTNAME_DBYTE") ? TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_SUBBD_GET_PORT") : TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT");
        Operation operWDM = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT_WDM");
        HashSet<Integer> set = new HashSet<Integer>();
        TECPAddiblePortRecord addiblePortRecord = null;
        int m = addiblePortRecordList.size();
        for (int i = 0; i < m; ++i) {
            addiblePortRecord = addiblePortRecordList.get(i);
            if (!addiblePortRecord.isWithInRange(neVersion)) continue;
            set.add(addiblePortRecord.portID);
        }
        if (!set.isEmpty()) {
            ArrayList<Integer> phyList = new ArrayList<Integer>();
            phyList.addAll(set);
            Collections.sort(phyList);
            if (null == oper) {
                TEQueryLogicPort.handleNotSupportBoard(neId, slotId, phyList);
                return;
            }
            ArrayList<Object> operationList = new ArrayList<Object>();
            int n = phyList.size();
            for (int j = 0; j < n; ++j) {
                int portId = (Integer)phyList.get(j);
                Input input = oper.getInput();
                Part part = input.getPart("slotID");
                if (part == null) {
                    part = input.getPart("slotid");
                }
                part.setValue(String.valueOf(slotId));
                part = input.getPart("portID");
                if (part == null) {
                    part = input.getPart("port");
                }
                part.setValue(String.valueOf(portId));
                operationList.add(oper.clone());
                if (operWDM == null) continue;
                input = operWDM.getInput();
                part = input.getPart("slotID");
                part.setValue(String.valueOf(slotId));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portId));
                operationList.add(operWDM.clone());
            }
            if (operationList.isEmpty()) {
                return;
            }
            int faultCode = 1090650120;
            int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
            for (int count = 0; result != 0 && count < 3; ++count) {
                result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
            }
            int m2 = operationList.size();
            for (int k = 0; k < m2; ++k) {
                oper = (Operation)operationList.get(k);
                if (oper.getOutputCount() == 0) continue;
                Output output = oper.getOutput()[0];
                if (!"".equalsIgnoreCase(output.getFault()[0].getCode())) {
                    faultCode = new Integer(output.getFault()[0].getCode());
                }
                if (faultCode == 0) {
                    String portid = output.getPartValue("portID");
                    if (portid == null) {
                        portid = output.getPartValue("port");
                    }
                    mgr.addLogicPort(neId, slotId, Integer.valueOf(portid), Integer.valueOf(output.getPart(output.getPartCount() - 2).getValue()), Integer.valueOf(output.getPart(output.getPartCount() - 1).getValue()));
                    continue;
                }
                if (faultCode != 37898) continue;
                int n2 = phyList.size();
                for (int i = 0; i < n2; ++i) {
                    int portId = (Integer)phyList.get(i);
                    mgr.addLogicPort(neId, slotId, portId);
                }
            }
        }
    }

    private static void handleNotSupportBoard(int neId, int slotId, ArrayList phyList) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        if (mgr.getLogicPortList(neId, slotId).isEmpty()) {
            int m = phyList.size();
            for (int i = 0; i < m; ++i) {
                int portId = (Integer)phyList.get(i);
                mgr.addLogicPort(neId, slotId, portId);
            }
        }
    }

    public static ArrayList getLogicPortList(int neId, int slotId, int boardType) {
        return TEQueryLogicPort.getLogicPortList(neId, slotId, boardType, false);
    }

    public static ArrayList getLogicPortList(int neId, int slotId, int boardType, boolean isSdhPort) {
        ArrayList<Object> logicPortList = new ArrayList<Object>();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        boolean isDynBD = mgr.isDynPortBoardType(neId, boardType);
        ArrayList portList = mgr.getLogicPortList(neId, slotId);
        ArrayList allPortPropertyList = mgr.getBoardPortPropertyList(neId, boardType);
        int size = allPortPropertyList.size();
        for (int i = 0; i < size; ++i) {
            TEPortProperty portProperty = (TEPortProperty)allPortPropertyList.get(i);
            int portId = portProperty.getPortNo();
            if (isDynBD && !portList.contains(portId)) continue;
            if (isSdhPort) {
                ArrayList fbList = portProperty.getFunBlockPropertyList();
                String vc4ListStr = "";
                int len = fbList.size();
                for (int j = 0; j < len; ++j) {
                    TEFunBlockProperty tempFB = (TEFunBlockProperty)fbList.get(j);
                    if (4 != tempFB.getFuctionBlockType()) continue;
                    ArrayList vc4List = tempFB.getFunctionBlockNoList();
                    vc4ListStr = String.valueOf(vc4List.size());
                    break;
                }
                if (NEED_QUERY_PORTLEVEL.contains(boardType)) {
                    int level = TEConfigurationDataMgr.getInstance().getLogicalPortSpeed(neId, slotId, portId);
                    vc4ListStr = STM4_VC4;
                    if (level == 2) {
                        vc4ListStr = STM4_VC4;
                    } else if (level == 1) {
                        vc4ListStr = STM1_VC4;
                    }
                }
                if ("".equals(vc4ListStr)) continue;
                String port = portId + "-" + vc4ListStr;
                logicPortList.add(port);
                continue;
            }
            if (logicPortList.contains(portId)) continue;
            logicPortList.add(portId);
        }
        return logicPortList;
    }

    public static ArrayList getLogicPortList(int neId, int slotId) {
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neId, slotId);
        return TEQueryLogicPort.getLogicPortList(neId, slotId, boardType);
    }

    static {
        NEED_QUERY_PORTLEVEL.add(2264);
    }
}

