/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEIFboard;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import org.slf4j.Logger;

public final class TEQueryIFMode {
    private static final int PARAM_IFPORT = 0;
    private static final int QXEXEC_TIMEOUT = 10;
    private static final int ERROR_WORKMODE = 0;
    private static final int IFMODE_SDH_MODE = 7;
    private static final int IFMODE_PDH_MODE1_START = 1;
    private static final int IFMODE_PDH_MODE1_END = 4;
    private static final int IFMODE_PDH_MODE1 = 1;
    private static final int IFMODE_PDH_MODE2_START = 5;
    private static final int IFMODE_PDH_MODE2_END = 6;
    private static final int IFMODE_PDH_MODE2 = 2;
    private static final int IFMODE_PDH_MODE3_START = 8;
    private static final int IFMODE_PDH_MODE3_END = 15;
    private static final int IFMODE_PDH_MODE3 = 3;

    public static ArrayList queryIFWorkMode(int neid, ArrayList slotidList) {
        int slotid;
        Logger log = TELogFactory.getNormalLogger();
        if (slotidList == null) {
            log.error("slot input List box is null!");
            return null;
        }
        ArrayList<TEIFboard> workModeList = new ArrayList<TEIFboard>();
        ArrayList<Integer> IFboardList = new ArrayList<Integer>();
        ArrayList<Operation> OperationList = new ArrayList<Operation>();
        int isize = slotidList.size();
        for (int i = 0; i < isize; ++i) {
            slotid = (Integer)slotidList.get(i);
            TEBoard tboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
            if (tboard == null || !TEConfigurationDataMgr.getInstance().isIFboard(tboard.getBoardType())) continue;
            IFboardList.add(slotid);
        }
        if (IFboardList.isEmpty()) {
            return workModeList;
        }
        int ksize = IFboardList.size();
        for (int k = 0; k < ksize; ++k) {
            slotid = (Integer)IFboardList.get(k);
            Operation oper = TECreateObjectFactory.getOperation(neid, "NSCMD_CFG_GET_RADIO_IFMODE");
            oper.getInput().setPartValue("slotid", String.valueOf(slotid));
            oper.getInput().setPartValue("port", String.valueOf(0));
            OperationList.add(oper);
        }
        int result = TENECommMgr.getInstance().sendCommand((int)neid, OperationList, (int)10).retCode;
        if (result == 0) {
            int ksize2 = OperationList.size();
            for (int k = 0; k < ksize2; ++k) {
                Operation optemp = (Operation)OperationList.get(k);
                Output[] output = optemp.getOutput();
                int kisize = output.length;
                for (int ki = 0; ki < kisize; ++ki) {
                    Fault fault;
                    Fault[] faultArr = output[ki].getFault();
                    int code = -1;
                    int len2 = faultArr.length;
                    for (int j = 0; j < len2 && (code = Integer.parseInt((fault = faultArr[j]).getCode())) == 0; ++j) {
                    }
                    if (code != 0) continue;
                    int slotid2 = Integer.parseInt(output[ki].getPartValue("slotid"));
                    int portid = Integer.parseInt(output[ki].getPartValue("port"));
                    int ifMode = Integer.parseInt(output[ki].getPartValue("W32PORT_ATTR_RADIOWORKMODE"));
                    TEIFboard ifboard = new TEIFboard(neid, slotid2, portid, ifMode);
                    workModeList.add(ifboard);
                }
            }
        }
        return workModeList;
    }

    public static int queryIFWorkMode(int neid, int slotid, int port) {
        Logger log = TELogFactory.getNormalLogger();
        TEBoard tboard = TEConfigurationDataMgr.getInstance().getBoard(neid, slotid);
        if (!TEConfigurationDataMgr.getInstance().isIFboard(tboard.getBoardType())) {
            return 0;
        }
        ArrayList<Operation> OperationList = new ArrayList<Operation>();
        Operation oper = null;
        try {
            oper = TECreateObjectFactory.getOperation(neid, "NSCMD_CFG_GET_RADIO_IFMODE");
            if (oper == null) {
                return 0;
            }
        }
        catch (Exception e) {
            log.error("query IF board working mode,(neid,slot,port) Parse Qx description file fail!", (Throwable)e);
            return 0;
        }
        oper.getInput().setPartValue("slotid", String.valueOf(slotid));
        oper.getInput().setPartValue("port", String.valueOf(port));
        OperationList.add(oper);
        int result = TENECommMgr.getInstance().sendCommand((int)neid, OperationList, (int)10).retCode;
        if (result == 0) {
            Output[] output = ((Operation)OperationList.get(0)).getOutput();
            int kisize = output.length;
            for (int ki = 0; ki < kisize; ++ki) {
                Fault fault;
                Fault[] faultArr = output[ki].getFault();
                int code = -1;
                int len2 = faultArr.length;
                for (int j = 0; j < len2 && (code = Integer.parseInt((fault = faultArr[j]).getCode())) == 0; ++j) {
                }
                if (code != 0) continue;
                int ifMode = Integer.parseInt(output[ki].getPartValue("W32PORT_ATTR_RADIOWORKMODE"));
                return ifMode;
            }
        }
        return 0;
    }

    public static boolean isSDHMode(int neid, int slotid, int port) {
        int ifmode = TEQueryIFMode.queryIFWorkMode(neid, slotid, port);
        return ifmode == 7;
    }

    public static boolean isPDHMode(int neid, int slotid, int port) {
        int ifmode = TEQueryIFMode.queryIFWorkMode(neid, slotid, port);
        return ifmode > 0 && TEConfigurationDataMgr.getInstance().isSDHLineBoard(neid, slotid) && ifmode != 7;
    }

    public static int getPDHMode(int neid, int slotid, int port) {
        int pdhMode = 0;
        int ifmode = TEQueryIFMode.queryIFWorkMode(neid, slotid, port);
        if (ifmode > 0 && TEConfigurationDataMgr.getInstance().isSDHLineBoard(neid, slotid)) {
            if (ifmode >= 1 && ifmode <= 4) {
                pdhMode = 1;
            } else if (ifmode >= 5 && ifmode <= 6) {
                pdhMode = 2;
            } else if (ifmode >= 8 && ifmode <= 15) {
                pdhMode = 3;
            }
        }
        return pdhMode;
    }
}

