/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.mo.TEDynCpKey;
import com.huawei.nglct.mo.TEDynMapKey;
import com.huawei.nglct.mo.TEPortDynSn;
import com.huawei.nglct.mo.TEPortDynSnSubFB;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOByID;
import com.huawei.nglct.nelist.model.circuitpack.TESDInstallPortKey;
import com.huawei.nglct.nelist.model.circuitpack.TESDPortRecord;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TEPortDescription {
    public static final int DOMAIN_INVALID = 255;
    public static final int IL_INVALID = 255;
    public static final int FB_INVALID = 255;
    private HashMap portMap = new HashMap();
    private HashMap outPortMap = new HashMap();
    private HashMap coantainMOMap = new HashMap();
    private Map<Integer, Integer> m_PortTpyeAndPortMode = new ConcurrentHashMap<Integer, Integer>();
    private Map<TEDynMapKey, TEPortDynSn> m_InnerPortDynSnMap = new ConcurrentHashMap<TEDynMapKey, TEPortDynSn>();
    private Map<TEPortDynSnSubFB, Map<Integer, Boolean>> m_DynPortMap = new ConcurrentHashMap<TEPortDynSnSubFB, Map<Integer, Boolean>>();
    private Map<TEDynCpKey, Map<Integer, Boolean>> m_DynCpMap = new ConcurrentHashMap<TEDynCpKey, Map<Integer, Boolean>>();
    private static TEPortDescription instance = null;

    private TEPortDescription() {
        Collections.synchronizedMap(this.portMap);
        Collections.synchronizedMap(this.outPortMap);
        Collections.synchronizedMap(this.coantainMOMap);
    }

    public static synchronized TEPortDescription getInstance() {
        if (null == instance) {
            instance = new TEPortDescription();
        }
        return instance;
    }

    public HashMap getPortRecord() {
        return this.portMap;
    }

    public HashMap getPortContainMORecord() {
        return this.coantainMOMap;
    }

    public boolean isValidPortType(int portType) {
        return this.portMap.containsKey(portType);
    }

    public boolean isNameUpdable(int portType) {
        TESDPortRecord record = (TESDPortRecord)this.portMap.get(portType);
        if (null != record) {
            return record.bNameUpdable;
        }
        return false;
    }

    public boolean isVisible(int portType) {
        if (this.portMap.containsKey(portType)) {
            TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(portType);
            return portRecord.bVisible;
        }
        return false;
    }

    public ArrayList getNameUpdatableList() {
        ArrayList<Integer> portList = new ArrayList<Integer>();
        for (Map.Entry set : this.portMap.entrySet()) {
            TESDPortRecord portRecord = (TESDPortRecord)set.getValue();
            if (!portRecord.bNameUpdable) continue;
            portList.add(portRecord.portType);
        }
        return portList;
    }

    public boolean isInnerPortType(int innerType, int[] outerType) {
        outerType[0] = innerType;
        if (this.portMap.containsKey(innerType)) {
            TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(innerType);
            if (portRecord.portType != portRecord.outPortType) {
                outerType[0] = portRecord.outPortType;
                return true;
            }
        }
        return false;
    }

    public String getPortMOClassName(int portType) {
        TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(portType);
        if (null != portRecord) {
            return portRecord.moClassName;
        }
        return "UNKNOWN";
    }

    public ArrayList getPortLevelList(int portType) {
        TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(portType);
        if (null != portRecord) {
            return portRecord.levelList;
        }
        return null;
    }

    public String getTypeName(int portType) {
        TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(portType);
        if (null != portRecord) {
            return portRecord.portTypeName;
        }
        return "UNKNOWN";
    }

    public int getPortDomain(int portType) {
        TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(portType);
        if (null != portRecord) {
            return portRecord.domainType;
        }
        return 255;
    }

    public ArrayList getPortConainMO(int portType, int level) {
        TESDInstallPortKey portKey = new TESDInstallPortKey(portType, level);
        if (this.coantainMOMap.containsKey(portKey)) {
            return (ArrayList)this.coantainMOMap.get(portKey);
        }
        return new ArrayList();
    }

    public int getPortConainMOSize(int portType, int level) {
        TESDInstallPortKey portKey = new TESDInstallPortKey(portType, level);
        ArrayList conainMOList = (ArrayList)this.coantainMOMap.get(portKey);
        if (null != conainMOList) {
            return conainMOList.size();
        }
        return 0;
    }

    public int getPortContainMONumByName(int portType, int level, String moName) {
        TESDInstallPortKey portKey = new TESDInstallPortKey(portType, level);
        ArrayList conainMOList = (ArrayList)this.coantainMOMap.get(portKey);
        TEFuncBlockDescription desc = TEFuncBlockDescription.getInstance();
        int size = conainMOList.size();
        for (int i = 0; i < size; ++i) {
            TESDContianMOByID containMOByID = (TESDContianMOByID)conainMOList.get(i);
            String str = desc.getFBClassName(containMOByID.fbType);
            if (!str.equals(moName)) continue;
            return containMOByID.idList.size();
        }
        return 0;
    }

    public int getPortContainMONumByType(int portType, int level, int fbType) {
        TESDInstallPortKey portKey = new TESDInstallPortKey(portType, level);
        ArrayList conainMOList = (ArrayList)this.coantainMOMap.get(portKey);
        int size = conainMOList.size();
        for (int i = 0; i < size; ++i) {
            TESDContianMOByID containMOByID = (TESDContianMOByID)conainMOList.get(i);
            if (fbType != containMOByID.fbType) continue;
            return containMOByID.idList.size();
        }
        return 0;
    }

    public HashMap getAllPort() {
        int[] tmpType = new int[1];
        for (Map.Entry set : this.portMap.entrySet()) {
            TESDPortRecord portRecord = (TESDPortRecord)set.getValue();
            if (!this.isInnerPortType(portRecord.portType, tmpType)) continue;
            this.outPortMap.put(portRecord.portType, portRecord.portTypeName);
        }
        return this.outPortMap;
    }

    public ArrayList getPortFBList(int portType, int level, boolean bAll) {
        ArrayList<Integer> portFBList = new ArrayList<Integer>();
        TESDPortRecord portRecord = (TESDPortRecord)this.portMap.get(portType);
        if (null != portRecord && bAll) {
            portFBList.addAll(portRecord.containFBList);
        }
        if (bAll) {
            ArrayList recordList = null;
            if (255 != level) {
                recordList = this.getPortConainMO(portType, level);
            } else {
                recordList = new ArrayList();
                Set entries = this.coantainMOMap.keySet();
                for (TESDInstallPortKey portKey : entries) {
                    if (portType != portKey.portType) continue;
                    ArrayList containMOList = (ArrayList)this.coantainMOMap.get(portKey);
                    recordList.addAll(containMOList);
                }
            }
            if (null == recordList) {
                return portFBList;
            }
            int idListSize = recordList.size();
            for (int i = 0; i < idListSize; ++i) {
                TESDContianMOByID contianMOByID = (TESDContianMOByID)recordList.get(i);
                int fbType = contianMOByID.fbType;
                if (fbType == 255 || portFBList.contains(fbType = TEFuncBlockDescription.getInstance().getOuterFBType(fbType))) continue;
                portFBList.add(fbType);
            }
        }
        return portFBList;
    }

    public void getPortFBAllSubFBType(int portType, int iSubFBGroup, int iLevel, Map<Integer, TIntArrayList> subfbvecmap) {
        TEFuncBlockDescription pFBDes = TEFuncBlockDescription.getInstance();
        TEDynMapKey key = null;
        TEPortDynSn sn = null;
        Map.Entry<TEDynMapKey, TEPortDynSn> entry2 = null;
        for (Map.Entry<TEDynMapKey, TEPortDynSn> entry2 : this.m_InnerPortDynSnMap.entrySet()) {
            key = entry2.getKey();
            sn = entry2.getValue();
            if (key.m_PortType != portType || key.m_InterfaceLevel != iLevel) continue;
            HashMap<Integer, Boolean> fbMap = new HashMap<Integer, Boolean>();
            this.getPortMOEnable(portType, iSubFBGroup, sn.m_PortDynSn, fbMap);
            Map.Entry entry12 = null;
            for (Map.Entry entry12 : fbMap.entrySet()) {
                int fbType = pFBDes.getOuterFBType((Integer)entry12.getKey());
                if (fbType == (Integer)entry12.getKey() || !((Boolean)entry12.getValue()).booleanValue()) continue;
                if (subfbvecmap.containsKey(fbType)) {
                    subfbvecmap.get(fbType).add(((Integer)entry12.getKey()).intValue());
                    continue;
                }
                TIntArrayList list = new TIntArrayList();
                list.add(((Integer)entry12.getKey()).intValue());
                subfbvecmap.put(fbType, list);
            }
        }
    }

    public void addPortRecord(int portType, int domainType, String portTypeName, String moClassName, ArrayList levelList, boolean bVisible, boolean bNameUpdable) {
        TESDPortRecord portRecord = new TESDPortRecord(portType, portType, domainType, portTypeName, moClassName, levelList, bVisible, bNameUpdable);
        this.portMap.put(portType, portRecord);
    }

    public void addPortMOCount(int portType, int level, int fbType, int moCount) {
        TESDContianMOByID record = new TESDContianMOByID(fbType);
        for (int id = 1; id <= moCount; ++id) {
            record.idList.add(id);
        }
        TESDInstallPortKey portKey = new TESDInstallPortKey(portType, level);
        if (this.coantainMOMap.containsKey(portKey)) {
            ArrayList recordList = (ArrayList)this.coantainMOMap.get(portKey);
            recordList.add(record);
        } else {
            ArrayList<TESDContianMOByID> recordList = new ArrayList<TESDContianMOByID>();
            recordList.add(record);
            this.coantainMOMap.put(portKey, recordList);
        }
    }

    public void addPortMOIDs(int portType, int level, int fbType, ArrayList idList) {
        TESDContianMOByID record = new TESDContianMOByID(fbType);
        record.setIdList(idList);
        TESDInstallPortKey portKey = new TESDInstallPortKey(portType, level);
        if (this.coantainMOMap.containsKey(portKey)) {
            ArrayList recordList = (ArrayList)this.coantainMOMap.get(portKey);
            recordList.add(record);
        } else {
            ArrayList<TESDContianMOByID> recordList = new ArrayList<TESDContianMOByID>();
            recordList.add(record);
            this.coantainMOMap.put(portKey, recordList);
        }
    }

    public void addPortRecord(int innerType, int outerType, int domainType, String portTypeName, String moClassName, ArrayList levelList, boolean bVisible, boolean bNameUpdable) {
        TESDPortRecord record = new TESDPortRecord(innerType, outerType, domainType, portTypeName, moClassName, levelList, bVisible, bNameUpdable);
        this.portMap.put(innerType, record);
    }

    public void addPortRecord(TESDPortRecord record) {
        this.portMap.put(record.portType, record);
    }

    public void addDynPortMoEnable(TEPortDynSn portdynsn, int iSubFBGroup, int fbType, boolean bMo_Enable) {
        Map<Object, Object> m_MoMap = null;
        TEPortDynSnSubFB subfb = new TEPortDynSnSubFB(portdynsn, iSubFBGroup);
        if (this.m_DynPortMap.containsKey(subfb)) {
            m_MoMap = this.m_DynPortMap.get(subfb);
            m_MoMap.put(fbType, bMo_Enable);
        } else {
            m_MoMap = new HashMap<Integer, Boolean>();
            m_MoMap.put(fbType, bMo_Enable);
            this.m_DynPortMap.put(subfb, m_MoMap);
        }
    }

    public void addDynCpMoEnable(TEDynCpKey dynCpKey, Map<Integer, Boolean> moMap) {
        this.m_DynCpMap.put(dynCpKey, moMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynPortDynSn(TEDynMapKey dynMapKey, TEPortDynSn portdynsn) {
        Map<TEDynMapKey, TEPortDynSn> map = this.m_InnerPortDynSnMap;
        synchronized (map) {
            this.m_InnerPortDynSnMap.put(dynMapKey, portdynsn);
        }
    }

    public void addPortTypeAndMode(int portType, int portMode) {
        this.m_PortTpyeAndPortMode.put(portType, portMode);
    }

    public int getPortMOEnable(int pPortType, int iSunFBGroup, int iPortDynSn, Map<Integer, Boolean> moMap) {
        TEPortDynSnSubFB fb = new TEPortDynSnSubFB(pPortType, iPortDynSn, iSunFBGroup);
        if (this.m_DynPortMap.containsKey(fb)) {
            moMap.putAll(this.m_DynPortMap.get(fb));
            return 0;
        }
        fb = new TEPortDynSnSubFB(pPortType, iPortDynSn, 0);
        if (this.m_DynPortMap.containsKey(fb)) {
            moMap.putAll(this.m_DynPortMap.get(fb));
            return 0;
        }
        return 1090592823;
    }
}

