/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;

public class TEPort
implements Comparable,
Cloneable {
    private static final int HASHCODE_MULTIPLIEDVALUE = 37;
    private static final int HASHCODE_INITVALUE = 17;
    private static final int VALUE_0XFF = 255;
    private int neID = -1;
    private int slotID = -1;
    private int boardType = -1;
    private int portNo = -1;
    private int portType = -1;
    private int portAddibleType = -1;
    private int level = -1;
    private String portName = null;
    private volatile int hashCode = 0;
    private String innerPortName;
    private String outPortName;
    private long portMode = -1L;
    private int portDomainType = -1;

    public TEPort() {
    }

    public TEPort(int portType, int level, int portNo, String portName, String innerPortName, String outPortName) {
        this.portType = portType;
        this.level = level;
        this.portNo = portNo;
        this.portName = portName;
        this.innerPortName = innerPortName;
        this.outPortName = outPortName;
    }

    public TEPort(int iNEID, int iSlotID, int iBoardType, int iPortID, int iPortType, int iPortSpeed) {
        this.neID = iNEID;
        this.slotID = iSlotID;
        this.boardType = iBoardType;
        this.portNo = iPortID;
        this.portType = iPortType;
        this.level = iPortSpeed;
    }

    public TEPort(int iNEID, int iSlotID, int iBoardType, int iPortID) {
        this.neID = iNEID;
        this.slotID = iSlotID;
        this.boardType = iBoardType;
        this.portNo = iPortID;
    }

    public TEPort(int iNEID, int iSlotID, int iPortID, int iPortType, int iPortSpeed) {
        this.neID = iNEID;
        this.slotID = iSlotID;
        this.portNo = iPortID;
        this.portType = iPortType;
        this.level = iPortSpeed;
    }

    public int getNEID() {
        return this.neID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public int getBoardType() {
        return this.boardType;
    }

    public void setPortNo(int portNo) {
        this.portNo = portNo;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setOutPortName(String outPortName) {
        this.outPortName = outPortName;
    }

    public void setInnerPortName(String innerPortName) {
        this.innerPortName = innerPortName;
    }

    public void setPortType(int portType) {
        this.portType = portType;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setPortAddibleType(int iPortAddibleType) {
        this.portAddibleType = iPortAddibleType;
    }

    public int getPortNo() {
        return this.portNo;
    }

    public String getPortName() {
        return this.portName;
    }

    public String getOutPortName() {
        return this.outPortName;
    }

    public String getInnerPortName() {
        return this.innerPortName;
    }

    public int getPortType() {
        return this.portType;
    }

    public int getLevel() {
        return this.level;
    }

    public long getPortMode() {
        return this.portMode;
    }

    public void setPortMode(long portMode) {
        this.portMode = portMode;
    }

    public int getPortAddibleType() {
        return this.portAddibleType;
    }

    public boolean isOpticalPort() {
        return (this.portAddibleType & 0xFF) == 1;
    }

    public boolean isElectricPort() {
        return (this.portAddibleType & 0xFF) == 0;
    }

    public int getPortDomainType() {
        return this.portDomainType;
    }

    public void setPortDomainType(int portDomainType) {
        this.portDomainType = portDomainType;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = result * 37 + this.neID;
            result = result * 37 + this.slotID;
            result = result * 37 + this.boardType;
            result = result * 37 + this.portType;
            result = result * 37 + this.portNo;
            this.hashCode = result = result * 37 + this.level;
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TEPort)) {
            return false;
        }
        TEPort comparePort = (TEPort)obj;
        return comparePort.getNEID() == this.neID && comparePort.getSlotID() == this.slotID && comparePort.getBoardType() == this.boardType && comparePort.getPortType() == this.portType && comparePort.getPortNo() == this.portNo && comparePort.getLevel() == this.level;
    }

    public int compareTo(Object obj) {
        TEPort comparePort;
        try {
            comparePort = (TEPort)obj;
        }
        catch (ClassCastException ex) {
            TELogFactory.getNormalLogger().error("TEPort.compareTo() fail!", (Throwable)ex);
            return 1;
        }
        if (comparePort == null) {
            return 1;
        }
        int neidDiff = this.neID - comparePort.getNEID();
        if (neidDiff != 0) {
            return neidDiff;
        }
        int slotidDiff = this.slotID - comparePort.getSlotID();
        if (slotidDiff != 0) {
            return slotidDiff;
        }
        return this.portNo - comparePort.getPortNo();
    }

    public int compare(Object obj) {
        TEPort comparePort;
        try {
            comparePort = (TEPort)obj;
        }
        catch (ClassCastException ex) {
            TELogFactory.getNormalLogger().error("TEPort.compare() fail!", (Throwable)ex);
            return 1;
        }
        if (comparePort == null) {
            return 1;
        }
        int neidDiff = this.neID - comparePort.getNEID();
        if (neidDiff != 0) {
            return neidDiff;
        }
        int slotidDiff = this.slotID - comparePort.getSlotID();
        if (slotidDiff != 0) {
            return slotidDiff;
        }
        return this.portNo - comparePort.getPortNo();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    public String toString() {
        if (this.getPortName() != null) {
            return this.getPortName();
        }
        return this.slotID + "-" + this.portNo;
    }
}

