/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPerformanceDataMgr;
import com.huawei.nglct.nelist.model.performance.TEPerformModel;
import com.huawei.nglct.nelist.model.performance.TEPfmBsEvent;
import com.huawei.nglct.nelist.model.performance.TEPfmBsFBObj;
import com.huawei.nglct.nelist.model.performance.TEPfmEventsDataLoader;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class TEPfmUtility {
    public static final String DELIMITER = "-";
    public static final int TE_PERF_FLOAT = 6;
    public static final int QUERY_THRSHPFM = 1;
    public static final int VC12_PATH_OFFSET = 65536;

    public static TEPerformModel getPfmModel(int neid, int slotid) {
        TENE ne = TENEListMgr.getInstance().getNE(neid);
        TEBoard board = ne.getBoard(slotid);
        if (null == board) {
            return null;
        }
        try {
            TEPerformModel model = TEPerformanceDataMgr.getInstance().getPerformModel(board.getBoardType());
            model.setNEID(neid);
            return model;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ArrayList getTokensFromStr(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(str, DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            arrayList.add(tokenizer.nextToken());
        }
        return arrayList;
    }

    public static HashMap getTokenListFromStr(String str) {
        if (null == str || str.length() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(str, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            ArrayList tmp = TEPfmUtility.getTokensFromStr(token);
            if (null == tmp || tmp.size() != 2) continue;
            String key = (String)tmp.get(0);
            String value = (String)tmp.get(1);
            map.put(key, value);
        }
        return map;
    }

    public static String getStringFromSequenceOfInt(ArrayList src) {
        if (src != null) {
            StringBuffer result = new StringBuffer();
            int size = src.size();
            for (int i = 0; i < size; ++i) {
                result.append((Integer)src.get(i));
                if (i == size - 1) continue;
                result.append(DELIMITER);
            }
            return result.toString();
        }
        return "";
    }

    public static TEPfmBsEvent getPfmBsEvent(int neid, int slotid, int peid) {
        return TEPfmEventsDataLoader.getInstance().getPfmBsEvent(neid, peid);
    }

    public static int pfmEid2Qx5Eid(int neid, int slotid, int nmEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return nmEid;
        }
        int neEid = model.getNEEvent(nmEid);
        if (neEid > 4096) {
            return neEid;
        }
        return neEid & 0xFF;
    }

    public static int pfmEid2Qx5Eid(int neid, int slotid, int portid, int pathid, int nmEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return nmEid;
        }
        int neEid = model.getNEEvent(portid, pathid, nmEid);
        if (neEid > 4096) {
            return neEid;
        }
        return neEid & 0xFF;
    }

    public static int qx5Eid2PfmEid(int neid, int slotid, int neEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return neEid;
        }
        if (!model.getCpEventFBs().isEmpty()) {
            return neEid;
        }
        int nmEid = model.getNMEventID(neEid);
        int size = model.getEventList().size();
        for (int i = 0; i < size; ++i) {
            Integer tmp = (Integer)model.getEventList().get(i);
            if (tmp != nmEid) continue;
            return nmEid;
        }
        return neEid;
    }

    public static int qx5Eid2PfmEid(int neid, int slotid, int portid, int pathid, int neEid) {
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (null == model) {
            return neEid;
        }
        if (!model.getCpEventFBs().isEmpty()) {
            return neEid;
        }
        int nmEid = model.getNMEventID(portid, pathid, neEid);
        int size = model.getEventList().size();
        for (int i = 0; i < size; ++i) {
            Integer tmp = (Integer)model.getEventList().get(i);
            if (tmp != nmEid) continue;
            return nmEid;
        }
        return neEid;
    }

    public static long pfmValue2Qx5Value(int neid, int slotid, double pfmValue, int peid) {
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (event != null && event.m_dUnit == 0.1) {
            return (long)(pfmValue * 10.0);
        }
        return (long)pfmValue;
    }

    public static double qx5Value2PfmValue(int neid, int slotid, int qx5Value, int peid) {
        double pfmValue = 0.0;
        if (qx5Value == Integer.MAX_VALUE) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (null == event) {
            return -1.0;
        }
        pfmValue = event.isCounter() ? (double)qx5Value : (double)qx5Value * event.m_dUnit;
        return pfmValue;
    }

    public static double qx5Value2PfmValue(int neid, int slotid, long qx5Value, int peid) {
        double pfmValue = 0.0;
        if (qx5Value == Integer.MAX_VALUE) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (null == event) {
            return -1.0;
        }
        if (event.isCounter()) {
            if (6.0 == event.m_dUnit) {
                long expMUM = qx5Value & 0xFFFFL;
                long tmpValue = qx5Value;
                double baseNUM = (double)(tmpValue >>= 16) / 100.0;
                pfmValue = baseNUM * Math.pow(10.0, expMUM * -1L);
                pfmValue = new BigDecimal(pfmValue, new MathContext(4)).doubleValue();
            } else {
                pfmValue = qx5Value;
            }
        } else {
            pfmValue = (double)qx5Value * event.m_dUnit;
        }
        return pfmValue;
    }

    public static double qx5ValuePfmValue(int neid, double qx5Value, int peid) {
        double pfmValue = 0.0;
        if (peid == 0) {
            return -1.0;
        }
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, 255, peid);
        if (null == event) {
            return -1.0;
        }
        pfmValue = event.isCounter() ? qx5Value : qx5Value * event.m_dUnit;
        return pfmValue;
    }

    public static double qxValuePfmValue(int neid, int slotid, double qx5Value, int peid) {
        if (qx5Value == 2.147483647E9) {
            return -1.0;
        }
        if (peid == 0) {
            return -1.0;
        }
        if (slotid == 0) {
            return -1.0;
        }
        TEPfmBsEvent event = TEPfmUtility.getPfmBsEvent(neid, slotid, peid);
        if (event.m_dUnit == 0.1) {
            return qx5Value * event.m_dUnit;
        }
        return qx5Value;
    }

    public static Operation getOperation(int neid, String qxDes) {
        return TECreateObjectFactory.getOperation(neid, qxDes);
    }

    public static Operation getOperation(int neid, int cmdCode) {
        return TECreateObjectFactory.getOperation(neid, cmdCode);
    }

    public static boolean validatePart(Part part, String name) {
        return part.getName().equalsIgnoreCase(name) && part.getValue() != null;
    }

    public static boolean validateParam(Param param, String name) {
        return param.getName().equalsIgnoreCase(name) && param.getValue().length() > 0;
    }

    private static List<Integer> getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(0);
        errorCodeList.add(38410);
        errorCodeList.add(38416);
        errorCodeList.add(42308);
        errorCodeList.add(38777);
        errorCodeList.add(41761);
        errorCodeList.add(38722);
        errorCodeList.add(38748);
        return errorCodeList;
    }

    public static boolean handleRowError(RowParams rowparams, Output output, TEPfmMonObjID pfmmonobj) {
        String errorCode = "";
        String errorinfo = "";
        boolean row_succ = false;
        int faultlen = output.getFaultCount();
        for (int i = 0; i < faultlen; ++i) {
            errorCode = output.getFault(i).getCode();
            if (null == errorCode) continue;
            errorinfo = output.getFault(i).getValue();
            if (null == errorinfo) {
                errorinfo = "";
            }
            if (TEPfmUtility.getFilterErrorCodeList().contains(Integer.parseInt(errorCode))) {
                row_succ = true;
                continue;
            }
            RowErrors rowError = new RowErrors();
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setErrorcode(errorCode);
            if (!errorCode.equals("") && errorinfo.equals("")) {
                errorMessage.setErrorinfo(TEErrorResourceUtil.getErrCodeResWithDot(Integer.parseInt(errorCode)));
            } else {
                errorMessage.setErrorinfo(errorinfo);
            }
            rowError.setErrorMessage(errorMessage);
            if (pfmmonobj != null) {
                Param rowObj = new Param();
                rowObj.setName("monObj");
                rowObj.setValue(pfmmonobj.toString());
                rowError.addParam(rowObj);
            }
            rowparams.addRowErrors(rowError);
        }
        return row_succ;
    }

    public static boolean handleRowError(int neid, RowParams rowparams, Output output, Input input) {
        return TEPfmUtility.handleRowError(rowparams, output, TEPfmUtility.getPfmMonObjFromInput(neid, input));
    }

    private static TEPfmMonObjID getPfmMonObjFromInput(int neid, Input input) {
        Part[] partArr = input.getPart();
        TEPfmMonObjID pfmmonobj = new TEPfmMonObjID();
        pfmmonobj.m_ulNEID = neid;
        int len2 = partArr.length;
        for (int k = 0; k < len2; ++k) {
            if (TEPfmUtility.validatePart(partArr[k], "slotID")) {
                pfmmonobj.m_usSlotID = Integer.parseInt(partArr[k].getValue());
                continue;
            }
            if (TEPfmUtility.validatePart(partArr[k], "portID")) {
                pfmmonobj.m_usPortID = Integer.parseInt(partArr[k].getValue());
                continue;
            }
            if (!TEPfmUtility.validatePart(partArr[k], "pathID")) continue;
            pfmmonobj.m_usPathID = Integer.parseInt(partArr[k].getValue());
        }
        pfmmonobj.decPathID();
        return pfmmonobj;
    }

    public static boolean faultFilter(Output output) {
        boolean isFilter = false;
        for (int i = 0; i < output.getFaultCount(); ++i) {
            if ((!output.getFault(i).getCode().equals("0") || output.getPartCount() != 0) && !output.getFault(i).getCode().equals("42310") && !output.getFault(i).getCode().equals("38429") && !output.getFault(i).getCode().equals("38410") && !output.getFault(i).getCode().equals("46587") && !output.getFault(i).getCode().equals("38662") && !output.getFault(i).getCode().equals("42297") && !output.getFault(i).getCode().equals("38671") && !output.getFault(i).getCode().equals("38737") && !output.getFault(i).getCode().equals("40004") && !output.getFault(i).getCode().equals("38666")) continue;
            isFilter = true;
            break;
        }
        return isFilter;
    }

    public static Map filterOperation(List operList) {
        ArrayList redundantList = new ArrayList();
        HashMap map = new HashMap();
        for (int i = 0; i < operList.size() - 1; ++i) {
            Operation operI = (Operation)operList.get(i);
            if (redundantList.contains(operI)) continue;
            ArrayList<Operation> tempList = new ArrayList<Operation>();
            for (int j = i + 1; j < operList.size(); ++j) {
                Operation operJ = (Operation)operList.get(j);
                if (!TEPfmUtility.isInputEqual(operI, operJ)) continue;
                tempList.add(operJ);
            }
            if (tempList.size() <= 0) continue;
            map.put(operI, tempList);
            redundantList.addAll(tempList);
        }
        operList.removeAll(redundantList);
        return map;
    }

    private static boolean isInputEqual(Operation operI, Operation operJ) {
        Input inputI = operI.getInput();
        Input inputJ = operJ.getInput();
        if (operI.getCmdid() != operJ.getCmdid()) {
            return false;
        }
        if (inputI.getPart("period") != null && inputJ.getPart("period") != null && !inputI.getPart("period").getValue().equals(inputJ.getPart("period").getValue())) {
            return false;
        }
        return inputI.getPart("objtype").getValue().equals(inputJ.getPart("objtype").getValue()) && inputI.getPart("paralen").getValue().equals(inputJ.getPart("paralen").getValue()) && inputI.getPart("objpara").getValue().equals(inputJ.getPart("objpara").getValue());
    }

    public static void fillRedundantOperation(Map map, List operationList) {
        for (Map.Entry entry : map.entrySet()) {
            Operation tempOper = (Operation)entry.getKey();
            List redundantList = (List)entry.getValue();
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                Operation operation = (Operation)operationList.get(i);
                if (!TEPfmUtility.isInputEqual(tempOper, operation)) continue;
                tempOper = (Operation)operation.clone();
                Output[] tempOutput = tempOper.getOutput();
                int jsize = redundantList.size();
                for (int j = 0; j < jsize; ++j) {
                    Operation redundantOper = (Operation)redundantList.get(j);
                    redundantOper.clearOutput();
                    for (int m = 0; m < tempOutput.length; ++m) {
                        redundantOper.addOutput((Output)tempOutput[m].clone());
                    }
                    operationList.add(redundantOper);
                }
            }
        }
    }

    public static String[] parseEventIdString(String eventList) {
        eventList = eventList.replace('[', ' ');
        eventList = eventList.replace(']', ' ');
        eventList = eventList.trim();
        String[] peidArray = eventList.split(";");
        return peidArray;
    }

    public static Datainterface getCpSupportEventType(int neid, int slotid, int queryType) {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        TEPerformModel model = TEPfmUtility.getPfmModel(neid, slotid);
        if (model != null) {
            RowParams rowParam = new RowParams();
            rowParam.addParam("fbType", String.valueOf(0));
            rowParam.addParam("eventType", TEPfmUtility.getStringFromSequenceOfInt(model.getSupportEventType(0, queryType)));
            outputData.getBussinessParams().addRowParams(rowParam);
            int size = model.getCpSupFbTypeList().size();
            for (int i = 0; i < size; ++i) {
                rowParam = new RowParams();
                TEPfmBsFBObj tmp = (TEPfmBsFBObj)model.getCpSupFbTypeList().get(i);
                rowParam.addParam("fbType", String.valueOf(tmp.m_usFBType));
                rowParam.addParam("eventType", TEPfmUtility.getStringFromSequenceOfInt(model.getSupportEventType(tmp.m_usFBType, queryType)));
                outputData.getBussinessParams().addRowParams(rowParam);
            }
        }
        outputData.setErrorMessage(new ErrorMessage());
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        return outputData;
    }

    public static int getFbTypeFromModel(TEPerformModel model, int portid, int pathid, int eventID, TEPfmBsEvent event) {
        int m_usFBType;
        if (model == null) {
            m_usFBType = event != null ? event.m_usFBType : -1;
        } else {
            if (pathid > 65536) {
                pathid %= 65536;
            }
            if ((m_usFBType = model.getFBTypeID(portid, pathid, eventID)) == -1 && event != null) {
                m_usFBType = event.m_usFBType;
            }
        }
        return m_usFBType;
    }

    public static int getFbTypeFromModel(TEPerformModel model, int portid, int pathid, int eventID, TEPfmBsEvent event, int objtype) {
        int m_usFBType;
        if (model == null) {
            m_usFBType = event != null ? event.m_usFBType : -1;
        } else {
            if (pathid > 65536) {
                pathid %= 65536;
            }
            if ((m_usFBType = model.getFBTypeID(portid, pathid, eventID, objtype)) == -1 && event != null) {
                m_usFBType = event.m_usFBType;
            }
        }
        return m_usFBType;
    }

    public static String convertCTPFbType(String ctpType) {
        if (ctpType.indexOf("FB_CTP_ODU") != -1) {
            String tmpStr = ctpType.replace("_CTP_", "_");
            return tmpStr;
        }
        return ctpType;
    }
}

