/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.cbb.xmlinterpreter.XMLInterpreterImpl;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESupportODUkSPRingBoardTypeBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEOdukSpringInterpreter
extends XMLInterpreterImpl {
    @Override
    public int interpretXMLTag(Node node) {
        Element element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("odukspring");
        if (nodeList.getLength() == 0) {
            return 0;
        }
        Map<Integer, List<TESupportODUkSPRingBoardTypeBean>> boardTypeMap = TEOdukSpringInterpreter.parseOdukSpringNodeList(nodeList);
        if (!boardTypeMap.isEmpty()) {
            Map<Integer, List<TESupportODUkSPRingBoardTypeBean>> mapTemp = TECircuitPackDescription.getInstance().getOdukSpringMap();
            Set<Integer> boardTypeSet = boardTypeMap.keySet();
            for (int level : boardTypeSet) {
                if (mapTemp.containsKey(level)) {
                    List<TESupportODUkSPRingBoardTypeBean> listTemp = mapTemp.get(level);
                    listTemp.addAll((Collection<TESupportODUkSPRingBoardTypeBean>)boardTypeMap.get(level));
                    continue;
                }
                mapTemp.put(level, boardTypeMap.get(level));
            }
        }
        return 0;
    }

    private static Map<Integer, List<TESupportODUkSPRingBoardTypeBean>> parseOdukSpringNodeList(NodeList nl) {
        Element eltWdm;
        String cpTypeValue;
        HashMap<Integer, List<TESupportODUkSPRingBoardTypeBean>> boardTypeMap = new HashMap<Integer, List<TESupportODUkSPRingBoardTypeBean>>();
        SDXMLInterpreterMgr instance = SDXMLInterpreterMgr.getInstance();
        int cptype = instance.parseInt(cpTypeValue = (eltWdm = (Element)nl.item(0)).getAttribute("cp_type"));
        if (cptype == 0) {
            return boardTypeMap;
        }
        TESDCircuitPackRecord record = TECircuitPackDescription.getInstance().getCPRecord(cptype);
        String boardTypeName = record.cpName;
        NodeList levelNodeList = eltWdm.getChildNodes();
        int m = levelNodeList.getLength();
        for (int i = 0; i < m; ++i) {
            Node levelNode = levelNodeList.item(i);
            if (!levelNode.getNodeName().equalsIgnoreCase("level")) continue;
            Integer level = Integer.valueOf(levelNode.getAttributes().getNamedItem("value").getNodeValue());
            ArrayList<TESupportODUkSPRingBoardTypeBean> boardTypeList = new ArrayList<TESupportODUkSPRingBoardTypeBean>();
            NodeList itemNodeList = levelNode.getChildNodes();
            int n = itemNodeList.getLength();
            for (int j = 0; j < n; ++j) {
                Node itemNode = itemNodeList.item(j);
                if (!itemNode.getNodeName().equalsIgnoreCase("item")) continue;
                NamedNodeMap namedNodeMap = itemNode.getAttributes();
                String portListStr = namedNodeMap.getNamedItem("portlist").getNodeValue();
                int pathNum = Integer.parseInt(namedNodeMap.getNamedItem("pathnum").getNodeValue());
                int pathBeginNum = 0;
                if (namedNodeMap.getNamedItem("pathbegin") != null) {
                    pathBeginNum = Integer.valueOf(namedNodeMap.getNamedItem("pathbegin").getNodeValue());
                }
                ArrayList<Integer> portList = new ArrayList<Integer>();
                StringTokenizer token = new StringTokenizer(portListStr, ",");
                while (token.hasMoreTokens()) {
                    String tokenStr = token.nextToken();
                    int index = tokenStr.indexOf("-");
                    if (index > 0) {
                        int max = Integer.parseInt(tokenStr.substring(index + 1));
                        for (int min = Integer.parseInt(tokenStr.substring(0, index)); min <= max; ++min) {
                            portList.add(new Integer(min));
                        }
                        continue;
                    }
                    portList.add(Integer.valueOf(tokenStr));
                }
                TESupportODUkSPRingBoardTypeBean boardTypeBean = new TESupportODUkSPRingBoardTypeBean(cptype, boardTypeName, portList, pathNum, pathBeginNum);
                boardTypeList.add(boardTypeBean);
            }
            boardTypeMap.put(level, boardTypeList);
        }
        return boardTypeMap;
    }
}

