/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.model.DynPort;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortProperty;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class TENgwdmDynPortConfigurationDataCache {
    private Hashtable<Integer, Hashtable<Integer, List<DynPort>>> dynPortData = new Hashtable();
    private static TENgwdmDynPortConfigurationDataCache instance;
    public static int ALL_PORT_FLAG;

    private TENgwdmDynPortConfigurationDataCache() {
    }

    public static synchronized TENgwdmDynPortConfigurationDataCache getInstance() {
        if (instance == null) {
            instance = new TENgwdmDynPortConfigurationDataCache();
        }
        return instance;
    }

    public List<DynPort> queryExistDynPortPort(int neId, int slotId, int portID) {
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int boardType = mgr.getBoardType(neId, slotId);
        Operation oper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_PORT");
        HashSet<Integer> dynPortSet = new HashSet<Integer>();
        if (portID != ALL_PORT_FLAG) {
            dynPortSet.add(portID);
        } else if (mgr.isMutativeBoardType(neId, boardType)) {
            ArrayList dynProList = mgr.getDynPropertyList(neId, boardType);
            int size = dynProList.size();
            for (int i = 0; i < size; ++i) {
                TEPortProperty portProperty = (TEPortProperty)dynProList.get(i);
                int portType = portProperty.getPortType();
                if ((portType & 2) != 2) continue;
                dynPortSet.add(portProperty.getPortNo());
            }
        }
        ArrayList<DynPort> portList = new ArrayList<DynPort>();
        if (dynPortSet.size() > 0) {
            ArrayList<Integer> phyList = new ArrayList<Integer>();
            phyList.addAll(dynPortSet);
            Collections.sort(phyList);
            if (null == oper) {
                return null;
            }
            ArrayList<Object> operationList = new ArrayList<Object>();
            int n = phyList.size();
            for (int j = 0; j < n; ++j) {
                int portId = (Integer)phyList.get(j);
                Input input = oper.getInput();
                Part part = input.getPart("slotID");
                part.setValue(String.valueOf(slotId));
                part = input.getPart("portID");
                part.setValue(String.valueOf(portId));
                operationList.add(oper.clone());
            }
            if (operationList.isEmpty()) {
                return null;
            }
            int faultCode = 1090650120;
            int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
            if (result != 0) {
                TELogFactory.getNormalLogger().debug("TENgwdmDynPortConfigurationDataCache  queryExistDynPortPort failed(" + result + ")");
            }
            int m = operationList.size();
            for (int k = 0; k < m; ++k) {
                oper = (Operation)operationList.get(k);
                if (oper.getOutputCount() == 0) continue;
                Output output = oper.getOutput()[0];
                if (!"".equalsIgnoreCase(output.getFault()[0].getCode())) {
                    faultCode = new Integer(output.getFault()[0].getCode());
                }
                if (faultCode != 0) continue;
                String portType = output.getPartValue("portType");
                String portIDStr = output.getPartValue("portID");
                if (portType == null || portIDStr == null) continue;
                DynPort port = new DynPort(Integer.parseInt(portIDStr), Integer.parseInt(portType));
                this.addDynPortData(neId, slotId, port);
                portList.add(port);
            }
        }
        return portList;
    }

    private synchronized void addDynPortData(int neID, int slotID, DynPort port) {
        if (this.dynPortData.containsKey(neID)) {
            Hashtable<Integer, List<DynPort>> slotPortMap = this.dynPortData.get(neID);
            if (slotPortMap.containsKey(slotID)) {
                List<DynPort> dynPortList = slotPortMap.get(slotID);
                if (dynPortList.contains(port)) {
                    dynPortList.remove(port);
                    dynPortList.add(port);
                } else {
                    dynPortList.add(port);
                }
            } else {
                ArrayList<DynPort> dynPortList = new ArrayList<DynPort>();
                dynPortList.add(port);
                slotPortMap.put(slotID, dynPortList);
            }
        } else {
            Hashtable slotPortMap = new Hashtable();
            ArrayList<DynPort> dynPortList = new ArrayList<DynPort>();
            dynPortList.add(port);
            slotPortMap.put(slotID, dynPortList);
            this.dynPortData.put(neID, slotPortMap);
        }
    }

    public Integer getDynportType(int neID, int slotID, int portID) {
        List<DynPort> portList;
        List<DynPort> dynPortList;
        Hashtable<Integer, List<DynPort>> slotPortMap = this.dynPortData.get(neID);
        if (slotPortMap != null && (dynPortList = slotPortMap.get(slotID)) != null) {
            for (int i = 0; i < dynPortList.size(); ++i) {
                DynPort port = dynPortList.get(i);
                if (port.getPortID() != portID) continue;
                return port.getPortType();
            }
        }
        if ((portList = this.queryExistDynPortPort(neID, slotID, portID)) != null) {
            return portList.get(0).getPortType();
        }
        return null;
    }

    public void setDynportType(int neID, int slotID, int portID, int portType) {
        List<DynPort> dynPortList;
        Hashtable<Integer, List<DynPort>> slotPortMap = this.dynPortData.get(neID);
        if (slotPortMap != null && (dynPortList = slotPortMap.get(slotID)) != null) {
            for (int i = 0; i < dynPortList.size(); ++i) {
                DynPort port = dynPortList.get(i);
                if (port.getPortID() != portID) continue;
                port.setPortType(portType);
                break;
            }
        }
    }

    public void deleteDynPortCacheDataByNEID(int neID) {
        if (this.dynPortData.containsKey(neID)) {
            this.dynPortData.remove(neID);
        }
    }

    public void deleteDynPortCacheDataBySlotID(int neID, int slotID) {
        Hashtable<Integer, List<DynPort>> slotCache;
        if (this.dynPortData.containsKey(neID) && (slotCache = this.dynPortData.get(neID)).containsKey(slotID)) {
            slotCache.remove(slotID);
        }
    }

    public void deleteDynPortCacheDataByPortID(int neID, int slotID, int portID) {
        Hashtable<Integer, List<DynPort>> slotCache;
        if (this.dynPortData.containsKey(neID) && (slotCache = this.dynPortData.get(neID)).containsKey(slotID)) {
            List<DynPort> dynPortList = slotCache.get(slotID);
            for (int i = 0; i < dynPortList.size(); ++i) {
                DynPort port = dynPortList.get(i);
                if (port.getPortID() != portID) continue;
                dynPortList.remove(i);
                break;
            }
        }
    }

    static {
        ALL_PORT_FLAG = -1;
    }
}

