/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEGetBoardMode {
    public static final int ASYNC_MODE = 0;
    public static final int SYNC_MODE = 256;
    private static final List<Integer> NEED_QUERY_BOARDMODES = new ArrayList<Integer>();

    public static int getBoardMode(int neId, int slotId) {
        return TEGetBoardMode.getBoardSyncMode(neId, slotId) + TEGetBoardMode.queryBoardMode(neId, slotId);
    }

    public static int getBoardSyncMode(int neId, int slotId) {
        int boardMode = 0;
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        if (TECircuitPackDescription.getInstance().isCPSupportSYNC(cfgMgr.getBoardType(neId, slotId))) {
            List boardList = cfgMgr.getBoardList(neId, 1569);
            boardList.addAll(cfgMgr.getBoardList(neId, 2215));
            boardList.addAll(cfgMgr.getBoardList(neId, 1570));
            boardList.addAll(cfgMgr.getBoardList(neId, 1601));
            boardList.addAll(cfgMgr.getBoardList(neId, 1602));
            boardList.addAll(cfgMgr.getBoardList(neId, 2325));
            boardList.addAll(cfgMgr.getBoardList(neId, 2329));
            boardList.addAll(cfgMgr.getBoardList(neId, 2116));
            TENE tene = TENEListMgr.getInstance().getNE(neId);
            int neType = tene.getNEType();
            int subrackType = TEBoardUtil.getLogicSubrackType(neId, neType, slotId);
            if (subrackType == 84 || subrackType == 74 || subrackType == 97 || subrackType == 98) {
                boardMode = 256;
                return boardMode;
            }
            TEBoard board = null;
            int m = boardList.size();
            for (int i = 0; i < m; ++i) {
                board = (TEBoard)boardList.get(i);
                if (TEBoardUtil.getSubrackIDFromSlot(neId, board.getSlotID()) != TEBoardUtil.getSubrackIDFromSlot(neId, slotId)) continue;
                boardMode = 256;
                break;
            }
        }
        return boardMode;
    }

    public static int queryBoardMode(int neId, int slotId) {
        Operation oper;
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode(TEConfigurationDataMgr.getInstance().getBoardType(neId, slotId));
        if ((null != genCfgModel && null != genCfgModel.getAttrFromId("W32BD_ATTR_SUBBDTYPE") || NEED_QUERY_BOARDMODES.contains(TEConfigurationDataMgr.getInstance().getBoardType(neId, slotId))) && null != (oper = TECreateObjectFactory.getOperation(neId, "NSCMD_CFG_GET_SUBBDTYPE"))) {
            Output output;
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            oper.getInput().setPartValue("slotid", String.valueOf(slotId));
            operationList.add(oper);
            int result = TENECommMgr.getInstance().sendCommand((int)neId, operationList, (int)10).retCode;
            if (0 == result && 0 == (result = Integer.valueOf((output = (oper = (Operation)operationList.get(0)).getOutput(0)).getFault(0).getCode()).intValue())) {
                return Integer.valueOf(output.getPartValue("W32BD_ATTR_SUBBDTYPE"));
            }
        }
        return 0;
    }

    static {
        NEED_QUERY_BOARDMODES.add(1620);
    }
}

