/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.nelist.model.InnerFBSubData;
import com.huawei.nglct.nelist.model.TESDFuncBlockRecord;
import com.huawei.nglct.nelist.model.TETPLayerData;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOByID;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TEFuncBlockDescription {
    private TIntObjectHashMap<TESDFuncBlockRecord> fbMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TIntHashSet> fbb2uMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TESDContianMOByID> fbMOMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TIntArrayList> domainFBMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TIntArrayList> subTPMap = new TIntObjectHashMap();
    private TIntObjectHashMap<InnerFBSubData> innerFBSubTPMap = new TIntObjectHashMap();
    private static TEFuncBlockDescription instance = null;

    private TEFuncBlockDescription() {
    }

    public static synchronized TEFuncBlockDescription getInstance() {
        if (null == instance) {
            instance = new TEFuncBlockDescription();
        }
        return instance;
    }

    public TIntObjectHashMap<TESDFuncBlockRecord> getFBRecord() {
        return this.fbMap;
    }

    public TIntObjectHashMap<TIntArrayList> getDomainFBRecord() {
        return this.domainFBMap;
    }

    public TIntObjectHashMap<TIntHashSet> getBiTypeToFBRecord() {
        return this.fbb2uMap;
    }

    public boolean isValidFBType(int fbType) {
        if (this.fbMap.containsKey(fbType)) {
            return true;
        }
        return this.innerFBSubTPMap.containsKey(fbType);
    }

    public boolean isFBNameUpdatable(int fbType) {
        if (this.fbMap.containsKey(fbType)) {
            return ((TESDFuncBlockRecord)this.fbMap.get((int)fbType)).bNameUpdatable;
        }
        return false;
    }

    public TIntHashSet getNameUpdatables() {
        TIntHashSet fbs = new TIntHashSet();
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (!record.bNameUpdatable) continue;
            fbs.add(iter.key());
        }
        return fbs;
    }

    public String getFBTypeName(int fbType) {
        if (this.fbMap.containsKey(fbType)) {
            return ((TESDFuncBlockRecord)this.fbMap.get((int)fbType)).fbTypeName;
        }
        return "";
    }

    public String getFBClassName(int fbType) {
        if (this.fbMap.containsKey(fbType)) {
            return ((TESDFuncBlockRecord)this.fbMap.get((int)fbType)).moClassName;
        }
        return "";
    }

    public int getFBTypeClassName(String strMOName) {
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (!strMOName.equalsIgnoreCase(record.moClassName)) continue;
            return record.fbType;
        }
        return 255;
    }

    public int getFBTypeByBiType(int biType, TIntHashSet fbs) {
        fbs.clear();
        if (this.fbb2uMap.containsKey(biType)) {
            fbs.addAll(((TIntHashSet)this.fbb2uMap.get(biType)).toArray());
        }
        return fbs.size();
    }

    public boolean isBiFBType(int fbType) {
        if (this.fbMap.containsKey(fbType)) {
            return ((TESDFuncBlockRecord)this.fbMap.get(fbType)).isBiFBType();
        }
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (record.biFBType != fbType) continue;
            return record.isBiFBType();
        }
        return false;
    }

    public int getBidirFBType(int fbType) {
        if (255 == fbType || 0 == fbType) {
            return fbType;
        }
        if (this.fbMap.containsKey(fbType)) {
            return ((TESDFuncBlockRecord)this.fbMap.get((int)fbType)).biFBType;
        }
        return fbType;
    }

    public List<TESDContianMOByID> getFBConainMO(int fbType) {
        ArrayList<TESDContianMOByID> moCountList = new ArrayList<TESDContianMOByID>();
        if (this.fbMOMap.containsKey(fbType)) {
            moCountList.add((TESDContianMOByID)this.fbMOMap.get(fbType));
        }
        return moCountList;
    }

    public void getDomainContainFB(int domain, TIntArrayList fbs) {
        fbs.clear();
        if (this.domainFBMap.containsKey(domain)) {
            fbs.add(((TIntArrayList)this.domainFBMap.get(domain)).toNativeArray());
        }
    }

    public int getDomainOfFB(int fbType) {
        int biFB = this.getBidirFBType(fbType);
        TIntObjectIterator iter = this.domainFBMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int domain = iter.key();
            if (domain >= 129) continue;
            TIntArrayList recordList = (TIntArrayList)iter.value();
            int size = recordList.size();
            for (int i = 0; i < size; ++i) {
                int fb = recordList.get(i);
                if (fb != biFB) continue;
                return domain;
            }
        }
        return 255;
    }

    public TIntArrayList getAllDomain() {
        TIntArrayList domainList = new TIntArrayList();
        TIntObjectIterator iter = this.domainFBMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int domain = iter.key();
            if (domain >= 129) continue;
            domainList.add(domain);
        }
        return domainList;
    }

    public void addFuncBlockRecord(int fbType, TESDFuncBlockRecord fbRecord) {
        this.fbMap.put(new Integer(fbType).intValue(), (Object)fbRecord);
        if (fbRecord.biFBType != fbRecord.fbType) {
            TIntHashSet intSet = null;
            if (this.fbb2uMap.contains(fbRecord.biFBType)) {
                intSet = (TIntHashSet)this.fbb2uMap.get(fbRecord.biFBType);
                intSet.add(fbRecord.fbType);
            } else {
                intSet = new TIntHashSet();
                intSet.add(fbRecord.fbType);
                this.fbb2uMap.put(fbRecord.biFBType, (Object)intSet);
            }
        }
    }

    public void addDomainContainFB(int domainType, TIntArrayList fbList) {
        this.domainFBMap.put(domainType, (Object)fbList);
    }

    public int getFBTypeByName(String fbName) {
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (record == null || !record.fbTypeName.equals(fbName)) continue;
            return record.biFBType;
        }
        return 255;
    }

    public int getMOFBType(int fbType) {
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (record.fbType != fbType) continue;
            return record.moFBType;
        }
        return 255;
    }

    public int getPortFBDirection(int fbType) {
        if (this.fbMap.containsKey(fbType)) {
            TESDFuncBlockRecord fbRec = (TESDFuncBlockRecord)this.fbMap.get(fbType);
            if (fbRec.fbType == fbType) {
                return fbRec.portFBDir;
            }
        }
        return 255;
    }

    public String getAIDPrefix(int fbType) {
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (record.fbType != fbType) continue;
            return record.strAIDPrefix;
        }
        return "";
    }

    public String getMOD2(int fbType) {
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (record.fbType != fbType) continue;
            return record.strMOD2;
        }
        return "";
    }

    public ArrayList getMod2List() {
        ArrayList<String> list = new ArrayList<String>();
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            String mod2 = record.strMOD2.trim();
            if ((mod2 = mod2.equals("") ? record.fbTypeName : mod2).equals("") || list.contains(mod2)) continue;
            list.add(record.strMOD2);
        }
        return list;
    }

    public int getAidByMod2(String mod2) {
        int aidStr = 0;
        TESDFuncBlockRecord record = null;
        TIntObjectIterator iter = this.fbMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            record = (TESDFuncBlockRecord)iter.value();
            if (mod2.equals("") || !mod2.equals(record.strMOD2)) continue;
            aidStr = record.fbType;
            break;
        }
        return aidStr;
    }

    public void addSubTPRecord(int subType, TIntArrayList parentFBList) {
        this.subTPMap.put(subType, (Object)parentFBList);
    }

    public ArrayList getSubTPList(int parentFB) {
        ArrayList<Integer> subFBList = new ArrayList<Integer>();
        TIntObjectIterator iter = this.subTPMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            TIntArrayList fbList = (TIntArrayList)iter.value();
            int m = fbList.size();
            for (int i = 0; i < m; ++i) {
                int fb = fbList.get(i);
                if (fb != parentFB) continue;
                subFBList.add(iter.key());
            }
        }
        return subFBList;
    }

    public void getParentTPList(int subFB, TIntArrayList parentFBList) {
        parentFBList.clear();
        if (this.subTPMap.containsKey(subFB)) {
            parentFBList.add(((TIntArrayList)this.subTPMap.get(subFB)).toNativeArray());
        }
    }

    public void addInnerFBType(int innerFBType, int outerFBType, Set subTPSet, Set subBuildTPSet) {
        InnerFBSubData fbSubData = new InnerFBSubData();
        fbSubData.m_outerFBType = outerFBType;
        fbSubData.m_TPLayerData = subTPSet;
        fbSubData.m_BuildTPLayerData = subBuildTPSet;
        this.innerFBSubTPMap.put(innerFBType, (Object)fbSubData);
    }

    public boolean isInnerFBType(int innerFBType) {
        return this.innerFBSubTPMap.containsKey(innerFBType);
    }

    public int getOuterFBType(int innerFBType) {
        if (this.innerFBSubTPMap.containsKey(innerFBType)) {
            InnerFBSubData fbSubData = (InnerFBSubData)this.innerFBSubTPMap.get(innerFBType);
            return fbSubData.m_outerFBType;
        }
        return innerFBType;
    }

    public int appendSubTPSet(int innerFBType, Set subTPSet) {
        if (this.innerFBSubTPMap.containsKey(innerFBType)) {
            InnerFBSubData data = (InnerFBSubData)this.innerFBSubTPMap.get(innerFBType);
            Iterator<TETPLayerData> iter = data.m_TPLayerData.iterator();
            while (iter.hasNext()) {
                subTPSet.add(iter.next());
            }
            return data.m_outerFBType;
        }
        return innerFBType;
    }

    public int appendSubTPByModeSet(int innerFBType, List subTPSet) {
        if (this.innerFBSubTPMap.containsKey(innerFBType)) {
            InnerFBSubData data = (InnerFBSubData)this.innerFBSubTPMap.get(innerFBType);
            Iterator<TETPLayerData> iter = data.m_BuildTPLayerData.iterator();
            while (iter.hasNext()) {
                subTPSet.add(iter.next());
            }
            return data.m_outerFBType;
        }
        return innerFBType;
    }
}

