/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.pnp.TENEPNPMgr;
import com.huawei.nglct.cbb.pnp.TESDMgrInterface;
import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.mo.TECPMenuRecord;
import com.huawei.nglct.mo.TENETypeCpMenu;
import com.huawei.nglct.mo.TENETypeVerCpMenu;
import com.huawei.nglct.mo.VerRange;
import com.huawei.nglct.nelist.model.TEFunBlockID;
import com.huawei.nglct.nelist.model.TEFunBlockProperty;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPortDescription;
import com.huawei.nglct.nelist.model.circuitpack.TECPAddiblePortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TECPMappingAbility;
import com.huawei.nglct.nelist.model.circuitpack.TECPPortKey;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallCPPortRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallItfCPPortKey;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallSubCPKey;
import com.huawei.nglct.nelist.model.circuitpack.TEInstallSubCPRecord;
import com.huawei.nglct.nelist.model.circuitpack.TEPortModeData;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDCircuitPackRecord;
import com.huawei.nglct.nelist.model.circuitpack.TESDContianMOCount;
import com.huawei.nglct.nelist.model.circuitpack.TESupportODUkSPRingBoardTypeBean;
import com.huawei.nglct.util.device.port.TEPortUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TECircuitPackDescription
implements TESDMgrInterface {
    private TIntObjectHashMap<char[]> cpType2MacroNameMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TESDCircuitPackRecord> cpRecordMap = new TIntObjectHashMap();
    private TIntObjectHashMap<HashMap<TEInstallSubCPKey, TEInstallSubCPRecord>> subCPMap = new TIntObjectHashMap();
    private TIntObjectHashMap<List<TEInstallCPPortRecord>> cpPortMap = new TIntObjectHashMap();
    private HashMap<TEInstallItfCPPortKey, Integer> itfCPPortMap = new HashMap();
    private TIntObjectHashMap<List<TECPAddiblePortRecord>> addiblePortMap = new TIntObjectHashMap();
    private TIntObjectHashMap<List<TECPAddiblePortRecord>> addibleDefaultPortMap = new TIntObjectHashMap();
    private TIntObjectHashMap<List<TESDContianMOCount>> cpMOMap = new TIntObjectHashMap();
    private HashMap<Integer, List<Integer>> cpAlsPortsMap = new HashMap();
    private HashMap<TECPPortKey, TEPortParaRecord> cpPortCfgParaMap = new HashMap();
    private TIntObjectHashMap<TECPMenuRecord> m_CPMenuMap = new TIntObjectHashMap();
    private Map<Integer, TIntArrayList> m_CPModeMap = new ConcurrentHashMap<Integer, TIntArrayList>();
    private static TECircuitPackDescription instance = new TECircuitPackDescription();
    private TIntObjectHashMap<TECPMappingAbility> mappingAbilityMap = new TIntObjectHashMap();
    private Map<Integer, ArrayList<TEPortModeData>> workModeMap = new HashMap<Integer, ArrayList<TEPortModeData>>();
    private Map<Integer, List<TESupportODUkSPRingBoardTypeBean>> odukSpringMap = new HashMap<Integer, List<TESupportODUkSPRingBoardTypeBean>>();

    private TECircuitPackDescription() {
    }

    public static synchronized TECircuitPackDescription getInstance() {
        return instance;
    }

    public TESDCircuitPackRecord getCPRecord(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        return record;
    }

    public boolean isValidCPType(int cpType) {
        if (0 == cpType) {
            return false;
        }
        return this.cpType2MacroNameMap.containsKey(cpType);
    }

    public boolean isItfCPType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return (record.dynamicType & 2) > 0;
        }
        return false;
    }

    public boolean isProcessBoardType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return (record.dynamicType & 1) > 0;
        }
        return false;
    }

    public boolean isMutativeBoardType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return (record.dynamicType & 8) > 0;
        }
        return false;
    }

    public boolean isSupportDynPortType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            boolean bResult;
            boolean bl = bResult = (record.dynamicType & 0x20) != 0;
            if (!bResult) {
                bResult = this.isSupportSubCard(cpType);
            }
            return bResult;
        }
        return false;
    }

    public boolean isCPSupportSYNC(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return (record.dynamicType & 0x80) > 0;
        }
        return false;
    }

    public boolean isDWDMBoardType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        boolean isWDMBoard = this.isCPInDomain(cpType, 3);
        if (isWDMBoard) {
            record.isWDMBoard = isWDMBoard;
        }
        return isWDMBoard;
    }

    public int getDynamicType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return record.dynamicType;
        }
        return 0;
    }

    public String getTypeName(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return record.cpName;
        }
        return "UNKNOWN";
    }

    public String getTypeDefineName(int cpType) {
        char[] definition = (char[])this.cpType2MacroNameMap.get(cpType);
        if (null != definition) {
            return String.valueOf(definition);
        }
        return "";
    }

    public int getPortNumber(int cpType) {
        if (!this.isValidCPType(cpType)) {
            return 0;
        }
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return record.portNumber;
        }
        return 0;
    }

    public int getOccupySlotNumber(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return record.occupySlotNumber;
        }
        return 0;
    }

    public List<TEInstallCPPortRecord> getInstallCPPort(int cpType) {
        ArrayList<TEInstallCPPortRecord> portList = new ArrayList<TEInstallCPPortRecord>();
        if (!this.isValidCPType(cpType)) {
            return portList;
        }
        this.loadCircuitPackDescription(cpType);
        List recordList = (List)this.cpPortMap.get(cpType);
        if (null != recordList) {
            portList.addAll(recordList);
        }
        return portList;
    }

    public List<TEInstallCPPortRecord> getInstallSubCPPort(int cpType, int subType, int subSlot) {
        ArrayList<TEInstallCPPortRecord> portList = new ArrayList<TEInstallCPPortRecord>();
        if (!this.isValidCPType(cpType) || !this.isValidCPType(subType)) {
            return portList;
        }
        this.loadCircuitPackDescription(cpType);
        List recordList = (List)this.cpPortMap.get(subType);
        TEInstallSubCPRecord subCPRecord = this.getInstallSubCPType(cpType, subSlot);
        if (null != recordList && null != subCPRecord) {
            int startPortID = subCPRecord.startPortID;
            int size = recordList.size();
            for (int i = 0; i < size; ++i) {
                TEInstallCPPortRecord record = (TEInstallCPPortRecord)((TEInstallCPPortRecord)recordList.get(i)).clone();
                int lenj = record.getPortIDList().size();
                for (int j = 0; j < lenj; ++j) {
                    int portid = (Integer)record.getPortIDList().get(j);
                    record.getPortIDList().set(j, portid + startPortID);
                }
                portList.add(record);
            }
        }
        return portList;
    }

    public List<TECPAddiblePortRecord> getAddibleCPPort(int cpType) {
        ArrayList<TECPAddiblePortRecord> portList = new ArrayList<TECPAddiblePortRecord>();
        if (!this.isValidCPType(cpType)) {
            return portList;
        }
        this.loadCircuitPackDescription(cpType);
        List recordList = (List)this.addiblePortMap.get(cpType);
        if (null != recordList) {
            portList.addAll(recordList);
        }
        return portList;
    }

    public List<TECPAddiblePortRecord> getAddibleSubCPPort(int cpType, int subType, int subSlot) {
        ArrayList<TECPAddiblePortRecord> portList = new ArrayList<TECPAddiblePortRecord>();
        if (!this.isValidCPType(cpType) || !this.isValidCPType(subType)) {
            return null;
        }
        this.loadCircuitPackDescription(cpType);
        ArrayList recordList = (ArrayList)this.addiblePortMap.get(subType);
        TEInstallSubCPRecord subCPRecord = this.getInstallSubCPType(cpType, subSlot);
        if (null != recordList && null != subCPRecord) {
            int startPortID = subCPRecord.startPortID;
            int size = recordList.size();
            for (int i = 0; i < size; ++i) {
                TECPAddiblePortRecord record = (TECPAddiblePortRecord)((TECPAddiblePortRecord)recordList.get(i)).clone();
                record.portID += startPortID;
                portList.add(record);
            }
        }
        return portList;
    }

    public List<TECPAddiblePortRecord> getAddibleCPPort(int cpType, int portID) {
        ArrayList<TECPAddiblePortRecord> portList = new ArrayList<TECPAddiblePortRecord>();
        if (!this.isValidCPType(cpType)) {
            return null;
        }
        this.loadCircuitPackDescription(cpType);
        ArrayList recordList = (ArrayList)this.addiblePortMap.get(cpType);
        if (null != recordList) {
            int size = recordList.size();
            for (int i = 0; i < size; ++i) {
                TECPAddiblePortRecord record = (TECPAddiblePortRecord)recordList.get(i);
                if (record.portID != portID) continue;
                portList.add(record);
            }
        }
        return portList;
    }

    public TECPAddiblePortRecord getAddibleCPPort(int cpType, int portID, String level) {
        return this.getAddibleCPPort(cpType, portID, SDXMLInterpreterMgr.getInstance().parseInt(level));
    }

    public TECPAddiblePortRecord getAddibleCPPort(int cpType, int portID, int level) {
        List<TECPAddiblePortRecord> portList = this.getAddibleCPPort(cpType, portID);
        if (portList == null || portList.isEmpty()) {
            return null;
        }
        TECPAddiblePortRecord finalPort = null;
        for (TECPAddiblePortRecord port : portList) {
            if (port.m_interface != level && level != 0) continue;
            finalPort = port;
        }
        return finalPort;
    }

    public int getSubCPNum(int cpType) {
        if (!this.isValidCPType(cpType)) {
            return 0;
        }
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(cpType);
        if (null != record) {
            return record.subCPNumber;
        }
        return 0;
    }

    public TEInstallSubCPRecord getInstallSubCPType(int cpType, int subSlot) {
        this.loadCircuitPackDescription(cpType);
        HashMap subMap = (HashMap)this.subCPMap.get(cpType);
        TEInstallSubCPRecord subCPREcord = null;
        if (null != subMap) {
            TEInstallSubCPKey subCPKey = new TEInstallSubCPKey(cpType, subSlot);
            subCPREcord = (TEInstallSubCPRecord)subMap.get(subCPKey);
        }
        return subCPREcord;
    }

    public List<Integer> getInstallSubSlots(int cpType) {
        this.loadCircuitPackDescription(cpType);
        HashMap subMap = (HashMap)this.subCPMap.get(cpType);
        ArrayList<Integer> subSlots = new ArrayList<Integer>();
        Iterator keys = subMap.keySet().iterator();
        while (keys.hasNext()) {
            subSlots.add(((TEInstallSubCPKey)keys.next()).getSubSlot());
        }
        return subSlots;
    }

    public int getSubCPStartPortID(int cpType, int subSlot) {
        int startID = 0;
        TEInstallSubCPRecord record = this.getInstallSubCPType(cpType, subSlot);
        if (null != record) {
            startID = record.startPortID;
        }
        return startID;
    }

    public ArrayList getSubCPPort(int mCPType, int subCPType, int subSlot) {
        this.loadCircuitPackDescription(mCPType);
        ArrayList<Integer> subPortList = new ArrayList<Integer>();
        List<TEInstallCPPortRecord> portList = this.getInstallCPPort(subCPType);
        TEInstallSubCPRecord subCPRecord = this.getInstallSubCPType(mCPType, subSlot);
        int startPortID = subCPRecord.startPortID;
        int size = portList.size();
        for (int i = 0; i < size; ++i) {
            TEInstallCPPortRecord cpPortRecord = portList.get(i);
            int jSize = cpPortRecord.portIDList.size();
            for (int j = 0; j < jSize; ++j) {
                int portID = (Integer)cpPortRecord.portIDList.get(j) + startPortID;
                subPortList.add(portID);
            }
        }
        return subPortList;
    }

    public int convertSubCPNMPort(int mCPType, int subSlot, int portid) {
        int result = portid;
        TEInstallSubCPRecord subCPRecord = this.getInstallSubCPType(mCPType, subSlot);
        if (null != subCPRecord) {
            result = portid + subCPRecord.startPortID;
        }
        return result;
    }

    public int resumeSubCPPort(int cpType, int subSlot, int portID) {
        return portID - this.getSubCPStartPortID(cpType, subSlot);
    }

    public ArrayList getCPContainMO(int cpType) {
        if (!this.isValidCPType(cpType)) {
            return null;
        }
        ArrayList moCountList = new ArrayList();
        this.loadCircuitPackDescription(cpType);
        List moList = (List)this.cpMOMap.get(cpType);
        if (null != moList) {
            moCountList.addAll(moList);
        }
        return moCountList;
    }

    public List<TEFunBlockProperty> getCPFunBlockList(int cpType) {
        ArrayList moCountList = this.getCPContainMO(cpType);
        if (null == moCountList || moCountList.isEmpty()) {
            return null;
        }
        this.loadCircuitPackDescription(cpType);
        ArrayList<TEFunBlockProperty> funBlockPropertyList = new ArrayList<TEFunBlockProperty>();
        int m = moCountList.size();
        for (int i = 0; i < m; ++i) {
            TESDContianMOCount moCountRecord = (TESDContianMOCount)moCountList.get(i);
            if (moCountRecord == null || moCountRecord.moCount <= 0) continue;
            ArrayList<TEFunBlockID> ttpIDList = new ArrayList<TEFunBlockID>(moCountRecord.moCount);
            for (int j = 0; j < moCountRecord.moCount; ++j) {
                ttpIDList.add(new TEFunBlockID(j + 1, 0));
            }
            int fbType = TEFuncBlockDescription.getInstance().getFBTypeClassName(moCountRecord.moName);
            if (255 == fbType) continue;
            moCountRecord.setFBType(fbType);
            TEFunBlockProperty funblockproperty = new TEFunBlockProperty(moCountRecord.fbType, ttpIDList);
            funBlockPropertyList.add(funblockproperty);
        }
        return funBlockPropertyList;
    }

    public void addCPRecord(int cpType, String macroName, String typeName, String className, int dynType, int portNum, int wdmType, int subCPNum, int slotNum) {
        TESDCircuitPackRecord record = new TESDCircuitPackRecord(cpType, className, macroName, typeName, portNum, wdmType, dynType, slotNum, subCPNum);
        if (this.cpRecordMap.containsKey(cpType)) {
            this.delSDByCPType(cpType);
        }
        this.cpRecordMap.put(Integer.valueOf(cpType).intValue(), (Object)record);
    }

    public void addCPRecord(TESDCircuitPackRecord record) {
        if (this.cpRecordMap.containsKey(record.cpType)) {
            this.delSDByCPType(record.cpType);
        }
        this.cpRecordMap.put(Integer.valueOf(record.cpType).intValue(), (Object)record);
    }

    private synchronized void delSDByCPType(int cpType) {
        this.cpRecordMap.remove(cpType);
        this.cpPortMap.remove(cpType);
        this.addiblePortMap.remove(cpType);
        this.subCPMap.remove(cpType);
        TEInstallItfCPPortKey itfCPPortKey = null;
        Iterator<Object> iter = this.itfCPPortMap.keySet().iterator();
        while (iter.hasNext()) {
            itfCPPortKey = iter.next();
            if (itfCPPortKey.pCPType != cpType) continue;
            iter.remove();
        }
        this.cpMOMap.remove(cpType);
        TECPPortKey cpPortKey = null;
        iter = this.cpPortCfgParaMap.keySet().iterator();
        while (iter.hasNext()) {
            cpPortKey = (TECPPortKey)iter.next();
            if (cpPortKey.cpType != cpType) continue;
            iter.remove();
        }
        this.m_CPMenuMap.remove(cpType);
    }

    public void addInstallCPPort(int cpType, TEInstallCPPortRecord record) {
        int portDomain;
        ArrayList<Integer> portIDList = new ArrayList<Integer>();
        if (!TEPortDescription.getInstance().getPortMOClassName(record.portType).equalsIgnoreCase("") && 255 != (portDomain = TEPortDescription.getInstance().getPortDomain(record.portType))) {
            int i;
            int size = record.portIDList.size();
            for (i = 0; i < size; ++i) {
                int portID = (Integer)record.portIDList.get(i);
                portIDList.add(portID);
            }
            record.portIDList.clear();
            size = portIDList.size();
            for (i = 0; i < size; ++i) {
                Integer port = (Integer)portIDList.get(i);
                record.portIDList.add(port);
            }
        }
        if (this.cpPortMap.containsKey(cpType)) {
            ((List)this.cpPortMap.get(cpType)).add(record);
        } else {
            ArrayList<TEInstallCPPortRecord> recordList = new ArrayList<TEInstallCPPortRecord>();
            recordList.add(record);
            this.cpPortMap.put(cpType, recordList);
        }
    }

    public void addInstallCPPort(int cpType, int portType, int iSubFBGroup, int level, ArrayList portIDList, int signalType, int portUsage, int dynType, int cpMode, String aid_frefix, int port_offset) {
        TEInstallCPPortRecord record = new TEInstallCPPortRecord(portType, iSubFBGroup, level, portIDList, signalType, portUsage, dynType, cpMode, aid_frefix, port_offset);
        if (!TEPortDescription.getInstance().getPortMOClassName(record.portType).equalsIgnoreCase("")) {
            int portDomain = TEPortDescription.getInstance().getPortDomain(portType);
            if (255 != portDomain) {
                portIDList.clear();
                int size = record.portIDList.size();
                for (int i = 0; i < size; ++i) {
                    int portID = (Integer)record.portIDList.get(i);
                    portIDList.add(portID);
                }
            }
        } else if (portType == 61005) {
            record.portIDList.clear();
            int m = portIDList.size();
            for (int i = 0; i < m; ++i) {
                int portID = (Integer)portIDList.get(i);
                record.portIDList.add(portID + 32768);
            }
        }
        if (this.cpPortMap.containsKey(cpType)) {
            ((List)this.cpPortMap.get(cpType)).add(record);
        } else {
            ArrayList<TEInstallCPPortRecord> recordList = new ArrayList<TEInstallCPPortRecord>();
            recordList.add(record);
            this.cpPortMap.put(cpType, recordList);
        }
    }

    public void addAddiblePort(int cpType, ArrayList portIDList, int portType, int level, int signalType, int portUsage, int dynType) {
        int size = portIDList.size();
        for (int i = 0; i < size; ++i) {
            int portDomain;
            int portID = (Integer)portIDList.get(i);
            TECPAddiblePortRecord record = new TECPAddiblePortRecord(portID, portType, level, signalType, portUsage, dynType);
            if (!TEPortDescription.getInstance().getPortMOClassName(portType).equalsIgnoreCase("") && 255 != (portDomain = TEPortDescription.getInstance().getPortDomain(portType))) {
                record.portID = portID;
            }
            if (this.addiblePortMap.containsKey(cpType)) {
                ((List)this.addiblePortMap.get(cpType)).add(record);
                continue;
            }
            ArrayList<TECPAddiblePortRecord> recordList = new ArrayList<TECPAddiblePortRecord>();
            recordList.add(record);
            this.addiblePortMap.put(cpType, recordList);
        }
    }

    public void addAddiblePort(int cpType, int portID, int portType, int iSubFBGroup, int level, int signalType, int portUsage, int dynType, int dependPortID, List<VerRange> verRangeList, List<Integer> boardModeList) {
        int portDomain;
        TECPAddiblePortRecord record = new TECPAddiblePortRecord(portID, portType, iSubFBGroup, level, signalType, portUsage, dynType, dependPortID, 0, verRangeList, boardModeList);
        if (!TEPortDescription.getInstance().getPortMOClassName(portType).equalsIgnoreCase("") && 255 != (portDomain = TEPortDescription.getInstance().getPortDomain(portType))) {
            record.portID = portID;
            int n = record.m_DependPortID = record.m_DependPortID == 0 ? 0 : dependPortID;
        }
        if (this.addiblePortMap.containsKey(cpType)) {
            ((List)this.addiblePortMap.get(cpType)).add(record);
        } else {
            ArrayList<TECPAddiblePortRecord> recordList = new ArrayList<TECPAddiblePortRecord>();
            recordList.add(record);
            this.addiblePortMap.put(cpType, recordList);
        }
    }

    public void addAddibleDefaultPort(int cpType, int portID, int portType, int iSubFBGroup, int level, int signalType, int portUsage, int dynType, int dependPortID, List<Integer> boardModeList) {
        int portDomain;
        TECPAddiblePortRecord record = new TECPAddiblePortRecord(portID, portType, iSubFBGroup, level, signalType, portUsage, dynType, dependPortID, 0, null, boardModeList);
        if (!TEPortDescription.getInstance().getPortMOClassName(portType).equalsIgnoreCase("") && 255 != (portDomain = TEPortDescription.getInstance().getPortDomain(portType))) {
            record.portID = portID;
            int n = record.m_DependPortID = record.m_DependPortID == 0 ? 0 : dependPortID;
        }
        if (this.addibleDefaultPortMap.containsKey(cpType)) {
            ((List)this.addibleDefaultPortMap.get(cpType)).add(record);
        } else {
            ArrayList<TECPAddiblePortRecord> recordList = new ArrayList<TECPAddiblePortRecord>();
            recordList.add(record);
            this.addibleDefaultPortMap.put(cpType, recordList);
        }
    }

    public void addSubCPPort(int mCPType, int subSlot, ArrayList subCPTypeList, int startPort) {
        HashMap<TEInstallSubCPKey, TEInstallSubCPRecord> subMap = (HashMap<TEInstallSubCPKey, TEInstallSubCPRecord>)this.subCPMap.get(mCPType);
        if (null == subMap) {
            subMap = new HashMap<TEInstallSubCPKey, TEInstallSubCPRecord>();
            this.subCPMap.put(mCPType, subMap);
        }
        TEInstallSubCPKey subCPKey = new TEInstallSubCPKey(mCPType, subSlot);
        TEInstallSubCPRecord record = new TEInstallSubCPRecord(subCPTypeList, startPort);
        subMap.put(subCPKey, record);
    }

    public boolean isSupportSubCard(int boardType) {
        return this.subCPMap.contains(boardType);
    }

    public synchronized void addItfCPPort(int pCPType, int iCPType, int relativeSlot, int startPort) {
        TEInstallItfCPPortKey key = new TEInstallItfCPPortKey(pCPType, iCPType, relativeSlot);
        this.itfCPPortMap.put(key, startPort);
    }

    public void addCPMOCount(int cpType, String moName, int moCount) {
        TESDContianMOCount record = new TESDContianMOCount(moName, moCount);
        if (this.cpMOMap.containsKey(cpType)) {
            ((List)this.cpMOMap.get(cpType)).add(record);
        } else {
            ArrayList<TESDContianMOCount> moList = new ArrayList<TESDContianMOCount>();
            moList.add(record);
            this.cpMOMap.put(cpType, moList);
        }
    }

    public int getICPStartPortID(int cpType, int iCPType, int relativeSlot, int[] startPort) {
        this.loadCircuitPackDescription(cpType);
        TEInstallItfCPPortKey key = new TEInstallItfCPPortKey(cpType, iCPType, relativeSlot);
        startPort[0] = this.itfCPPortMap.get(key);
        return 0;
    }

    public void addDynCP(int cpType, String cpName, int portType, int portNum, int level, int signalType) {
        TESDCircuitPackRecord record = new TESDCircuitPackRecord();
        record.cpName = cpName;
        record.cpType = cpType;
        record.portNumber = portNum;
        record.moClassName = "TECircuitPack";
        record.dynamicType = 1;
        record.wdmType = 0;
        record.subCPNumber = 0;
        record.occupySlotNumber = 1;
        ArrayList<Integer> portIDList = new ArrayList<Integer>();
        for (int i = 1; i <= portNum; ++i) {
            portIDList.add(i);
        }
        TEInstallCPPortRecord recordPort = new TEInstallCPPortRecord(portType, level, portIDList, signalType, 0, 1);
        if (this.cpRecordMap.containsKey(Integer.valueOf(cpType).intValue())) {
            return;
        }
        this.cpRecordMap.put(cpType, (Object)record);
        if (this.cpPortMap.containsKey(cpType)) {
            ((List)this.cpPortMap.get(cpType)).add(recordPort);
        } else {
            ArrayList<TEInstallCPPortRecord> recordList = new ArrayList<TEInstallCPPortRecord>();
            recordList.add(recordPort);
            this.cpPortMap.put(cpType, recordList);
        }
    }

    public void deleteDynCP(int cpType) {
        this.cpRecordMap.remove(Integer.valueOf(cpType).intValue());
        this.cpPortMap.remove(Integer.valueOf(cpType).intValue());
    }

    public ArrayList getCPSupportXCLevelList(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(Integer.valueOf(cpType).intValue());
        if (null != record) {
            return record.getsupportLevelList();
        }
        return null;
    }

    public ArrayList getCPContainFBList(int cpType, boolean bAll) {
        this.loadCircuitPackDescription(cpType);
        ArrayList<Integer> fbList = new ArrayList<Integer>();
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(Integer.valueOf(cpType).intValue());
        if (null != record) {
            fbList.addAll(record.getContainFBList());
        }
        if (!bAll) {
            return fbList;
        }
        List moList = (List)this.cpMOMap.get(cpType);
        if (null != moList) {
            int m = moList.size();
            for (int i = 0; i < m; ++i) {
                int fbType = TEFuncBlockDescription.getInstance().getFBTypeClassName(((TESDContianMOCount)moList.get((int)i)).moName);
                fbList.add(fbType);
            }
        }
        if (this.cpPortMap.contains(cpType)) {
            ArrayList portRecordList = (ArrayList)this.cpPortMap.get(cpType);
            int size = portRecordList.size();
            for (int i = 0; i < size; ++i) {
                TEInstallCPPortRecord portRecord = (TEInstallCPPortRecord)portRecordList.get(i);
                ArrayList tmpFBList = TEPortDescription.getInstance().getPortFBList(portRecord.portType, portRecord.interfaceLevel, bAll);
                fbList.addAll(tmpFBList);
            }
        }
        return fbList;
    }

    public ArrayList getPortContainFBList(int cpType, int portType) {
        this.loadCircuitPackDescription(cpType);
        ArrayList fbList = new ArrayList();
        ArrayList portRecordList = (ArrayList)this.cpPortMap.get(cpType);
        int size = portRecordList.size();
        for (int i = 0; i < size; ++i) {
            TEInstallCPPortRecord portRecord = (TEInstallCPPortRecord)portRecordList.get(i);
            if (portRecord.portType != portType) continue;
            ArrayList tmpFBList = TEPortDescription.getInstance().getPortFBList(portRecord.portType, portRecord.interfaceLevel, true);
            System.arraycopy(tmpFBList, 0, fbList, fbList.size(), tmpFBList.size());
        }
        return fbList;
    }

    public void addCPSupportALSPortList(int cpType, ArrayList alsPortList) {
        this.cpAlsPortsMap.put(cpType, alsPortList);
    }

    public int getCPWDMType(int cpType) {
        this.loadCircuitPackDescription(cpType);
        TESDCircuitPackRecord record = (TESDCircuitPackRecord)this.cpRecordMap.get(Integer.valueOf(cpType).intValue());
        if (null != record) {
            return record.wdmType;
        }
        return 0;
    }

    public void addCPPortPara(int cpType, int portID, TEPortParaRecord record) {
        if (0 == cpType || 0 == TEPortUtil.getPortNo(portID)) {
            return;
        }
        TECPPortKey key = new TECPPortKey(cpType, portID);
        if (TEPortDescription.getInstance().getPortMOClassName(record.portType).equalsIgnoreCase("") && record.portType == 61005) {
            key.portID = portID + 32768;
        }
        if (this.cpPortCfgParaMap.containsKey(key)) {
            int i;
            TEPortParaRecord tempRecord = this.cpPortCfgParaMap.get(key);
            int n = record.supTl1XCLevelList.size();
            for (i = 0; i < n; ++i) {
                Integer tempI = (Integer)record.supTl1XCLevelList.get(i);
                if (tempRecord.supTl1XCLevelList.contains(tempI)) continue;
                tempRecord.supTl1XCLevelList.add(tempI);
            }
            n = record.supXCLevelList.size();
            for (i = 0; i < n; ++i) {
                Integer tempJ = (Integer)record.supXCLevelList.get(i);
                if (tempRecord.supXCLevelList.contains(tempJ)) continue;
                tempRecord.supXCLevelList.add(tempJ);
            }
            if (record.boardModeList != null) {
                n = record.boardModeList.size();
                for (i = 0; i < n; ++i) {
                    Integer tempK = (Integer)record.boardModeList.get(i);
                    if (tempRecord.boardModeList.contains(tempK)) continue;
                    tempRecord.boardModeList.add(tempK);
                }
            }
            record = tempRecord;
        }
        this.cpPortCfgParaMap.put(key, record);
    }

    public TEPortParaRecord getCPPortPara(int cpType, int portID) {
        this.loadCircuitPackDescription(cpType);
        TECPPortKey key = new TECPPortKey(cpType, portID);
        TEPortParaRecord portParaRecord = this.cpPortCfgParaMap.get(key);
        return portParaRecord;
    }

    public String getCPPortINName(int cpType, int portID) {
        String inName;
        this.loadCircuitPackDescription(cpType);
        TECPPortKey key = new TECPPortKey(cpType, portID);
        TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
        if (null != record && null != (inName = record.inName)) {
            return inName;
        }
        return "";
    }

    public String getCPPortOUTName(int cpType, int portID) {
        String outName;
        this.loadCircuitPackDescription(cpType);
        TECPPortKey key = new TECPPortKey(cpType, portID);
        TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
        if (null != record && null != (outName = record.outName)) {
            return outName;
        }
        return "";
    }

    public ArrayList getCPPortSrcPathList(int cpType, int portID) {
        this.loadCircuitPackDescription(cpType);
        TECPPortKey key = new TECPPortKey(cpType, portID);
        TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
        return record.srcPathIDList;
    }

    public ArrayList getCPPortSnkPathList(int cpType, int portID) {
        this.loadCircuitPackDescription(cpType);
        TECPPortKey key = new TECPPortKey(cpType, portID);
        TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
        return record.snkPathIDList;
    }

    public ArrayList getCPPortSupXCList(int cpType, int portID) {
        this.loadCircuitPackDescription(cpType);
        ArrayList xcList = new ArrayList();
        if (0 == portID) {
            Set<TECPPortKey> entries = this.cpPortCfgParaMap.keySet();
            for (TECPPortKey key : entries) {
                if (cpType != key.cpType) continue;
                TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
                int m = record.supXCLevelList.size();
                for (int i = 0; i < m; ++i) {
                    xcList.add(record.supXCLevelList.get(i));
                }
            }
        } else {
            TECPPortKey key = new TECPPortKey(cpType, portID);
            TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
            System.arraycopy(record.supXCLevelList, 0, xcList, 0, record.supXCLevelList.size());
        }
        return xcList;
    }

    public ArrayList getCPPortByXCCfgType(int xcCfgType, int cpType) {
        this.loadCircuitPackDescription(cpType);
        ArrayList<Integer> portList = new ArrayList<Integer>();
        Set<TECPPortKey> entries = this.cpPortCfgParaMap.keySet();
        for (TECPPortKey key : entries) {
            if (cpType != key.cpType) continue;
            TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
            if (xcCfgType != record.supXCCfgType) continue;
            portList.add(key.portID);
        }
        return portList;
    }

    public boolean isCPSupXCCfgType(int xcCfgType, int cpType) {
        this.loadCircuitPackDescription(cpType);
        Set<TECPPortKey> entries = this.cpPortCfgParaMap.keySet();
        for (TECPPortKey key : entries) {
            if (cpType != key.cpType) continue;
            TEPortParaRecord record = this.cpPortCfgParaMap.get(key);
            if (xcCfgType != record.supXCCfgType) continue;
            return true;
        }
        return false;
    }

    public boolean isCPInDomain(int cpType, int domain) {
        this.loadCircuitPackDescription(cpType);
        ArrayList fbList = this.getCPContainFBList(cpType, true);
        int size = fbList.size();
        for (int i = 0; i < size; ++i) {
            int fbType = (Integer)fbList.get(i);
            int domainType = TEFuncBlockDescription.getInstance().getDomainOfFB(fbType);
            if (domain != domainType) continue;
            return true;
        }
        return false;
    }

    public TECPMenuRecord getCPMenuRecordList(int cpType) {
        this.loadCircuitPackDescription(cpType);
        if (cpType >= 53247 && cpType < 57343) {
            return (TECPMenuRecord)this.m_CPMenuMap.get(53247);
        }
        return (TECPMenuRecord)this.m_CPMenuMap.get(cpType);
    }

    public void addCPSupportMenuList(int cpType, TECPMenuRecord cpMenu) {
        if (this.m_CPMenuMap.containsKey(cpType)) {
            int j;
            int n;
            int i;
            int m;
            TECPMenuRecord tempCpMenuRec = (TECPMenuRecord)this.m_CPMenuMap.get(cpType);
            if (!cpMenu.m_NeTVCpMenuList.isEmpty()) {
                if (tempCpMenuRec.m_NeTVCpMenuList.isEmpty()) {
                    tempCpMenuRec.m_NeTVCpMenuList.addAll(cpMenu.m_NeTVCpMenuList);
                } else {
                    ArrayList<TENETypeVerCpMenu> noTVCpMenuRec = new ArrayList<TENETypeVerCpMenu>();
                    TENETypeVerCpMenu verCpMenu = null;
                    TENETypeVerCpMenu tempVerCpMenu = null;
                    m = cpMenu.m_NeTVCpMenuList.size();
                    for (i = 0; i < m; ++i) {
                        boolean isExit = false;
                        verCpMenu = cpMenu.m_NeTVCpMenuList.get(i);
                        n = tempCpMenuRec.m_NeTVCpMenuList.size();
                        for (j = 0; j < n; ++j) {
                            tempVerCpMenu = tempCpMenuRec.m_NeTVCpMenuList.get(j);
                            if (verCpMenu.m_NEType != tempVerCpMenu.m_NEType || !verCpMenu.m_NeVerRange.equals(tempVerCpMenu.m_NeVerRange)) continue;
                            tempVerCpMenu.m_CpMenuList.clear();
                            tempVerCpMenu.m_tl1CpMenuList.clear();
                            tempVerCpMenu.m_CpMenuList.add(verCpMenu.m_CpMenuList.toNativeArray());
                            tempVerCpMenu.m_tl1CpMenuList.add(verCpMenu.m_tl1CpMenuList.toNativeArray());
                            isExit = true;
                            break;
                        }
                        if (isExit) continue;
                        noTVCpMenuRec.add(verCpMenu);
                    }
                    tempCpMenuRec.m_NeTVCpMenuList.addAll(noTVCpMenuRec);
                }
            }
            if (!cpMenu.m_NeTypeMenuList.isEmpty()) {
                if (tempCpMenuRec.m_NeTypeMenuList.isEmpty()) {
                    tempCpMenuRec.m_NeTypeMenuList.addAll(cpMenu.m_NeTypeMenuList);
                } else {
                    ArrayList<TENETypeCpMenu> noNeTCpMenuRec = new ArrayList<TENETypeCpMenu>();
                    TENETypeCpMenu typeCpMenu = null;
                    TENETypeCpMenu tempTypeCpMenu = null;
                    m = cpMenu.m_NeTypeMenuList.size();
                    for (i = 0; i < m; ++i) {
                        boolean isNeExit = false;
                        typeCpMenu = cpMenu.m_NeTypeMenuList.get(i);
                        n = tempCpMenuRec.m_NeTypeMenuList.size();
                        for (j = 0; j < n; ++j) {
                            tempTypeCpMenu = tempCpMenuRec.m_NeTypeMenuList.get(j);
                            if (typeCpMenu.m_NeType != tempTypeCpMenu.m_NeType) continue;
                            tempTypeCpMenu.m_CpMenuList.clear();
                            tempTypeCpMenu.m_CpMenuList.add(typeCpMenu.m_CpMenuList.toNativeArray());
                            isNeExit = true;
                            break;
                        }
                        if (isNeExit) continue;
                        noNeTCpMenuRec.add(typeCpMenu);
                    }
                    tempCpMenuRec.m_NeTypeMenuList.addAll(noNeTCpMenuRec);
                }
            }
            if (!cpMenu.m_CPMenuList.isEmpty()) {
                tempCpMenuRec.m_CPMenuList = cpMenu.m_CPMenuList;
            }
            if (!cpMenu.m_tl1CPMenuList.isEmpty()) {
                tempCpMenuRec.m_tl1CPMenuList = cpMenu.m_tl1CPMenuList;
            }
            return;
        }
        this.m_CPMenuMap.put(cpType, (Object)cpMenu);
    }

    public void addCPSupportMenuMap(TIntObjectHashMap<TECPMenuRecord> cpMenuMap) {
        TIntObjectIterator iter = cpMenuMap.iterator();
        while (iter.hasNext()) {
            iter.advance();
            this.m_CPMenuMap.put(iter.key(), iter.value());
        }
    }

    public void addCPSupportModeList(int cpType, TIntArrayList modeList) {
        TIntArrayList tempList = null;
        if (this.m_CPModeMap.containsKey(cpType)) {
            tempList = this.m_CPModeMap.get(cpType);
            tempList.add(modeList.toNativeArray());
        } else {
            this.m_CPModeMap.put(cpType, modeList);
        }
    }

    public void getCPSupportXCLevelList(int cpType, List<Integer> levelList) {
        this.loadCircuitPackDescription(cpType);
        levelList.clear();
        if (this.cpRecordMap.containsKey(cpType)) {
            levelList.addAll(((TESDCircuitPackRecord)this.cpRecordMap.get((int)cpType)).supportLevelList);
        }
    }

    public void addCPType2MacroName(int cptype, String macroName) {
        this.cpType2MacroNameMap.put(cptype, (Object)macroName.toCharArray());
    }

    public int getBoardType(int neType, String boardName, String convertName) {
        TIntObjectIterator iter = this.cpRecordMap.iterator();
        TESDCircuitPackRecord cpRecord = null;
        int boardType = -1;
        while (iter.hasNext()) {
            iter.advance();
            cpRecord = (TESDCircuitPackRecord)iter.value();
            if (cpRecord.cpName.equals(boardName)) {
                if (!convertName.equals(boardName)) {
                    if (!cpRecord.cpTypeName.equals(convertName)) continue;
                    boardType = cpRecord.getBoardType();
                    break;
                }
                boardType = cpRecord.getBoardType();
                break;
            }
            if (!cpRecord.cpName.equals(convertName)) continue;
            boardType = cpRecord.getBoardType();
            break;
        }
        return boardType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCircuitPackDescription(int cptype) {
        TIntObjectHashMap<TESDCircuitPackRecord> tIntObjectHashMap = this.cpRecordMap;
        synchronized (tIntObjectHashMap) {
            if (!this.cpRecordMap.containsKey(cptype)) {
                String macroName = null;
                if (null != this.cpType2MacroNameMap.get(cptype)) {
                    macroName = String.valueOf((char[])this.cpType2MacroNameMap.get(cptype));
                }
                if (null == macroName) {
                    return;
                }
                String desFileName = TEResourceManager.getPath() + "core/conf/xml/pnp/core/" + macroName + ".xml";
                TELogFactory.getNormalLogger().info("dynamic load board----type -> " + cptype + "  , file name->  " + desFileName);
                TENEPNPMgr.getInstance().addBoardFile(desFileName);
                SDXMLInterpreterMgr.getInstance().parseXMLFile(desFileName);
            }
        }
    }

    public TIntObjectHashMap<TECPMappingAbility> getMappingAbilityMap() {
        return this.mappingAbilityMap;
    }

    public Map<Integer, ArrayList<TEPortModeData>> getWorkModeMap() {
        return this.workModeMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWorkModeMap(HashMap<Integer, ArrayList<TEPortModeData>> workModeMapTmp) {
        Map<Integer, ArrayList<TEPortModeData>> map = this.workModeMap;
        synchronized (map) {
            if (this.workModeMap != null) {
                this.workModeMap.putAll(workModeMapTmp);
            }
        }
    }

    public Map<Integer, List<TESupportODUkSPRingBoardTypeBean>> getOdukSpringMap() {
        return this.odukSpringMap;
    }

    @Override
    public void clear() {
        this.cpRecordMap.clear();
        this.cpPortMap.clear();
        this.addiblePortMap.clear();
        this.cpPortCfgParaMap.clear();
        this.m_CPMenuMap.clear();
        this.mappingAbilityMap.clear();
        this.odukSpringMap.clear();
        this.subCPMap.clear();
        this.itfCPPortMap.clear();
        this.addibleDefaultPortMap.clear();
        this.cpMOMap.clear();
        this.cpAlsPortsMap.clear();
        this.m_CPModeMap.clear();
    }
}

