/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.model;

import com.huawei.nglct.cbb.pnp.TESDMgrInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.model.AlmFBKeyType;
import com.huawei.nglct.nelist.model.AlmObjKeyType;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.alarm.TEAlarmAISTh;
import com.huawei.nglct.nelist.model.alarm.TEAlarmInverse;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import com.huawei.nglct.nelist.model.alarm.TEAlarmUneqTh;
import com.huawei.nglct.nelist.model.alarm.TEAlmFBObj;
import com.huawei.nglct.nelist.model.alarm.TEAlmObjInfo;
import com.huawei.nglct.nelist.model.alarm.TEPortBitErrorTh;
import com.huawei.nglct.nelist.model.alarm.TEServiceAlarm;
import com.huawei.nglct.nelist.model.alarm.TEServiceAlarmFBInfo;
import com.huawei.nglct.ngwdm_pub.TEOTNModelDataMgr;
import com.huawei.nglct.util.string.TEConvertUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEAlarmDataMgr
implements TESDMgrInterface {
    private HashMap<Integer, List<Integer>> portNOMap = new HashMap();
    private HashMap<Integer, List<TEAlarmAISTh>> alarmAIDThMap = new HashMap();
    private HashMap<Integer, List<TEAlarmUneqTh>> alarmUNEQThMap = new HashMap();
    private HashMap<Integer, List<TEAlarmInverse>> alarmInverseMap = new HashMap();
    private HashMap<Integer, List<TEPortBitErrorTh>> alarmBITThMap = new HashMap();
    private HashMap<Integer, List<Integer>> thtypeMap = new HashMap();
    private HashMap<Integer, List<TEAlmFBObj>> alarmFBMap = new HashMap();
    private HashMap alarmCptypeFBMap = new HashMap();
    private HashMap<Integer, List<TEAlmFBObj>> alarmInsertFBMap = new HashMap();
    private HashMap alarmInsertMap = new HashMap();
    private HashMap almAttrToFBMap = new HashMap();
    private Map<AlmObjKeyType, Set<TEAlmObjInfo>> almAttrToObjMap = new HashMap<AlmObjKeyType, Set<TEAlmObjInfo>>();
    private static List<TEServiceAlarm> serviceAlarmList = new ArrayList<TEServiceAlarm>();
    private static TEAlarmDataMgr instance = null;

    private TEAlarmDataMgr() {
    }

    public static synchronized TEAlarmDataMgr getInstance() {
        if (instance == null) {
            instance = new TEAlarmDataMgr();
        }
        return instance;
    }

    public void fillPortNOMap(int cpType, ArrayList portNOList) {
        if (!this.portNOMap.containsKey(new Integer(cpType))) {
            this.portNOMap.put(new Integer(cpType), portNOList);
        }
    }

    public void fillAISList(int cpType, TEAlarmAISTh alarmAIDTh) {
        if (!this.alarmAIDThMap.containsKey(new Integer(cpType))) {
            ArrayList<TEAlarmAISTh> alarmAISThList = new ArrayList<TEAlarmAISTh>();
            alarmAISThList.add(alarmAIDTh);
            this.alarmAIDThMap.put(new Integer(cpType), alarmAISThList);
        } else {
            ArrayList alarmAISThList = (ArrayList)this.alarmAIDThMap.get(new Integer(cpType));
            if (!alarmAISThList.contains(alarmAIDTh)) {
                alarmAISThList.add(alarmAIDTh);
            }
        }
    }

    public void fillUNEQList(int cpType, TEAlarmUneqTh tEAlarmUneqTh) {
        if (!this.alarmUNEQThMap.containsKey(new Integer(cpType))) {
            ArrayList<TEAlarmUneqTh> alarmUNEQThList = new ArrayList<TEAlarmUneqTh>();
            alarmUNEQThList.add(tEAlarmUneqTh);
            this.alarmUNEQThMap.put(new Integer(cpType), alarmUNEQThList);
        } else {
            ArrayList alarmUNEQThList = (ArrayList)this.alarmUNEQThMap.get(new Integer(cpType));
            if (!alarmUNEQThList.contains(tEAlarmUneqTh)) {
                alarmUNEQThList.add(tEAlarmUneqTh);
            }
        }
    }

    public void fillBITThList(int cpType, TEPortBitErrorTh portBitErrorTh) {
        if (!this.alarmBITThMap.containsKey(new Integer(cpType))) {
            ArrayList<TEPortBitErrorTh> alarmBITThList = new ArrayList<TEPortBitErrorTh>();
            alarmBITThList.add(portBitErrorTh);
            this.alarmBITThMap.put(new Integer(cpType), alarmBITThList);
        } else {
            ArrayList alarmBITThList = (ArrayList)this.alarmBITThMap.get(new Integer(cpType));
            if (!alarmBITThList.contains(portBitErrorTh)) {
                alarmBITThList.add(portBitErrorTh);
            }
        }
    }

    public void fillBITTypeList(int cpType, int thtype) {
        Integer type = new Integer(thtype);
        if (!this.thtypeMap.containsKey(new Integer(cpType))) {
            ArrayList<Integer> thtypeList = new ArrayList<Integer>();
            thtypeList.add(type);
            this.thtypeMap.put(new Integer(cpType), thtypeList);
        } else {
            ArrayList thtypeList = (ArrayList)this.thtypeMap.get(new Integer(cpType));
            if (!thtypeList.contains(type)) {
                thtypeList.add(type);
            }
        }
    }

    public ArrayList getBITTypeList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.thtypeMap.get(new Integer(cpType));
    }

    public void fillInverseList(int cpType, TEAlarmInverse tEAlarmInverse) {
        if (!this.alarmInverseMap.containsKey(cpType)) {
            ArrayList<TEAlarmInverse> alarmInverseList = new ArrayList<TEAlarmInverse>();
            alarmInverseList.add(tEAlarmInverse);
            this.alarmInverseMap.put(cpType, alarmInverseList);
        } else {
            ArrayList alarmInverseList = (ArrayList)this.alarmInverseMap.get(new Integer(cpType));
            if (!alarmInverseList.contains(tEAlarmInverse)) {
                alarmInverseList.add(tEAlarmInverse);
            }
        }
    }

    public ArrayList getPortNOList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.portNOMap.get(new Integer(cpType));
    }

    public ArrayList getAISList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.alarmAIDThMap.get(new Integer(cpType));
    }

    public ArrayList getUNEQList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.alarmUNEQThMap.get(new Integer(cpType));
    }

    public ArrayList getBITThList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.alarmBITThMap.get(new Integer(cpType));
    }

    public ArrayList getInverseList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.alarmInverseMap.get(new Integer(cpType));
    }

    public void setAlarmInsertFBMap(int cpType, TEAlmFBObj fbObj) {
        if (!this.alarmInsertFBMap.containsKey(new Integer(cpType))) {
            ArrayList<TEAlmFBObj> alarmFbList = new ArrayList<TEAlmFBObj>();
            alarmFbList.add(fbObj);
            this.alarmInsertFBMap.put(new Integer(cpType), alarmFbList);
        } else {
            ArrayList alarmFbList = (ArrayList)this.alarmInsertFBMap.get(new Integer(cpType));
            if (!alarmFbList.contains(fbObj)) {
                alarmFbList.add(fbObj);
            }
        }
    }

    public void setAlarmInsertMap(int cpType, TEAlmFBObj fbObj, ArrayList supportAlmList) {
        if (!this.alarmInsertMap.containsKey(new Integer(cpType))) {
            HashMap<TEAlmFBObj, ArrayList> fBAlarmMap = new HashMap<TEAlmFBObj, ArrayList>();
            fBAlarmMap.put(fbObj, supportAlmList);
            this.alarmInsertMap.put(new Integer(cpType), fBAlarmMap);
        } else {
            HashMap fBAlarmMap = (HashMap)this.alarmInsertMap.get(new Integer(cpType));
            if (!fBAlarmMap.containsKey(fbObj)) {
                fBAlarmMap.put(fbObj, supportAlmList);
            } else {
                ArrayList list = (ArrayList)fBAlarmMap.get(fbObj);
                if (!list.containsAll(supportAlmList)) {
                    list.addAll(supportAlmList);
                }
            }
        }
    }

    public ArrayList getAlarmInsertList(int cpType, TEAlmFBObj fbObj) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        HashMap fBAlarmMap = (HashMap)this.alarmInsertMap.get(new Integer(cpType));
        return (ArrayList)fBAlarmMap.get(fbObj);
    }

    public void setAlarmFBMap(int cpType, TEAlmFBObj fbObj) {
        if (!this.alarmFBMap.containsKey(new Integer(cpType))) {
            ArrayList<TEAlmFBObj> alarmFbList = new ArrayList<TEAlmFBObj>();
            alarmFbList.add(fbObj);
            this.alarmFBMap.put(new Integer(cpType), alarmFbList);
        } else {
            ArrayList alarmFbList = (ArrayList)this.alarmFBMap.get(new Integer(cpType));
            if (!alarmFbList.contains(fbObj)) {
                alarmFbList.add(fbObj);
            }
        }
    }

    public void setAlarmMap(HashMap almAttrToFBMap) {
        this.almAttrToFBMap.putAll(almAttrToFBMap);
    }

    public void setServiceAlarmList(List<TEServiceAlarm> serviceAlarm) {
        serviceAlarmList.addAll(serviceAlarm);
    }

    public int getAlarmFbType(int neid, AlmFBKeyType fbKeyType, TEAlmObjTypeData almObjTypeObj) {
        int fbType = 30;
        if (almObjTypeObj == null) {
            fbType = this.getAlarmFbType(fbKeyType);
        } else if (fbKeyType.getBoadType() == -1) {
            fbType = TEAlarmDataMgr.getInstance().getNEServiceAlarmFbType(neid, fbKeyType.getAlarmID());
        } else {
            fbType = this.getAlarmFBTypeFromPTN(fbKeyType, almObjTypeObj.getObjType());
            if (fbType == 30) {
                fbType = this.getAlarmFbType(fbKeyType);
            }
        }
        return fbType;
    }

    private int getAlarmFBTypeFromPTN(AlmFBKeyType fbKeyType, int objType) {
        int fbType = 30;
        Set<TEAlmObjInfo> objInfos = this.getAlarmObjType(fbKeyType.getBoadType(), fbKeyType.getPort(), fbKeyType.getPath());
        if (objInfos != null && !objInfos.isEmpty()) {
            Iterator<TEAlmObjInfo> iterator = objInfos.iterator();
            TEAlmObjInfo objInfo = null;
            while (iterator.hasNext()) {
                objInfo = iterator.next();
                if (objInfo.objType != objType || !objInfo.aeidList.contains(fbKeyType.getAlarmID())) continue;
                fbType = objInfo.fbType;
                break;
            }
        }
        return fbType;
    }

    public Integer getAlarmFbType(AlmFBKeyType fbKeyType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(fbKeyType.getBoadType());
        Integer fbType = (Integer)this.almAttrToFBMap.get(fbKeyType);
        if (fbType == null && fbKeyType.getPort() > 0 && fbKeyType.getPath() <= 0) {
            fbKeyType.setPath(1);
            fbType = (Integer)this.almAttrToFBMap.get(fbKeyType);
        }
        if (fbType == null) {
            fbKeyType.setPort(0);
            fbKeyType.setPath(0);
            fbType = (Integer)this.almAttrToFBMap.get(fbKeyType);
        }
        if (fbType == null) {
            fbType = 30;
        }
        return fbType;
    }

    public HashMap getAlarmMap() {
        return this.almAttrToFBMap;
    }

    public ArrayList getAlarmFbList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        return (ArrayList)this.alarmFBMap.get(new Integer(cpType));
    }

    public ArrayList getAlmMonObjIDList(int cpType, int slotID, int neID) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        ArrayList list = (ArrayList)this.alarmFBMap.get(new Integer(cpType));
        ArrayList<TEAlarmMonObjID> almMonObjIDList = new ArrayList<TEAlarmMonObjID>();
        TEOTNModelDataMgr otnModel = TEOTNModelDataMgr.getInstance();
        if (null != list) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                TEAlarmMonObjID monObjID;
                TEAlmFBObj fbObj = (TEAlmFBObj)list.get(i);
                if (otnModel.isSupportSimpleModePort(cpType, fbObj.m_usPortID) && fbObj.m_usFBType == 30 && fbObj.m_usPortID < 51 && fbObj.m_usPathID == 1) {
                    Set<TEAlmObjInfo> objList = this.getAlarmObjType(cpType, fbObj.m_usPortID, fbObj.m_usPathID);
                    for (TEAlmObjInfo objinfo : objList) {
                        int nmPath = TEOTNModelDataMgr.getInstance().getNMPathFromObjType(objinfo.objType, cpType, fbObj.m_usPathID);
                        if (nmPath == -1) continue;
                        monObjID = this.createAlarmMonObjID(neID, slotID, fbObj, objinfo.objType);
                        almMonObjIDList.add(monObjID);
                    }
                    continue;
                }
                monObjID = this.createAlarmMonObjID(neID, slotID, fbObj, -1);
                almMonObjIDList.add(monObjID);
            }
        }
        return almMonObjIDList;
    }

    private TEAlarmMonObjID createAlarmMonObjID(int neID, int slotID, TEAlmFBObj fbObj, int objectType) {
        TEAlarmMonObjID monObjID = new TEAlarmMonObjID();
        monObjID.m_ulNEID = neID;
        monObjID.m_usSlotID = slotID;
        monObjID.m_usFBType = fbObj.m_usFBType;
        monObjID.m_usPortID = fbObj.m_usPortID;
        monObjID.m_usPathID = fbObj.m_usPathID;
        monObjID.subtp = fbObj.subtp;
        monObjID.m_objectType = objectType;
        monObjID.decPathID();
        return monObjID;
    }

    public ArrayList getAlmInsertMonObjIDList(int netype, int cpType, int slotID, int neID) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        ArrayList list = (ArrayList)this.alarmInsertFBMap.get(new Integer(cpType));
        ArrayList<TEAlarmMonObjID> almMonObjIDList = new ArrayList<TEAlarmMonObjID>();
        if (list == null) {
            return almMonObjIDList;
        }
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            TEAlmFBObj fbObj = (TEAlmFBObj)list.get(i);
            if (netype != fbObj.m_NEType) continue;
            TEAlarmMonObjID monObjID = new TEAlarmMonObjID();
            monObjID.m_ulNEID = neID;
            monObjID.m_usSlotID = slotID;
            monObjID.m_usFBType = fbObj.m_usFBType;
            monObjID.m_usPortID = fbObj.m_usPortID;
            monObjID.m_usPathID = fbObj.m_usPathID;
            monObjID.decPathID();
            almMonObjIDList.add(monObjID);
        }
        return almMonObjIDList;
    }

    public ArrayList getSupportAlarmList(int cpType, TEAlmFBObj fbObj) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        HashMap fBAlarmMap = (HashMap)this.alarmCptypeFBMap.get(new Integer(cpType));
        return (ArrayList)fBAlarmMap.get(fbObj);
    }

    public ArrayList getSupportAlarmList(int cpType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(cpType);
        HashMap fBAlarmMap = null;
        Object obj = this.alarmCptypeFBMap.get(new Integer(cpType));
        fBAlarmMap = null == obj ? new HashMap() : (HashMap)obj;
        ArrayList supportList = new ArrayList();
        ArrayList temp2 = null;
        for (ArrayList temp2 : fBAlarmMap.values()) {
            if (supportList.containsAll(temp2)) continue;
            supportList.addAll(temp2);
        }
        return supportList;
    }

    public void setAlarmCptypeFBMap(int cpType, TEAlmFBObj fbObj, ArrayList supportAlmList) {
        if (!this.alarmCptypeFBMap.containsKey(new Integer(cpType))) {
            HashMap<TEAlmFBObj, ArrayList> fBAlarmMap = new HashMap<TEAlmFBObj, ArrayList>();
            fBAlarmMap.put(fbObj, supportAlmList);
            this.alarmCptypeFBMap.put(new Integer(cpType), fBAlarmMap);
        } else {
            HashMap fBAlarmMap = (HashMap)this.alarmCptypeFBMap.get(new Integer(cpType));
            if (!fBAlarmMap.containsKey(fbObj)) {
                fBAlarmMap.put(fbObj, supportAlmList);
            } else {
                ArrayList list = (ArrayList)fBAlarmMap.get(fbObj);
                if (!list.containsAll(supportAlmList)) {
                    list.addAll(supportAlmList);
                }
            }
        }
    }

    public void setAlarmObjMap(Map<AlmObjKeyType, Set<TEAlmObjInfo>> almAttrToObjMap) {
        this.almAttrToObjMap.putAll(almAttrToObjMap);
    }

    public Set<TEAlmObjInfo> getAlarmObjType(AlmObjKeyType objKeyType) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(objKeyType.getBoadType());
        Set<TEAlmObjInfo> strObj = this.almAttrToObjMap.get(objKeyType);
        if (null != strObj) {
            return strObj;
        }
        return null;
    }

    public Set<TEAlmObjInfo> getAlarmObjType(int boardType, int port, int path) {
        TECircuitPackDescription.getInstance().loadCircuitPackDescription(boardType);
        port = port < 0 ? 0 : port;
        path = path < 0 ? 0 : path;
        AlmObjKeyType objKeyType = new AlmObjKeyType(boardType, port, path);
        return this.getAlarmObjType(objKeyType);
    }

    public TEServiceAlarm getNeServiceAlarm(int neID) {
        TEServiceAlarm serviceAlarmResult = null;
        int neVersion = TEConvertUtil.convertVerStrToInt(TENEListMgr.getInstance().getNE(neID).getHostVersion());
        TEServiceAlarm serviceAlarm = null;
        int len = serviceAlarmList.size();
        for (int i = 0; i < len; ++i) {
            serviceAlarm = serviceAlarmList.get(i);
            if (!serviceAlarm.getVerRange().isWithInRange(neVersion)) continue;
            serviceAlarmResult = serviceAlarm;
            break;
        }
        return serviceAlarmResult;
    }

    public List<Integer> getNeServiceAlarmList(int neID) {
        List<Integer> list = new ArrayList<Integer>();
        TEServiceAlarm serviceAlarm = this.getNeServiceAlarm(neID);
        if (null != serviceAlarm) {
            list = serviceAlarm.getAlarmList();
        }
        return list;
    }

    public List<TEServiceAlarmFBInfo> getNEServiceAlarmObjList(int neID) {
        List<TEServiceAlarmFBInfo> list = new ArrayList<TEServiceAlarmFBInfo>();
        TEServiceAlarm serviceAlarm = this.getNeServiceAlarm(neID);
        if (null != serviceAlarm) {
            list = serviceAlarm.getAlarmFbList();
        }
        return list;
    }

    @Override
    public void clear() {
        this.portNOMap.clear();
        this.alarmAIDThMap.clear();
        this.alarmUNEQThMap.clear();
        this.alarmInverseMap.clear();
        this.alarmBITThMap.clear();
        this.thtypeMap.clear();
        this.alarmFBMap.clear();
        this.alarmCptypeFBMap.clear();
        this.alarmInsertFBMap.clear();
        this.alarmInsertMap.clear();
        this.almAttrToFBMap.clear();
        this.almAttrToObjMap.clear();
    }

    public int getNEServiceAlarmFbType(int neID, int alarmID) {
        List<TEServiceAlarmFBInfo> alarms = this.getNEServiceAlarmObjList(neID);
        for (TEServiceAlarmFBInfo alarm : alarms) {
            if (!alarm.getAlarmIDList().contains(alarmID)) continue;
            return alarm.getFbType();
        }
        return 30;
    }
}

