/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.lpara;

import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjParaData;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmPosition;
import com.huawei.nglct.nelist.lpara.TEGetAlmObjResource;
import com.huawei.nglct.nelist.lpara.TEObjectParam;
import com.huawei.nglct.nelist.model.TEAlarmDataMgr;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import com.huawei.nglct.nelist.model.TEPerformanceDataMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import com.huawei.nglct.nelist.model.alarm.TEAlmObjInfo;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.nelist.model.performance.TEPfmObjInfo;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TELParamMgr {
    private TENE ne = null;
    private static TELParamMgr instance = null;
    private static final int LEN_BYTE = 1;
    private static final int LEN_WORD = 2;
    private static final int LEN_DWORD = 4;
    private static final int VCGPORT_NUM = 32768;

    public TELParamMgr(int neID) {
        this.ne = TENEListMgr.getInstance().getNE(neID);
    }

    public static synchronized TELParamMgr getInstance(int neid) {
        if (instance == null) {
            instance = new TELParamMgr(neid);
        }
        return instance;
    }

    public TEAlmObjTypeData getAlmObjTypeData(TEPfmMonObjID monObj) {
        String objType = this.getObjectType(monObj);
        TEAlmObjTypeData almObjTypeObj = TEGetAlmObjResource.getInstance().getPtnObjTypeData(Integer.valueOf(objType));
        return almObjTypeObj;
    }

    public String getObjectType(TEPfmMonObjID monObj) {
        List objList = this.getObjTypeList(monObj, 0);
        return (String)objList.get(0);
    }

    public String getParaLen(TEPfmMonObjID monObj) {
        TEAlmObjTypeData data = this.getAlmObjTypeData(monObj);
        if (data == null) {
            return "2";
        }
        return String.valueOf(data.getParaLen());
    }

    public String getObjPara(TEAlmObjTypeData data, TEPfmMonObjID monObj) {
        TEBoard boardObj = this.ne.getBoard(monObj.m_usSlotID);
        int boardType = 0;
        if (boardObj != null) {
            boardType = boardObj.getBoardType();
        }
        if (boardType != 1557) {
            monObj.decPathID();
        }
        TEAlmPosition almpos = new TEAlmPosition();
        almpos.setSlot(monObj.getSlotID());
        almpos.setPort(monObj.getPortID());
        if (boardType == 1557) {
            almpos.setPath(monObj.fbID1 <= 0 ? monObj.getPathID() : monObj.fbID1);
        } else {
            almpos.setPath(monObj.fbID1);
        }
        almpos.setVc12path(monObj.fbID2);
        String ret = TELParamMgr.getObjPara(almpos, data);
        return ret;
    }

    public static String getObjPara(TEAlmPosition almpos, TEAlmObjTypeData data) {
        if (data == null) {
            return "0000";
        }
        TEAlmObjParaData itParaMap = null;
        StringBuffer retValue = new StringBuffer();
        List paraList = data.getParaList();
        int len = paraList.size();
        block5: for (int i = 0; i < len; ++i) {
            itParaMap = (TEAlmObjParaData)paraList.get(i);
            int paraLen = itParaMap.getParaLen();
            switch (paraLen) {
                case 1: {
                    String hexStr;
                    if (0 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(almpos.getSlot(), paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (1 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(255, paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (2 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(almpos.getPort(), paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (3 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(almpos.getPath(), paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (4 != itParaMap.getAidPos()) continue block5;
                    hexStr = TELParamMgr.getHexVal(almpos.getVc12path(), paraLen);
                    retValue.append(hexStr);
                    continue block5;
                }
                case 2: {
                    String hexStr;
                    if (0 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(TEBoardUtil.subrackIDNMToNE(almpos.getSlot()), paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (2 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(almpos.getPort(), paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (3 == itParaMap.getAidPos()) {
                        hexStr = TELParamMgr.getHexVal(almpos.getPath(), paraLen);
                        retValue.append(hexStr);
                        continue block5;
                    }
                    if (4 != itParaMap.getAidPos()) continue block5;
                    hexStr = TELParamMgr.getHexVal(almpos.getVc12path(), paraLen);
                    retValue.append(hexStr);
                    continue block5;
                }
                case 4: {
                    String hexStr = TELParamMgr.getHexVal(0, paraLen);
                    retValue.append(hexStr);
                    continue block5;
                }
            }
        }
        return retValue.toString();
    }

    public TEAlmObjTypeData getAlmObjTypeData(TEAlarmMonObjID monObj) {
        String objType = this.getObjectType(monObj);
        TEAlmObjTypeData almObjTypeObj = TEGetAlmObjResource.getInstance().getPtnObjTypeData(Integer.valueOf(objType));
        return almObjTypeObj;
    }

    public String getObjectType(TEAlarmMonObjID monObj) {
        List objList = this.getObjTypeList(monObj, 0);
        return (String)objList.get(0);
    }

    public String getObjectType(TEAlarmMonObjID monObj, int alarmId) {
        List objList = this.getObjTypeList(monObj, alarmId);
        return (String)objList.get(0);
    }

    public String getParaLen(TEAlarmMonObjID monObj) {
        TEAlmObjTypeData data = this.getAlmObjTypeData(monObj);
        if (data == null) {
            return "2";
        }
        return String.valueOf(data.getParaLen());
    }

    public String getObjPara(TEAlmObjTypeData data, TEAlarmMonObjID monObj) {
        int boardType = this.ne.getBoard(monObj.m_usSlotID).getBoardType();
        if (boardType != 1557) {
            monObj.decPathID();
        }
        TEAlmPosition almpos = new TEAlmPosition();
        almpos.setSlot(monObj.m_usSlotID);
        almpos.setPort(monObj.m_usPortID);
        almpos.setPath(monObj.fbID1);
        almpos.setVc12path(monObj.fbID2);
        return TELParamMgr.getObjPara(almpos, data);
    }

    public String getObjPara(TEAlarmMonObjID monObj) {
        TEAlmObjTypeData data = this.getAlmObjTypeData(monObj);
        if (data == null) {
            return "0000";
        }
        return this.getObjPara(data, monObj);
    }

    public String getObjPara(TEPfmMonObjID monObj) {
        TEAlmObjTypeData data = this.getAlmObjTypeData(monObj);
        if (data == null) {
            return "0000";
        }
        return this.getObjPara(data, monObj);
    }

    private static String getHexVal(int value, int len) {
        int newValue = value;
        if (newValue < 0) {
            newValue = 0;
        }
        String retStr = Integer.toString(newValue, 16);
        int size = len * 2;
        while (retStr.length() < size) {
            retStr = "0" + retStr;
        }
        return retStr;
    }

    public static final byte[] getBytes(int len, int num) {
        return IOStreamConvertor.unsignedShort2Bytes(num);
    }

    public static final byte[] get1Bytes(int a) {
        byte[] b = new byte[]{(byte)(a & 0xFF)};
        return b;
    }

    public TEAlmObjTypeData getAlmObjTypeData(int objType) {
        TEAlmObjTypeData almObjTypeObj = TEGetAlmObjResource.getInstance().getPtnObjTypeData(objType);
        return almObjTypeObj;
    }

    public List getObjTypeList(TEAlarmMonObjID monObj, int almId) {
        TEBoard board = this.ne.getBoard(monObj.m_usSlotID);
        ArrayList<String> objList = new ArrayList<String>();
        if (null != board) {
            int boardType = board.getBoardType();
            String objType = "";
            int portId = monObj.m_usPortID;
            int pathId = monObj.m_usPathID;
            portId = portId < 0 ? 0 : portId;
            pathId = pathId < 0 ? 0 : pathId;
            boolean isConvertFB = TEGetAlmObjResource.getInstance().isConvertFB(boardType);
            boolean isExistFB = true;
            if (isConvertFB) {
                int fbType = TEGetAlmObjResource.getInstance().getFBType(boardType, monObj.m_usFBType);
                TEAlmObjTypeData obj = TEGetAlmObjResource.getInstance().getFBObjTypeData(fbType);
                if (-1 == fbType || null == obj) {
                    isExistFB = false;
                } else {
                    objList.add(String.valueOf(obj.getObjType()));
                }
            }
            if (!isConvertFB || !isExistFB) {
                Set<TEAlmObjInfo> objTypeTemp = TEAlarmDataMgr.getInstance().getAlarmObjType(boardType, portId, pathId);
                Set<TEAlmObjInfo> objTypeTemp0 = null;
                if (pathId != 0) {
                    objTypeTemp0 = TEAlarmDataMgr.getInstance().getAlarmObjType(boardType, portId, 0);
                }
                if (null != objTypeTemp) {
                    if (null != objTypeTemp0) {
                        objTypeTemp.addAll(objTypeTemp0);
                    }
                    TEAlmObjInfo objinfo2 = null;
                    if (objTypeTemp.size() == 1) {
                        objinfo2 = objTypeTemp.iterator().next();
                        objType = String.valueOf(objinfo2.objType);
                        objList.add(objType);
                    } else {
                        for (TEAlmObjInfo objinfo2 : objTypeTemp) {
                            if (objinfo2.fbType != 30 && TEFuncBlockDescription.getInstance().getBidirFBType(objinfo2.fbType) != TEFuncBlockDescription.getInstance().getBidirFBType(monObj.m_usFBType) && objinfo2.fbType != 0 || objList.contains(objinfo2.objType) || almId != 0 && (almId == 0 || !objinfo2.aeidList.contains(almId))) continue;
                            objType = String.valueOf(objinfo2.objType);
                            objList.add(objType);
                        }
                    }
                }
            }
        }
        if (objList.isEmpty()) {
            objList.add("76");
        }
        return objList;
    }

    public List getObjTypeList(TEPfmMonObjID monObj, int eventId) {
        TEBoard board = this.ne.getBoard(monObj.m_usSlotID);
        ArrayList<String> objList = new ArrayList<String>();
        if (null != board) {
            int boardType = board.getBoardType();
            int portId = monObj.m_usPortID;
            int pathId = monObj.m_usPathID & 0xFFFF;
            portId = portId < 0 ? 0 : portId;
            pathId = pathId < 0 ? 0 : pathId;
            boolean isConvertFB = TEGetAlmObjResource.getInstance().isConvertFB(boardType);
            boolean isExistFB = true;
            if (isConvertFB) {
                int fbType = TEGetAlmObjResource.getInstance().getFBType(boardType, monObj.getFBType());
                TEAlmObjTypeData obj = TEGetAlmObjResource.getInstance().getFBObjTypeData(fbType);
                if (-1 == fbType || null == obj) {
                    isExistFB = false;
                } else {
                    objList.add(String.valueOf(obj.getObjType()));
                }
            }
            if (!isConvertFB || !isExistFB) {
                String objType = "";
                List<TEPfmObjInfo> objTypeTemp = TEPerformanceDataMgr.getInstance().getPerformObjType(boardType, portId, pathId);
                List<TEPfmObjInfo> objTypeTemp0 = null;
                if (pathId != 0) {
                    objTypeTemp0 = TEPerformanceDataMgr.getInstance().getPerformObjType(boardType, portId, 0);
                }
                if (null != objTypeTemp) {
                    if (null != objTypeTemp0) {
                        objTypeTemp.addAll(objTypeTemp0);
                    }
                    TEPfmObjInfo objinfo = null;
                    for (int i = 0; i < objTypeTemp.size(); ++i) {
                        objinfo = objTypeTemp.get(i);
                        if (objinfo.fbType != 30 && TEFuncBlockDescription.getInstance().getBidirFBType(objinfo.fbType) != TEFuncBlockDescription.getInstance().getBidirFBType(monObj.m_usFBType) && objinfo.fbType != 0 || objList.contains(objinfo.objType) || eventId != 0 && (eventId == 0 || !objinfo.eventidList.contains(eventId))) continue;
                        objType = String.valueOf(objinfo.objType);
                        objList.add(objType);
                    }
                    if (objList.isEmpty() && eventId != 0) {
                        objinfo = objTypeTemp.get(0);
                        objType = String.valueOf(objinfo.objType);
                        objList.add(objType);
                    }
                }
            }
        }
        if (objList.isEmpty()) {
            objList.add("76");
        }
        return objList;
    }

    public TEObjectParam getObjectParam(String objType, TEPfmMonObjID monObj) {
        TEObjectParam obj = new TEObjectParam();
        obj.setObjType(objType);
        TEAlmObjTypeData almObjTypeObj = TEGetAlmObjResource.getInstance().getPtnObjTypeData(Integer.valueOf(objType));
        if (null == almObjTypeObj) {
            return obj;
        }
        obj.setParamLength(String.valueOf(almObjTypeObj.getParaLen()));
        obj.setObjParam(this.getObjPara(almObjTypeObj, monObj));
        return obj;
    }

    public TEObjectParam getObjectParam(String objType, TEAlarmMonObjID monObj) {
        TEObjectParam obj = new TEObjectParam();
        obj.setObjType(objType);
        TEAlmObjTypeData almObjTypeObj = TEGetAlmObjResource.getInstance().getPtnObjTypeData(Integer.valueOf(objType));
        if (null == almObjTypeObj) {
            return obj;
        }
        obj.setParamLength(String.valueOf(almObjTypeObj.getParaLen()));
        obj.setObjParam(this.getObjPara(almObjTypeObj, monObj));
        return obj;
    }

    public List getObjectParams(TEPfmMonObjID monObj, int eventId) {
        List objList = null;
        TEPfmMonObjID monObj1 = (TEPfmMonObjID)monObj.clone();
        objList = this.getObjTypeList(monObj, eventId);
        String objType = "";
        TEObjectParam operTemp = null;
        ArrayList<TEObjectParam> operations = new ArrayList<TEObjectParam>();
        for (int i = 0; i < objList.size(); ++i) {
            objType = (String)objList.get(i);
            operTemp = this.getObjectParam(objType, monObj1);
            operations.add(operTemp);
        }
        return operations;
    }

    public List getObjectParams(TEAlarmMonObjID monObj, int eventId) {
        List objList = null;
        objList = this.getObjTypeList(monObj, eventId);
        String objType = "";
        TEObjectParam operTemp = null;
        ArrayList<TEObjectParam> operations = new ArrayList<TEObjectParam>();
        for (int i = 0; i < objList.size(); ++i) {
            objType = (String)objList.get(i);
            if (String.valueOf(objType).equals("98") && monObj.m_usPortID > 32768) {
                TEAlarmMonObjID tempObj = (TEAlarmMonObjID)monObj.clone();
                int portid = tempObj.m_usPortID;
                tempObj.m_usPortID = tempObj.m_usPathID;
                tempObj.m_usPathID = portid;
                operTemp = this.getObjectParam(objType, tempObj);
            } else {
                operTemp = this.getObjectParam(objType, monObj);
            }
            operations.add(operTemp);
        }
        return operations;
    }
}

