/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.lpara;

import com.huawei.nglct.cbb.xmlinterpreter.TELoadDataUtil;
import com.huawei.nglct.nelist.lpara.TEAlmFBConvertMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.model.TEFuncBlockDescription;
import gnu.trove.TIntObjectHashMap;

public class TEGetAlmObjResource {
    private TIntObjectHashMap<TEAlmObjTypeData> fbObjectTypeMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TEAlmObjTypeData> ptnObjectTypeMap = new TIntObjectHashMap();
    private TIntObjectHashMap<TEAlmFBConvertMgr> fbConvertMap = new TIntObjectHashMap();
    private static TEGetAlmObjResource instance = new TEGetAlmObjResource();
    private boolean isPtnObjectLoaded = false;

    private TEGetAlmObjResource() {
    }

    public static TEGetAlmObjResource getInstance() {
        return instance;
    }

    public void addPtnObject(TEAlmObjTypeData objType) {
        this.fbObjectTypeMap.put(objType.getFbType(), (Object)objType);
        this.ptnObjectTypeMap.put(objType.getObjType(), (Object)objType);
    }

    public void addFBConvertMap(int cpType, TEAlmFBConvertMgr fbMgr) {
        this.fbConvertMap.put(cpType, (Object)fbMgr);
    }

    public int getFBType(int cpType, int fbType) {
        int fbTypeNew = TEFuncBlockDescription.getInstance().getBidirFBType(fbType);
        TEAlmFBConvertMgr fbMgr = (TEAlmFBConvertMgr)this.fbConvertMap.get(cpType);
        if (null == fbMgr) {
            return -1;
        }
        return fbMgr.getFBType(fbTypeNew);
    }

    public boolean isConvertFB(int cpType) {
        return this.fbConvertMap.containsKey(cpType);
    }

    public TEAlmObjTypeData getFBObjTypeData(int fbType) {
        this.loadPTNObjectData();
        return (TEAlmObjTypeData)this.fbObjectTypeMap.get(fbType);
    }

    public TEAlmObjTypeData getPtnObjTypeData(int objType) {
        this.loadPTNObjectData();
        return (TEAlmObjTypeData)this.ptnObjectTypeMap.get(objType);
    }

    private void loadPTNObjectData() {
        if (!this.isPtnObjectLoaded) {
            this.isPtnObjectLoaded = true;
            TELoadDataUtil.loadModelData("xml/model/ptnobject.xml");
            TELoadDataUtil.loadModelData("xml/alarm/alarm.xml");
        }
    }
}

