/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.lpara;

import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.lpara.TEAlmObjParaData;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeMgr;
import com.huawei.nglct.nelist.model.performance.PfmFilter;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEAlmReturnParamParse {
    private static TEAlmReturnParamParse instance = null;
    private static final int OBJ_NEW_ETH_VCGPORT = 149;
    private static final int OBJ_NEW_ETH_PATH = 98;
    private static final int VCGPORT_NUM = 32768;
    private static int OBJ_NEW_PORT_PRI = 107;
    private static final int VC12_PATH_OFFSET = 65536;

    public static synchronized TEAlmReturnParamParse getInstance() {
        if (instance == null) {
            instance = new TEAlmReturnParamParse();
        }
        return instance;
    }

    public TEPfmMonObjID parseObjParam(byte[] objByte, TEAlmObjTypeData almObjTypeObj) {
        TEPfmMonObjID monObj = new TEPfmMonObjID();
        if (almObjTypeObj == null) {
            return monObj;
        }
        List paramList = almObjTypeObj.getParaList();
        int asonValue = 0;
        String textpattern = "";
        for (int i = 0; i < paramList.size(); ++i) {
            TEAlmObjParaData itParaMap = (TEAlmObjParaData)paramList.get(i);
            int length = itParaMap.getParaLen();
            int offset = itParaMap.getQxBegin() * 2;
            byte[] temp = new byte[length * 2];
            if (objByte.length >= offset + length * 2) {
                System.arraycopy(objByte, offset, temp, 0, length * 2);
            }
            if (itParaMap.getTextPattern() == null || itParaMap.getTextPattern().equals("")) {
                if (0 == itParaMap.getAidPos() && itParaMap.getParaLen() <= 2) {
                    monObj.m_usSlotID = TEAlmObjTypeMgr.convertSlotidFromBytes(temp);
                    continue;
                }
                if (1 == itParaMap.getAidPos()) {
                    monObj.setSubcardID(IOStreamConvertor.readPositiveShort(temp, 0));
                    continue;
                }
                if (2 == itParaMap.getAidPos() && 1 == itParaMap.getParaLen()) {
                    monObj.m_usPortID = IOStreamConvertor.readPositiveShort(temp, 0);
                    continue;
                }
                if (2 == itParaMap.getAidPos() && 2 == itParaMap.getParaLen()) {
                    monObj.m_usPortID = IOStreamConvertor.readPositiveInt(temp, 0);
                    if (almObjTypeObj.getObjType() != 149 || monObj.m_usPortID >= 32768) continue;
                    monObj.m_usPortID += 32768;
                    continue;
                }
                if (3 == itParaMap.getAidPos() && 2 == itParaMap.getParaLen()) {
                    monObj.m_usPathID = IOStreamConvertor.readPositiveInt(temp, 0);
                    if (almObjTypeObj.getObjType() != 98 || monObj.m_usPathID <= 32768) continue;
                    int portid = monObj.m_usPortID;
                    monObj.m_usPortID = monObj.m_usPathID;
                    monObj.m_usPathID = portid;
                    continue;
                }
                if (3 == itParaMap.getAidPos() && 1 == itParaMap.getParaLen()) {
                    monObj.m_usPathID = IOStreamConvertor.readPositiveShort(temp, 0);
                    continue;
                }
                if (4 != itParaMap.getAidPos() || 1 != itParaMap.getParaLen()) continue;
                monObj.m_usPathID = monObj.m_usPathID * 65536 + IOStreamConvertor.readPositiveShort(temp, 0);
                continue;
            }
            textpattern = itParaMap.getTextPattern();
            if (length == 1) {
                asonValue = IOStreamConvertor.readPositiveShort(temp, 0);
                if (OBJ_NEW_PORT_PRI == almObjTypeObj.getObjType() && itParaMap.getQxBegin() == 5) {
                    textpattern = textpattern.replaceAll("%d", this.covertCOS(asonValue));
                } else {
                    textpattern = textpattern.replaceAll("%d", String.valueOf(asonValue));
                    textpattern = textpattern.replaceAll("%x", Long.toHexString(asonValue).toUpperCase());
                }
            } else if (length == 2) {
                asonValue = IOStreamConvertor.readPositiveInt(temp, 0);
                textpattern = textpattern.replaceAll("%d", String.valueOf(asonValue));
                textpattern = textpattern.replaceAll("%x", Long.toHexString(asonValue).toUpperCase());
            } else if (length == 4) {
                asonValue = IOStreamConvertor.readPositiveLong(temp, 0);
                textpattern = textpattern.replaceAll("%x", Long.toHexString(asonValue).toUpperCase());
                textpattern = textpattern.replaceAll("%d", String.valueOf(asonValue));
            } else {
                textpattern = textpattern.replaceAll("%s", TEStringUtils.ascStrToStr(new String(temp)).trim());
            }
            int start = textpattern.indexOf(91);
            int end = textpattern.indexOf(93);
            if (start >= 0 && end >= 0) {
                String str1 = TENEListUtils.getString(textpattern.substring(start + 1, end));
                String str2 = textpattern.substring(end + 1);
                textpattern = str1 + str2;
            }
            monObj.asonString = monObj.asonString + textpattern;
        }
        return monObj;
    }

    private String covertCOS(int cos) {
        String nubConvert = "";
        switch (cos) {
            case 1: {
                nubConvert = "CS7";
                break;
            }
            case 2: {
                nubConvert = "CS6";
                break;
            }
            case 3: {
                nubConvert = "EF";
                break;
            }
            case 4: {
                nubConvert = "AF4";
                break;
            }
            case 5: {
                nubConvert = "AF3";
                break;
            }
            case 6: {
                nubConvert = "AF2";
                break;
            }
            case 7: {
                nubConvert = "AF1";
                break;
            }
            case 8: {
                nubConvert = "BE";
                break;
            }
            default: {
                nubConvert = String.valueOf(cos);
            }
        }
        return nubConvert;
    }

    public Map getMonObjAndFilter(Output output, Input input, List filterArr) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        TEPfmMonObjID pfmmonobjItem = null;
        PfmFilter filter = null;
        if (output.getPart("objtype") != null) {
            if ("-1".equals(output.getPart("objtype").getValue())) {
                output.getPart("objtype").setValue(input.getPart("objtype").getValue());
            }
            if ("-1".equals(output.getPart("paralen").getValue())) {
                output.getPart("paralen").setValue(input.getPart("paralen").getValue());
            }
            if ("-1".equals(output.getPart("objpara").getValue())) {
                output.getPart("objpara").setValue(input.getPart("objpara").getValue());
            }
            if (input.getPart("monObj") == null) {
                return null;
            }
            Part part = new Part();
            part.setName("monObj");
            part.setValue(input.getPart("monObj").getValue());
            output.addPart(part);
            for (int m = 0; m < filterArr.size(); ++m) {
                filter = (PfmFilter)filterArr.get(m);
                TEPfmMonObjID tempPfmmonobj = filter.getPfmmonobj();
                if (!output.getPart("monObj").getValue().equals(tempPfmmonobj.toString())) continue;
                pfmmonobjItem = tempPfmmonobj;
                break;
            }
        }
        map.put("monObj", pfmmonobjItem);
        map.put("filter", filter);
        return map;
    }

    public TEPfmMonObjID getMonObj(Output output, Input input, List pfmMonObjArr) {
        Part part;
        TEPfmMonObjID pfmmonobjItem = null;
        if (output.getPart("objtype") != null) {
            if ("-1".equals(output.getPart("objtype").getValue())) {
                output.getPart("objtype").setValue(input.getPart("objtype").getValue());
            }
            if ("-1".equals(output.getPart("paralen").getValue())) {
                output.getPart("paralen").setValue(input.getPart("paralen").getValue());
            }
            if ("-1".equals(output.getPart("objpara").getValue())) {
                output.getPart("objpara").setValue(input.getPart("objpara").getValue());
            }
        } else if (output.getPart("objtype") == null && input.getPart("objtype") != null) {
            part = new Part();
            part.setName("objtype");
            part.setValue(input.getPart("objtype").getValue());
            output.addPart(part);
            part = new Part();
            part.setName("paralen");
            part.setValue(input.getPart("paralen").getValue());
            output.addPart(part);
            part = new Part();
            part.setName("objpara");
            part.setValue(input.getPart("objpara").getValue());
            output.addPart(part);
        }
        if (output.getPart("peid") == null && input.getPart("peid") != null) {
            part = new Part();
            part.setName("peid");
            part.setValue(input.getPart("peid").getValue());
            output.addPart(part);
        }
        if (input.getPart("monObj") == null) {
            return null;
        }
        part = new Part();
        part.setName("monObj");
        part.setValue(input.getPart("monObj").getValue());
        output.addPart(part);
        for (int m = 0; m < pfmMonObjArr.size(); ++m) {
            TEPfmMonObjID tempPfmmonobj = (TEPfmMonObjID)pfmMonObjArr.get(m);
            if (!output.getPart("monObj").getValue().equals(tempPfmmonobj.toSimpleString()) && !output.getPart("monObj").getValue().equals(tempPfmmonobj.toString())) continue;
            pfmmonobjItem = tempPfmmonobj;
            break;
        }
        return pfmmonobjItem;
    }
}

