/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.lpara;

import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.lpara.TEAlmObjTypeData;
import com.huawei.nglct.nelist.lpara.TEAlmPosition;
import com.huawei.nglct.nelist.lpara.TEGetAlmObjResource;
import com.huawei.nglct.nelist.lpara.TELParamMgr;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import com.huawei.nglct.nelist.model.performance.TEPfmMonObjID;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;

public class TEAlmObjTypeMgr {
    private static final int FB_OTHER = 30;
    private TENE ne = null;

    public TEAlmObjTypeMgr(int neID) {
        this.ne = TENEListMgr.getInstance().getNE(neID);
    }

    public int getFBType(int slotid, int fbType) {
        TEBoard board = this.ne.getBoard(slotid);
        return TEGetAlmObjResource.getInstance().getFBType(board.getBoardType(), fbType);
    }

    public TEAlmObjTypeData getAlmObjTypeData(TEPfmMonObjID monObj) {
        int fbType = monObj.m_usFBType == 0 ? 30 : this.getFBType(monObj.m_usSlotID, monObj.m_usFBType);
        return TEGetAlmObjResource.getInstance().getFBObjTypeData(fbType);
    }

    public String getObjPara(TEPfmMonObjID monObj) {
        TEAlmObjTypeData data = this.getAlmObjTypeData(monObj);
        monObj.decPathID();
        TEAlmPosition almpos = new TEAlmPosition();
        almpos.setSlot(monObj.m_usSlotID);
        almpos.setPort(monObj.m_usPortID);
        almpos.setPath(monObj.fbID1);
        almpos.setVc12path(monObj.fbID2);
        return TELParamMgr.getObjPara(almpos, data);
    }

    public TEAlmObjTypeData getAlmObjTypeData(TEAlarmMonObjID monObj) {
        int fbType = monObj.m_usFBType == 0 ? 30 : this.getFBType(monObj.m_usSlotID, monObj.m_usFBType);
        return TEGetAlmObjResource.getInstance().getFBObjTypeData(fbType);
    }

    public String getObjPara(TEAlmObjTypeData data, TEAlarmMonObjID monObj) {
        monObj.decPathID();
        TEAlmPosition almpos = new TEAlmPosition();
        almpos.setSlot(monObj.m_usSlotID);
        almpos.setPort(monObj.m_usPortID);
        almpos.setPath(monObj.fbID1);
        almpos.setVc12path(monObj.fbID2);
        return TELParamMgr.getObjPara(almpos, data);
    }

    public String getObjPara(TEAlarmMonObjID monObj) {
        TEAlmObjTypeData data = this.getAlmObjTypeData(monObj);
        return this.getObjPara(data, monObj);
    }

    public static final byte[] getBytes(int len, int num) {
        return IOStreamConvertor.unsignedShort2Bytes(num);
    }

    public static final byte[] get1Bytes(int a) {
        byte[] b = new byte[]{(byte)(a & 0xFF)};
        return b;
    }

    public TEAlmObjTypeData getAlmObjTypeData(int objType) {
        return TEGetAlmObjResource.getInstance().getPtnObjTypeData(objType);
    }

    public static String convertNMToNEHexString(int slotid) {
        int tempSlotid = TEBoardUtil.subrackIDNMToNE(slotid);
        byte[] b = IOStreamConvertor.unsignedShort2Bytes(tempSlotid);
        return IOStreamConvertor.hexChangToString(b);
    }

    public static int convertSlotidFromBytes(byte[] bSlotid) {
        if (bSlotid.length <= 2) {
            return IOStreamConvertor.readPositiveShort(bSlotid, 0);
        }
        if (bSlotid.length < 4) {
            return IOStreamConvertor.readPositiveInt(bSlotid, 0);
        }
        int slotid = IOStreamConvertor.readPositiveInt(bSlotid, 0);
        slotid = TEBoardUtil.subrackIDNEToNM(slotid);
        return slotid;
    }
}

