/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.initnelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.List;
import org.slf4j.Logger;

public class TENEListInitialUtil {
    private TENEListMgr nelistMgr = TENEListMgr.getInstance();
    private static TENEListInitialUtil instance;
    private static Logger embededWnemgrlog;

    public static synchronized TENEListInitialUtil getInstance() {
        if (instance == null) {
            instance = new TENEListInitialUtil();
        }
        return instance;
    }

    private TENEListInitialUtil() {
    }

    public void addInterNEOnStart(String domain) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        try {
            TEDaoOperationResult drb = TECommonDaoService.findAll(TENEMOPO.class);
            if (0 != drb.getResult()) {
                embededWnemgrlog.error("Get all ne mo failed!");
            } else {
                List<Object> cmgrNEList = drb.getData();
                if (cmgrNEList.isEmpty()) {
                    embededWnemgrlog.info("The size of neList is 0.");
                }
                TENE subNE = null;
                for (Object obj : cmgrNEList) {
                    TENEMOPO nepo = (TENEMOPO)obj;
                    subNE = this.convertTENEPO2TENE(nepo, domain);
                    if (null == subNE) continue;
                    this.nelistMgr.registerNewNeToList(subNE);
                }
                cmgrNEList.clear();
            }
        }
        catch (Exception e1) {
            embededWnemgrlog.error("addInterNEOnStart error", (Throwable)e1);
        }
    }

    private TENE convertTENEPO2TENE(TENEMOPO nepo, String domain) {
        int neID = (int)nepo.getNEID();
        int phyID = (int)nepo.getPhyID();
        int logicNEType = nepo.getType();
        int phyNEType = TEGetNEDomainVersion.getInstance().getNeType(logicNEType);
        if (phyNEType <= 0) {
            return null;
        }
        if (!TEGetNEDomainVersion.getInstance().getDomain(phyNEType).equals(domain)) {
            return null;
        }
        String subClassName = TENELdDevPkgNoticeReceiver.getSubNEClass(phyNEType);
        String neName = nepo.getName();
        embededWnemgrlog.info("TENEListMgr.addInterNEOnStart().subClassName is:" + subClassName);
        TENE subNE = null;
        if (null == subClassName) {
            embededWnemgrlog.info("TENEListMgr:subClassName is null! neid is: " + neID + "logicNEType: " + logicNEType);
        } else {
            try {
                subNE = (TENE)Class.forName(subClassName).newInstance();
            }
            catch (Exception e) {
                embededWnemgrlog.error("Class.forName error", (Throwable)e);
            }
            if (null != subNE) {
                subNE.setNEID(neID);
                subNE.setRealNEID(phyID);
                subNE.setNEType(phyNEType);
                subNE.setNEName(neName);
            }
        }
        return subNE;
    }

    static {
        embededWnemgrlog = TELogFactory.getembededWnemgrLogger();
    }
}

