/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist.handler;

import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.handler.TENEHandlerInf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TENEHandlerMgr {
    private static TENEHandlerMgr instance = null;
    private Map<Integer, List<TENEHandlerInf>> listenersMap = new HashMap<Integer, List<TENEHandlerInf>>();

    private TENEHandlerMgr() {
    }

    public static synchronized TENEHandlerMgr getInstance() {
        if (null == instance) {
            instance = new TENEHandlerMgr();
        }
        return instance;
    }

    public synchronized boolean registerListener(int neType, TENEHandlerInf listener) {
        if (null == listener) {
            return false;
        }
        List<TENEHandlerInf> handlerList = this.listenersMap.get(neType);
        if (null == handlerList) {
            handlerList = new ArrayList<TENEHandlerInf>();
            this.listenersMap.put(neType, handlerList);
        }
        if (!handlerList.contains(listener)) {
            handlerList.add(listener);
        }
        return true;
    }

    public synchronized boolean unregisterListener(int neType) {
        if (0 >= neType) {
            return false;
        }
        this.listenersMap.remove(neType);
        return true;
    }

    public synchronized boolean doNEDeleteHandle(int neID) {
        if (null == this.listenersMap || this.listenersMap.isEmpty()) {
            return false;
        }
        if (0 >= neID) {
            return false;
        }
        TENE neInfo = TENEListMgr.getInstance().getNE(neID);
        if (null == neInfo) {
            return false;
        }
        List<TENEHandlerInf> handlerList = this.listenersMap.get(neInfo.getNEType());
        if (handlerList == null) {
            return false;
        }
        for (TENEHandlerInf handler : handlerList) {
            handler.doAfterNEDeleteHandle(neID);
        }
        return true;
    }

    public synchronized boolean doBoardDeleteHandle(int neID, int slotID, int boardType) {
        if (null == this.listenersMap || this.listenersMap.isEmpty()) {
            return false;
        }
        if (0 >= neID) {
            return false;
        }
        TENE neInfo = TENEListMgr.getInstance().getNE(neID);
        if (null == neInfo) {
            return false;
        }
        TEBoard board = neInfo.getBoard(slotID);
        if (null == board) {
            return false;
        }
        List<TENEHandlerInf> handlerList = this.listenersMap.get(neInfo.getNEType());
        if (handlerList != null) {
            for (TENEHandlerInf handler : handlerList) {
                handler.doAfterBoardDeleteHandle(neID, slotID, boardType);
            }
        }
        return true;
    }
}

