/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.nelist.TETaskManager;
import java.util.ArrayList;
import java.util.List;

public class TEThreadPool {
    private static TEThreadPool instance = null;
    private int threadCounter;
    private boolean shutDown = false;
    private List<TETaskManager> idleThreads = new ArrayList<TETaskManager>();

    public static synchronized TEThreadPool newInstance() {
        if (null == instance) {
            instance = new TEThreadPool();
        }
        return instance;
    }

    public synchronized int getThreadCounter() {
        return this.threadCounter;
    }

    protected synchronized void repool(TETaskManager thread) {
        if (!this.shutDown) {
            this.idleThreads.add(thread);
            this.notifyAll();
        } else {
            thread.shutDown();
        }
    }

    public synchronized void shutdown() {
        this.shutDown = true;
        for (int i = 0; i < this.idleThreads.size(); ++i) {
            this.idleThreads.get(i).shutDown();
        }
        this.notifyAll();
    }

    public synchronized void start(Runnable target) {
        TETaskManager thread = null;
        if (!this.idleThreads.isEmpty()) {
            int lastIndex = this.idleThreads.size() - 1;
            thread = this.idleThreads.get(lastIndex);
            this.idleThreads.remove(lastIndex);
            thread.setTarget(target);
            this.notifyAll();
        } else {
            ++this.threadCounter;
            thread = new TETaskManager(target, this);
            thread.start();
        }
    }
}

