/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TETL1NEDataBackupBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.List;

public class TETL1NEManuallyDataBackupBean
extends TETL1NEDataBackupBean {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        this.outputData = new Datainterface();
        try {
            ArrayList tempList = new ArrayList();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            for (int i = 0; i < rParams.length; ++i) {
                tempList.clear();
                String neid = rParams[i].getParam("neid").getValue();
                Datainterface tempInput = new Datainterface();
                tempInput.setBussinessParams(new BussinessParams());
                tempInput.getBussinessParams().addRowParams(rParams[i]);
                tempList = this.getTL1Operation(Integer.parseInt(neid), subFunc, tempInput);
                String slotidForNE = this.getSCCSlot(Integer.parseInt(neid));
                if (slotidForNE == null || slotidForNE.indexOf("false") != -1) {
                    int errcode = 1090646019;
                    if (slotidForNE != null) {
                        errcode = Integer.parseInt(slotidForNE.split("-")[0]);
                    }
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(errcode));
                    return this.outputData;
                }
                TL1Operation tempOper = (TL1Operation)tempList.get(0);
                tempOper.getInMsg().getPart("SLOT").setValue(slotidForNE);
                this.writeLog(Integer.parseInt(neid), subFunc, "0", ipAddress, tempList);
                OperationResult result = TETL1NECommMgr.getInstance().sendCommand(Integer.parseInt(neid), (List)tempList, 900);
                if (result.retCode != 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result.retCode));
                    return this.outputData;
                }
                Datainterface tempOutput = this.handleMessage(Integer.parseInt(neid), tempList, subFunc);
                this.handleReturnDate(tempOutput);
                this.writeLog(Integer.parseInt(neid), subFunc, "0", ipAddress, this.cloneTL1OperationList);
            }
            this.outputData.setErrorMessage(new ErrorMessage());
            if (this.failedNeCount == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else if (this.failedNeCount == 2 * rParams.length) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1));
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TETL1NEManuallyDataBackupBean.subFuncProcessed() fail!", (Throwable)ex);
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        }
        return this.outputData;
    }

    private String getSCCSlot(int neid) {
        String cmdvar = "RTRV-DX-EQPT";
        try {
            this.cloneTL1OperationList.clear();
            ArrayList<TL1Operation> clntOperList = new ArrayList<TL1Operation>();
            TL1Definitions definitions = TECreateObjectFactory.parseTL1DesFile(neid);
            TL1Operation operation = definitions.getTL1Operation(cmdvar);
            clntOperList.add(operation);
            OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, clntOperList, this.TIME_OUT);
            if (result.retCode == 0) {
                if (clntOperList != null && clntOperList.size() > 0) {
                    operation = (TL1Operation)clntOperList.get(0);
                    if (!operation.getOutMsg(0).getFault().getErrDesc().equals("")) {
                        operation.addCmdFault(operation.getOutMsg(0).getFault());
                        return null;
                    }
                    this.cloneTL1OperationList.add(operation.clone());
                    String sccslot = operation.getOutMsg(0).getMsgBlock().getPart("ACTSLOT").getValue();
                    return sccslot;
                }
                return null;
            }
            return result.retCode + "-false";
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TETL1NEManuallyDataBackupBean.getSCCSlot() fail!", (Throwable)e);
            return null;
        }
    }
}

