/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.cbb.log.TETL1OperateLogInfo;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.OperObject;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.appmanager.api.DeploymentMode;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TETL1NEDataBackupBean
implements TENEListInterface {
    protected Datainterface outputData = null;
    protected int failedNeCount = 0;
    protected int TIME_OUT = 60;
    protected ArrayList cloneTL1OperationList = new ArrayList();
    protected TL1Operation curTL1Operation = null;
    protected boolean msgBlockFlag = true;
    private static TESysManagerBean sysManager = TESysManagerBean.getInstance();

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        this.outputData = new Datainterface();
        if (subFunc.getQxMapping()[0].getContent().indexOf("RTRV") == -1) {
            this.msgBlockFlag = false;
        }
        try {
            ArrayList tempList = new ArrayList();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            for (int i = 0; i < rParams.length; ++i) {
                tempList.clear();
                String neid = rParams[i].getParam("neid").getValue();
                Datainterface tempInput = new Datainterface();
                tempInput.setBussinessParams(new BussinessParams());
                tempInput.getBussinessParams().addRowParams(rParams[i]);
                tempList = this.getTL1Operation(Integer.parseInt(neid), subFunc, tempInput);
                OperationResult result = TETL1NECommMgr.getInstance().sendCommand(Integer.parseInt(neid), (List)tempList, this.TIME_OUT);
                if (result.retCode != 0) {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result.retCode));
                    return this.outputData;
                }
                Datainterface tempOutput = this.handleMessage(Integer.parseInt(neid), tempList, subFunc);
                this.handleReturnDate(tempOutput);
                this.writeLog(Integer.parseInt(neid), subFunc, "0", ipAddress, this.cloneTL1OperationList);
            }
            this.outputData.setErrorMessage(new ErrorMessage());
            if (this.failedNeCount == 0) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else if (this.failedNeCount == 2 * rParams.length) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(2));
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1));
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TETL1NEDataBackupBean.subFuncProcessed() fail!", (Throwable)ex);
        }
        return this.outputData;
    }

    public void handleReturnDate(Datainterface tempOutput) {
        if (this.outputData.getBussinessParams() == null) {
            if (tempOutput.getBussinessParams() != null) {
                this.outputData.setBussinessParams(tempOutput.getBussinessParams());
            }
        } else if (tempOutput.getBussinessParams() != null && tempOutput.getBussinessParams().getRowParamsCount() != 0) {
            int len = tempOutput.getBussinessParams().getRowParamsCount();
            RowParams temRowParams = null;
            for (int i = 0; i < len; ++i) {
                temRowParams = tempOutput.getBussinessParams().getRowParams(i);
                this.outputData.getBussinessParams().addRowParams(temRowParams);
            }
        }
    }

    public Datainterface handleMessage(int neid, ArrayList tl1OperList, SubFunc subfunc) {
        return this.convertToDatainterface(neid, subfunc, tl1OperList);
    }

    protected Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList) {
        int tl1OperSize = 0;
        ArrayList errorData = this.joinTL1Operation(neid, subfunc, tl1OperList);
        TL1Operation tl1Operation = null;
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        if (null == tl1OperList || 0 == tl1OperList.size()) {
            if (null == errorData || 0 == errorData.size()) {
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
            } else if (errorData.size() >= tl1OperSize) {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
                this.failedNeCount += 2;
            } else {
                rowparams = new RowParams();
                int sizei = errorData.size();
                for (int ii = 0; ii < sizei; ++ii) {
                    rowparams.addRowErrors((RowErrors)errorData.get(ii));
                }
                outputData.getBussinessParams().addRowParams(rowparams);
                outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
                ++this.failedNeCount;
            }
            return outputData;
        }
        tl1OperSize = tl1OperList.size();
        InMsg input = null;
        OutMsg output = null;
        int len = tl1OperList.size();
        for (int i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            input = tl1Operation.getInMsg();
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                rowparams = new RowParams();
                output = tl1Operation.getOutMsg(row);
                if (!this.handleRowData(neid, subfunc, rowparams, input, output)) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (0 != errorData.size()) {
            rowparams = new RowParams();
            int sizei = errorData.size();
            for (int ii = 0; ii < sizei; ++ii) {
                rowparams.addRowErrors((RowErrors)errorData.get(ii));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
            this.failedNeCount += 2;
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
            ++this.failedNeCount;
        }
        return outputData;
    }

    public ArrayList joinTL1Operation(int neid, SubFunc subfunc, ArrayList tl1OperationList) {
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        ArrayList tl1OperObject = TETL1DataConverter.getTL1OperationObject(subfunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        TL1Operation tl1Oper = null;
        TL1Operation tmpTL1Oper = null;
        OutMsg curOutput = null;
        OutMsg tmpOutput = null;
        String errorCode = "OK";
        if (null == tl1OperationList || 0 == tl1OperationList.size()) {
            return errorDataList;
        }
        this.cloneTL1OperationList.clear();
        for (int i = tl1OperationList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperationList.get(i);
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = String.valueOf(curOutput.getFault().getCompletionCode());
                if ("0".equals(errorCode)) continue;
                tl1Oper.addCmdFault(curOutput.getFault());
                errorDataList.add(0, this.handleErrorData(neid, subfunc, tl1Oper, curOutput));
                tl1Oper.removeOutMsg(curOutput);
            }
            this.cloneTL1OperationList.add(tl1Oper.clone());
            if (tl1Oper.getOutMsgCount() != 0) continue;
            tl1OperationList.remove(i);
        }
        int operSize = tl1OperationList.size();
        if (0 == operSize) {
            return errorDataList;
        }
        if (null != tl1OperObject && 0 != tl1OperObject.size()) {
            for (int i = 0; i < operSize; ++i) {
                tl1Oper = (TL1Operation)tl1OperationList.get(i);
                TETL1DataConverter.copyInDataToOutData(tl1Oper);
                int ouputlen = tl1Oper.getOutMsgCount();
                for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = tl1Oper.getOutMsg(outputIndex);
                    operObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tl1Oper.getInMsg(), curOutput);
                    for (int j = i + 1; j < operSize; ++j) {
                        tmpTL1Oper = (TL1Operation)tl1OperationList.get(j);
                        TETL1DataConverter.copyInDataToOutData(tmpTL1Oper);
                        for (int tmpOutputIndex = tmpTL1Oper.getOutMsgCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpTL1Oper.getOutMsg(tmpOutputIndex);
                            tmpoperObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tmpTL1Oper.getInMsg(), tmpOutput);
                            if (!TETL1DataConverter.compareOperObj(operObjPart, tmpoperObjPart)) continue;
                            TETL1DataConverter.joinTL1OperationOutput(curOutput, tmpOutput);
                            tmpTL1Oper.removeOutMsg(tmpOutput);
                        }
                        if (0 != tmpTL1Oper.getOutMsgCount()) continue;
                        tl1OperationList.remove(tmpTL1Oper);
                        --operSize;
                        --j;
                    }
                }
            }
        }
        return errorDataList;
    }

    protected boolean handleRowData(int neid, SubFunc subfunc, RowParams rowparams, InMsg input, OutMsg output) {
        Part tmpPart = null;
        HashMap partmap = TETL1CommonUtil.getOutMsgPart(output);
        if (this.isFilterRowData(partmap)) {
            return false;
        }
        Param param = null;
        ArrayList<Param> paramList = new ArrayList<Param>();
        Param newParam = null;
        int len = subfunc.getOutput().getParamCount();
        for (int col = 0; col < len; ++col) {
            param = new Param(subfunc.getOutput().getParam(col).getName(), "");
            if ("neid".equalsIgnoreCase(param.getName())) {
                param.setValue(String.valueOf(neid));
            }
            if (null != input) {
                tmpPart = input.getPart(param.getName());
            }
            if (null != tmpPart) {
                param.setValue(tmpPart.getValue());
            }
            if ((newParam = this.convertParamValue(param, partmap, neid)) == null) continue;
            paramList.add(newParam);
        }
        int len2 = paramList.size();
        if (len2 != 0) {
            for (int j = 0; j < len2; ++j) {
                rowparams.addParam((Param)paramList.get(j));
            }
        } else {
            return false;
        }
        TETL1DataConverter.addReturnParam(neid, rowparams);
        return true;
    }

    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        MsgBlock outputBlock;
        int j;
        int size;
        int i;
        int len;
        ArrayList operObjct = this.getTL1OperationObject(subfunc);
        InMsg input = oper.getInMsg();
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        DataBlock dataBlock = null;
        if (null != input) {
            AID aid = input.getStagBlock().getAID();
            len = aid.getPartCount();
            for (i = 0; i < len; ++i) {
                errorparam = new Param(aid.getPart(i).getName(), aid.getPart(i).getValue());
                rowError.addParam(errorparam);
            }
            len = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                size = dataBlock.getPartCount();
                for (j = 0; j < size; ++j) {
                    String partName = dataBlock.getPart(j).getConvert();
                    if (partName == null || partName.equals("")) {
                        partName = dataBlock.getPart(j).getName();
                    }
                    if ((errorparam = new Param(partName, dataBlock.getPart(j).getValue())).getValue() != null) {
                        rowError.addParam(errorparam);
                    }
                    if (operObjct.contains(errorparam.getName()) || errorparam.getValue() == null) continue;
                    errorparam = new Param("attrId", partName);
                    rowError.addParam(errorparam);
                }
            }
        }
        if ((outputBlock = output.getMsgBlock()) != null) {
            len = outputBlock.getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = output.getMsgBlock().getDataBlock(i);
                size = dataBlock.getPartCount();
                for (j = 0; j < size; ++j) {
                    errorparam = new Param("attrId", dataBlock.getPart(j).getName());
                    if (null != rowError.getParam(dataBlock.getPart(j).getName())) continue;
                    rowError.addParam(errorparam);
                }
            }
        }
        this.addErrorParam(neid, rowError);
        return rowError;
    }

    protected boolean isFilterRowData(HashMap partmap) {
        return false;
    }

    protected Param convertParamValue(Param oldParam, HashMap partmap, int neid) {
        if (oldParam.getName().equalsIgnoreCase("nename")) {
            TENE ne = TENEListUtils.getNEObj(neid);
            oldParam.setValue(ne.getNEName());
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("autobackupenable")) {
            Part aidPart = (Part)partmap.get("STATUS");
            if (aidPart != null && aidPart.getValue() != null) {
                oldParam.setValue(aidPart.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("backupcycle")) {
            Part aidPart = (Part)partmap.get("DBPERIOD");
            if (aidPart != null && aidPart.getValue() != null) {
                oldParam.setValue(aidPart.getValue());
            }
            return oldParam;
        }
        if (oldParam.getName().equalsIgnoreCase("neid")) {
            oldParam.setValue(neid + "");
            return oldParam;
        }
        return oldParam;
    }

    public ArrayList getTL1OperationObject(SubFunc subfunc) {
        ArrayList<String> list = new ArrayList<String>();
        OperObject operObj = subfunc.getOperObject();
        if (null == operObj) {
            return list;
        }
        for (int i = 0; i < operObj.getParamCount(); ++i) {
            list.add(operObj.getParam(i).getName().toLowerCase());
        }
        return list;
    }

    public void addErrorParam(int neid, RowErrors rowError) {
        int slotid = 0;
        int boardtype = 0;
        int port = 0;
        Param param = null;
        int shelfID = 0;
        TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
        if (null != rowError.getParam("neid")) {
            param = new Param("nename", neObj.getNEName());
            rowError.addParam(param);
        }
        if (null != rowError.getParam("AID")) {
            String[] str;
            try {
                String[] aid = TETL1CommonUtil.parseAID(rowError.getParam("AID").getValue(), neid);
                shelfID = Integer.parseInt(aid[1]);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (shelfID != -1) {
                param = new Param("subrackID", "Subrack" + shelfID);
                rowError.addParam(param);
            }
            try {
                slotid = TETL1CommonUtil.getNMSlotStr(rowError.getParam("AID").getValue(), neid);
            }
            catch (NumberFormatException e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                slotid = -1;
            }
            if (slotid != -1) {
                if (null != rowError.getParam("boardtype")) {
                    try {
                        boardtype = Integer.parseInt(rowError.getParam("boardtype").getValue());
                    }
                    catch (NumberFormatException e) {
                        boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                        rowError.getParam("boardtype").setValue(boardtype + "");
                    }
                } else {
                    boardtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotid);
                    param = new Param("boardtype", boardtype + "");
                    rowError.addParam(param);
                }
                String boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(neid, boardtype);
                if (boardName.indexOf("UNKNOWN") == -1) {
                    param = new Param("boardname", slotid + "-" + boardName);
                }
                rowError.addParam(param);
            }
            try {
                str = TETL1CommonUtil.parseAID(rowError.getParam("AID").getValue(), neid);
                if (str.length > 3 && !str[3].equals("ALL")) {
                    port = Integer.parseInt(str[3]);
                }
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("Format Port Fail!", (Throwable)e);
                port = -1;
            }
            if (port != -1) {
                param = new Param("portid", String.valueOf(port));
                rowError.addParam(param);
                str = TETL1CommonUtil.parseAID(rowError.getParam("AID").getValue(), neid);
                String portName = TETL1CommonUtil.getPortNameFromNEPort(str[0], slotid, Integer.parseInt(str[3]), neid);
                param = new Param("portname", portName);
                rowError.addParam(param);
                param = new Param("pathid", str[4]);
                rowError.addParam(param);
            }
        }
    }

    public ArrayList getTL1Operation(int neid, SubFunc subFunc, Datainterface inputData) {
        try {
            TL1Definitions tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
            return this.convertToTL1Operation(subFunc, inputData, tl1definitions, null);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("getOperation fail!", (Throwable)e);
            return null;
        }
    }

    public ArrayList convertToTL1Operation(SubFunc subfunc, Datainterface inputData, TL1Definitions tl1Definitions, ArrayList tl1OperNameList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> tl1List = tl1OperNameList;
        if (null == tl1OperNameList) {
            tl1List = new ArrayList<String>();
            int len = subfunc.getQxMappingCount();
            for (int i = 0; i < len; ++i) {
                String tl1Mod2 = TETL1CommonUtil.getTL1CmdMod2(subfunc.getQxMapping(i).getContent());
                tl1List.add(tl1Mod2);
            }
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = tl1List.size();
            for (int i = 0; i < size; ++i) {
                tl1Operation = tl1Definitions.getTL1Operation((String)tl1List.get(i));
                this.changeMod2(tl1Operation, rowparams);
                this.curTL1Operation = tl1Operation;
                if (null == tl1Operation) continue;
                inputMsg = tl1Operation.getInMsg();
                if (null == inputMsg) {
                    tl1OperList.add(tl1Operation);
                    continue;
                }
                tl1Operation.clearCmdFaultInfo();
                fillComplete = this.fillStagBlock(rowparams, inputMsg.getStagBlock());
                if (fillComplete) {
                    fillComplete = this.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!this.msgBlockFlag && !fillComplete) continue;
                tl1OperList.add(tl1Operation);
            }
        }
        return tl1OperList;
    }

    protected void changeMod2(TL1Operation tl1Operation, RowParams rowparams) {
    }

    protected boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            if (this.convertPartValue(part, rowparams)) continue;
            if (null != part.getDefault()) {
                part.setValue(part.getDefault());
                continue;
            }
            flag = false;
            break;
        }
        return flag;
    }

    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int num = 0;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                if (!this.convertPartValue(part, rowparams)) {
                    if (null == part.getDefault()) continue;
                    part.setValue(part.getDefault());
                    continue;
                }
                ++num;
            }
        }
        if (num < 1) {
            flag = false;
        }
        return flag;
    }

    protected boolean convertPartValue(Part part, RowParams rowparams) {
        boolean flag = true;
        Param tmpParam = rowparams.getParam(part.getName());
        if (tmpParam == null) {
            tmpParam = TETL1CommonUtil.getParam(rowparams.getParam(), part.getConvert());
        }
        if (tmpParam != null && !tmpParam.getModifyFlag()) {
            return false;
        }
        if (null != tmpParam) {
            part.setValue(tmpParam.getValue());
        } else {
            flag = false;
        }
        return flag;
    }

    public void writeLog(int neid, SubFunc subfunc, String user, String ipAddress, ArrayList tl1OperList) {
        try {
            int i;
            DeploymentMode runningStatus = sysManager.getSysStauts();
            ArrayList<TELogInfo> loginfoList = new ArrayList<TELogInfo>();
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            int len = tl1OperList.size();
            for (i = 0; i < len; ++i) {
                loginfo = new TETL1OperateLogInfo();
                TL1Operation tl1Oper = (TL1Operation)tl1OperList.get(i);
                ArrayList faultList = tl1Oper.getCmdFaultList();
                boolean hasSuccess = false;
                boolean hasFail = false;
                StringBuilder errInfoSB = new StringBuilder();
                int size = faultList.size();
                for (int j = 0; j < size; ++j) {
                    Fault fault = (Fault)faultList.get(j);
                    if (fault.getCompletionCode() != 0) {
                        hasFail = true;
                        if (errInfoSB.length() == 0) {
                            errInfoSB.append(TETL1CommonUtil.getOperationResult(fault));
                            continue;
                        }
                        errInfoSB.append("\n").append(TETL1CommonUtil.getOperationResult(fault));
                        continue;
                    }
                    hasSuccess = true;
                }
                String errInfo = errInfoSB.toString();
                if (!hasFail) {
                    loginfo.setErrCode(0);
                    loginfo.setResult(0);
                    loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(0));
                    loginfo.setOperateDesc(tl1Oper.getCmdDetail());
                } else if (hasSuccess) {
                    loginfo.setErrCode(1);
                    loginfo.setResult(1);
                    loginfo.setErrInfo(errInfo);
                    loginfo.setOperateDesc(tl1Oper.getCmdDetail());
                } else {
                    loginfo.setErrCode(1107329312);
                    loginfo.setResult(2);
                    loginfo.setErrInfo(errInfo);
                    if (DeploymentMode.independent == runningStatus) {
                        loginfo.setOperateDesc(tl1Oper.getCmdDetail());
                    } else {
                        loginfo.setOperateDesc(tl1Oper.getCmdDetail() + "Result Desc:" + loginfo.getErrInfo());
                    }
                }
                loginfoList.add(loginfo);
            }
            int size = loginfoList.size();
            for (i = 0; i < size; ++i) {
                loginfo = (TELogInfo)loginfoList.get(i);
                loginfo.setCmdID(subfunc.getCode());
                loginfo.setLocation(ipAddress);
                loginfo.setUserID(userID);
                loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
                loginfo.setOperateName(subfunc.getSubFuncDes(neid));
                loginfo.setOperateObject(operObj);
                TELogMgr.writeLog((TELogInfo)loginfoList.get(i));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    protected boolean isMsgBlockFlag() {
        return this.msgBlockFlag;
    }

    protected void setMsgBlockFlag(boolean msgBlockFlag) {
        this.msgBlockFlag = msgBlockFlag;
    }
}

