/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.po.TESubrackTypes;

public class TESubrack
implements Cloneable,
Comparable {
    private int neid = 0;
    private String subrackID = "";
    private String logicSubrackType = "";
    private String subrackState = "0";
    private String phySubrackType = "-";
    private static final int HASHCODE_MULTIPLIED = 37;
    private static final int HASHCODE_INITVALUE = 17;
    private String ficInfo = "";
    private String subrackName = "";
    private int shelfType = 0;
    private String barCode = "";
    private short crossMode = (short)-1;
    public static final String SUBRACKTYPE_18001U = "140";
    public static final String SUBRACKTYPE_18002U = "141";
    public static final String SUBRACKTYPE_18002UII = "153";
    public static final String SUBRACKTYPE_OPTICAL = "93";
    public static final String NETYPE_1800 = "67";
    public static final String NETYPE_6800 = "51";
    public static final String SUBRACKTYPE_8800T32E = "97";
    public static final String SUBRACKTYPE_8800T64E = "98";
    public static final String NETYPE_8800T32 = "68";
    public static final String NETYPE_8800T64 = "74";
    public static final String SUBRACKTYPE_1832STD = "109";
    public static final String SUBRACKTYPE_1832PLATFORM = "110";

    public TESubrack() {
    }

    public TESubrack(String subrackID, String subrackType, String subrackName) {
        this.subrackID = subrackID;
        this.logicSubrackType = subrackType;
        this.subrackName = subrackName;
    }

    public TESubrack(int neid, String subrackID) {
        this.neid = neid;
        this.subrackID = subrackID;
    }

    public int getNeid() {
        return this.neid;
    }

    public String getSubrackID() {
        return this.subrackID;
    }

    public String getSubrackState() {
        return this.subrackState;
    }

    public String getLogicSubrackType() {
        return this.logicSubrackType;
    }

    public String getNeType() {
        if (this.logicSubrackType.equals(SUBRACKTYPE_18001U) || this.logicSubrackType.equals(SUBRACKTYPE_18002U) || this.logicSubrackType.equals(SUBRACKTYPE_18002UII)) {
            return NETYPE_1800;
        }
        if (this.logicSubrackType.equals(SUBRACKTYPE_OPTICAL)) {
            return NETYPE_6800;
        }
        if (this.logicSubrackType.equals(SUBRACKTYPE_8800T32E)) {
            return NETYPE_8800T32;
        }
        if (this.logicSubrackType.equals(SUBRACKTYPE_8800T64E)) {
            return NETYPE_8800T64;
        }
        if (this.logicSubrackType.equals(SUBRACKTYPE_1832PLATFORM)) {
            return SUBRACKTYPE_1832STD;
        }
        int neType = TESubrackTypes.getInstance().getNeType(this.logicSubrackType);
        if (neType != -1) {
            return String.valueOf(neType);
        }
        return this.logicSubrackType;
    }

    public String getTL1ShelfType() {
        return String.valueOf(TESubrackTypes.getInstance().getTL1SubrackType(this.logicSubrackType));
    }

    public String getTl1NeType() {
        return String.valueOf(this.getTl1NeTypeInt());
    }

    public int getTl1NeTypeInt() {
        if (this.logicSubrackType.equals("SHELF6800A")) {
            return 71;
        }
        if (this.logicSubrackType.equals("SHELF8800I") || this.logicSubrackType.equals("SHELF8800T32") || this.logicSubrackType.equals("SHELF8800T32E")) {
            return 73;
        }
        if (this.logicSubrackType.equals("SHELF8800II") || this.logicSubrackType.equals("SHELF8800T64") || this.logicSubrackType.equals("SHELF8800T64E")) {
            return 75;
        }
        if (this.logicSubrackType.equals("SHELF8800T16")) {
            return 85;
        }
        if (this.logicSubrackType.equals("1U") || this.logicSubrackType.equals("2U") || this.logicSubrackType.equals("1U_AUTO_COOL")) {
            return 66;
        }
        int subrackType = -1;
        int neType = TESubrackTypes.getInstance().getNeType(this.logicSubrackType);
        if (neType != -1) {
            subrackType = neType;
        } else {
            try {
                subrackType = Integer.parseInt(this.logicSubrackType);
            }
            catch (NumberFormatException e) {
                subrackType = -1;
            }
        }
        return subrackType;
    }

    public String getPhySubrackType() {
        return this.phySubrackType;
    }

    public void setSubrackID(String subrackID) {
        this.subrackID = subrackID;
    }

    public void setSubrackState(String subrackState) {
        this.subrackState = subrackState;
    }

    public void setLogicSubrackType(String subrackType) {
        this.logicSubrackType = subrackType;
    }

    public void setPhySubrackType(String subrackType) {
        this.phySubrackType = subrackType;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof TESubrack)) {
            return -1;
        }
        TESubrack compareSubrack = (TESubrack)obj;
        return Integer.parseInt(this.subrackID) - Integer.parseInt(compareSubrack.getSubrackID());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TESubrack)) {
            return false;
        }
        TESubrack subrack = (TESubrack)obj;
        return subrack.neid == this.neid && subrack.getSubrackID().equals(this.subrackID) && subrack.getLogicSubrackType().equals(this.logicSubrackType);
    }

    public int hashCode() {
        int result = 17 + 37 * this.neid + 37 * this.subrackID.hashCode() + 37 * this.logicSubrackType.hashCode();
        return result;
    }

    public String getFicInfo() {
        return this.ficInfo;
    }

    public void setFicInfo(String ficInfo) {
        this.ficInfo = ficInfo;
    }

    public String getSubrackName() {
        return this.subrackName;
    }

    public void setSubrackName(String subrackName) {
        this.subrackName = subrackName;
    }

    public int getShelfType() {
        return this.shelfType;
    }

    public void setShelfType(int shelfType) {
        this.shelfType = shelfType;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public short getCrossMode() {
        return this.crossMode;
    }

    public void setCrossMode(short crossMode) {
        this.crossMode = crossMode;
    }
}

