/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class TEStartUSBSerInstaller
implements TENEListInterface {
    private static final String FILE_PATH = TEResourceManager.getRealPathByAppName("weblct") + File.separator + "tools" + File.separator + "driver" + File.separator + "xr21x141x_1930_single_installer.EXE";

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        outputData.setBussinessParams(new BussinessParams());
        ErrorMessage errorMsg = TEErrorResourceUtil.getErrorMessage(0);
        try {
            TELogFactory.getNormalLogger().info("Start usbserInstaller for:" + FILE_PATH);
            Process process = Runtime.getRuntime().exec(FILE_PATH);
            if (null != process) {
                ProcessOutputThread outThread = new ProcessOutputThread(process);
                outThread.start();
            }
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("Start usbserInstaller tool fail!", (Throwable)e);
            errorMsg = TEErrorResourceUtil.getErrorMessage(36993);
            errorMsg.setErrorinfo(errorMsg.getErrorinfo() + " (" + FILE_PATH + ") ");
        }
        outputData.setErrorMessage(errorMsg);
        return outputData;
    }

    class ProcessOutputThread
    extends Thread {
        BufferedReader buff;

        public ProcessOutputThread(Process process) {
            this.buff = new BufferedReader(new InputStreamReader(process.getInputStream()));
        }

        @Override
        public void run() {
            try {
                while (true) {
                    String str;
                    if ((str = this.buff.readLine()) == null) {
                        return;
                    }
                    TELogFactory.getNormalLogger().debug("usbserInstaller start output:" + str);
                }
            }
            catch (IOException ex) {
                TELogFactory.getNormalLogger().error("read BufferedReader throw Exception ", (Throwable)ex);
                try {
                    this.buff.close();
                }
                catch (IOException ex1) {
                    TELogFactory.getNormalLogger().error("read BufferedReader throw Exception ", (Throwable)ex1);
                }
                return;
            }
        }
    }
}

