/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpNEInfo;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.snmp.Neid;
import com.huawei.nglct.nelist.snmp.Nelist;
import com.huawei.nglct.nelist.snmpparams.Snmpparam;
import com.huawei.nglct.nelist.snmpparams.Snmpparams;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Vector;
import org.slf4j.Logger;

public class TESnmpNEListMgr {
    private static TESnmpNEListMgr instance = null;
    public static final String NELIST_PATH = TEResourceManager.getPath() + File.separator + "conf" + File.separator + "snmpnelistinfo.xml";
    public static final String SNMPPARAMS_PATH = TEResourceManager.getPath() + File.separator + "conf" + File.separator + "snmpparams.xml";
    private HashMap neListMap = new HashMap();
    private Snmpparams templates = null;
    private Nelist _nelist = null;
    private Logger normalLog = TELogFactory.getNormalLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TESnmpNEListMgr getInstance() {
        if (null != instance) return instance;
        Class<TESnmpNEListMgr> clazz = TESnmpNEListMgr.class;
        synchronized (TESnmpNEListMgr.class) {
            instance = new TESnmpNEListMgr();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private TESnmpNEListMgr() {
        this.normalLog.info(System.getProperty("user.dir"));
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            return;
        }
        this.loadNEInfo();
    }

    private void loadNEInfo() {
        this.readNEListFile(NELIST_PATH);
        this.readSNMPLoginTemp(SNMPPARAMS_PATH);
        this.loadTESnmpNEInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNEListFile(String path) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            this._nelist = Nelist.unmarshal(reader);
            reader.close();
        }
        catch (Exception e) {
            this.normalLog.error("Parse file failed:", (Throwable)e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.normalLog.error("Parse file failed:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readSNMPLoginTemp(String path) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8"));
            this.templates = Snmpparams.unmarshal(reader);
            reader.close();
        }
        catch (Exception e) {
            this.normalLog.error("Parse file failed:", (Throwable)e);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    this.normalLog.error("Parse file failed:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSnmpParams(String path) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(path));
            this.templates.marshal(writer);
            writer.close();
        }
        catch (Exception e) {
            this.normalLog.error("Save file failed:", (Throwable)e);
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.normalLog.error("Save file failed:", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSnmpNEList(String path) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(path));
            this._nelist.marshal(writer);
            writer.close();
        }
        catch (Exception e) {
            this.normalLog.error("Save file failed:", (Throwable)e);
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.normalLog.error("Save file failed:", (Throwable)e);
                }
            }
        }
    }

    private void loadTESnmpNEInfo() {
        Neid ne = null;
        Snmpparam template = null;
        TESnmpNEInfo neInfo = null;
        int neCount = this._nelist.getNeidCount();
        for (int ni = 0; ni < neCount; ++ni) {
            ne = this._nelist.getNeid(ni);
            int tcount = this.templates.getSnmpparamCount();
            for (int ti = 0; ti < tcount; ++ti) {
                template = this.templates.getSnmpparam(ti);
                if (ne.getTemplateid() != template.getIndex()) continue;
                neInfo = new TESnmpNEInfo(ne, template);
                this.neListMap.put(ne.getIp(), neInfo);
            }
        }
    }

    public Vector getNEList() {
        return new Vector(this.neListMap.values());
    }

    public TESnmpNEInfo getNE(String neIP) {
        return (TESnmpNEInfo)this.neListMap.get(neIP);
    }

    public int addNE(TENE ne) {
        return 0;
    }

    public int addNE(TENE ne, String sbiAddress, String sbiPort) {
        return 0;
    }

    public int deleteNE(TENE ne) {
        return 0;
    }
}

