/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.NECommuStateReceiverQxOnI;
import com.huawei.nglct.nelist.NECommuStateReceiverTL1OnI;
import com.huawei.nglct.nelist.TEIProcessOnReceiveNeMsg;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEInterImpl;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.uflight.qxprotocol.NEStateNoticeHandle;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;

public final class TERefreshNEInfo {
    private TERefreshNEInfo() {
    }

    public static void refreshNEInfo(int neID) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            TELogFactory.getembededWnemgrLogger().info("ne is not exist! neID->" + neID);
            return;
        }
        TENEMOPO nemo = ((TENEInterImpl)ne.getNeImplInterface()).getTENEPO();
        if (null == nemo) {
            TELogFactory.getembededWnemgrLogger().error("ne mo is not exist! neID->" + neID);
            return;
        }
        TERefreshNEInfo.refreshWebLCTNEInfo(ne, nemo);
    }

    private static void registerInUfliht(TENE ne) {
        int neID = ne.getNEID();
        if (1 == ne.getIsTL1OrQX()) {
            String newNeName = ne.getNEName();
            TETL1NECommMgr.getInstance().putLogicNEIDName((long)neID, newNeName);
            TETL1NECommMgr.getInstance().registerNEStateListener((long)neID, (com.huawei.uflight.tl1.NEStateNoticeHandle)new NECommuStateReceiverTL1OnI());
        } else {
            int phyID = ne.getRealNEID();
            TENECommMgr.getInstance().putLogicNEID((long)phyID, (long)neID);
            TENECommMgr.getInstance().registerNEStateListener(neID, (NEStateNoticeHandle)new NECommuStateReceiverQxOnI());
        }
    }

    private static void unregisterFromUflight(TENE ne) {
        int neID = ne.getNEID();
        if (1 == ne.getIsTL1OrQX()) {
            TETL1NECommMgr.getInstance().unregisterNEStateListener((long)neID);
            TETL1NECommMgr.getInstance().deleteTL1NEID((long)neID);
        } else {
            TENECommMgr.getInstance().unregisterNEStateListener(neID);
            TENECommMgr.getInstance().deleteNEID((long)neID);
        }
    }

    private static void refreshWebLCTNEInfo(TENE ne, TENEMOPO nemo) {
        int phyID = (int)nemo.getPhyID();
        int logicNEType = nemo.getType();
        int phyNEType = TEGetNEDomainVersion.getInstance().getNeType(logicNEType);
        String neName = nemo.getName();
        TERefreshNEInfo.logNEInfo("ne before refresh ", ne);
        ne.setRealNEID(phyID);
        ne.setNEType(phyNEType);
        ne.setNEName(neName);
        TERefreshNEInfo.logNEInfo("ne after refresh ", ne);
        int neID = ne.getNEID();
        if (TESpecialAttrMgr.getInstance().isNESupport(ne.getNEID(), "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")) {
            try {
                TEIProcessOnReceiveNeMsg pro = (TEIProcessOnReceiveNeMsg)Class.forName(TESpecialAttrMgr.getInstance().getNEAttrValue(neID, "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")).newInstance();
                TELogFactory.getNormalLogger().info("start add l3vpn ne to inventory table on refreshing ne info!" + neID);
                pro.processOnAdd(neID);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("construct process on adding ne failed! " + neID, (Throwable)e);
            }
        } else {
            TELogFactory.getNormalLogger().info("this ne do not support l3vpn! " + neID);
        }
    }

    private static void logNEInfo(String tipStr, TENE ne) {
        int phyID = ne.getRealNEID();
        int phyNEType = ne.getNEType();
        String neName = ne.getNEName();
        StringBuffer logBuffer = new StringBuffer(50);
        logBuffer.append(tipStr);
        logBuffer.append("phyID:").append(phyID);
        logBuffer.append("phyNEType:").append(phyNEType);
        logBuffer.append("neName:").append(neName);
        TELogFactory.getembededWnemgrLogger().info(logBuffer.toString());
    }
}

