/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;

public class TEReconnectNEBean
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface outputData = new Datainterface();
        BussinessParams rtnBParams = new BussinessParams();
        int failedCount = 0;
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        int neID = 0;
        int len = rowParams.length;
        for (int i = 0; i < len; ++i) {
            for (Param tmpParam : rowParams[i].getParam()) {
                if (!tmpParam.getName().equals("neID")) continue;
                neID = Integer.parseInt(tmpParam.getValue());
            }
            TENE ne = TENEListUtils.getNEObj(neID);
            if (ne == null) {
                TELogFactory.getNormalLogger().error("ne is not exist! neID->" + neID);
                return null;
            }
            int result = this.reConnectNE(ne);
            if (result != 0) {
                ++failedCount;
                TELogFactory.getNormalLogger().info("Connect NE Fail!");
                ne.setComStatus(0);
                RowParams rowParam = new RowParams();
                RowErrors rowError = new RowErrors();
                rowError.addParam(new Param("neid", String.valueOf(ne.getNEID())));
                rowError.addParam(new Param("nename", String.valueOf(ne.getNEName())));
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage(ne.getNEID(), 1091109266));
                rowParam.addRowErrors(rowError);
                rtnBParams.addRowParams(rowParam);
                continue;
            }
            TELogFactory.getNormalLogger().info("Connect NE Success!");
            ne.setComStatus(1);
        }
        ErrorMessage bigErr = failedCount == 0 ? TEErrorResourceUtil.getErrorMessage(0) : (failedCount == rowParams.length ? TEErrorResourceUtil.getErrorMessage(2) : TEErrorResourceUtil.getErrorMessage(1));
        outputData.setBussinessParams(rtnBParams);
        outputData.setErrorMessage(bigErr);
        return outputData;
    }

    private int reConnectNE(TENE ne) {
        String neIP = ne.getNEGWAddress();
        int nePort = Integer.valueOf(ne.getPort());
        int neGWType = ne.getNEGWType();
        String baudRate = ne.getBaudRate();
        int isTL1OrQX = ne.getIsTL1OrQX();
        if (neGWType == 5) {
            neGWType = 3;
        }
        int result = 0;
        if (ne.getLogStatus() == 1) {
            return result;
        }
        if (neGWType == 3) {
            if (isTL1OrQX == 0) {
                TENECommMgr.getInstance().closeConnect((long)ne.getNEID(), nePort, neIP, neGWType);
                result = TENECommMgr.getInstance().createConect((long)ne.getNEID(), nePort, neIP, neGWType, baudRate);
            } else {
                TETL1NECommMgr.getInstance().closeConnect((long)ne.getNEID(), nePort, neIP, neGWType);
                result = TETL1NECommMgr.getInstance().createConect((long)ne.getNEID(), nePort, neIP, neGWType, baudRate);
            }
        } else if (isTL1OrQX == 0) {
            TENECommMgr.getInstance().closeConnect((long)ne.getNEID(), nePort, neIP, neGWType);
            result = TENECommMgr.getInstance().createConect((long)ne.getNEID(), nePort, neIP, neGWType);
        } else {
            TETL1NECommMgr.getInstance().closeConnect((long)ne.getNEID(), nePort, neIP, neGWType);
            result = TETL1NECommMgr.getInstance().createConect((long)ne.getNEID(), nePort, neIP, neGWType);
        }
        return result;
    }
}

