/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.NEStateNoticeReceiver;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEStatusMgr;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;

public class TEQueryNEStatusReq
implements Runnable {
    private final int neid;
    private final int number;
    private static final String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";
    private static final int MAX_QUERY_TIMES = 3;
    private static final int TIME_OUT = 15;
    private static final Random random = new Random();
    private int count = 0;

    public TEQueryNEStatusReq(int neid, int number) {
        this.neid = neid;
        this.number = number;
        this.count = 0;
    }

    @Override
    public void run() {
        try {
            Thread.sleep(random.nextInt(1500));
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TENE ne = TENEStatusMgr.getInstance().getNE(this.neid);
        if (ne != null && ne.getIsTL1OrQX() != 1) {
            this.queryNEStatus();
        }
    }

    public String toString() {
        return "[ Request from NE" + this.neid + " No." + this.number + " ]";
    }

    private void queryNEStatus() {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        TENE neobj = TENEListMgr.getInstance().getNE(this.neid);
        try {
            Operation oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_CFG_GET_NE_STATE");
            if (oper == null) {
                TELogFactory.getInterfaceLogger().error("queryNEStatus Operation is null!neid = " + this.neid);
                return;
            }
            operationList.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neid, operationList, 15);
            ++this.count;
            TELogFactory.getInterfaceLogger().info(this.toString() + " return code is " + result.retCode + " at count " + this.count);
            TELogFactory.getInterfaceLogger().info(this.toString() + " NE: " + neobj.toString() + " , " + " ComStarus:" + neobj.getComStarus() + ", LogStatus:" + neobj.getLogStatus());
            if (result.retCode == 0) {
                this.count = 0;
                Operation ostate = (Operation)operationList.get(0);
                if (ostate.getOutputCount() > 0) {
                    String errorCode = ostate.getOutput(0).getFault(0).getCode();
                    TELogFactory.getInterfaceLogger().info("query NEStatus " + this.toString() + " cmd return errcode is " + errorCode);
                    if (neobj.getComStarus() == 0 || neobj.getLogStatus() == 1 && errorCode.equals("37926")) {
                        NEStateNoticeReceiver receiver = new NEStateNoticeReceiver();
                        receiver.handleNoticeNeStateChange(this.neid, 1);
                    } else if (neobj.getLogStatus() == 0 && errorCode.equals("0")) {
                        TELogFactory.getInterfaceLogger().info("Set NE " + this.toString() + " logStatus is normal");
                        neobj.setLogStatus(1);
                    }
                }
            } else if (result.retCode == 1090617361) {
                this.count = 0;
            } else if (result.retCode == 1090650120 && this.count < 3) {
                this.queryNEStatus();
            } else if (result.retCode == 1090650120 && this.count >= 3) {
                this.count = 0;
                NEStateNoticeReceiver receiver = new NEStateNoticeReceiver();
                receiver.handleNoticeNeStateChange(this.neid, 0);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("query NEStatus fail! NE:" + neobj.toString(), (Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.neid;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEQueryNEStatusReq other = (TEQueryNEStatusReq)obj;
        return this.neid == other.neid;
    }
}

