/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TENEResListMgr {
    private static TENEResListMgr instance = new TENEResListMgr();
    private static final String NELIST_PATH = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, "conf" + File.separator + "nelistinfo.xml");

    private TENEResListMgr() {
    }

    public static TENEResListMgr getInstance() {
        return instance;
    }

    public synchronized boolean setNEListInfoKeyValue(int neid, String keyName, String keyValue) {
        try {
            Document doc = this.parseNEListXML();
            if (null == doc) {
                return false;
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode) {
                return false;
            }
            NodeList resKeyNodeList = ((Element)neNode).getElementsByTagName(keyName);
            if (resKeyNodeList.getLength() > 0) {
                ((Element)resKeyNodeList.item(0)).setAttribute("value", keyValue);
            } else {
                Element elemreskeyName = doc.createElement(keyName);
                elemreskeyName.setAttribute("value", keyValue);
                neNode.appendChild(elemreskeyName);
            }
            doc.normalize();
            TEResourceManager.writeXmlFile(doc, NELIST_PATH);
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("write nelistinfo.xml file fail!" + neid + "-" + keyName + "=" + keyValue, (Throwable)e);
            return false;
        }
    }

    public synchronized String getNEListInfoKeyValue(int neid, String keyName) {
        try {
            Document doc = this.parseNEListXML();
            if (null == doc) {
                return "";
            }
            Node neListNode = TEResourceManager.getNENode(doc, neid);
            if (null == neListNode) {
                return "";
            }
            NodeList keyNodeList = ((Element)neListNode).getElementsByTagName(keyName);
            if (keyNodeList.getLength() > 0) {
                return ((Element)keyNodeList.item(0)).getAttribute("value");
            }
            return "";
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("get nelistinfo.xml file fail!" + neid + "-" + keyName, (Throwable)e);
            return "";
        }
    }

    public synchronized boolean setNEListInfoNEKeys(int neid, Hashtable neAttributes) {
        try {
            Document doc = this.parseNEListXML();
            if (null == doc || null == neAttributes) {
                return false;
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode) {
                TENE ne = TENEListMgr.getInstance().getNE(neid);
                if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts() && null != ne) {
                    this.addNEListInfoNENode(ne);
                    doc = this.parseNEListXML();
                    if (null == doc) {
                        return false;
                    }
                    neNode = TEResourceManager.getNENode(doc, neid);
                    if (null == neNode) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            Set keys = neAttributes.keySet();
            for (String keyName : keys) {
                NodeList keyNodeList = ((Element)neNode).getElementsByTagName(keyName);
                if (keyNodeList.getLength() > 0) {
                    ((Element)keyNodeList.item(0)).setAttribute("value", String.valueOf(neAttributes.get(keyName)));
                    continue;
                }
                Element elemkeyName = doc.createElement(keyName);
                elemkeyName.setAttribute("value", String.valueOf(neAttributes.get(keyName)));
                neNode.appendChild(elemkeyName);
            }
            doc.normalize();
            TEResourceManager.writeXmlFile(doc, NELIST_PATH);
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("write nelistinfo.xml file fail!" + neid, (Throwable)e);
            return false;
        }
    }

    public synchronized Hashtable getNEListInfoNEKeys(int neid, Vector neAttrs) {
        Hashtable<String, String> neListAttributes = null;
        try {
            Document doc = this.parseNEListXML();
            if (null == doc) {
                return neListAttributes;
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode || null == neAttrs) {
                return neListAttributes;
            }
            neListAttributes = new Hashtable<String, String>();
            for (String keyName : neAttrs) {
                NodeList keyNodeList = ((Element)neNode).getElementsByTagName(keyName);
                if (keyNodeList.getLength() > 0) {
                    neListAttributes.put(keyName, ((Element)keyNodeList.item(0)).getAttribute("value"));
                    continue;
                }
                neListAttributes.put(keyName, "");
            }
            return neListAttributes;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!" + neid, (Throwable)e);
            return neListAttributes;
        }
    }

    private Document parseNEListXML() {
        File file = new File(NELIST_PATH);
        if (!file.exists() || file.length() == 0L) {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(NELIST_PATH), "UTF-8"));
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.write("<nelist></nelist>");
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Create nelist.xml fail", (Throwable)e);
            }
        }
        try {
            InputStream inputsStream = file.toURL().openStream();
            return TEParseXMLFile.parseFile(inputsStream);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Create nelist.xml fail", (Throwable)e);
            return null;
        }
    }

    public synchronized boolean addNEListInfoNENode(TENE neObj) {
        try {
            Document doc = this.parseNEListXML();
            boolean blAdd = TEResourceManager.addNeListDocNeNode(doc, neObj, true);
            if (!blAdd) {
                return false;
            }
            TEResourceManager.writeXmlFile(doc, NELIST_PATH);
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
            return false;
        }
    }

    public synchronized boolean deleteNEListInfoNENode(int neid) {
        try {
            Document doc = this.parseNEListXML();
            if (null == doc) {
                return false;
            }
            Node neNode = TEResourceManager.getNENode(doc, neid);
            if (null == neNode) {
                return false;
            }
            doc.getDocumentElement().removeChild(neNode);
            doc.normalize();
            TEResourceManager.writeXmlFile(doc, NELIST_PATH);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
        }
        TELogFactory.getNormalLogger().info("Not find neid=" + neid + "in nelistinfo.xml file !");
        return true;
    }

    public synchronized List getNEListInfo() {
        ArrayList nelistInfo = new ArrayList();
        try {
            Document doc = this.parseNEListXML();
            NodeList neNodeList = doc.getElementsByTagName("neid");
            Element elem = null;
            Node node = null;
            NodeList childNodeList = null;
            int isize = neNodeList.getLength();
            for (int i = 0; i < isize; ++i) {
                HashMap<String, String> neAttributes = new HashMap<String, String>();
                elem = (Element)neNodeList.item(i);
                neAttributes.put(elem.getNodeName(), elem.getAttribute("value"));
                childNodeList = elem.getChildNodes();
                int m = childNodeList.getLength();
                for (int j = 0; j < m; ++j) {
                    node = childNodeList.item(j);
                    if (1 != node.getNodeType()) continue;
                    elem = (Element)node;
                    neAttributes.put(elem.getNodeName(), elem.getAttribute("value"));
                }
                nelistInfo.add(neAttributes);
            }
            return nelistInfo;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("read nelistinfo.xml file fail!", (Throwable)e);
            return nelistInfo;
        }
    }
}

